<?php

//////////////////////////////////////////////////////////////////////////////80
// Macro Control
//////////////////////////////////////////////////////////////////////////////80
// Copyright (c) Atheos & Liam Siira (Atheos.io), distributed as-is and without
// warranty under the MIT License. See [root]/docs/LICENSE.md for more.
// This information must remain intact.
//////////////////////////////////////////////////////////////////////////////80
// Authors: Codiad Team, @daeks, Atheos Team, @hlsiira
//////////////////////////////////////////////////////////////////////////////80

require_once("class.macro.php");

$activeUser = SESSION("user");
$Macro = new Macro($activeUser);

switch ($action) {

	//////////////////////////////////////////////////////////////////////////80
	// Load User Macros
	//////////////////////////////////////////////////////////////////////////80
	case "load":
		$Macro->load();
		break;

	//////////////////////////////////////////////////////////////////////////80
	// Create new macro
	//////////////////////////////////////////////////////////////////////////80
	case "create":
		$macro = POST("macro");
		if ($macro) {
			$Macro->save($macro);
		} else {
			Common::send("error", "Missing macro.");
		}
		break;

	//////////////////////////////////////////////////////////////////////////80
	// Save User Settings
	//////////////////////////////////////////////////////////////////////////80
	case "exec":
		$key = POST("key");
		$value = POST("value");
		if ($key && $value) {
			$Macro->save($key, $value);
		} else {
			Common::send("error", "Missing key or value.");
		}
		break;

	//////////////////////////////////////////////////////////////////////////80
	// Default: Invalid Action
	//////////////////////////////////////////////////////////////////////////80
	default:
		Common::send("error", "Invalid action.");
		break;
}