<?php 
/**
 * Bg_5_dealer_products_latest Page Controller
 * @category  Controller
 */
class Bg_5_dealer_products_latestController extends SecureController{
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function index($fieldname = null , $fieldvalue = null){
		$db = $this->GetModel();
		$fields = array('products_id', 	'PRODUCT_CODE', 	'DESCRIPTION', 	'Price', 	'Product_Type', 	'Product_Sub_Group');
		$limit = $this->get_page_limit(MAX_RECORD_COUNT); // return pagination from BaseModel Class e.g array(5,20)
		if(!empty($this->search)){
			$text = $this->search;
			$db->orWhere('PRODUCT_CODE',"%$text%",'LIKE');
			$db->orWhere('DESCRIPTION',"%$text%",'LIKE');
			$db->orWhere('Product_Type',"%$text%",'LIKE');
			$db->orWhere('Product_Sub_Group',"%$text%",'LIKE');
		}
		if(!empty($this->orderby)){ // when order by request fields (from $_GET param)
			$db->orderBy($this->orderby,$this->ordertype);
		}
		else{
			$db->orderBy('products_id', ORDER_TYPE);
		}
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get('bg_5_dealer_products_latest', $limit, $fields);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		if($db->getLastError()){
			$this->view->page_error = $db->getLastError();
		}
		$this->view->page_title ="Dealer Products Latest";
		$this->view->render('bg_5_dealer_products_latest/list.php' , $data ,'main_layout.php');
	}
	/**
     * View Record Action 
     * @return View
     */
	function view( $rec_id = null , $value = null){
		$db = $this->GetModel();
		$fields = array( 'products_id', 	'PRODUCT_CODE', 	'DESCRIPTION', 	'Price', 	'Product_Type', 	'Product_Sub_Group' );
		if( !empty($value) ){
			$db->where($rec_id, urldecode($value));
		}
		else{
			$db->where('products_id' , $rec_id);
		}
		$record = $db->getOne( 'bg_5_dealer_products_latest', $fields );
		if(!empty($record)){
			$this->view->page_title ="View  Product";
			$this->view->render('bg_5_dealer_products_latest/view.php' , $record ,'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error = $db->getLastError();
			}
			else{
				$this->view->page_error = "No record found";
			}
			$this->view->render('bg_5_dealer_products_latest/view.php' , $record , 'main_layout.php');
		}
	}
}
