<?php 
/**
 * Jl_1_Dd_Woods Page Controller
 * @category  Controller
 */
class Jl_1_Dd_WoodsController extends SecureController{
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function index($fieldname = null , $fieldvalue = null){
		$db = $this->GetModel();
		$fields = array('pk_wood_id', 	'full', 	'list', 	'updated', 	'changed_by');
		$limit = $this->get_page_limit(MAX_RECORD_COUNT); // return pagination from BaseModel Class e.g array(5,20)
		if(!empty($this->search)){
			$text = $this->search;
			$db->orWhere('pk_wood_id',"%$text%",'LIKE');
			$db->orWhere('full',"%$text%",'LIKE');
			$db->orWhere('list',"%$text%",'LIKE');
			$db->orWhere('updated',"%$text%",'LIKE');
			$db->orWhere('changed_by',"%$text%",'LIKE');
		}
		if(!empty($this->orderby)){ // when order by request fields (from $_GET param)
			$db->orderBy($this->orderby,$this->ordertype);
		}
		else{
			$db->orderBy('pk_wood_id', ORDER_TYPE);
		}
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get('jl_1_dd_woods', $limit, $fields);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		if($db->getLastError()){
			$this->view->page_error = $db->getLastError();
		}
		$this->view->page_title ="Drop Down Woods";
		$this->view->render('jl_1_dd_woods/list.php' , $data ,'main_layout.php');
	}
	/**
     * View Record Action 
     * @return View
     */
	function view( $rec_id = null , $value = null){
		$db = $this->GetModel();
		$fields = array( 'pk_wood_id', 	'full', 	'list', 	'updated', 	'changed_by' );
		if( !empty($value) ){
			$db->where($rec_id, urldecode($value));
		}
		else{
			$db->where('pk_wood_id' , $rec_id);
		}
		$record = $db->getOne( 'jl_1_dd_woods', $fields );
		if(!empty($record)){
			$this->view->page_title ="View  Jl 1 Dd Woods";
			$this->view->render('jl_1_dd_woods/view.php' , $record ,'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error = $db->getLastError();
			}
			else{
				$this->view->page_error = "Record not found";
			}
			$this->view->render('jl_1_dd_woods/view.php' , $record , 'main_layout.php');
		}
	}
	/**
     * Add New Record Action 
     * If Not $_POST Request, Display Add Record Form View
     * @return View
     */
	function add(){
		if(is_post_request()){
			$modeldata = transform_request_data($_POST);
			$rules_array = array(
				'full' => 'required',
				'list' => 'required',
				'changed_by' => 'required',
			);
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}
			if( empty($this->view->page_error) ){
				$db = $this->GetModel();
				$rec_id = $db->insert( 'jl_1_dd_woods' , $modeldata );
				if(!empty($rec_id)){
					set_flash_msg('','');
					redirect_to_page("jl_1_dd_woods");
					return;
				}
				else{
					if($db->getLastError()){
						$this->view->page_error[] = $db->getLastError();
					}
					else{
						$this->view->page_error[] = "Error inserting record";
					}
				}
			}
		}
		$this->view->page_title ="Add New Jl 1 Dd Woods";
		$this->view->render('jl_1_dd_woods/add.php' ,null,'main_layout.php');
	}
	/**
     * Edit Record Action 
     * If Not $_POST Request, Display Edit Record Form View
     * @return View
     */
	function edit($rec_id=null){
		$db = $this->GetModel();
		if(is_post_request()){
			$modeldata = transform_request_data($_POST);
			$rules_array = array(
				'full' => 'required',
				'list' => 'required',
				'changed_by' => 'required',
			);
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}
			if(empty($this->view->page_error)){
				$db->where('pk_wood_id' , $rec_id);
				$bool = $db->update('jl_1_dd_woods',$modeldata);
				if($bool){
					set_flash_msg('','');
					redirect_to_page("jl_1_dd_woods");
					return;
				}
				else{
					$this->view->page_error[] = $db->getLastError();
				}
			}
		}
		$fields = array('pk_wood_id','full','list','changed_by');
		$db->where('pk_wood_id' , $rec_id);
		$data = $db->getOne('jl_1_dd_woods',$fields);
		$this->view->page_title ="Edit  Jl 1 Dd Woods";
		if(!empty($data)){
			$this->view->render('jl_1_dd_woods/edit.php' , $data, 'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error[] = $db->getLastError();
			}
			else{
				$this->view->page_error[] = "Record not found";
			}
			$this->view->render('jl_1_dd_woods/edit.php' , $data , 'main_layout.php');
		}
	}
	/**
     * Delete Record Action 
     * @return View
     */
	function delete( $rec_ids = null ){
		$db = $this->GetModel();
		$arr_id = explode( ',', $rec_ids );
		foreach( $arr_id as $rec_id ){
			$db->where('pk_wood_id' , $rec_id,"=",'OR');
		}
		$bool = $db->delete( 'jl_1_dd_woods' );
		if($bool){
			set_flash_msg("Data Deleted",'success');
		}
		else{
			if($db->getLastError()){
				set_flash_msg($db->getLastError(),'danger');
			}
			else{
				set_flash_msg("Error deleting the record. please make sure that the record exit",'danger');
			}
		}
		redirect_to_page("jl_1_dd_woods");
	}
}
