<?php 
/**
 * Rgalist Page Controller
 * @category  Controller
 */
class RgalistController extends SecureController{
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function index($fieldname = null , $fieldvalue = null){
		$db = $this->GetModel();
		$fields = array('RGANum', 	'Dealer', 	'TagName', 	'RGAEntry', 	'RGAIssuer', 	'SalesRep', 	'RecdRFQ', 	'ExtraLeadTime', 	'Value', 	'SentToRGAE', 	'SentToDealer', 	'Comments', 	'TimeStamp', 	'Originator', 	'NumRevisions', 	'OriginalOrder', 	'NewJobNum', 	'PickUpDate', 	'GoodsRecd', 	'Location', 	'PiecesRecd', 	'WhoRecd', 	'ItemsToBeRetd', 	'PiecesToBeRetd', 	'DateRetd', 	'PropRetDate', 	'status', 	'completed');
		$limit = $this->get_page_limit(MAX_RECORD_COUNT); // return pagination from BaseModel Class e.g array(5,20)
		if(!empty($this->search)){
			$text = $this->search;
			$db->orWhere('RGANum',"%$text%",'LIKE');
			$db->orWhere('Dealer',"%$text%",'LIKE');
			$db->orWhere('TagName',"%$text%",'LIKE');
			$db->orWhere('RGAEntry',"%$text%",'LIKE');
			$db->orWhere('RGAIssuer',"%$text%",'LIKE');
			$db->orWhere('SalesRep',"%$text%",'LIKE');
			$db->orWhere('RecdRFQ',"%$text%",'LIKE');
			$db->orWhere('ExtraLeadTime',"%$text%",'LIKE');
			$db->orWhere('Value',"%$text%",'LIKE');
			$db->orWhere('SentToRGAE',"%$text%",'LIKE');
			$db->orWhere('SentToDealer',"%$text%",'LIKE');
			$db->orWhere('Comments',"%$text%",'LIKE');
			$db->orWhere('TimeStamp',"%$text%",'LIKE');
			$db->orWhere('Originator',"%$text%",'LIKE');
			$db->orWhere('NumRevisions',"%$text%",'LIKE');
			$db->orWhere('OriginalOrder',"%$text%",'LIKE');
			$db->orWhere('NewJobNum',"%$text%",'LIKE');
			$db->orWhere('PickUpDate',"%$text%",'LIKE');
			$db->orWhere('GoodsRecd',"%$text%",'LIKE');
			$db->orWhere('Location',"%$text%",'LIKE');
			$db->orWhere('PiecesRecd',"%$text%",'LIKE');
			$db->orWhere('WhoRecd',"%$text%",'LIKE');
			$db->orWhere('ItemsToBeRetd',"%$text%",'LIKE');
			$db->orWhere('PiecesToBeRetd',"%$text%",'LIKE');
			$db->orWhere('DateRetd',"%$text%",'LIKE');
			$db->orWhere('PropRetDate',"%$text%",'LIKE');
			$db->orWhere('status',"%$text%",'LIKE');
			$db->orWhere('completed',"%$text%",'LIKE');
		}
		if(!empty($this->orderby)){ // when order by request fields (from $_GET param)
			$db->orderBy($this->orderby,$this->ordertype);
		}
		else{
			$db->orderBy('RGANum', ORDER_TYPE);
		}
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get('rgalist', $limit, $fields);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		if($db->getLastError()){
			$this->view->page_error = $db->getLastError();
		}
		$this->view->page_title ="Rgalist";
		$this->view->render('rgalist/list.php' , $data ,'main_layout.php');
	}
	/**
     * Load json data
     * @return data
     */
	function import_data(){
		if(!empty($_FILES['file'])){
			$finfo = pathinfo($_FILES['file']['name']);
			$ext = strtolower($finfo['extension']);
			if(!in_array($ext , array('json'))){
				set_flash_msg("File format not supported",'danger');
			}
			else{
			$file_path = $_FILES['file']['tmp_name'];
				if(!empty($file_path)){
					$db = $this->GetModel();
					$data = $db->loadJsonData( $file_path, 'rgalist' , false );
					if($db->getLastError()){
						set_flash_msg($db->getLastError(),'danger');
					}
					else{
						set_flash_msg("Data imported successfully",'success');
					}
				}
				else{
					set_flash_msg("Error uploading file",'danger');
				}
			}
		}
		else{
			set_flash_msg("No file selected for upload",'warning');
		}
		$list_page = (!empty($_POST['redirect']) ? $_POST['redirect'] : 'rgalist/list');
		redirect_to_page($list_page);
	}
	/**
     * View Record Action 
     * @return View
     */
	function view( $rec_id = null , $value = null){
		$db = $this->GetModel();
		$fields = array( 'RGANum', 	'Dealer', 	'TagName', 	'RGAEntry', 	'RGAIssuer', 	'SalesRep', 	'RecdRFQ', 	'ExtraLeadTime', 	'Value', 	'SentToRGAE', 	'SentToDealer', 	'Comments', 	'TimeStamp', 	'Originator', 	'NumRevisions', 	'OriginalOrder', 	'NewJobNum', 	'PickUpDate', 	'GoodsRecd', 	'Location', 	'PiecesRecd', 	'WhoRecd', 	'ItemsToBeRetd', 	'PiecesToBeRetd', 	'DateRetd', 	'PropRetDate', 	'status', 	'completed' );
		if( !empty($value) ){
			$db->where($rec_id, urldecode($value));
		}
		else{
			$db->where('RGANum' , $rec_id);
		}
		$record = $db->getOne( 'rgalist', $fields );
		if(!empty($record)){
			$this->view->page_title ="View  Rgalist";
			$this->view->render('rgalist/view.php' , $record ,'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error = $db->getLastError();
			}
			else{
				$this->view->page_error = "Record not found";
			}
			$this->view->render('rgalist/view.php' , $record , 'main_layout.php');
		}
	}
	/**
     * Add New Record Action 
     * If Not $_POST Request, Display Add Record Form View
     * @return View
     */
	function add(){
		if(is_post_request()){
			$postdata = transform_multi_request_data($_POST);
			if(!empty($postdata)){
				foreach($postdata as &$modeldata){
			$rules_array = array(
				'Dealer' => 'required',
				'TagName' => 'required',
				'RGAEntry' => 'required',
				'RGAIssuer' => 'required',
				'SalesRep' => 'required',
				'RecdRFQ' => 'required',
				'ExtraLeadTime' => 'required',
				'Value' => 'required|numeric',
				'SentToRGAE' => 'required',
				'SentToDealer' => 'required',
				'Comments' => 'required',
				'Originator' => 'required',
				'NumRevisions' => 'required|numeric',
				'OriginalOrder' => 'required',
				'NewJobNum' => 'required',
				'PickUpDate' => 'required',
				'Location' => 'required',
				'ItemsToBeRetd' => 'required',
				'PiecesToBeRetd' => 'required|numeric',
				'PropRetDate' => 'required',
			);
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}
				}
				if( empty($this->view->page_error) ){
					$db = $this->GetModel();
					$rec_id = $db->insertMulti( 'rgalist' , $postdata );
					if(!empty($rec_id)){
						set_flash_msg('','');
						redirect_to_page("rgalist");
						return;
					}
					else{
						if($db->getLastError()){
							$this->view->page_error[] = $db->getLastError();
						}
						else{
							$this->view->page_error[] = "Error inserting record";
						}
					}
				}
			}
			else{
				$this->view->page_error[] = "No record inserted";
			}
		}
		$this->view->page_title ="Add New Rgalist";
		$this->view->render('rgalist/add.php' ,null,'main_layout.php');
	}
	/**
     * Edit Record Action 
     * If Not $_POST Request, Display Edit Record Form View
     * @return View
     */
	function edit($rec_id=null){
		$db = $this->GetModel();
		if(is_post_request()){
			$modeldata = transform_request_data($_POST);
			$rules_array = array(
				'RGANum' => 'required',
				'Dealer' => 'required',
				'TagName' => 'required',
				'RGAEntry' => 'required',
				'RGAIssuer' => 'required',
				'SalesRep' => 'required',
				'RecdRFQ' => 'required',
				'ExtraLeadTime' => 'required',
				'Value' => 'required|numeric',
				'SentToRGAE' => 'required',
				'SentToDealer' => 'required',
				'Comments' => 'required',
				'Originator' => 'required',
				'NumRevisions' => 'required|numeric',
				'OriginalOrder' => 'required',
				'NewJobNum' => 'required',
				'PickUpDate' => 'required',
				'GoodsRecd' => 'required',
				'Location' => 'required',
				'PiecesRecd' => 'required|numeric',
				'WhoRecd' => 'required',
				'ItemsToBeRetd' => 'required',
				'PiecesToBeRetd' => 'required|numeric',
				'DateRetd' => 'required',
				'PropRetDate' => 'required',
				'status' => 'required|numeric',
				'completed' => 'required',
			);
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}
			if(empty($this->view->page_error)){
				$db->where('RGANum' , $rec_id);
				$bool = $db->update('rgalist',$modeldata);
				if($bool){
					set_flash_msg('','');
					redirect_to_page("rgalist");
					return;
				}
				else{
					$this->view->page_error[] = $db->getLastError();
				}
			}
		}
		$fields = array('RGANum','Dealer','TagName','RGAEntry','RGAIssuer','SalesRep','RecdRFQ','ExtraLeadTime','Value','SentToRGAE','SentToDealer','Comments','Originator','NumRevisions','OriginalOrder','NewJobNum','PickUpDate','GoodsRecd','Location','PiecesRecd','WhoRecd','ItemsToBeRetd','PiecesToBeRetd','DateRetd','PropRetDate','status','completed');
		$db->where('RGANum' , $rec_id);
		$data = $db->getOne('rgalist',$fields);
		$this->view->page_title ="Edit  Rgalist";
		if(!empty($data)){
			$this->view->render('rgalist/edit.php' , $data, 'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error[] = $db->getLastError();
			}
			else{
				$this->view->page_error[] = "Record not found";
			}
			$this->view->render('rgalist/edit.php' , $data , 'main_layout.php');
		}
	}
	/**
     * Delete Record Action 
     * @return View
     */
	function delete( $rec_ids = null ){
		$db = $this->GetModel();
		$arr_id = explode( ',', $rec_ids );
		foreach( $arr_id as $rec_id ){
			$db->where('RGANum' , $rec_id,"=",'OR');
		}
		$bool = $db->delete( 'rgalist' );
		if($bool){
			set_flash_msg("Data Deleted",'success');
		}
		else{
			if($db->getLastError()){
				set_flash_msg($db->getLastError(),'danger');
			}
			else{
				set_flash_msg("Error deleting the record. please make sure that the record exit",'danger');
			}
		}
		redirect_to_page("rgalist");
	}
}
