<?php 
/**
 * Jl_0_Oc_Users Page Controller
 * @category  Controller
 */
class Jl_0_Oc_UsersController extends SecureController{
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function index($fieldname = null , $fieldvalue = null){
		$db = $this->GetModel();
		$fields = array('uid', 	'displayname', 	'uid_lower', 	'email', 	'type');
		$limit = $this->get_page_limit(MAX_RECORD_COUNT); // return pagination from BaseModel Class e.g array(5,20)
		if(!empty($this->search)){
			$text = $this->search;
			$db->orWhere('uid',"%$text%",'LIKE');
			$db->orWhere('displayname',"%$text%",'LIKE');
			$db->orWhere('password',"%$text%",'LIKE');
			$db->orWhere('uid_lower',"%$text%",'LIKE');
			$db->orWhere('email',"%$text%",'LIKE');
			$db->orWhere('type',"%$text%",'LIKE');
		}
		if(!empty($this->orderby)){ // when order by request fields (from $_GET param)
			$db->orderBy($this->orderby,$this->ordertype);
		}
		else{
			$db->orderBy('uid', ORDER_TYPE);
		}
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get('jl_0_oc_users', $limit, $fields);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		if($db->getLastError()){
			$this->view->page_error = $db->getLastError();
		}
		$this->view->page_title ="Jl 0 Oc Users";
		$this->view->render('jl_0_oc_users/list.php' , $data ,'main_layout.php');
	}
	/**
     * Load json data
     * @return data
     */
	function import_data(){
		if(!empty($_FILES['file'])){
			$finfo = pathinfo($_FILES['file']['name']);
			$ext = strtolower($finfo['extension']);
			if(!in_array($ext , array('json'))){
				set_flash_msg("File format not supported",'danger');
			}
			else{
			$file_path = $_FILES['file']['tmp_name'];
				if(!empty($file_path)){
					$db = $this->GetModel();
					$data = $db->loadJsonData( $file_path, 'jl_0_oc_users' , false );
					if($db->getLastError()){
						set_flash_msg($db->getLastError(),'danger');
					}
					else{
						set_flash_msg("Data imported successfully",'success');
					}
				}
				else{
					set_flash_msg("Error uploading file",'danger');
				}
			}
		}
		else{
			set_flash_msg("No file selected for upload",'warning');
		}
		$list_page = (!empty($_POST['redirect']) ? $_POST['redirect'] : 'jl_0_oc_users/list');
		redirect_to_page($list_page);
	}
	/**
     * View Record Action 
     * @return View
     */
	function view( $rec_id = null , $value = null){
		$db = $this->GetModel();
		$fields = array( 'uid', 	'displayname', 	'uid_lower', 	'email', 	'type' );
		if( !empty($value) ){
			$db->where($rec_id, urldecode($value));
		}
		else{
			$db->where('uid' , $rec_id);
		}
		$record = $db->getOne( 'jl_0_oc_users', $fields );
		if(!empty($record)){
			$this->view->page_title ="View  Jl 0 Oc Users";
			$this->view->render('jl_0_oc_users/view.php' , $record ,'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error = $db->getLastError();
			}
			else{
				$this->view->page_error = "Record not found";
			}
			$this->view->render('jl_0_oc_users/view.php' , $record , 'main_layout.php');
		}
	}
	/**
     * Add New Record Action 
     * If Not $_POST Request, Display Add Record Form View
     * @return View
     */
	function add(){
		if(is_post_request()){
			$modeldata = transform_request_data($_POST);
			$rules_array = array(
				'uid' => 'required',
				'displayname' => 'required',
				'password' => 'required',
				'uid_lower' => 'required',
				'email' => 'required|valid_email',
				'type' => 'required',
			);
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}
			$cpassword = $modeldata['confirm_password'];
			$password = $modeldata['password'];
			if($cpassword != $password){
				$this->view->page_error[] = "Your password confirmation is not consistent";
			}
			unset($modeldata['confirm_password']);
			$password_text = $modeldata['password'];
			$modeldata['password'] = password_hash($password_text , PASSWORD_DEFAULT);
			if( empty($this->view->page_error) ){
				$db = $this->GetModel();
				$rec_id = $db->insert( 'jl_0_oc_users' , $modeldata );
				if(!empty($rec_id)){
					set_flash_msg('','');
					redirect_to_page("jl_0_oc_users");
					return;
				}
				else{
					if($db->getLastError()){
						$this->view->page_error[] = $db->getLastError();
					}
					else{
						$this->view->page_error[] = "Error inserting record";
					}
				}
			}
		}
		$this->view->page_title ="Add New Jl 0 Oc Users";
		$this->view->render('jl_0_oc_users/add.php' ,null,'main_layout.php');
	}
	/**
     * Edit Record Action 
     * If Not $_POST Request, Display Edit Record Form View
     * @return View
     */
	function edit($rec_id=null){
		$db = $this->GetModel();
		if(is_post_request()){
			$modeldata = transform_request_data($_POST);
			$rules_array = array(
				'uid' => 'required',
				'displayname' => 'required',
				'uid_lower' => 'required',
				'type' => 'required',
			);
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}
			//Check if Duplicate Record Already Exit In The Database
			if(isset($modeldata['displayname'])){
				$db->where('displayname',$modeldata['displayname'])->where('uid',$rec_id,'!=');
				if($db->has('jl_0_oc_users')){
					$this->view->page_error[] = $modeldata['displayname']."Already exist!";
				}
			}
			//Check if Duplicate Record Already Exit In The Database
			if(isset($modeldata['uid_lower'])){
				$db->where('uid_lower',$modeldata['uid_lower'])->where('uid',$rec_id,'!=');
				if($db->has('jl_0_oc_users')){
					$this->view->page_error[] = $modeldata['uid_lower']."Already exist!";
				}
			} 
			if(empty($this->view->page_error)){
				$db->where('uid' , $rec_id);
				$bool = $db->update('jl_0_oc_users',$modeldata);
				if($bool){
					set_flash_msg('','');
					redirect_to_page("account");
					return;
				}
				else{
					$this->view->page_error[] = $db->getLastError();
				}
			}
		}
		$fields = array('uid','displayname','uid_lower','type');
		$db->where('uid' , $rec_id);
		$data = $db->getOne('jl_0_oc_users',$fields);
		$this->view->page_title ="Edit  Jl 0 Oc Users";
		if(!empty($data)){
			$this->view->render('jl_0_oc_users/edit.php' , $data, 'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error[] = $db->getLastError();
			}
			else{
				$this->view->page_error[] = "Record not found";
			}
			$this->view->render('jl_0_oc_users/edit.php' , $data , 'main_layout.php');
		}
	}
	/**
     * Delete Record Action 
     * @return View
     */
	function delete( $rec_ids = null ){
		$db = $this->GetModel();
		$arr_id = explode( ',', $rec_ids );
		foreach( $arr_id as $rec_id ){
			$db->where('uid' , $rec_id,"=",'OR');
		}
		$bool = $db->delete( 'jl_0_oc_users' );
		if($bool){
			set_flash_msg("Data Deleted",'success');
		}
		else{
			if($db->getLastError()){
				set_flash_msg($db->getLastError(),'danger');
			}
			else{
				set_flash_msg("Error deleting the record. please make sure that the record exit",'danger');
			}
		}
		redirect_to_page("jl_0_oc_users");
	}
}
