<?php 
/**
 * Jl_0_Oc_Users Page Controller
 * @category  Controller
 */
class Jl_0_Oc_UsersController extends SecureController{
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function index($fieldname = null , $fieldvalue = null){
		$db = $this->GetModel();
		$fields = array('uid', 	'displayname', 	'uid_lower', 	'email', 	'initials', 	'ql_type', 	'jl_type');
		$limit = $this->get_page_limit(50); // return pagination from BaseModel Class e.g array(5,20)
		if(!empty($this->search)){
			$text = $this->search;
			$db->orWhere('uid',"%$text%",'LIKE');
			$db->orWhere('displayname',"%$text%",'LIKE');
			$db->orWhere('password',"%$text%",'LIKE');
			$db->orWhere('uid_lower',"%$text%",'LIKE');
			$db->orWhere('email',"%$text%",'LIKE');
			$db->orWhere('type',"%$text%",'LIKE');
			$db->orWhere('initials',"%$text%",'LIKE');
			$db->orWhere('ql_type',"%$text%",'LIKE');
			$db->orWhere('jl_type',"%$text%",'LIKE');
		}
		if(!empty($this->orderby)){ // when order by request fields (from $_GET param)
			$db->orderBy($this->orderby,$this->ordertype);
		}
		else{
			$db->orderBy('uid', ORDER_TYPE);
		}
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get('jl_0_oc_users', $limit, $fields);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		if($db->getLastError()){
			$this->view->page_error = $db->getLastError();
		}
		$this->view->page_title ="Users";
		$this->view->render('jl_0_oc_users/list.php' , $data ,'main_layout.php');
	}
	/**
     * View Record Action 
     * @return View
     */
	function view( $rec_id = null , $value = null){
		$db = $this->GetModel();
		$fields = array( 'uid', 	'displayname', 	'uid_lower', 	'email', 	'type', 	'initials', 	'ql_type', 	'jl_type' );
		if( !empty($value) ){
			$db->where($rec_id, urldecode($value));
		}
		else{
			$db->where('uid' , $rec_id);
		}
		$record = $db->getOne( 'jl_0_oc_users', $fields );
		if(!empty($record)){
			$this->view->page_title ="View  Users";
			$this->view->render('jl_0_oc_users/view.php' , $record ,'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error = $db->getLastError();
			}
			else{
				$this->view->page_error = "Record not found";
			}
			$this->view->render('jl_0_oc_users/view.php' , $record , 'main_layout.php');
		}
	}
}
