<?php 
/**
 * Jl_5_Joblist Page Controller
 * @category  Controller
 */
class Jl_5_JoblistController extends SecureController{
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function index($fieldname = null , $fieldvalue = null){
		$db = $this->GetModel();
		$fields = array('JobNum', 	'Dealer', 	'TagName', 	'RSO', 	'Wood', 	'Colour', 	'Comments', 	'Requested_Date', 	'Plant', 	'Inv', 	'OE', 	'Value', 	'Door_Vendor', 	'Priority', 	'Proposed_Shipping_Date');
		$limit = $this->get_page_limit(MAX_RECORD_COUNT); // return pagination from BaseModel Class e.g array(5,20)
		if(!empty($this->search)){
			$text = $this->search;
			$db->orWhere('JobNum',"%$text%",'LIKE');
			$db->orWhere('Dealer',"%$text%",'LIKE');
			$db->orWhere('TagName',"%$text%",'LIKE');
			$db->orWhere('Customer_Number',"%$text%",'LIKE');
			$db->orWhere('RSO',"%$text%",'LIKE');
			$db->orWhere('Door_Style',"%$text%",'LIKE');
			$db->orWhere('Wood',"%$text%",'LIKE');
			$db->orWhere('Colour',"%$text%",'LIKE');
			$db->orWhere('Comments',"%$text%",'LIKE');
			$db->orWhere('Requested_Date',"%$text%",'LIKE');
			$db->orWhere('Received_Order',"%$text%",'LIKE');
			$db->orWhere('Sent_To_OE',"%$text%",'LIKE');
			$db->orWhere('Sent_To_Dealer',"%$text%",'LIKE');
			$db->orWhere('Confirmation_Received',"%$text%",'LIKE');
			$db->orWhere('Confirmed',"%$text%",'LIKE');
			$db->orWhere('Sent_To_Plant',"%$text%",'LIKE');
			$db->orWhere('Plant',"%$text%",'LIKE');
			$db->orWhere('Inv',"%$text%",'LIKE');
			$db->orWhere('OE',"%$text%",'LIKE');
			$db->orWhere('Uppers',"%$text%",'LIKE');
			$db->orWhere('Talls',"%$text%",'LIKE');
			$db->orWhere('Bases',"%$text%",'LIKE');
			$db->orWhere('Vanities',"%$text%",'LIKE');
			$db->orWhere('Accessories',"%$text%",'LIKE');
			$db->orWhere('Value',"%$text%",'LIKE');
			$db->orWhere('Door_Vendor',"%$text%",'LIKE');
			$db->orWhere('Priority',"%$text%",'LIKE');
			$db->orWhere('Standard_Lead_Time',"%$text%",'LIKE');
			$db->orWhere('Date_Shipped',"%$text%",'LIKE');
			$db->orWhere('Other_ETA',"%$text%",'LIKE');
			$db->orWhere('Door_ETA',"%$text%",'LIKE');
			$db->orWhere('Back_Orders',"%$text%",'LIKE');
			$db->orWhere('Back_Orders_Shipped',"%$text%",'LIKE');
			$db->orWhere('Proposed_Shipping_Date',"%$text%",'LIKE');
			$db->orWhere('Shipping_Comments',"%$text%",'LIKE');
			$db->orWhere('Shipping_Details',"%$text%",'LIKE');
			$db->orWhere('DealerRoute',"%$text%",'LIKE');
			$db->orWhere('NJobNum',"%$text%",'LIKE');
			$db->orWhere('OrgJobNum',"%$text%",'LIKE');
			$db->orWhere('Creator',"%$text%",'LIKE');
			$db->orWhere('UpdatedBy',"%$text%",'LIKE');
			$db->orWhere('SalesRep',"%$text%",'LIKE');
			$db->orWhere('TimeStamp',"%$text%",'LIKE');
			$db->orWhere('LastUpdated',"%$text%",'LIKE');
		}
		if(!empty($this->orderby)){ // when order by request fields (from $_GET param)
			$db->orderBy($this->orderby,$this->ordertype);
		}
		else{
			$db->orderBy('JobNum', ORDER_TYPE);
		}
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get('jl_5_joblist', $limit, $fields);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		if($db->getLastError()){
			$this->view->page_error = $db->getLastError();
		}
		$this->view->page_title ="Joblist";
		$this->view->render('jl_5_joblist/list.php' , $data ,'main_layout.php');
	}
	/**
     * View Record Action 
     * @return View
     */
	function view( $rec_id = null , $value = null){
		$db = $this->GetModel();
		$fields = array( 'JobNum', 	'Dealer', 	'TagName', 	'Customer_Number', 	'RSO', 	'Door_Style', 	'Wood', 	'Colour', 	'Comments', 	'Requested_Date', 	'Received_Order', 	'Sent_To_OE', 	'Sent_To_Dealer', 	'Confirmation_Received', 	'Confirmed', 	'Sent_To_Plant', 	'Plant', 	'Inv', 	'OE', 	'Uppers', 	'Talls', 	'Bases', 	'Vanities', 	'Accessories', 	'Value', 	'Door_Vendor', 	'Priority', 	'Standard_Lead_Time', 	'Date_Shipped', 	'Other_ETA', 	'Door_ETA', 	'Back_Orders', 	'Back_Orders_Shipped', 	'Proposed_Shipping_Date', 	'Shipping_Comments', 	'Shipping_Details', 	'DealerRoute', 	'NJobNum', 	'OrgJobNum', 	'Creator', 	'UpdatedBy', 	'SalesRep', 	'TimeStamp', 	'LastUpdated' );
		if( !empty($value) ){
			$db->where($rec_id, urldecode($value));
		}
		else{
			$db->where('JobNum' , $rec_id);
		}
		$record = $db->getOne( 'jl_5_joblist', $fields );
		if(!empty($record)){
			$this->view->page_title ="View  Job";
			$this->view->render('jl_5_joblist/view.php' , $record ,'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error = $db->getLastError();
			}
			else{
				$this->view->page_error = "Record not found";
			}
			$this->view->render('jl_5_joblist/view.php' , $record , 'main_layout.php');
		}
	}
	/**
     * Add New Record Action 
     * If Not $_POST Request, Display Add Record Form View
     * @return View
     */
	function add(){
		if(is_post_request()){
			$modeldata = transform_request_data($_POST);
			$rules_array = array(
				'NJobNum' => 'required',
				'Dealer' => 'required',
				'TagName' => 'required',
				'Customer_Number' => 'required',
				'RSO' => 'required',
				'Received_Order' => 'required',
				'Value' => 'numeric',
			);
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}
			$modeldata['LastUpdated']=datetime_now();
			if( empty($this->view->page_error) ){
				$db = $this->GetModel();
				$rec_id = $db->insert( 'jl_5_joblist' , $modeldata );
				if(!empty($rec_id)){
					set_flash_msg('','');
					redirect_to_page("jl_5_joblist");
					return;
				}
				else{
					if($db->getLastError()){
						$this->view->page_error[] = $db->getLastError();
					}
					else{
						$this->view->page_error[] = "Error inserting record";
					}
				}
			}
		}
		$this->view->page_title ="Add New Job";
		$this->view->render('jl_5_joblist/add.php' ,null,'main_layout.php');
	}
	/**
     * Edit Record Action 
     * If Not $_POST Request, Display Edit Record Form View
     * @return View
     */
	function edit($rec_id=null){
		$db = $this->GetModel();
		if(is_post_request()){
			$modeldata = transform_request_data($_POST);
			$rules_array = array(
				'NJobNum' => 'required',
				'Dealer' => 'required',
				'TagName' => 'required',
				'Customer_Number' => 'required',
				'RSO' => 'required',
				'Uppers' => 'numeric',
				'Talls' => 'numeric',
				'Bases' => 'numeric',
				'Vanities' => 'numeric',
				'Accessories' => 'numeric',
				'Value' => 'numeric',
			);
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}
			$modeldata['LastUpdated']=datetime_now();
			if(empty($this->view->page_error)){
				$db->where('JobNum' , $rec_id);
				$bool = $db->update('jl_5_joblist',$modeldata);
				if($bool){
					set_flash_msg('','');
					redirect_to_page("jl_5_joblist");
					return;
				}
				else{
					$this->view->page_error[] = $db->getLastError();
				}
			}
		}
		$fields = array('NJobNum','JobNum','Dealer','TagName','Customer_Number','RSO','Door_Style','Wood','Colour','Comments','Requested_Date','Sent_To_OE','Sent_To_Dealer','Confirmed','Sent_To_Plant','Plant','Inv','OE','Uppers','Talls','Bases','Vanities','Accessories','Value','Door_Vendor','Priority','Standard_Lead_Time','Date_Shipped','Other_ETA','Door_ETA','Back_Orders','Back_Orders_Shipped','Proposed_Shipping_Date','Shipping_Comments','Shipping_Details','OrgJobNum','SalesRep','LastUpdated');
		$db->where('JobNum' , $rec_id);
		$data = $db->getOne('jl_5_joblist',$fields);
		$this->view->page_title ="Edit Job";
		if(!empty($data)){
			$this->view->render('jl_5_joblist/edit.php' , $data, 'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error[] = $db->getLastError();
			}
			else{
				$this->view->page_error[] = "Record not found";
			}
			$this->view->render('jl_5_joblist/edit.php' , $data , 'main_layout.php');
		}
	}
}
