<?php 
/**
 * Ql_5_Quotelist Page Controller
 * @category  Controller
 */
class Ql_5_QuotelistController extends SecureController{
	/**
     * Add New Record Action 
     * If Not $_POST Request, Display Add Record Form View
     * @return View
     */
	function add(){
		if(is_post_request()){
			$modeldata = transform_request_data($_POST);
			$rules_array = array(
				'Status' => 'required',
				'Dealer' => 'required',
				'TagName' => 'required',
			);
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}
			if( empty($this->view->page_error) ){
				$db = $this->GetModel();
				$rec_id = $db->insert( 'ql_5_quotelist' , $modeldata );
				if(!empty($rec_id)){
					set_flash_msg('','');
					redirect_to_page("ql_5_quotelist");
					return;
				}
				else{
					if($db->getLastError()){
						$this->view->page_error[] = $db->getLastError();
					}
					else{
						$this->view->page_error[] = "Error inserting record";
					}
				}
			}
		}
		$this->view->page_title ="Add Quote";
		$this->view->render('ql_5_quotelist/add.php' ,null,'main_layout.php');
	}
	/**
     * Delete Record Action 
     * @return View
     */
	function delete( $rec_ids = null ){
		$db = $this->GetModel();
		$arr_id = explode( ',', $rec_ids );
		foreach( $arr_id as $rec_id ){
			$db->where('QuoteNum' , $rec_id,"=",'OR');
		}
		$bool = $db->delete( 'ql_5_quotelist' );
		if($bool){
			set_flash_msg("Data Deleted",'success');
		}
		else{
			if($db->getLastError()){
				set_flash_msg($db->getLastError(),'danger');
			}
			else{
				set_flash_msg("Error deleting the record. please make sure that the record exit",'danger');
			}
		}
		redirect_to_page("ql_5_quotelist");
	}
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function open_quotrd($fieldname = null , $fieldvalue = null){
		$db = $this->GetModel();
		$fields = array('QuoteNum', 	'Dealer', 	'TagName', 	'QuoteEntry', 	'SalesRep', 	'RecdRFQ', 	'Value', 	'SentToQE', 	'SentToDealer', 	'Comments', 	'TimeStamp', 	'Originator', 	'NumRevisions', 	'jobnumber', 	'followupdate', 	'changed_by', 	'Status');
		$limit = $this->get_page_limit(50); // return pagination from BaseModel Class e.g array(5,20)
		if(!empty($this->search)){
			$text = $this->search;
			$db->orWhere('QuoteNum',"%$text%",'LIKE');
			$db->orWhere('Dealer',"%$text%",'LIKE');
			$db->orWhere('TagName',"%$text%",'LIKE');
			$db->orWhere('QuoteEntry',"%$text%",'LIKE');
			$db->orWhere('SalesRep',"%$text%",'LIKE');
			$db->orWhere('RecdRFQ',"%$text%",'LIKE');
			$db->orWhere('Value',"%$text%",'LIKE');
			$db->orWhere('SentToQE',"%$text%",'LIKE');
			$db->orWhere('SentToDealer',"%$text%",'LIKE');
			$db->orWhere('Comments',"%$text%",'LIKE');
			$db->orWhere('TimeStamp',"%$text%",'LIKE');
			$db->orWhere('Originator',"%$text%",'LIKE');
			$db->orWhere('NumRevisions',"%$text%",'LIKE');
			$db->orWhere('jobnumber',"%$text%",'LIKE');
			$db->orWhere('followupdate',"%$text%",'LIKE');
			$db->orWhere('changed_by',"%$text%",'LIKE');
			$db->orWhere('Status',"%$text%",'LIKE');
		}
		if(!empty($this->orderby)){ // when order by request fields (from $_GET param)
			$db->orderBy($this->orderby, $this->ordertype);
		}
		else{
			$db->orderBy("SalesRep","DESC");
		}
		$db->where("Status like 'O-%'");
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get('ql_5_quotelist', $limit, $fields);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		if($db->getLastError()){
			$this->view->page_error = $db->getLastError();
		}
		$this->view->page_title ="Quotelist - Open";
		$this->view->render('ql_5_quotelist/open_quotrd.php' , $data ,'main_layout.php');
	}
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function open_quotes_for_followup($fieldname = null , $fieldvalue = null){
		$db = $this->GetModel();
		$fields = array('Status', 	'followupdate', 	'QuoteNum', 	'Dealer', 	'TagName', 	'QuoteEntry', 	'SalesRep', 	'RecdRFQ', 	'Value', 	'SentToQE', 	'SentToDealer', 	'Comments', 	'TimeStamp', 	'Originator', 	'NumRevisions', 	'jobnumber', 	'changed_by');
		$limit = $this->get_page_limit(50); // return pagination from BaseModel Class e.g array(5,20)
		if(!empty($this->search)){
			$text = $this->search;
			$db->orWhere('Status',"%$text%",'LIKE');
			$db->orWhere('followupdate',"%$text%",'LIKE');
			$db->orWhere('QuoteNum',"%$text%",'LIKE');
			$db->orWhere('Dealer',"%$text%",'LIKE');
			$db->orWhere('TagName',"%$text%",'LIKE');
			$db->orWhere('QuoteEntry',"%$text%",'LIKE');
			$db->orWhere('SalesRep',"%$text%",'LIKE');
			$db->orWhere('RecdRFQ',"%$text%",'LIKE');
			$db->orWhere('Value',"%$text%",'LIKE');
			$db->orWhere('SentToQE',"%$text%",'LIKE');
			$db->orWhere('SentToDealer',"%$text%",'LIKE');
			$db->orWhere('Comments',"%$text%",'LIKE');
			$db->orWhere('TimeStamp',"%$text%",'LIKE');
			$db->orWhere('Originator',"%$text%",'LIKE');
			$db->orWhere('NumRevisions',"%$text%",'LIKE');
			$db->orWhere('jobnumber',"%$text%",'LIKE');
			$db->orWhere('changed_by',"%$text%",'LIKE');
		}
		if(!empty($this->orderby)){ // when order by request fields (from $_GET param)
			$db->orderBy($this->orderby, $this->ordertype);
		}
		else{
			$db->orderBy("followupdate","ASC");
		}
		$db->where("Status like 'O-%' AND `followupdate` <= NOW()");
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get('ql_5_quotelist', $limit, $fields);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		if($db->getLastError()){
			$this->view->page_error = $db->getLastError();
		}
		$this->view->page_title ="Quotelist - Open";
		$this->view->render('ql_5_quotelist/open_quotes_for_followup.php' , $data ,'main_layout.php');
	}
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function open_quotes_for_followup_future($fieldname = null , $fieldvalue = null){
		$db = $this->GetModel();
		$fields = array('Status', 	'followupdate', 	'QuoteNum', 	'Dealer', 	'TagName', 	'QuoteEntry', 	'SalesRep', 	'RecdRFQ', 	'Value', 	'SentToQE', 	'SentToDealer', 	'Comments', 	'TimeStamp', 	'Originator', 	'NumRevisions', 	'jobnumber', 	'changed_by');
		$limit = $this->get_page_limit(50); // return pagination from BaseModel Class e.g array(5,20)
		if(!empty($this->search)){
			$text = $this->search;
			$db->orWhere('Status',"%$text%",'LIKE');
			$db->orWhere('followupdate',"%$text%",'LIKE');
			$db->orWhere('QuoteNum',"%$text%",'LIKE');
			$db->orWhere('Dealer',"%$text%",'LIKE');
			$db->orWhere('TagName',"%$text%",'LIKE');
			$db->orWhere('QuoteEntry',"%$text%",'LIKE');
			$db->orWhere('SalesRep',"%$text%",'LIKE');
			$db->orWhere('RecdRFQ',"%$text%",'LIKE');
			$db->orWhere('Value',"%$text%",'LIKE');
			$db->orWhere('SentToQE',"%$text%",'LIKE');
			$db->orWhere('SentToDealer',"%$text%",'LIKE');
			$db->orWhere('Comments',"%$text%",'LIKE');
			$db->orWhere('TimeStamp',"%$text%",'LIKE');
			$db->orWhere('Originator',"%$text%",'LIKE');
			$db->orWhere('NumRevisions',"%$text%",'LIKE');
			$db->orWhere('jobnumber',"%$text%",'LIKE');
			$db->orWhere('changed_by',"%$text%",'LIKE');
		}
		if(!empty($this->orderby)){ // when order by request fields (from $_GET param)
			$db->orderBy($this->orderby, $this->ordertype);
		}
		else{
			$db->orderBy("followupdate","ASC");
		}
		$db->where("Status like 'O-%' AND `followupdate` > NOW()");
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get('ql_5_quotelist', $limit, $fields);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		if($db->getLastError()){
			$this->view->page_error = $db->getLastError();
		}
		$this->view->page_title ="Quotelist - Open";
		$this->view->render('ql_5_quotelist/open_quotes_for_followup_future.php' , $data ,'main_layout.php');
	}
}
