
<?php 
$can_add = PageAccessManager::is_allowed('jl_5_joblist/add');
$can_edit = PageAccessManager::is_allowed('jl_5_joblist/edit');
$can_view = PageAccessManager::is_allowed('jl_5_joblist/view');
$can_delete = PageAccessManager::is_allowed('jl_5_joblist/delete');
?>

<?php
$comp_model = new SharedController;

//Page Data From Controller
$view_data = $this->view_data;

$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = Router :: $field_name;
$field_value = Router :: $field_value;

$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;

?>

<section class="page">
    
    <?php
    if( $show_header == true ){
    ?>
    
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            
            <div class="row ">
                
                <div class="col-sm-4 comp-grid">
                    <h3 class="record-title">Joblist Not Invoiced</h3>
                    
                </div>
                
                <div class="col-sm-3 comp-grid">
                    
                    <?php 
                    if($can_add){
                    ?>
                    
                    <a  class="btn btn btn-primary btn-block" href="<?php print_link("jl_5_joblist/add") ?>">
                        <i class="material-icons">add</i>                               
                        Add New Jl 5 Joblist 
                    </a>
                    
                    <?php 
                    }
                    ?>
                    
                </div>
                
                <div class="col-sm-5 comp-grid">
                    
                    <form  class="search" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_query_str_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="material-icons">search</i></button>
                                </div>
                            </div>
                        </form>
                        
                    </div>
                    
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <?php
                            if(!empty($field_name) || !empty($field_name)){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item"><a class="text-capitalize" href="<?php print_link('jl_5_joblist') ?>"><?php echo $field_name ?></a></li>
                                    <li  class="breadcrumb-item active text-capitalize"><?php echo urldecode($field_value) ?></li>
                                    <?php 
                                    }   
                                    ?>
                                    <?php
                                    if(!empty($_GET['search'])){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-capitalize" href="<?php print_link('jl_5_joblist') ?>">Search</a>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize"> <strong><?php echo get_value('search'); ?></strong></li>
                                    <?php
                                    }
                                    ?>
                                    
                                </ul>
                            </nav>  
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
        
        <?php
        }
        ?>
        
        <div  class="">
            <div class="container-fluid">
                
                <div class="row ">
                    
                    <div class="col-md-12 comp-grid">
                        
                        <?php $this :: display_page_errors(); ?>
                        
                        <div  class="card animated fadeIn">
                            <div id="jl_5_joblist-not_invoiced-records">
                                
                                <?php
                                if(!empty($records)){
                                ?>
                                <div class="page-records table-responsive">
                                    <table class="table  table-striped table-sm">
                                        <thead class="table-header bg-light">
                                            <tr>
                                                <th class="td-sno td-checkbox"><input class="toggle-check-all" type="checkbox" /></th>
                                                
                                                
                                                <th > Jobnum</th>
                                                <th > Dealer</th>
                                                <th > Tagname</th>
                                                <th > Customer Number</th>
                                                <th > Rso</th>
                                                <th > Door Style</th>
                                                <th > Wood</th>
                                                <th > Colour</th>
                                                <th > Comments</th>
                                                <th > Requested Date</th>
                                                <th > Received Order</th>
                                                <th > Sent To Oe</th>
                                                <th > Sent To Dealer</th>
                                                <th > Confirmation Received</th>
                                                <th > Confirmed</th>
                                                <th > Sent To Plant</th>
                                                <th > Plant</th>
                                                <th > Inv</th>
                                                <th > Oe</th>
                                                <th > Uppers</th>
                                                <th > Talls</th>
                                                <th > Bases</th>
                                                <th > Vanities</th>
                                                <th > Accessories</th>
                                                <th > Value</th>
                                                <th > Door Vendor</th>
                                                <th > Priority</th>
                                                <th > Standard Lead Time</th>
                                                <th > Date Shipped</th>
                                                <th > Other Eta</th>
                                                <th > Door Eta</th>
                                                <th > Back Orders</th>
                                                <th > Back Orders Shipped</th>
                                                <th > Proposed Shipping Date</th>
                                                <th > Shipping Comments</th>
                                                <th > Shipping Details</th>
                                                <th > Dealerroute</th>
                                                <th > Njobnum</th>
                                                <th > Orgjobnum</th>
                                                <th > Creator</th>
                                                <th > Updatedby</th>
                                                <th > Salesrep</th>
                                                <th > Timestamp</th>
                                                <th > Lastupdated</th>
                                                
                                                <th class="td-btn"></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            
                                            <?php
                                            
                                            foreach($records as $data){
                                            
                                            ?>
                                            <tr>
                                                
                                                <th class=" td-checkbox">
                                                    <label>
                                                        <input class="optioncheck" name="optioncheck[]" value="<?php echo $data['JobNum'] ?>" type="checkbox" />
                                                        </label>
                                                    </th>
                                                    
                                                    
                                                    <td><a href="<?php print_link("jl_5_joblist/view/$data[JobNum]") ?>"><?php echo $data['JobNum']; ?></a></td>
                                                    <td> <?php echo $data['Dealer']; ?> </td>
                                                    <td> <?php echo $data['TagName']; ?> </td>
                                                    <td> <?php echo $data['Customer_Number']; ?> </td>
                                                    <td> <?php echo $data['RSO']; ?> </td>
                                                    <td> <?php echo $data['Door_Style']; ?> </td>
                                                    <td> <?php echo $data['Wood']; ?> </td>
                                                    <td> <?php echo $data['Colour']; ?> </td>
                                                    <td> <?php echo $data['Comments']; ?> </td>
                                                    <td> <?php echo $data['Requested_Date']; ?> </td>
                                                    <td> <?php echo $data['Received_Order']; ?> </td>
                                                    <td> <?php echo $data['Sent_To_OE']; ?> </td>
                                                    <td> <?php echo $data['Sent_To_Dealer']; ?> </td>
                                                    <td> <?php echo $data['Confirmation_Received']; ?> </td>
                                                    <td> <?php echo $data['Confirmed']; ?> </td>
                                                    <td> <?php echo $data['Sent_To_Plant']; ?> </td>
                                                    <td> <?php echo $data['Plant']; ?> </td>
                                                    <td> <?php echo $data['Inv']; ?> </td>
                                                    <td> <?php echo $data['OE']; ?> </td>
                                                    <td> <?php echo $data['Uppers']; ?> </td>
                                                    <td> <?php echo $data['Talls']; ?> </td>
                                                    <td> <?php echo $data['Bases']; ?> </td>
                                                    <td> <?php echo $data['Vanities']; ?> </td>
                                                    <td> <?php echo $data['Accessories']; ?> </td>
                                                    <td> <?php echo $data['Value']; ?> </td>
                                                    <td> <?php echo $data['Door_Vendor']; ?> </td>
                                                    <td> <?php echo $data['Priority']; ?> </td>
                                                    <td> <?php echo $data['Standard_Lead_Time']; ?> </td>
                                                    <td> <?php echo $data['Date_Shipped']; ?> </td>
                                                    <td> <?php echo $data['Other_ETA']; ?> </td>
                                                    <td> <?php echo $data['Door_ETA']; ?> </td>
                                                    <td> <?php echo $data['Back_Orders']; ?> </td>
                                                    <td> <?php echo $data['Back_Orders_Shipped']; ?> </td>
                                                    <td> <?php echo $data['Proposed_Shipping_Date']; ?> </td>
                                                    <td> <?php echo $data['Shipping_Comments']; ?> </td>
                                                    <td> <?php echo $data['Shipping_Details']; ?> </td>
                                                    <td> <?php echo $data['DealerRoute']; ?> </td>
                                                    <td> <?php echo $data['NJobNum']; ?> </td>
                                                    <td> <?php echo $data['OrgJobNum']; ?> </td>
                                                    <td> <?php echo $data['Creator']; ?> </td>
                                                    <td> <?php echo $data['UpdatedBy']; ?> </td>
                                                    <td> <?php echo $data['SalesRep']; ?> </td>
                                                    <td> <?php echo $data['TimeStamp']; ?> </td>
                                                    <td> <?php echo $data['LastUpdated']; ?> </td>
                                                    
                                                    
                                                    <th class="td-btn">
                                                        
                                                        
                                                        
                                                        <?php 
                                                        if($can_edit){
                                                        ?>
                                                        
                                                        <a class="btn btn-sm btn-info has-tooltip" title="Edit This Record" href="<?php print_link('jl_5_joblist/edit/'.$data['JobNum']); ?>">
                                                            <i class="material-icons">edit</i> 
                                                        </a>
                                                        
                                                        <?php 
                                                        }
                                                        ?>
                                                        
                                                        
                                                        
                                                    </th>
                                                </tr>
                                                <?php 
                                                }
                                                ?>
                                                
                                            </tbody>
                                        </table>
                                    </div>
                                    <?php
                                    if( $show_footer == true ){
                                    ?>
                                    <div class="card-footer">
                                        <div class="row">   
                                            <div class="col-sm-3">  
                                                
                                                <button data-prompt-msg="Are you sure you want to delete these records" data-url="<?php print_link("jl_5_joblist/delete/{sel_ids}"); ?>" class="btn btn-sm btn-danger btn-delete-selected d-none">
                                                    <i class="material-icons">clear</i> Delete Selected
                                                </button>
                                                
                                                
                                                <button class="btn btn-sm btn-primary export-btn"><i class="material-icons">save</i> </button>
                                                
                                                
                                            </div>
                                            <div class="col">   
                                                
                                                <?php
                                                if( $show_pagination == true ){
                                                $pager = new Pagination($total_records,$record_count);
                                                $pager->page_name='jl_5_joblist';
                                                $pager->show_page_count=true;
                                                $pager->show_record_count=true;
                                                $pager->show_page_limit=true;
                                                $pager->show_page_number_list=true;
                                                $pager->pager_link_range=5;
                                                
                                                $pager->render();
                                                }
                                                ?>
                                                
                                            </div>
                                        </div>
                                    </div>
                                    <?php
                                    }
                                    }
                                    else{
                                    ?>
                                    <div class="text-muted animated bounce">
                                        <h4><i class="material-icons">block</i> </h4>
                                    </div>
                                    <?php
                                    }
                                    ?>
                                    
                                </div>
                            </div>
                            
                        </div>
                        
                    </div>
                </div>
            </div>
            
        </section>
        