<?php 
/**
 * Jlv2_jl_5_joblist Page Controller
 * @category  Controller
 */
class Jlv2_jl_5_joblistController extends SecureController{
	function __construct(){
		parent::__construct();
		$this->tablename = "jlv2_jl_5_joblist";
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("Full_Job_Number","Job_Number","Dealer","Tag_Name","Customer_PO","Rush","Door_Style","Wood","Colour","Comments","Requested_Date","Received_Order","Sent_To_OE","Sent_For_Confirmation","Confirmation_Received","Confirmed","Sent_To_Plant","Plant","Invoiced","OE","Uppers","Talls","Bases","Vanities","Accessories","Value","Door_Vendor","Standard_Lead_Time","Date_Shipped","Other_ETA","Door_ETA","Back_Orders","Back_Orders_Shipped","Proposed_Shipping_Date","Shipping_Comments","Shipping_Details","DealerRoute","Job_Number_Prefix","Original_Job_Number","Creator","UpdatedBy","Sales_Rep","LastUpdated","Status");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'Full_Job_Number' => 'required',
				'Dealer' => 'required',
				'Tag_Name' => 'required',
				'Customer_PO' => 'required',
				'Rush' => 'required',
				'Door_Style' => 'required',
				'Wood' => 'required',
				'Colour' => 'required',
				'Comments' => 'required',
				'Requested_Date' => 'required',
				'Received_Order' => 'required',
				'Sent_To_OE' => 'required',
				'Sent_For_Confirmation' => 'required',
				'Confirmation_Received' => 'required',
				'Confirmed' => 'required',
				'Sent_To_Plant' => 'required',
				'Plant' => 'required',
				'Invoiced' => 'required',
				'OE' => 'required',
				'Uppers' => 'required|numeric',
				'Talls' => 'required|numeric',
				'Bases' => 'required|numeric',
				'Vanities' => 'required|numeric',
				'Accessories' => 'required|numeric',
				'Value' => 'required|numeric',
				'Door_Vendor' => 'required',
				'Standard_Lead_Time' => 'required',
				'Date_Shipped' => 'required',
				'Other_ETA' => 'required',
				'Door_ETA' => 'required',
				'Back_Orders' => 'required',
				'Back_Orders_Shipped' => 'required',
				'Proposed_Shipping_Date' => 'required',
				'Shipping_Comments' => 'required',
				'Shipping_Details' => 'required',
				'DealerRoute' => 'required',
				'Job_Number_Prefix' => 'required',
				'Original_Job_Number' => 'required',
				'Creator' => 'required',
				'UpdatedBy' => 'required',
				'Sales_Rep' => 'required',
				'LastUpdated' => 'required',
				'Status' => 'required',
			);
			$this->sanitize_array = array(
				'Full_Job_Number' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'Tag_Name' => 'sanitize_string',
				'Customer_PO' => 'sanitize_string',
				'Rush' => 'sanitize_string',
				'Door_Style' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'Requested_Date' => 'sanitize_string',
				'Received_Order' => 'sanitize_string',
				'Sent_To_OE' => 'sanitize_string',
				'Sent_For_Confirmation' => 'sanitize_string',
				'Confirmation_Received' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'Sent_To_Plant' => 'sanitize_string',
				'Plant' => 'sanitize_string',
				'Invoiced' => 'sanitize_string',
				'OE' => 'sanitize_string',
				'Uppers' => 'sanitize_string',
				'Talls' => 'sanitize_string',
				'Bases' => 'sanitize_string',
				'Vanities' => 'sanitize_string',
				'Accessories' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'Door_Vendor' => 'sanitize_string',
				'Standard_Lead_Time' => 'sanitize_string',
				'Date_Shipped' => 'sanitize_string',
				'Other_ETA' => 'sanitize_string',
				'Door_ETA' => 'sanitize_string',
				'Back_Orders' => 'sanitize_string',
				'Back_Orders_Shipped' => 'sanitize_string',
				'Proposed_Shipping_Date' => 'sanitize_string',
				'Shipping_Comments' => 'sanitize_string',
				'Shipping_Details' => 'sanitize_string',
				'DealerRoute' => 'sanitize_string',
				'Job_Number_Prefix' => 'sanitize_string',
				'Original_Job_Number' => 'sanitize_string',
				'Creator' => 'sanitize_string',
				'UpdatedBy' => 'sanitize_string',
				'Sales_Rep' => 'sanitize_string',
				'LastUpdated' => 'sanitize_string',
				'Status' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("jlv2_jl_5_joblist.Job_Number", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					$this->write_to_log("edit", "true");
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					$this->write_to_log("edit", "false");
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
}
