<?php 
/**
 * Jlv2_jl_6_joblist_historyold Page Controller
 * @category  Controller
 */
class Jlv2_jl_6_joblist_historyoldController extends SecureController{
	function __construct(){
		parent::__construct();
		$this->tablename = "jlv2_jl_6_joblist_historyold";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("Full_Job_Number", 
			"Job_Number", 
			"Dealer", 
			"TagName", 
			"Customer_Number", 
			"RSO", 
			"Door_Style", 
			"Wood", 
			"Colour", 
			"Comments", 
			"Requested_Date", 
			"Received_Order", 
			"Sent_To_OE", 
			"Sent_For_Confirmation", 
			"Confirmation_Received", 
			"Confirmed", 
			"Sent_To_Plant", 
			"Plant", 
			"Inv", 
			"OE", 
			"Uppers", 
			"Talls", 
			"Bases", 
			"Vanities", 
			"Accessories", 
			"Value", 
			"Door_Vendor", 
			"Standard_Lead_Time", 
			"Date_Shipped", 
			"Other_ETA", 
			"Door_ETA", 
			"Back_Orders", 
			"Back_Orders_Shipped", 
			"Proposed_Shipping_Date", 
			"Shipping_Comments", 
			"Shipping_Details", 
			"DealerRoute", 
			"NJobNum", 
			"OrgJobNum", 
			"Creator", 
			"UpdatedBy", 
			"SalesRep", 
			"TimeStamp", 
			"LastUpdated", 
			"Status", 
			"pk_History_ID", 
			"ActorID", 
			"History_Date");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				jlv2_jl_6_joblist_historyold.Full_Job_Number LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Job_Number LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Dealer LIKE ? OR 
				jlv2_jl_6_joblist_historyold.TagName LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Customer_Number LIKE ? OR 
				jlv2_jl_6_joblist_historyold.RSO LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Door_Style LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Wood LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Colour LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Comments LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Requested_Date LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Received_Order LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Sent_To_OE LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Sent_For_Confirmation LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Confirmation_Received LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Confirmed LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Sent_To_Plant LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Plant LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Inv LIKE ? OR 
				jlv2_jl_6_joblist_historyold.OE LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Uppers LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Talls LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Bases LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Vanities LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Accessories LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Value LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Door_Vendor LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Standard_Lead_Time LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Date_Shipped LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Other_ETA LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Door_ETA LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Back_Orders LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Back_Orders_Shipped LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Proposed_Shipping_Date LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Shipping_Comments LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Shipping_Details LIKE ? OR 
				jlv2_jl_6_joblist_historyold.DealerRoute LIKE ? OR 
				jlv2_jl_6_joblist_historyold.NJobNum LIKE ? OR 
				jlv2_jl_6_joblist_historyold.OrgJobNum LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Creator LIKE ? OR 
				jlv2_jl_6_joblist_historyold.UpdatedBy LIKE ? OR 
				jlv2_jl_6_joblist_historyold.SalesRep LIKE ? OR 
				jlv2_jl_6_joblist_historyold.TimeStamp LIKE ? OR 
				jlv2_jl_6_joblist_historyold.LastUpdated LIKE ? OR 
				jlv2_jl_6_joblist_historyold.Status LIKE ? OR 
				jlv2_jl_6_joblist_historyold.pk_History_ID LIKE ? OR 
				jlv2_jl_6_joblist_historyold.ActorID LIKE ? OR 
				jlv2_jl_6_joblist_historyold.History_Date LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "jlv2_jl_6_joblist_historyold/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("jlv2_jl_6_joblist_historyold.pk_History_ID", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		//list of record id for audit trail
		$this->rec_id = array_column($records, "pk_History_ID");
		$this->write_to_log("list", "true");
		if($db->getLastError()){
			$this->set_page_error();
			$this->write_to_log("list", "false");
		}
		$page_title = $this->view->page_title = "Jlv2 Jl 6 Joblist Historyold";
		$this->render_view("jlv2_jl_6_joblist_historyold/list.php", $data); //render the full page
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("Full_Job_Number", 
			"Job_Number", 
			"Dealer", 
			"TagName", 
			"Customer_Number", 
			"RSO", 
			"Door_Style", 
			"Wood", 
			"Colour", 
			"Comments", 
			"Requested_Date", 
			"Received_Order", 
			"Sent_To_OE", 
			"Sent_For_Confirmation", 
			"Confirmation_Received", 
			"Confirmed", 
			"Sent_To_Plant", 
			"Plant", 
			"Inv", 
			"OE", 
			"Uppers", 
			"Talls", 
			"Bases", 
			"Vanities", 
			"Accessories", 
			"Value", 
			"Door_Vendor", 
			"Standard_Lead_Time", 
			"Date_Shipped", 
			"Other_ETA", 
			"Door_ETA", 
			"Back_Orders", 
			"Back_Orders_Shipped", 
			"Proposed_Shipping_Date", 
			"Shipping_Comments", 
			"Shipping_Details", 
			"DealerRoute", 
			"NJobNum", 
			"OrgJobNum", 
			"Creator", 
			"UpdatedBy", 
			"SalesRep", 
			"TimeStamp", 
			"LastUpdated", 
			"Status", 
			"pk_History_ID", 
			"ActorID", 
			"History_Date");
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("jlv2_jl_6_joblist_historyold.pk_History_ID", $rec_id);; //select record based on primary key
		}
		$record = $db->getOne($tablename, $fields );
		if($record){
			$this->write_to_log("view", "true");
			$page_title = $this->view->page_title = "View  Jlv2 Jl 6 Joblist Historyold";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
			$this->write_to_log("view", "false");
		}
		return $this->render_view("jlv2_jl_6_joblist_historyold/view.php", $record);
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("Full_Job_Number","Job_Number","Dealer","TagName","Customer_Number","RSO","Door_Style","Wood","Colour","Comments","Requested_Date","Received_Order","Sent_To_OE","Sent_For_Confirmation","Confirmation_Received","Confirmed","Sent_To_Plant","Plant","Inv","OE","Uppers","Talls","Bases","Vanities","Accessories","Value","Door_Vendor","Standard_Lead_Time","Date_Shipped","Other_ETA","Door_ETA","Back_Orders","Back_Orders_Shipped","Proposed_Shipping_Date","Shipping_Comments","Shipping_Details","DealerRoute","NJobNum","OrgJobNum","Creator","UpdatedBy","SalesRep","TimeStamp","LastUpdated","Status","ActorID");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'Full_Job_Number' => 'required',
				'Job_Number' => 'required|numeric',
				'Dealer' => 'required',
				'TagName' => 'required',
				'Customer_Number' => 'required',
				'RSO' => 'required',
				'Door_Style' => 'required',
				'Wood' => 'required',
				'Colour' => 'required',
				'Comments' => 'required',
				'Requested_Date' => 'required',
				'Received_Order' => 'required',
				'Sent_To_OE' => 'required',
				'Sent_For_Confirmation' => 'required',
				'Confirmation_Received' => 'required',
				'Confirmed' => 'required',
				'Sent_To_Plant' => 'required',
				'Plant' => 'required',
				'Inv' => 'required',
				'OE' => 'required',
				'Uppers' => 'required|numeric',
				'Talls' => 'required|numeric',
				'Bases' => 'required|numeric',
				'Vanities' => 'required|numeric',
				'Accessories' => 'required|numeric',
				'Value' => 'required|numeric',
				'Door_Vendor' => 'required',
				'Standard_Lead_Time' => 'required',
				'Date_Shipped' => 'required',
				'Other_ETA' => 'required',
				'Door_ETA' => 'required',
				'Back_Orders' => 'required',
				'Back_Orders_Shipped' => 'required',
				'Proposed_Shipping_Date' => 'required',
				'Shipping_Comments' => 'required',
				'Shipping_Details' => 'required',
				'DealerRoute' => 'required',
				'NJobNum' => 'required',
				'OrgJobNum' => 'required',
				'Creator' => 'required',
				'UpdatedBy' => 'required',
				'SalesRep' => 'required',
				'TimeStamp' => 'required',
				'LastUpdated' => 'required',
				'Status' => 'required',
				'ActorID' => 'required|numeric',
			);
			$this->sanitize_array = array(
				'Full_Job_Number' => 'sanitize_string',
				'Job_Number' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'TagName' => 'sanitize_string',
				'Customer_Number' => 'sanitize_string',
				'RSO' => 'sanitize_string',
				'Door_Style' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'Requested_Date' => 'sanitize_string',
				'Received_Order' => 'sanitize_string',
				'Sent_To_OE' => 'sanitize_string',
				'Sent_For_Confirmation' => 'sanitize_string',
				'Confirmation_Received' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'Sent_To_Plant' => 'sanitize_string',
				'Plant' => 'sanitize_string',
				'Inv' => 'sanitize_string',
				'OE' => 'sanitize_string',
				'Uppers' => 'sanitize_string',
				'Talls' => 'sanitize_string',
				'Bases' => 'sanitize_string',
				'Vanities' => 'sanitize_string',
				'Accessories' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'Door_Vendor' => 'sanitize_string',
				'Standard_Lead_Time' => 'sanitize_string',
				'Date_Shipped' => 'sanitize_string',
				'Other_ETA' => 'sanitize_string',
				'Door_ETA' => 'sanitize_string',
				'Back_Orders' => 'sanitize_string',
				'Back_Orders_Shipped' => 'sanitize_string',
				'Proposed_Shipping_Date' => 'sanitize_string',
				'Shipping_Comments' => 'sanitize_string',
				'Shipping_Details' => 'sanitize_string',
				'DealerRoute' => 'sanitize_string',
				'NJobNum' => 'sanitize_string',
				'OrgJobNum' => 'sanitize_string',
				'Creator' => 'sanitize_string',
				'UpdatedBy' => 'sanitize_string',
				'SalesRep' => 'sanitize_string',
				'TimeStamp' => 'sanitize_string',
				'LastUpdated' => 'sanitize_string',
				'Status' => 'sanitize_string',
				'ActorID' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->write_to_log("add", "true");
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("jlv2_jl_6_joblist_historyold");
				}
				else{
					$this->set_page_error();
					$this->write_to_log("add", "false");
				}
			}
		}
		$page_title = $this->view->page_title = "Add New Jlv2 Jl 6 Joblist Historyold";
		$this->render_view("jlv2_jl_6_joblist_historyold/add.php");
	}
	/**
     * Update table record with formdata
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function edit($rec_id = null, $formdata = null){
		$request = $this->request;
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		 //editable fields
		$fields = $this->fields = array("Full_Job_Number","Job_Number","Dealer","TagName","Customer_Number","RSO","Door_Style","Wood","Colour","Comments","Requested_Date","Received_Order","Sent_To_OE","Sent_For_Confirmation","Confirmation_Received","Confirmed","Sent_To_Plant","Plant","Inv","OE","Uppers","Talls","Bases","Vanities","Accessories","Value","Door_Vendor","Standard_Lead_Time","Date_Shipped","Other_ETA","Door_ETA","Back_Orders","Back_Orders_Shipped","Proposed_Shipping_Date","Shipping_Comments","Shipping_Details","DealerRoute","NJobNum","OrgJobNum","Creator","UpdatedBy","SalesRep","TimeStamp","LastUpdated","Status","pk_History_ID","ActorID");
		if($formdata){
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'Full_Job_Number' => 'required',
				'Job_Number' => 'required|numeric',
				'Dealer' => 'required',
				'TagName' => 'required',
				'Customer_Number' => 'required',
				'RSO' => 'required',
				'Door_Style' => 'required',
				'Wood' => 'required',
				'Colour' => 'required',
				'Comments' => 'required',
				'Requested_Date' => 'required',
				'Received_Order' => 'required',
				'Sent_To_OE' => 'required',
				'Sent_For_Confirmation' => 'required',
				'Confirmation_Received' => 'required',
				'Confirmed' => 'required',
				'Sent_To_Plant' => 'required',
				'Plant' => 'required',
				'Inv' => 'required',
				'OE' => 'required',
				'Uppers' => 'required|numeric',
				'Talls' => 'required|numeric',
				'Bases' => 'required|numeric',
				'Vanities' => 'required|numeric',
				'Accessories' => 'required|numeric',
				'Value' => 'required|numeric',
				'Door_Vendor' => 'required',
				'Standard_Lead_Time' => 'required',
				'Date_Shipped' => 'required',
				'Other_ETA' => 'required',
				'Door_ETA' => 'required',
				'Back_Orders' => 'required',
				'Back_Orders_Shipped' => 'required',
				'Proposed_Shipping_Date' => 'required',
				'Shipping_Comments' => 'required',
				'Shipping_Details' => 'required',
				'DealerRoute' => 'required',
				'NJobNum' => 'required',
				'OrgJobNum' => 'required',
				'Creator' => 'required',
				'UpdatedBy' => 'required',
				'SalesRep' => 'required',
				'TimeStamp' => 'required',
				'LastUpdated' => 'required',
				'Status' => 'required',
				'ActorID' => 'required|numeric',
			);
			$this->sanitize_array = array(
				'Full_Job_Number' => 'sanitize_string',
				'Job_Number' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'TagName' => 'sanitize_string',
				'Customer_Number' => 'sanitize_string',
				'RSO' => 'sanitize_string',
				'Door_Style' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'Requested_Date' => 'sanitize_string',
				'Received_Order' => 'sanitize_string',
				'Sent_To_OE' => 'sanitize_string',
				'Sent_For_Confirmation' => 'sanitize_string',
				'Confirmation_Received' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'Sent_To_Plant' => 'sanitize_string',
				'Plant' => 'sanitize_string',
				'Inv' => 'sanitize_string',
				'OE' => 'sanitize_string',
				'Uppers' => 'sanitize_string',
				'Talls' => 'sanitize_string',
				'Bases' => 'sanitize_string',
				'Vanities' => 'sanitize_string',
				'Accessories' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'Door_Vendor' => 'sanitize_string',
				'Standard_Lead_Time' => 'sanitize_string',
				'Date_Shipped' => 'sanitize_string',
				'Other_ETA' => 'sanitize_string',
				'Door_ETA' => 'sanitize_string',
				'Back_Orders' => 'sanitize_string',
				'Back_Orders_Shipped' => 'sanitize_string',
				'Proposed_Shipping_Date' => 'sanitize_string',
				'Shipping_Comments' => 'sanitize_string',
				'Shipping_Details' => 'sanitize_string',
				'DealerRoute' => 'sanitize_string',
				'NJobNum' => 'sanitize_string',
				'OrgJobNum' => 'sanitize_string',
				'Creator' => 'sanitize_string',
				'UpdatedBy' => 'sanitize_string',
				'SalesRep' => 'sanitize_string',
				'TimeStamp' => 'sanitize_string',
				'LastUpdated' => 'sanitize_string',
				'Status' => 'sanitize_string',
				'ActorID' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("jlv2_jl_6_joblist_historyold.pk_History_ID", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					$this->write_to_log("edit", "true");
					$this->set_flash_msg("Record updated successfully", "success");
					return $this->redirect("jlv2_jl_6_joblist_historyold");
				}
				else{
					if($db->getLastError()){
						$this->set_page_error();
						$this->write_to_log("edit", "false");
					}
					elseif(!$numRows){
						//not an error, but no record was updated
						$page_error = "No record updated";
						$this->set_page_error($page_error);
						$this->set_flash_msg($page_error, "warning");
						$this->write_to_log("edit", "false");
						return	$this->redirect("jlv2_jl_6_joblist_historyold");
					}
				}
			}
		}
		$db->where("jlv2_jl_6_joblist_historyold.pk_History_ID", $rec_id);;
		$data = $db->getOne($tablename, $fields);
		$page_title = $this->view->page_title = "Edit  Jlv2 Jl 6 Joblist Historyold";
		if(!$data){
			$this->set_page_error();
		}
		return $this->render_view("jlv2_jl_6_joblist_historyold/edit.php", $data);
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("Full_Job_Number","Job_Number","Dealer","TagName","Customer_Number","RSO","Door_Style","Wood","Colour","Comments","Requested_Date","Received_Order","Sent_To_OE","Sent_For_Confirmation","Confirmation_Received","Confirmed","Sent_To_Plant","Plant","Inv","OE","Uppers","Talls","Bases","Vanities","Accessories","Value","Door_Vendor","Standard_Lead_Time","Date_Shipped","Other_ETA","Door_ETA","Back_Orders","Back_Orders_Shipped","Proposed_Shipping_Date","Shipping_Comments","Shipping_Details","DealerRoute","NJobNum","OrgJobNum","Creator","UpdatedBy","SalesRep","TimeStamp","LastUpdated","Status","pk_History_ID","ActorID");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'Full_Job_Number' => 'required',
				'Job_Number' => 'required|numeric',
				'Dealer' => 'required',
				'TagName' => 'required',
				'Customer_Number' => 'required',
				'RSO' => 'required',
				'Door_Style' => 'required',
				'Wood' => 'required',
				'Colour' => 'required',
				'Comments' => 'required',
				'Requested_Date' => 'required',
				'Received_Order' => 'required',
				'Sent_To_OE' => 'required',
				'Sent_For_Confirmation' => 'required',
				'Confirmation_Received' => 'required',
				'Confirmed' => 'required',
				'Sent_To_Plant' => 'required',
				'Plant' => 'required',
				'Inv' => 'required',
				'OE' => 'required',
				'Uppers' => 'required|numeric',
				'Talls' => 'required|numeric',
				'Bases' => 'required|numeric',
				'Vanities' => 'required|numeric',
				'Accessories' => 'required|numeric',
				'Value' => 'required|numeric',
				'Door_Vendor' => 'required',
				'Standard_Lead_Time' => 'required',
				'Date_Shipped' => 'required',
				'Other_ETA' => 'required',
				'Door_ETA' => 'required',
				'Back_Orders' => 'required',
				'Back_Orders_Shipped' => 'required',
				'Proposed_Shipping_Date' => 'required',
				'Shipping_Comments' => 'required',
				'Shipping_Details' => 'required',
				'DealerRoute' => 'required',
				'NJobNum' => 'required',
				'OrgJobNum' => 'required',
				'Creator' => 'required',
				'UpdatedBy' => 'required',
				'SalesRep' => 'required',
				'TimeStamp' => 'required',
				'LastUpdated' => 'required',
				'Status' => 'required',
				'ActorID' => 'required|numeric',
			);
			$this->sanitize_array = array(
				'Full_Job_Number' => 'sanitize_string',
				'Job_Number' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'TagName' => 'sanitize_string',
				'Customer_Number' => 'sanitize_string',
				'RSO' => 'sanitize_string',
				'Door_Style' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'Requested_Date' => 'sanitize_string',
				'Received_Order' => 'sanitize_string',
				'Sent_To_OE' => 'sanitize_string',
				'Sent_For_Confirmation' => 'sanitize_string',
				'Confirmation_Received' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'Sent_To_Plant' => 'sanitize_string',
				'Plant' => 'sanitize_string',
				'Inv' => 'sanitize_string',
				'OE' => 'sanitize_string',
				'Uppers' => 'sanitize_string',
				'Talls' => 'sanitize_string',
				'Bases' => 'sanitize_string',
				'Vanities' => 'sanitize_string',
				'Accessories' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'Door_Vendor' => 'sanitize_string',
				'Standard_Lead_Time' => 'sanitize_string',
				'Date_Shipped' => 'sanitize_string',
				'Other_ETA' => 'sanitize_string',
				'Door_ETA' => 'sanitize_string',
				'Back_Orders' => 'sanitize_string',
				'Back_Orders_Shipped' => 'sanitize_string',
				'Proposed_Shipping_Date' => 'sanitize_string',
				'Shipping_Comments' => 'sanitize_string',
				'Shipping_Details' => 'sanitize_string',
				'DealerRoute' => 'sanitize_string',
				'NJobNum' => 'sanitize_string',
				'OrgJobNum' => 'sanitize_string',
				'Creator' => 'sanitize_string',
				'UpdatedBy' => 'sanitize_string',
				'SalesRep' => 'sanitize_string',
				'TimeStamp' => 'sanitize_string',
				'LastUpdated' => 'sanitize_string',
				'Status' => 'sanitize_string',
				'ActorID' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("jlv2_jl_6_joblist_historyold.pk_History_ID", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					$this->write_to_log("edit", "true");
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					$this->write_to_log("edit", "false");
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
	/**
     * Delete record from the database
	 * Support multi delete by separating record id by comma.
     * @return BaseView
     */
	function delete($rec_id = null){
		Csrf::cross_check();
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$this->rec_id = $rec_id;
		//form multiple delete, split record id separated by comma into array
		$arr_rec_id = array_map('trim', explode(",", $rec_id));
		$db->where("jlv2_jl_6_joblist_historyold.pk_History_ID", $arr_rec_id, "in");
		$bool = $db->delete($tablename);
		if($bool){
			$this->write_to_log("delete", "true");
			$this->set_flash_msg("Record deleted successfully", "success");
		}
		elseif($db->getLastError()){
			$page_error = $db->getLastError();
			$this->set_flash_msg($page_error, "danger");
			$this->write_to_log("delete", "false");
		}
		return	$this->redirect("jlv2_jl_6_joblist_historyold");
	}
}
