<?php 
/**
 * Maintenance_checklist_items Page Controller
 * @category  Controller
 */
class Maintenance_checklist_itemsController extends SecureController{
	function __construct(){
		parent::__construct();
		$this->tablename = "maintenance_checklist_items";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("maintenance_checklist_items.PK_Maintenance_Checklist_item_id", 
			"maintenance_checklist.Title AS maintenance_checklist_Title", 
			"maintenance_checklist_items.Title", 
			"maintenance_checklist_items.Description", 
			"maintenance_checklist.Assign_To AS maintenance_checklist_Assign_To", 
			"maintenance_checklist.Time_Monday AS maintenance_checklist_Time_Monday", 
			"maintenance_checklist.Time_Tuesday AS maintenance_checklist_Time_Tuesday", 
			"maintenance_checklist.Time_Wednesday AS maintenance_checklist_Time_Wednesday", 
			"maintenance_checklist.Time_Thursday AS maintenance_checklist_Time_Thursday", 
			"maintenance_checklist.Time_Friday AS maintenance_checklist_Time_Friday", 
			"maintenance_checklist.Status AS maintenance_checklist_Status", 
			"maintenance_checklist.Manager AS maintenance_checklist_Manager");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				maintenance_checklist_items.PK_Maintenance_Checklist_item_id LIKE ? OR 
				maintenance_checklist_items.fk_maintenance_checklist_id LIKE ? OR 
				maintenance_checklist.Title LIKE ? OR 
				maintenance_checklist_items.Title LIKE ? OR 
				maintenance_checklist_items.Description LIKE ? OR 
				maintenance_checklist_items.Time_Monday LIKE ? OR 
				maintenance_checklist_items.Time_Tuesday LIKE ? OR 
				maintenance_checklist_items.Time_Wednesday LIKE ? OR 
				maintenance_checklist_items.Time_Thursday LIKE ? OR 
				maintenance_checklist_items.Time_Friday LIKE ? OR 
				maintenance_checklist.PK_Maintenance_Checklist_id LIKE ? OR 
				maintenance_checklist.Description LIKE ? OR 
				maintenance_checklist.Assign_To LIKE ? OR 
				maintenance_checklist.Time_Monday LIKE ? OR 
				maintenance_checklist.Time_Tuesday LIKE ? OR 
				maintenance_checklist.Time_Wednesday LIKE ? OR 
				maintenance_checklist.Time_Thursday LIKE ? OR 
				maintenance_checklist.Time_Friday LIKE ? OR 
				maintenance_checklist.Status LIKE ? OR 
				maintenance_checklist.Manager LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "maintenance_checklist_items/search.php";
		}
		$db->join("maintenance_checklist", "maintenance_checklist_items.fk_maintenance_checklist_id = maintenance_checklist.PK_Maintenance_Checklist_id", "INNER");
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("maintenance_checklist_items.PK_Maintenance_Checklist_item_id", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		//list of record id for audit trail
		$this->rec_id = array_column($records, "PK_Maintenance_Checklist_item_id");
		$this->write_to_log("list", "true");
		if($db->getLastError()){
			$this->set_page_error();
			$this->write_to_log("list", "false");
		}
		$page_title = $this->view->page_title = "Maintenance Checklist Items";
		$this->render_view("maintenance_checklist_items/list.php", $data); //render the full page
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("maintenance_checklist_items.PK_Maintenance_Checklist_item_id", 
			"maintenance_checklist_items.Title", 
			"maintenance_checklist_items.Description", 
			"maintenance_checklist.Title AS maintenance_checklist_Title", 
			"maintenance_checklist.Description AS maintenance_checklist_Description", 
			"maintenance_checklist.Assign_To AS maintenance_checklist_Assign_To", 
			"maintenance_checklist.Status AS maintenance_checklist_Status", 
			"maintenance_checklist.Manager AS maintenance_checklist_Manager");
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("maintenance_checklist_items.PK_Maintenance_Checklist_item_id", $rec_id);; //select record based on primary key
		}
		$db->join("maintenance_checklist", "maintenance_checklist_items.fk_maintenance_checklist_id = maintenance_checklist.PK_Maintenance_Checklist_id", "INNER ");  
		$record = $db->getOne($tablename, $fields );
		if($record){
			$this->write_to_log("view", "true");
			$page_title = $this->view->page_title = "View  Maintenance Checklist Items";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
			$this->write_to_log("view", "false");
		}
		return $this->render_view("maintenance_checklist_items/view.php", $record);
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("fk_maintenance_checklist_id","Title","Description");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'fk_maintenance_checklist_id' => 'required',
				'Title' => 'required',
				'Description' => 'required',
			);
			$this->sanitize_array = array(
				'fk_maintenance_checklist_id' => 'sanitize_string',
				'Title' => 'sanitize_string',
				'Description' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->write_to_log("add", "true");
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("maintenance_checklist_items");
				}
				else{
					$this->set_page_error();
					$this->write_to_log("add", "false");
				}
			}
		}
		$page_title = $this->view->page_title = "Add New Maintenance Checklist Items";
		$this->render_view("maintenance_checklist_items/add.php");
	}
	/**
     * Update table record with formdata
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function edit($rec_id = null, $formdata = null){
		$request = $this->request;
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		 //editable fields
		$fields = $this->fields = array("PK_Maintenance_Checklist_item_id","fk_maintenance_checklist_id","Title","Description");
		if($formdata){
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'fk_maintenance_checklist_id' => 'required',
				'Title' => 'required',
				'Description' => 'required',
			);
			$this->sanitize_array = array(
				'fk_maintenance_checklist_id' => 'sanitize_string',
				'Title' => 'sanitize_string',
				'Description' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("maintenance_checklist_items.PK_Maintenance_Checklist_item_id", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					$this->write_to_log("edit", "true");
					$this->set_flash_msg("Record updated successfully", "success");
					return $this->redirect("maintenance_checklist_items");
				}
				else{
					if($db->getLastError()){
						$this->set_page_error();
						$this->write_to_log("edit", "false");
					}
					elseif(!$numRows){
						//not an error, but no record was updated
						$page_error = "No record updated";
						$this->set_page_error($page_error);
						$this->set_flash_msg($page_error, "warning");
						$this->write_to_log("edit", "false");
						return	$this->redirect("maintenance_checklist_items");
					}
				}
			}
		}
		$db->where("maintenance_checklist_items.PK_Maintenance_Checklist_item_id", $rec_id);;
		$data = $db->getOne($tablename, $fields);
		$page_title = $this->view->page_title = "Edit  Maintenance Checklist Items";
		if(!$data){
			$this->set_page_error();
		}
		return $this->render_view("maintenance_checklist_items/edit.php", $data);
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("PK_Maintenance_Checklist_item_id","fk_maintenance_checklist_id","Title","Description");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'fk_maintenance_checklist_id' => 'required',
				'Title' => 'required',
				'Description' => 'required',
			);
			$this->sanitize_array = array(
				'fk_maintenance_checklist_id' => 'sanitize_string',
				'Title' => 'sanitize_string',
				'Description' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("maintenance_checklist_items.PK_Maintenance_Checklist_item_id", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					$this->write_to_log("edit", "true");
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					$this->write_to_log("edit", "false");
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
}
