<?php 

/**
 * SharedController Controller
 * @category  Controller / Model
 */
class SharedController extends BaseController{
	
	/**
     * backorder_Job_Number_option_list Model Action
     * @return array
     */
	function backorder_Job_Number_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT Job_Number AS value,Job_Number AS label FROM job ORDER BY Job_Number DESC Limit 200";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * backorder_Job_Number_value_exist Model Action
     * @return array
     */
	function backorder_Job_Number_value_exist($val){
		$db = $this->GetModel();
		$db->where("Job_Number", $val);
		$exist = $db->has("backorder");
		return $exist;
	}

	/**
     * jlv2_aa_0_oc_users_uid_lower_value_exist Model Action
     * @return array
     */
	function jlv2_aa_0_oc_users_uid_lower_value_exist($val){
		$db = $this->GetModel();
		$db->where("uid_lower", $val);
		$exist = $db->has("jlv2_aa_0_oc_users");
		return $exist;
	}

	/**
     * jlv2_aa_0_oc_users_email_value_exist Model Action
     * @return array
     */
	function jlv2_aa_0_oc_users_email_value_exist($val){
		$db = $this->GetModel();
		$db->where("email", $val);
		$exist = $db->has("jlv2_aa_0_oc_users");
		return $exist;
	}

	/**
     * jlv2_aa_0_oc_users_lastcode_value_exist Model Action
     * @return array
     */
	function jlv2_aa_0_oc_users_lastcode_value_exist($val){
		$db = $this->GetModel();
		$db->where("lastcode", $val);
		$exist = $db->has("jlv2_aa_0_oc_users");
		return $exist;
	}

	/**
     * jlv2_jl_6_job_conversation_fk_JobNum_option_list Model Action
     * @return array
     */
	function jlv2_jl_6_job_conversation_fk_JobNum_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT Job_Number AS value,Job_Number AS label FROM jlv2_jl_5_joblist WHERE Job_Number > 4200;";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * job_Dealer_option_list Model Action
     * @return array
     */
	function job_Dealer_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT list AS value FROM jlv2_jl_1_dd_dealer";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * job_Door_Style_option_list Model Action
     * @return array
     */
	function job_Door_Style_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT list AS value FROM jlv2_jl_1_dd_door_style";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * job_Wood_option_list Model Action
     * @return array
     */
	function job_Wood_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT list AS value FROM jlv2_jl_1_dd_wood";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * job_Colour_option_list Model Action
     * @return array
     */
	function job_Colour_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT list AS value,full AS label FROM jlv2_jl_1_dd_colour";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * job_Job_Type_option_list Model Action
     * @return array
     */
	function job_Job_Type_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT list AS value FROM jlv2_jl_1_dd_job_type";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * job_Order_Entry_option_list Model Action
     * @return array
     */
	function job_Order_Entry_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT list AS value FROM jlv2_jl_1_dd_order_entry";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * job_Door_Vendor_option_list Model Action
     * @return array
     */
	function job_Door_Vendor_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT list AS value FROM jlv2_jl_1_dd_door_vendor";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * job_Sales_Rep_option_list Model Action
     * @return array
     */
	function job_Sales_Rep_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT list AS value FROM jlv2_jl_1_dd_sales_rep";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * job_Status_option_list Model Action
     * @return array
     */
	function job_Status_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT list AS value,full AS label FROM jlv2_jl_1_dd_production_status";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * job_Job_Number_Prefix_option_list Model Action
     * @return array
     */
	function job_Job_Number_Prefix_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT list AS value FROM jlv2_jl_1_dd_job_number_prefix";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * job_Job_Type_default_value Model Action
     * @return Value
     */
	function job_Job_Type_default_value(){
		$db = $this->GetModel();
		$sqltext = "SELECT value FROM `defaults` where type =? limit 1;"  ;
		$queryparams = array("job_type");
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

	/**
     * job_Job_Number_Prefix_default_value Model Action
     * @return Value
     */
	function job_Job_Number_Prefix_default_value(){
		$db = $this->GetModel();
		$sqltext = "SELECT value FROM `defaults` where type =? limit 1;"   ;
		$queryparams = array("job_number_prefix");
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

	/**
     * job_Job_Number_value_exist Model Action
     * @return array
     */
	function job_Job_Number_value_exist($val){
		$db = $this->GetModel();
		$db->where("Job_Number", $val);
		$exist = $db->has("job");
		return $exist;
	}

	/**
     * job_Dealer_option_list_2 Model Action
     * @return array
     */
	function job_Dealer_option_list_2(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT list AS value,fullname AS label FROM jlv2_jl_1_dd_dealer";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * job_Door_Style_option_list_2 Model Action
     * @return array
     */
	function job_Door_Style_option_list_2(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT list AS value,full AS label FROM jlv2_jl_1_dd_door_style";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * job_Wood_option_list_2 Model Action
     * @return array
     */
	function job_Wood_option_list_2(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT list AS value,full AS label FROM jlv2_jl_1_dd_wood";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * job_Colour_option_list_2 Model Action
     * @return array
     */
	function job_Colour_option_list_2(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT list AS value,full AS label FROM jlv2_jl_1_dd_colour ORDER BY list";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * job_Door_Vendor_option_list_2 Model Action
     * @return array
     */
	function job_Door_Vendor_option_list_2(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT list AS value,full AS label FROM jlv2_jl_1_dd_door_vendor";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * maintenance_checklist_Assign_To_option_list Model Action
     * @return array
     */
	function maintenance_checklist_Assign_To_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT uid AS value,displayname AS label FROM jlv2_aa_0_oc_users ORDER BY account_status";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * maintenance_checklist_items_fk_maintenance_checklist_id_option_list Model Action
     * @return array
     */
	function maintenance_checklist_items_fk_maintenance_checklist_id_option_list(){
		$db = $this->GetModel();
		$sqltext = "SELECT  DISTINCT PK_Maintenance_Checklist_id AS value,Title AS label FROM maintenance_checklist";
		$queryparams = null;
		$arr = $db->rawQuery($sqltext, $queryparams);
		return $arr;
	}

	/**
     * getcount_jobsneedingscheduling Model Action
     * @return Value
     */
	function getcount_jobsneedingscheduling(){
		$db = $this->GetModel();
		$sqltext = "SELECT COUNT(*) AS num FROM `job` where `Production_Received`='Y' AND `Job_Number` not in (select distinct `JobNum` as `Job_Number` from `jlv2_jl_7_production_status`)";
		$queryparams = null;
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

	/**
     * getcount_backordereta Model Action
     * @return Value
     */
	function getcount_backordereta(){
		$db = $this->GetModel();
		$sqltext = "SELECT COUNT(*) AS num FROM backorder where `Other_ETA`<= now() ";
		$queryparams = null;
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

	/**
     * getcount_jobsonhold Model Action
     * @return Value
     */
	function getcount_jobsonhold(){
		$db = $this->GetModel();
		$sqltext = "SELECT COUNT(*) AS num FROM job WHERE status='OH'";
		$queryparams = null;
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

	/**
     * getcount_jobswithanetatodayorbefore Model Action
     * @return Value
     */
	function getcount_jobswithanetatodayorbefore(){
		$db = $this->GetModel();
		$sqltext = "SELECT COUNT(*) AS num FROM job WHERE ((`Door_ETA` <= CURRENT_DATE()) OR (`Other_ETA` <= CURRENT_DATE())) AND `Date_Shipped` IS NULL";
		$queryparams = null;
		$val = $db->rawQueryValue($sqltext, $queryparams);
		
		if(is_array($val)){
			return $val[0];
		}
		return $val;
	}

}
