<?php 
//check if current user role is allowed access to the pages
$can_add = ACL::is_allowed("jlv2_jl_5_joblist_pre2020/add");
$can_edit = ACL::is_allowed("jlv2_jl_5_joblist_pre2020/edit");
$can_view = ACL::is_allowed("jlv2_jl_5_joblist_pre2020/view");
$can_delete = ACL::is_allowed("jlv2_jl_5_joblist_pre2020/delete");
?>
<?php
$comp_model = new SharedController;
$page_element_id = "list-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data From Controller
$view_data = $this->view_data;
$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = $this->route->field_name;
$field_value = $this->route->field_value;
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;
?>
<section class="page" id="<?php echo $page_element_id; ?>" data-page-type="list"  data-display-type="grid" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">Jlv2 Jl 5 Joblist Pre2020</h4>
                </div>
                <div class="col-sm-3 ">
                    <?php if($can_add){ ?>
                    <a  class="btn btn btn-primary my-1" href="<?php print_link("jlv2_jl_5_joblist_pre2020/add") ?>">
                        <i class="icon dripicons-plus"></i>                             
                        Add New Jlv2 Jl 5 Joblist Pre2020 
                    </a>
                    <?php } ?>
                </div>
                <div class="col-sm-4 ">
                    <form  class="search" action="<?php print_link('jlv2_jl_5_joblist_pre2020'); ?>" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="icon dripicons-search"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <!-- Page bread crumbs components-->
                            <?php
                            if(!empty($field_name) || !empty($_GET['search'])){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('jlv2_jl_5_joblist_pre2020'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <?php echo (get_value("tag") ? get_value("tag")  :  make_readable($field_name)); ?>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold">
                                        <?php echo (get_value("label") ? get_value("label")  :  make_readable(urldecode($field_value))); ?>
                                    </li>
                                    <?php 
                                    }   
                                    ?>
                                    <?php
                                    if(get_value("search")){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('jlv2_jl_5_joblist_pre2020'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item text-capitalize">
                                        Search
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold"><?php echo get_value("search"); ?></li>
                                    <?php
                                    }
                                    ?>
                                </ul>
                            </nav>
                            <!--End of Page bread crumbs components-->
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        }
        ?>
        <div  class="">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-md-12 comp-grid">
                        <?php $this :: display_page_errors(); ?>
                        <div  class=" animated fadeIn page-content">
                            <div id="jlv2_jl_5_joblist_pre2020-list-records">
                                <?php
                                if(!empty($records)){
                                ?>
                                <div id="page-report-body">
                                    <div class="row sm-gutters page-data" id="page-data-<?php echo $page_element_id; ?>">
                                        <!--record-->
                                        <?php
                                        $counter = 0;
                                        foreach($records as $data){
                                        $rec_id = (!empty($data['JobNum']) ? urlencode($data['JobNum']) : null);
                                        $counter++;
                                        ?>
                                        <div class="col-sm-4">
                                            <div class="bg-light p-2 mb-3 animated bounceIn">
                                                <div class="td-btn">
                                                    <?php if($can_view){ ?>
                                                    <a class="btn btn-sm btn-success has-tooltip page-modal" title="View Record" href="<?php print_link("jlv2_jl_5_joblist_pre2020/view/$rec_id"); ?>">
                                                        <i class="icon dripicons-preview"></i> View
                                                    </a>
                                                    <?php } ?>
                                                </div>
                                                <div class="mb-2">  <a href="<?php print_link("jlv2_jl_5_joblist_pre2020/view/$data[JobNum]") ?>">
                                                    <span class="font-weight-light text-muted ">
                                                        Jobnum:  
                                                    </span>
                                                <?php echo $data['JobNum']; ?></a></div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Dealer" 
                                                        data-title="Enter Dealer" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Dealer:  
                                                        </span>
                                                        <?php echo $data['Dealer']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="TagName" 
                                                        data-title="Enter Tagname" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Tagname:  
                                                        </span>
                                                        <?php echo $data['TagName']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Customer_Number" 
                                                        data-title="Enter Customer Number" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Customer Number:  
                                                        </span>
                                                        <?php echo $data['Customer_Number']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['RSO']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="RSO" 
                                                        data-title="Enter Rso" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Rso:  
                                                        </span>
                                                        <?php echo $data['RSO']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['Door_Style']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Door_Style" 
                                                        data-title="Enter Door Style" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Door Style:  
                                                        </span>
                                                        <?php echo $data['Door_Style']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Wood" 
                                                        data-title="Enter Wood" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Wood:  
                                                        </span>
                                                        <?php echo $data['Wood']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Colour" 
                                                        data-title="Enter Colour" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Colour:  
                                                        </span>
                                                        <?php echo $data['Colour']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Comments" 
                                                        data-title="Enter Comments" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Comments:  
                                                        </span>
                                                        <?php echo $data['Comments']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Requested_Date']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Requested_Date" 
                                                        data-title="Enter Requested Date" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Requested Date:  
                                                        </span>
                                                        <?php echo $data['Requested_Date']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Received_Order']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Received_Order" 
                                                        data-title="Enter Received Order" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Received Order:  
                                                        </span>
                                                        <?php echo $data['Received_Order']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Sent_To_OE']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Sent_To_OE" 
                                                        data-title="Enter Sent To Oe" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Sent To Oe:  
                                                        </span>
                                                        <?php echo $data['Sent_To_OE']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Sent_For_Confirmation']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Sent_For_Confirmation" 
                                                        data-title="Enter Sent For Confirmation" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Sent For Confirmation:  
                                                        </span>
                                                        <?php echo $data['Sent_For_Confirmation']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['Confirmation_Received']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Confirmation_Received" 
                                                        data-title="Enter Confirmation Received" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Confirmation Received:  
                                                        </span>
                                                        <?php echo $data['Confirmation_Received']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Confirmed']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Confirmed" 
                                                        data-title="Enter Confirmed" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Confirmed:  
                                                        </span>
                                                        <?php echo $data['Confirmed']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Sent_To_Plant']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Sent_To_Plant" 
                                                        data-title="Enter Sent To Plant" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Sent To Plant:  
                                                        </span>
                                                        <?php echo $data['Sent_To_Plant']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['Plant']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Plant" 
                                                        data-title="Enter Plant" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Plant:  
                                                        </span>
                                                        <?php echo $data['Plant']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Inv']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Inv" 
                                                        data-title="Enter Inv" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Inv:  
                                                        </span>
                                                        <?php echo $data['Inv']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="OE" 
                                                        data-title="Enter Oe" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Oe:  
                                                        </span>
                                                        <?php echo $data['OE']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['Uppers']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Uppers" 
                                                        data-title="Enter Uppers" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Uppers:  
                                                        </span>
                                                        <?php echo $data['Uppers']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['Talls']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Talls" 
                                                        data-title="Enter Talls" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Talls:  
                                                        </span>
                                                        <?php echo $data['Talls']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['Bases']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Bases" 
                                                        data-title="Enter Bases" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Bases:  
                                                        </span>
                                                        <?php echo $data['Bases']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['Vanities']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Vanities" 
                                                        data-title="Enter Vanities" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Vanities:  
                                                        </span>
                                                        <?php echo $data['Vanities']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['Accessories']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Accessories" 
                                                        data-title="Enter Accessories" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Accessories:  
                                                        </span>
                                                        <?php echo $data['Accessories']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-step="0.1" 
                                                        data-value="<?php echo $data['Value']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Value" 
                                                        data-title="Enter Value" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Value:  
                                                        </span>
                                                        <?php echo $data['Value']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Door_Vendor" 
                                                        data-title="Enter Door Vendor" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Door Vendor:  
                                                        </span>
                                                        <?php echo $data['Door_Vendor']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Standard_Lead_Time']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Standard_Lead_Time" 
                                                        data-title="Enter Standard Lead Time" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Standard Lead Time:  
                                                        </span>
                                                        <?php echo $data['Standard_Lead_Time']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Date_Shipped']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Date_Shipped" 
                                                        data-title="Enter Date Shipped" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Date Shipped:  
                                                        </span>
                                                        <?php echo $data['Date_Shipped']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Other_ETA']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Other_ETA" 
                                                        data-title="Enter Other Eta" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Other Eta:  
                                                        </span>
                                                        <?php echo $data['Other_ETA']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Door_ETA']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Door_ETA" 
                                                        data-title="Enter Door Eta" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Door Eta:  
                                                        </span>
                                                        <?php echo $data['Door_ETA']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Back_Orders" 
                                                        data-title="Enter Back Orders" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Back Orders:  
                                                        </span>
                                                        <?php echo $data['Back_Orders']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Back_Orders_Shipped']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Back_Orders_Shipped" 
                                                        data-title="Enter Back Orders Shipped" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Back Orders Shipped:  
                                                        </span>
                                                        <?php echo $data['Back_Orders_Shipped']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Proposed_Shipping_Date']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Proposed_Shipping_Date" 
                                                        data-title="Enter Proposed Shipping Date" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Proposed Shipping Date:  
                                                        </span>
                                                        <?php echo $data['Proposed_Shipping_Date']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Shipping_Comments" 
                                                        data-title="Enter Shipping Comments" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Shipping Comments:  
                                                        </span>
                                                        <?php echo $data['Shipping_Comments']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Shipping_Details" 
                                                        data-title="Enter Shipping Details" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Shipping Details:  
                                                        </span>
                                                        <?php echo $data['Shipping_Details']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="DealerRoute" 
                                                        data-title="Enter Dealerroute" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Dealerroute:  
                                                        </span>
                                                        <?php echo $data['DealerRoute']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['NJobNum']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="NJobNum" 
                                                        data-title="Enter Njobnum" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Njobnum:  
                                                        </span>
                                                        <?php echo $data['NJobNum']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['OrgJobNum']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="OrgJobNum" 
                                                        data-title="Enter Orgjobnum" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Orgjobnum:  
                                                        </span>
                                                        <?php echo $data['OrgJobNum']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Creator" 
                                                        data-title="Enter Creator" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Creator:  
                                                        </span>
                                                        <?php echo $data['Creator']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{ minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['UpdatedBy']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="UpdatedBy" 
                                                        data-title="Enter Updatedby" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Updatedby:  
                                                        </span>
                                                        <?php echo $data['UpdatedBy']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="SalesRep" 
                                                        data-title="Enter Salesrep" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Salesrep:  
                                                        </span>
                                                        <?php echo $data['SalesRep']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span class="font-weight-light text-muted ">
                                                        Timestamp:  
                                                    </span>
                                                <?php echo $data['TimeStamp']; ?></div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{ minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['LastUpdated']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="LastUpdated" 
                                                        data-title="Enter Lastupdated" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Lastupdated:  
                                                        </span>
                                                        <?php echo $data['LastUpdated']; ?> 
                                                    </span>
                                                </div>
                                                <div class="mb-2">  
                                                    <span <?php if($can_edit){ ?> data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist_pre2020/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Status" 
                                                        data-title="Enter Status" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <span class="font-weight-light text-muted ">
                                                            Status:  
                                                        </span>
                                                        <?php echo $data['Status']; ?> 
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                        <?php 
                                        }
                                        ?>
                                        <!--endrecord-->
                                    </div>
                                    <div class="row sm-gutters search-data" id="search-data-<?php echo $page_element_id; ?>"></div>
                                    <div>
                                    </div>
                                </div>
                                <?php
                                if($show_footer == true){
                                ?>
                                <div class=" border-top mt-2">
                                    <div class="row justify-content-center">    
                                        <div class="col-md-auto">   
                                        </div>
                                        <div class="col">   
                                            <?php
                                            if($show_pagination == true){
                                            $pager = new Pagination($total_records, $record_count);
                                            $pager->route = $this->route;
                                            $pager->show_page_count = true;
                                            $pager->show_record_count = true;
                                            $pager->show_page_limit =true;
                                            $pager->limit_count = $this->limit_count;
                                            $pager->show_page_number_list = true;
                                            $pager->pager_link_range=5;
                                            $pager->render();
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                }
                                }
                                else{
                                ?>
                                <div class="text-muted  animated bounce p-3">
                                    <h4><i class="icon dripicons-wrong"></i> No record found</h4>
                                </div>
                                <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
