<?php 
//check if current user role is allowed access to the pages
$can_add = ACL::is_allowed("job/add");
$can_edit = ACL::is_allowed("job/edit");
$can_view = ACL::is_allowed("job/view");
$can_delete = ACL::is_allowed("job/delete");
?>
<?php
$comp_model = new SharedController;
$page_element_id = "list-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data From Controller
$view_data = $this->view_data;
$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = $this->route->field_name;
$field_value = $this->route->field_value;
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;
?>
<section class="page" id="<?php echo $page_element_id; ?>" data-page-type="list"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">Job</h4>
                </div>
                <div class="col-sm-3 ">
                    <?php if($can_add){ ?>
                    <a  class="btn btn btn-primary my-1" href="<?php print_link("job/add") ?>">
                        <i class="icon dripicons-plus"></i>                             
                        Add New Job 
                    </a>
                    <?php } ?>
                </div>
                <div class="col-sm-4 ">
                    <form  class="search" action="<?php print_link('job'); ?>" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="icon dripicons-search"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <!-- Page bread crumbs components-->
                            <?php
                            if(!empty($field_name) || !empty($_GET['search'])){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('job'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <?php echo (get_value("tag") ? get_value("tag")  :  make_readable($field_name)); ?>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold">
                                        <?php echo (get_value("label") ? get_value("label")  :  make_readable(urldecode($field_value))); ?>
                                    </li>
                                    <?php 
                                    }   
                                    ?>
                                    <?php
                                    if(get_value("search")){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('job'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item text-capitalize">
                                        Search
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold"><?php echo get_value("search"); ?></li>
                                    <?php
                                    }
                                    ?>
                                </ul>
                            </nav>
                            <!--End of Page bread crumbs components-->
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        }
        ?>
        <div  class="">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-md-12 comp-grid">
                        <?php $this :: display_page_errors(); ?>
                        <div  class=" animated fadeIn page-content">
                            <div id="job-on_hold-records">
                                <div id="page-report-body" class="table-responsive">
                                    <table class="table  table-striped table-sm text-left">
                                        <thead class="table-header bg-light">
                                            <tr>
                                                <th class="td-btn"></th>
                                                <th  class="td-DJob_No"> Job_#</th>
                                                <th  class="td-Dealer"> Dealer</th>
                                                <th  class="td-Customer_PO"> Customer PO</th>
                                                <th  class="td-Tag_Name"> Tag Name</th>
                                                <th  class="td-Comments"> Comments</th>
                                                <th  class="td-Sent_For_Confirmation"> Sent For Confirmation</th>
                                                <th  class="td-Confirmed"> Confirmed</th>
                                                <th  class="td-Value"> Value</th>
                                                <th  class="td-Uppers"> Uppers</th>
                                                <th  class="td-Talls"> Talls</th>
                                                <th  class="td-Bases"> Bases</th>
                                                <th  class="td-Vanities"> Vanities</th>
                                                <th  class="td-Accessories"> Accessories</th>
                                                <th  class="td-Door_Style"> Door Style</th>
                                                <th  class="td-Wood"> Wood</th>
                                                <th  class="td-Colour"> Colour</th>
                                            </tr>
                                        </thead>
                                        <?php
                                        if(!empty($records)){
                                        ?>
                                        <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                            <!--record-->
                                            <?php
                                            $counter = 0;
                                            foreach($records as $data){
                                            $rec_id = (!empty($data['Job_Number']) ? urlencode($data['Job_Number']) : null);
                                            $counter++;
                                            ?>
                                            <tr>
                                                <th class="td-btn">
                                                    <?php if($can_edit){ ?>
                                                    <a class="btn btn-sm btn-info has-tooltip" title="Edit This Record" href="<?php print_link("job/edit/$rec_id"); ?>">
                                                        <i class="icon dripicons-document-edit"></i> Edit
                                                    </a>
                                                    <?php } ?>
                                                </th>
                                                <td class="td-DJob_No"> <?php echo $data['DJob_No']; ?></td>
                                                <td class="td-Dealer">
                                                    <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/job_Dealer_option_list'); ?>' 
                                                        data-value="<?php echo $data['Dealer']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Dealer" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Dealer']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Customer_PO">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['Customer_PO']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Customer_PO" 
                                                        data-title="Enter Customer Po" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Customer_PO']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Tag_Name">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['Tag_Name']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Tag_Name" 
                                                        data-title="Enter Tag Name" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Tag_Name']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Comments">
                                                    <span <?php if($can_edit){ ?> data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Comments" 
                                                        data-title="Enter Comments" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="inline" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Comments']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Sent_For_Confirmation">
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Sent_For_Confirmation']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Sent_For_Confirmation" 
                                                        data-title="Enter Sent For Confirmation" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Sent_For_Confirmation']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Confirmed">
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Confirmed']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Confirmed" 
                                                        data-title="Enter Confirmed" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Confirmed']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Value">
                                                    <span <?php if($can_edit){ ?> data-step="0.1" 
                                                        data-value="<?php echo $data['Value']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Value" 
                                                        data-title="Enter Value" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Value']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Uppers">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['Uppers']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Uppers" 
                                                        data-title="Enter Uppers" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Uppers']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Talls">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['Talls']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Talls" 
                                                        data-title="Enter Talls" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Talls']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Bases">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['Bases']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Bases" 
                                                        data-title="Enter Bases" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Bases']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Vanities">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['Vanities']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Vanities" 
                                                        data-title="Enter Vanities" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Vanities']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Accessories">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['Accessories']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Accessories" 
                                                        data-title="Enter Accessories" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Accessories']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Door_Style">
                                                    <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/job_Door_Style_option_list'); ?>' 
                                                        data-value="<?php echo $data['Door_Style']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Door_Style" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Door_Style']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Wood">
                                                    <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/job_Wood_option_list'); ?>' 
                                                        data-value="<?php echo $data['Wood']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Wood" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Wood']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Colour">
                                                    <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/job_Colour_option_list_2'); ?>' 
                                                        data-value="<?php echo $data['Colour']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Colour" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Colour']; ?> 
                                                    </span>
                                                </td>
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            <!--endrecord-->
                                        </tbody>
                                        <tbody class="search-data" id="search-data-<?php echo $page_element_id; ?>"></tbody>
                                        <?php
                                        }
                                        ?>
                                    </table>
                                    <?php 
                                    if(empty($records)){
                                    ?>
                                    <h4 class="bg-light text-center border-top text-muted animated bounce  p-3">
                                        <i class="icon dripicons-wrong"></i> No record found
                                    </h4>
                                    <?php
                                    }
                                    ?>
                                </div>
                                <?php
                                if( $show_footer && !empty($records)){
                                ?>
                                <div class=" border-top mt-2">
                                    <div class="row justify-content-center">    
                                        <div class="col-md-auto justify-content-center">    
                                            <div class="p-3 d-flex justify-content-between">    
                                            </div>
                                        </div>
                                        <div class="col">   
                                            <?php
                                            if($show_pagination == true){
                                            $pager = new Pagination($total_records, $record_count);
                                            $pager->route = $this->route;
                                            $pager->show_page_count = true;
                                            $pager->show_record_count = true;
                                            $pager->show_page_limit =true;
                                            $pager->limit_count = $this->limit_count;
                                            $pager->show_page_number_list = true;
                                            $pager->pager_link_range=5;
                                            $pager->render();
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
