<?php 
/**
 * Account Page Controller
 * @category  Controller
 */
class AccountController extends SecureController{
	function __construct(){
		parent::__construct(); 
		$this->tablename = "jlv2_aa_0_oc_users";
	}
	/**
		* Index Action
		* @return null
		*/
	function index(){
		$db = $this->GetModel();
		$rec_id = $this->rec_id = USER_ID; //get current user id from session
		$db->where ("uid", $rec_id);
		$tablename = $this->tablename;
		$fields = array("uid", 
			"displayname", 
			"uid_lower", 
			"email", 
			"type", 
			"jl_type", 
			"ql_type", 
			"sl_type", 
			"rl_type", 
			"initials", 
			"account_status");
		$user = $db->getOne($tablename , $fields);
		if(!empty($user)){
			$page_title = $this->view->page_title = "My Account";
			$this->render_view("account/view.php", $user);
		}
		else{
			$this->set_page_error();
			$this->render_view("account/view.php");
		}
	}
	/**
     * Update user account record with formdata
	 * @param $formdata array() from $_POST
     * @return array
     */
	function edit($formdata = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = USER_ID;
		$tablename = $this->tablename;
		 //editable fields
		$fields = $this->fields = array("uid","displayname","uid_lower","type","jl_type","ql_type","sl_type","rl_type","initials","account_status");
		if($formdata){
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'uid' => 'required',
				'displayname' => 'required',
				'uid_lower' => 'required',
				'type' => 'required',
				'jl_type' => 'required',
				'ql_type' => 'required',
				'sl_type' => 'required',
				'rl_type' => 'required',
				'initials' => 'required',
				'account_status' => 'required',
			);
			$this->sanitize_array = array(
				'uid' => 'sanitize_string',
				'displayname' => 'sanitize_string',
				'uid_lower' => 'sanitize_string',
				'type' => 'sanitize_string',
				'jl_type' => 'sanitize_string',
				'ql_type' => 'sanitize_string',
				'sl_type' => 'sanitize_string',
				'rl_type' => 'sanitize_string',
				'initials' => 'sanitize_string',
				'account_status' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			//Check if Duplicate Record Already Exit In The Database
			if(isset($modeldata['uid_lower'])){
				$db->where("uid_lower", $modeldata['uid_lower'])->where("uid", $rec_id, "!=");
				if($db->has($tablename)){
					$this->view->page_error[] = $modeldata['uid_lower']." Already exist!";
				}
			} 
			if($this->validated()){
				$db->where("jlv2_aa_0_oc_users.uid", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					$this->write_to_log("edit", "true");
					$this->set_flash_msg("Record updated successfully", "success");
					$db->where ("uid", $rec_id);
					$user = $db->getOne($tablename , "*");
					set_session("user_data", $user);// update session with new user data
					return $this->redirect("account");
				}
				else{
					if($db->getLastError()){
						$this->set_page_error();
						$this->write_to_log("edit", "false");
					}
					elseif(!$numRows){
						//not an error, but no record was updated
						$this->set_flash_msg("No record updated", "warning");
						return	$this->redirect("account");
					}
				}
			}
		}
		$db->where("jlv2_aa_0_oc_users.uid", $rec_id);;
		$data = $db->getOne($tablename, $fields);
		$page_title = $this->view->page_title = "My Account";
		if(!$data){
			$this->set_page_error();
		}
		return $this->render_view("account/edit.php", $data);
	}
	/**
     * Change account email
     * @return BaseView
     */
	function change_email($formdata = null){
		if($formdata){
			$email = trim($formdata['email']);
			$db = $this->GetModel();
			$rec_id = $this->rec_id = USER_ID; //get current user id from session
			$tablename = $this->tablename;
			$db->where ("uid", $rec_id);
			$result = $db->update($tablename, array('email' => $email ));
			if($result){
				$this->write_to_log("emailchange", "true");
			}
			else{
				$this->set_page_error("Email not changed");
				$this->write_to_log("emailchange", "false");
			}
		}
		return $this->render_view("account/change_email.php");
	}
}
