<?php 
/**
 * Jlv2_jl_1_dd_glaze_custom Page Controller
 * @category  Controller
 */
class Jlv2_jl_1_dd_glaze_customController extends SecureController{
	function __construct(){
		parent::__construct();
		$this->tablename = "jlv2_jl_1_dd_glaze_custom";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("pk_glaze_custom_id", 
			"full", 
			"list", 
			"changed_by", 
			"updated");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				jlv2_jl_1_dd_glaze_custom.pk_glaze_custom_id LIKE ? OR 
				jlv2_jl_1_dd_glaze_custom.full LIKE ? OR 
				jlv2_jl_1_dd_glaze_custom.list LIKE ? OR 
				jlv2_jl_1_dd_glaze_custom.changed_by LIKE ? OR 
				jlv2_jl_1_dd_glaze_custom.updated LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "jlv2_jl_1_dd_glaze_custom/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("jlv2_jl_1_dd_glaze_custom.pk_glaze_custom_id", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		//list of record id for audit trail
		$this->rec_id = array_column($records, "pk_glaze_custom_id");
		$this->write_to_log("list", "true");
		if($db->getLastError()){
			$this->set_page_error();
			$this->write_to_log("list", "false");
		}
		$page_title = $this->view->page_title = "Jlv2 Jl 1 Dd Glaze Custom";
		$this->render_view("jlv2_jl_1_dd_glaze_custom/list.php", $data); //render the full page
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("pk_glaze_custom_id", 
			"full", 
			"list", 
			"changed_by", 
			"updated");
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("jlv2_jl_1_dd_glaze_custom.pk_glaze_custom_id", $rec_id);; //select record based on primary key
		}
		$record = $db->getOne($tablename, $fields );
		if($record){
			$this->write_to_log("view", "true");
			$page_title = $this->view->page_title = "View  Jlv2 Jl 1 Dd Glaze Custom";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
			$this->write_to_log("view", "false");
		}
		return $this->render_view("jlv2_jl_1_dd_glaze_custom/view.php", $record);
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("full","list","changed_by");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'full' => 'required',
				'list' => 'required',
				'changed_by' => 'required',
			);
			$this->sanitize_array = array(
				'full' => 'sanitize_string',
				'list' => 'sanitize_string',
				'changed_by' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->write_to_log("add", "true");
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("jlv2_jl_1_dd_glaze_custom");
				}
				else{
					$this->set_page_error();
					$this->write_to_log("add", "false");
				}
			}
		}
		$page_title = $this->view->page_title = "Add New Jlv2 Jl 1 Dd Glaze Custom";
		$this->render_view("jlv2_jl_1_dd_glaze_custom/add.php");
	}
	/**
     * Update table record with formdata
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function edit($rec_id = null, $formdata = null){
		$request = $this->request;
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		 //editable fields
		$fields = $this->fields = array("pk_glaze_custom_id","full","list","changed_by");
		if($formdata){
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'full' => 'required',
				'list' => 'required',
				'changed_by' => 'required',
			);
			$this->sanitize_array = array(
				'full' => 'sanitize_string',
				'list' => 'sanitize_string',
				'changed_by' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("jlv2_jl_1_dd_glaze_custom.pk_glaze_custom_id", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					$this->write_to_log("edit", "true");
					$this->set_flash_msg("Record updated successfully", "success");
					return $this->redirect("jlv2_jl_1_dd_glaze_custom");
				}
				else{
					if($db->getLastError()){
						$this->set_page_error();
						$this->write_to_log("edit", "false");
					}
					elseif(!$numRows){
						//not an error, but no record was updated
						$page_error = "No record updated";
						$this->set_page_error($page_error);
						$this->set_flash_msg($page_error, "warning");
						$this->write_to_log("edit", "false");
						return	$this->redirect("jlv2_jl_1_dd_glaze_custom");
					}
				}
			}
		}
		$db->where("jlv2_jl_1_dd_glaze_custom.pk_glaze_custom_id", $rec_id);;
		$data = $db->getOne($tablename, $fields);
		$page_title = $this->view->page_title = "Edit  Jlv2 Jl 1 Dd Glaze Custom";
		if(!$data){
			$this->set_page_error();
		}
		return $this->render_view("jlv2_jl_1_dd_glaze_custom/edit.php", $data);
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("pk_glaze_custom_id","full","list","changed_by");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'full' => 'required',
				'list' => 'required',
				'changed_by' => 'required',
			);
			$this->sanitize_array = array(
				'full' => 'sanitize_string',
				'list' => 'sanitize_string',
				'changed_by' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("jlv2_jl_1_dd_glaze_custom.pk_glaze_custom_id", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					$this->write_to_log("edit", "true");
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					$this->write_to_log("edit", "false");
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
	/**
     * Delete record from the database
	 * Support multi delete by separating record id by comma.
     * @return BaseView
     */
	function delete($rec_id = null){
		Csrf::cross_check();
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$this->rec_id = $rec_id;
		//form multiple delete, split record id separated by comma into array
		$arr_rec_id = array_map('trim', explode(",", $rec_id));
		$db->where("jlv2_jl_1_dd_glaze_custom.pk_glaze_custom_id", $arr_rec_id, "in");
		$bool = $db->delete($tablename);
		if($bool){
			$this->write_to_log("delete", "true");
			$this->set_flash_msg("Record deleted successfully", "success");
		}
		elseif($db->getLastError()){
			$page_error = $db->getLastError();
			$this->set_flash_msg($page_error, "danger");
			$this->write_to_log("delete", "false");
		}
		return	$this->redirect("jlv2_jl_1_dd_glaze_custom");
	}
}
