<?php 
/**
 * Jlv2_jl_6_job_conversation Page Controller
 * @category  Controller
 */
class Jlv2_jl_6_job_conversationController extends SecureController{
	function __construct(){
		parent::__construct();
		$this->tablename = "jlv2_jl_6_job_conversation";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("Comment_ID", 
			"fk_JobNum", 
			"Commentor_ID", 
			"Comment", 
			"Status", 
			"created");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				jlv2_jl_6_job_conversation.Comment_ID LIKE ? OR 
				jlv2_jl_6_job_conversation.fk_JobNum LIKE ? OR 
				jlv2_jl_6_job_conversation.Comment LIKE ? OR 
				jlv2_jl_6_job_conversation.Status LIKE ? OR 
				jlv2_jl_6_job_conversation.Parent_Comment_ID LIKE ? OR 
				jlv2_jl_6_job_conversation.created LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "jlv2_jl_6_job_conversation/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("jlv2_jl_6_job_conversation.Comment_ID", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		//list of record id for audit trail
		$this->rec_id = array_column($records, "Comment_ID");
		$this->write_to_log("list", "true");
		if($db->getLastError()){
			$this->set_page_error();
			$this->write_to_log("list", "false");
		}
		$page_title = $this->view->page_title = "Job Notes";
		$this->render_view("jlv2_jl_6_job_conversation/list.php", $data); //render the full page
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("Comment_ID", 
			"fk_JobNum", 
			"Commentor_ID", 
			"Recipient_ID", 
			"Comment", 
			"created");
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("jlv2_jl_6_job_conversation.Comment_ID", $rec_id);; //select record based on primary key
		}
		$record = $db->getOne($tablename, $fields );
		if($record){
			$this->write_to_log("view", "true");
			$page_title = $this->view->page_title = "View Conversation";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
			$this->write_to_log("view", "false");
		}
		return $this->render_view("jlv2_jl_6_job_conversation/view.php", $record);
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("Commentor_ID","Comment","fk_JobNum");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'Comment' => 'required',
				'fk_JobNum' => 'required',
			);
			$this->sanitize_array = array(
				'Commentor_ID' => 'sanitize_string',
				'Comment' => 'sanitize_string',
				'fk_JobNum' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->write_to_log("add", "true");
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("jlv2_jl_6_job_conversation");
				}
				else{
					$this->set_page_error();
					$this->write_to_log("add", "false");
				}
			}
		}
		$page_title = $this->view->page_title = "Add Conversation";
		$this->render_view("jlv2_jl_6_job_conversation/add.php");
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function list_perjob($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("Comment_ID", 
			"Commentor_ID", 
			"Comment", 
			"created");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				jlv2_jl_6_job_conversation.Comment_ID LIKE ? OR 
				jlv2_jl_6_job_conversation.Comment LIKE ? OR 
				jlv2_jl_6_job_conversation.Status LIKE ? OR 
				jlv2_jl_6_job_conversation.Parent_Comment_ID LIKE ? OR 
				jlv2_jl_6_job_conversation.fk_JobNum LIKE ? OR 
				jlv2_jl_6_job_conversation.created LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "jlv2_jl_6_job_conversation/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("jlv2_jl_6_job_conversation.Comment_ID", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		//list of record id for audit trail
		$this->rec_id = array_column($records, "Comment_ID");
		$this->write_to_log("list", "true");
		if($db->getLastError()){
			$this->set_page_error();
			$this->write_to_log("list", "false");
		}
		$page_title = $this->view->page_title = "Conversation";
		$this->render_view("jlv2_jl_6_job_conversation/list_perjob.php", $data); //render the full page
	}
}
