<?php 
/**
 * Job Page Controller
 * @category  Controller
 */
class JobController extends SecureController{
	function __construct(){
		parent::__construct();
		$this->tablename = "job";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("Concat(Job_Number_Prefix,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM Job_Number)))) AS DJob_No", 
			"Job_Number", 
			"Production_Received", 
			"Dealer", 
			"Customer_PO", 
			"Tag_Name", 
			"Comments", 
			"Confirmed", 
			"Value", 
			"Uppers", 
			"Talls", 
			"Bases", 
			"Vanities", 
			"Accessories", 
			"Door_Style", 
			"Wood", 
			"Colour");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				Concat(Job_Number_Prefix,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM Job_Number)))) LIKE ? OR 
				job.Full_Job_Number LIKE ? OR 
				job.Job_Type LIKE ? OR 
				job.Job_Number_Prefix LIKE ? OR 
				job.Job_Number LIKE ? OR 
				trim(TRAILING '.' FROM (trim(TRAILING '0' FROM Job_Number))) LIKE ? OR 
				job.Production_Received LIKE ? OR 
				job.Dealer LIKE ? OR 
				job.Customer_PO LIKE ? OR 
				job.Tag_Name LIKE ? OR 
				job.Comments LIKE ? OR 
				job.Order_Entry LIKE ? OR 
				job.Received_Order LIKE ? OR 
				job.Requested_Date LIKE ? OR 
				job.Sent_To_OE LIKE ? OR 
				job.Sent_For_Confirmation LIKE ? OR 
				job.Confirmation_Received LIKE ? OR 
				job.Confirmed LIKE ? OR 
				job.Sent_To_Plant LIKE ? OR 
				job.Invoiced LIKE ? OR 
				job.Value LIKE ? OR 
				job.Uppers LIKE ? OR 
				job.Talls LIKE ? OR 
				job.Bases LIKE ? OR 
				job.Vanities LIKE ? OR 
				job.Accessories LIKE ? OR 
				job.Door_Style LIKE ? OR 
				job.Wood LIKE ? OR 
				job.Colour LIKE ? OR 
				job.Original_Job_Number LIKE ? OR 
				job.Door_Vendor LIKE ? OR 
				job.Door_ETA LIKE ? OR 
				job.Other_ETA LIKE ? OR 
				job.Standard_Lead_Time LIKE ? OR 
				job.Date_Shipped LIKE ? OR 
				job.Back_Orders LIKE ? OR 
				job.Back_Orders_Shipped LIKE ? OR 
				job.Proposed_Shipping_Date LIKE ? OR 
				job.Shipping_Comments LIKE ? OR 
				job.Shipping_Details LIKE ? OR 
				job.Dealer_Route LIKE ? OR 
				job.Sales_Rep LIKE ? OR 
				job.Creator LIKE ? OR 
				job.Updated_By LIKE ? OR 
				job.Created_TS LIKE ? OR 
				job.Last_Updated_TS LIKE ? OR 
				job.Status LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "job/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("job.Job_Number", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		//list of record id for audit trail
		$this->rec_id = array_column($records, "Job_Number");
		$this->write_to_log("list", "true");
		if($db->getLastError()){
			$this->set_page_error();
			$this->write_to_log("list", "false");
		}
		$page_title = $this->view->page_title = "Job";
		$this->render_view("job/list.php", $data); //render the full page
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("Full_Job_Number", 
			"Concat(Job_Number_Prefix,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM Job_Number)))) AS Job_No", 
			"Job_Type", 
			"Job_Number", 
			"Production_Received", 
			"Dealer", 
			"Customer_PO", 
			"Tag_Name", 
			"Order_Entry", 
			"Received_Order", 
			"Requested_Date", 
			"Sent_To_OE", 
			"Sent_For_Confirmation", 
			"Confirmation_Received", 
			"Confirmed", 
			"Sent_To_Plant", 
			"Invoiced", 
			"Value", 
			"Uppers", 
			"Talls", 
			"Bases", 
			"Vanities", 
			"Accessories", 
			"Door_Style", 
			"Wood", 
			"Colour", 
			"Comments", 
			"Original_Job_Number", 
			"Door_Vendor", 
			"Door_ETA", 
			"Other_ETA", 
			"Standard_Lead_Time", 
			"Date_Shipped", 
			"Back_Orders", 
			"Back_Orders_Shipped", 
			"Proposed_Shipping_Date", 
			"Shipping_Comments", 
			"Shipping_Details", 
			"Dealer_Route", 
			"Sales_Rep", 
			"Creator", 
			"Updated_By", 
			"Created_TS", 
			"Last_Updated_TS", 
			"Status");
		#Statement to execute before view record
		$user_id = USER_ID;
$db->rawQuery("UPDATE `jlv2_aa_0_oc_users` SET `lastcode`='$rec_id' WHERE uid='$user_id'");
		# End of before view statement
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("job.Job_Number", $rec_id);; //select record based on primary key
		}
		$record = $db->getOne($tablename, $fields );
		if($record){
			$this->write_to_log("view", "true");
			$page_title = $this->view->page_title = "View  Job";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
			$this->write_to_log("view", "false");
		}
		return $this->render_view("job/view.php", $record);
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("Job_Type","Job_Number_Prefix","Job_Number","Production_Received","Dealer","Customer_PO","Tag_Name","Order_Entry","Received_Order","Requested_Date","Sent_To_OE","Door_Style","Wood","Colour","Comments","Original_Job_Number","Door_Vendor","Door_ETA","Other_ETA","Proposed_Shipping_Date","Sales_Rep","Creator","Created_TS","Status");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'Job_Number' => 'numeric',
			);
			$this->sanitize_array = array(
				'Job_Type' => 'sanitize_string',
				'Job_Number_Prefix' => 'sanitize_string',
				'Job_Number' => 'sanitize_string',
				'Production_Received' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'Customer_PO' => 'sanitize_string',
				'Tag_Name' => 'sanitize_string',
				'Order_Entry' => 'sanitize_string',
				'Received_Order' => 'sanitize_string',
				'Requested_Date' => 'sanitize_string',
				'Sent_To_OE' => 'sanitize_string',
				'Door_Style' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'Original_Job_Number' => 'sanitize_string',
				'Door_Vendor' => 'sanitize_string',
				'Door_ETA' => 'sanitize_string',
				'Other_ETA' => 'sanitize_string',
				'Proposed_Shipping_Date' => 'sanitize_string',
				'Sales_Rep' => 'sanitize_string',
				'Status' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			$modeldata['Creator'] = USER_ID;
$modeldata['Created_TS'] = "CURRENT_TIMESTAMP";
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->write_to_log("add", "true");
		# Statement to execute after adding record
		if ($modeldata['Job_type']=='RSO')
{
$rsoTail = ".44";
if (substr_count(rtrim($rec_id),".") > 0) { $rsoTail ="44";}
$newJobNumber = rtrim($rec_id) . $rsoTail;
$db->rawQuery("UPDATE `job` SET Job_Number=($newJobNumber) WHERE Job_Number='$rec_id'");
}
		# End of after add statement
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("job");
				}
				else{
					$this->set_page_error();
					$this->write_to_log("add", "false");
				}
			}
		}
		$page_title = $this->view->page_title = "Add New Job";
		$this->render_view("job/add.php");
	}
	/**
     * Update table record with formdata
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function edit($rec_id = null, $formdata = null){
		$request = $this->request;
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		 //editable fields
		$fields = $this->fields = array("Job_Type","Job_Number_Prefix","Job_Number","Production_Received","Dealer","Customer_PO","Tag_Name","Order_Entry","Received_Order","Requested_Date","Sent_To_OE","Sent_For_Confirmation","Confirmation_Received","Confirmed","Sent_To_Plant","Invoiced","Value","Uppers","Talls","Bases","Vanities","Accessories","Door_Style","Wood","Colour","Comments","Original_Job_Number","Door_Vendor","Door_ETA","Other_ETA","Proposed_Shipping_Date","Sales_Rep","Updated_By","Last_Updated_TS","Status");
		if($formdata){
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'Job_Number' => 'numeric',
				'Value' => 'numeric',
				'Uppers' => 'numeric',
				'Talls' => 'numeric',
				'Bases' => 'numeric',
				'Vanities' => 'numeric',
				'Accessories' => 'numeric',
			);
			$this->sanitize_array = array(
				'Job_Type' => 'sanitize_string',
				'Job_Number_Prefix' => 'sanitize_string',
				'Job_Number' => 'sanitize_string',
				'Production_Received' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'Customer_PO' => 'sanitize_string',
				'Tag_Name' => 'sanitize_string',
				'Order_Entry' => 'sanitize_string',
				'Received_Order' => 'sanitize_string',
				'Requested_Date' => 'sanitize_string',
				'Sent_To_OE' => 'sanitize_string',
				'Sent_For_Confirmation' => 'sanitize_string',
				'Confirmation_Received' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'Sent_To_Plant' => 'sanitize_string',
				'Invoiced' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'Uppers' => 'sanitize_string',
				'Talls' => 'sanitize_string',
				'Bases' => 'sanitize_string',
				'Vanities' => 'sanitize_string',
				'Accessories' => 'sanitize_string',
				'Door_Style' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'Original_Job_Number' => 'sanitize_string',
				'Door_Vendor' => 'sanitize_string',
				'Door_ETA' => 'sanitize_string',
				'Other_ETA' => 'sanitize_string',
				'Proposed_Shipping_Date' => 'sanitize_string',
				'Sales_Rep' => 'sanitize_string',
				'Last_Updated_TS' => 'sanitize_string',
				'Status' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			$modeldata['Updated_By'] = USER_ID;
			if($this->validated()){
		# Statement to execute after adding record
		$Name = get_active_user('displayname');
$db->rawQuery("Insert into `jlv2_jl_6_job_history` Select *,'','$Name',NULL from `job` WHERE Job_Number='$rec_id'");
		# End of before update statement
				$db->where("job.Job_Number", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					$this->write_to_log("edit", "true");
		# Statement to execute after adding record
			//execute SQL statement and return the result
$params = array($rec_id);
$bool   = $db->rawQuery("UPDATE `job` SET `Requested_Date` = NULL WHERE  `Requested_Date` like '00%'; UPDATE `job` SET `Sent_To_OE` = NULL WHERE  `Sent_To_OE` like '00%'; UPDATE `job` SET `Confirmation_Received` = NULL WHERE  `Confirmation_Received` like '00%'; UPDATE `job` SET `Sent_For_Confirmation` = NULL WHERE  `Sent_For_Confirmation` like '00%'; UPDATE `job` SET `Confirmed` = NULL WHERE `Confirmed` like '00%'; UPDATE `job` SET `Sent_To_Plant` = NULL WHERE  `Sent_To_Plant` like '00%'; UPDATE `job` SET `Invoiced` = NULL WHERE  `Invoiced` like '00%'; UPDATE `job` SET `Door_ETA` = NULL WHERE  `Door_ETA` like '00%'; UPDATE `job` SET `Other_ETA` = NULL WHERE  `Other_ETA` like '00%'; UPDATE `job` SET `Standard_Lead_Time` = NULL WHERE  `Standard_Lead_Time` like '00%'; UPDATE `job` SET `Date_Shipped` = NULL WHERE  `Date_Shipped` like '00%'; UPDATE `job` SET `Standard_Lead_Time` = NULL WHERE  `Standard_Lead_Time` like '00%'; UPDATE `job` SET `Date_Shipped` = NULL WHERE  `Date_Shipped` like '00%'; UPDATE `job` SET `Back_Orders_Shipped` = NULL WHERE  `Back_Orders_Shipped` like '00%'; UPDATE `job` SET  `Proposed_Shipping_Date` = NULL WHERE  `Proposed_Shipping_Date` like '00%';");
		# End of after update statement
					$this->set_flash_msg("Record updated successfully", "success");
					return $this->redirect("job/view/$rec_id");
				}
				else{
					if($db->getLastError()){
						$this->set_page_error();
						$this->write_to_log("edit", "false");
					}
					elseif(!$numRows){
						//not an error, but no record was updated
						$page_error = "No record updated";
						$this->set_page_error($page_error);
						$this->set_flash_msg($page_error, "warning");
						$this->write_to_log("edit", "false");
						return	$this->redirect("job/view/$rec_id");
					}
				}
			}
		}
		$db->where("job.Job_Number", $rec_id);;
		$data = $db->getOne($tablename, $fields);
		$page_title = $this->view->page_title = "Edit  Job";
		if(!$data){
			$this->set_page_error();
		}
		return $this->render_view("job/edit.php", $data);
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("Job_Type","Job_Number_Prefix","Job_Number","Production_Received","Dealer","Customer_PO","Tag_Name","Order_Entry","Received_Order","Requested_Date","Sent_To_OE","Sent_For_Confirmation","Confirmation_Received","Confirmed","Sent_To_Plant","Invoiced","Value","Uppers","Talls","Bases","Vanities","Accessories","Door_Style","Wood","Colour","Comments","Original_Job_Number","Door_Vendor","Door_ETA","Other_ETA","Proposed_Shipping_Date","Sales_Rep","Updated_By","Last_Updated_TS","Status");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'Job_Number' => 'numeric',
				'Value' => 'numeric',
				'Uppers' => 'numeric',
				'Talls' => 'numeric',
				'Bases' => 'numeric',
				'Vanities' => 'numeric',
				'Accessories' => 'numeric',
			);
			$this->sanitize_array = array(
				'Job_Type' => 'sanitize_string',
				'Job_Number_Prefix' => 'sanitize_string',
				'Job_Number' => 'sanitize_string',
				'Production_Received' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'Customer_PO' => 'sanitize_string',
				'Tag_Name' => 'sanitize_string',
				'Order_Entry' => 'sanitize_string',
				'Received_Order' => 'sanitize_string',
				'Requested_Date' => 'sanitize_string',
				'Sent_To_OE' => 'sanitize_string',
				'Sent_For_Confirmation' => 'sanitize_string',
				'Confirmation_Received' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'Sent_To_Plant' => 'sanitize_string',
				'Invoiced' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'Uppers' => 'sanitize_string',
				'Talls' => 'sanitize_string',
				'Bases' => 'sanitize_string',
				'Vanities' => 'sanitize_string',
				'Accessories' => 'sanitize_string',
				'Door_Style' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'Original_Job_Number' => 'sanitize_string',
				'Door_Vendor' => 'sanitize_string',
				'Door_ETA' => 'sanitize_string',
				'Other_ETA' => 'sanitize_string',
				'Proposed_Shipping_Date' => 'sanitize_string',
				'Sales_Rep' => 'sanitize_string',
				'Last_Updated_TS' => 'sanitize_string',
				'Status' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("job.Job_Number", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					$this->write_to_log("edit", "true");
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					$this->write_to_log("edit", "false");
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function quick_add_job($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("Job_Type","Job_Number_Prefix","Job_Number","Dealer","Customer_PO","Tag_Name","Order_Entry","Received_Order","Requested_Date","Door_Style","Wood","Colour","Comments","Original_Job_Number","Creator","Created_TS","Status");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'Job_Number' => 'numeric',
			);
			$this->sanitize_array = array(
				'Job_Type' => 'sanitize_string',
				'Job_Number_Prefix' => 'sanitize_string',
				'Job_Number' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'Customer_PO' => 'sanitize_string',
				'Tag_Name' => 'sanitize_string',
				'Order_Entry' => 'sanitize_string',
				'Received_Order' => 'sanitize_string',
				'Requested_Date' => 'sanitize_string',
				'Door_Style' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'Original_Job_Number' => 'sanitize_string',
				'Status' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			$modeldata['Creator'] = USER_ID;
$modeldata['Created_TS'] = "CURRENT_TIMESTAMP";
			//Check if Duplicate Record Already Exit In The Database
			$db->where("Job_Number", $modeldata['Job_Number']);
			if($db->has($tablename)){
				$this->view->page_error[] = $modeldata['Job_Number']." Already exist!";
			} 
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->write_to_log("add", "true");
		//Email Notification
		$time = datetime_now();
		$site_addr = SITE_ADDR;
		$mailtitle = "New Job Record Added";
		$mailbody = "Hi Admin, New Job record has been added successfully. 
			Link : <a href='$site_addr#/job/add/$rec_id'>$rec_id</a> 
			Date added : $time";
		$rec_email = DEFAULT_EMAIL;
		$mailer = new Mailer;
		$mailer->send_mail($rec_email, $mailtitle, $mailbody);
		# Statement to execute after adding record
		if ($modeldata['Job_Type']=='RSO')
{
$rsoTail = ".44";
if (substr_count(rtrim($rec_id),".") > 0) { $rsoTail ="44";}
$newJobNumber = rtrim($rec_id) . $rsoTail;
$db->rawQuery("UPDATE `job` SET Job_Number=($newJobNumber) WHERE Job_Number='$rec_id'");
}
		# End of after add statement
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("job");
				}
				else{
					$this->set_page_error();
					$this->write_to_log("add", "false");
				}
			}
		}
		$page_title = $this->view->page_title = "Add New Job";
		$this->render_view("job/quick_add_job.php");
	}
	/**
     * Update table record with formdata
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function production_edit($rec_id = null, $formdata = null){
		$request = $this->request;
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		 //editable fields
		$fields = $this->fields = array("Full_Job_Number","Job_Type","Job_Number_Prefix","Job_Number","Production_Received","Dealer","Customer_PO","Tag_Name","Order_Entry","Received_Order","Requested_Date","Sent_To_OE","Sent_For_Confirmation","Confirmed","Sent_To_Plant","Invoiced","Value","Uppers","Talls","Bases","Vanities","Accessories","Door_Style","Wood","Colour","Comments","Original_Job_Number","Door_Vendor","Door_ETA","Other_ETA","Standard_Lead_Time","Date_Shipped","Back_Orders","Back_Orders_Shipped","Proposed_Shipping_Date","Shipping_Comments","Shipping_Details","Dealer_Route","Sales_Rep","Creator","Updated_By","Status");
		if($formdata){
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'Full_Job_Number' => 'required',
				'Job_Type' => 'required',
				'Job_Number_Prefix' => 'required',
				'Production_Received' => 'required',
				'Dealer' => 'required',
				'Customer_PO' => 'required',
				'Tag_Name' => 'required',
				'Order_Entry' => 'required',
				'Received_Order' => 'required',
				'Requested_Date' => 'required',
				'Sent_To_OE' => 'required',
				'Sent_For_Confirmation' => 'required',
				'Confirmed' => 'required',
				'Sent_To_Plant' => 'required',
				'Invoiced' => 'required',
				'Value' => 'required|numeric',
				'Uppers' => 'required|numeric',
				'Talls' => 'required|numeric',
				'Bases' => 'required|numeric',
				'Vanities' => 'required|numeric',
				'Accessories' => 'required|numeric',
				'Door_Style' => 'required',
				'Wood' => 'required',
				'Colour' => 'required',
				'Comments' => 'required',
				'Original_Job_Number' => 'required',
				'Door_Vendor' => 'required',
				'Door_ETA' => 'required',
				'Other_ETA' => 'required',
				'Standard_Lead_Time' => 'required',
				'Date_Shipped' => 'required',
				'Back_Orders' => 'required',
				'Back_Orders_Shipped' => 'required',
				'Proposed_Shipping_Date' => 'required',
				'Shipping_Comments' => 'required',
				'Shipping_Details' => 'required',
				'Dealer_Route' => 'required',
				'Sales_Rep' => 'required',
				'Creator' => 'required',
				'Updated_By' => 'required',
				'Status' => 'required',
			);
			$this->sanitize_array = array(
				'Full_Job_Number' => 'sanitize_string',
				'Job_Type' => 'sanitize_string',
				'Job_Number_Prefix' => 'sanitize_string',
				'Production_Received' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'Customer_PO' => 'sanitize_string',
				'Tag_Name' => 'sanitize_string',
				'Order_Entry' => 'sanitize_string',
				'Received_Order' => 'sanitize_string',
				'Requested_Date' => 'sanitize_string',
				'Sent_To_OE' => 'sanitize_string',
				'Sent_For_Confirmation' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'Sent_To_Plant' => 'sanitize_string',
				'Invoiced' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'Uppers' => 'sanitize_string',
				'Talls' => 'sanitize_string',
				'Bases' => 'sanitize_string',
				'Vanities' => 'sanitize_string',
				'Accessories' => 'sanitize_string',
				'Door_Style' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'Original_Job_Number' => 'sanitize_string',
				'Door_Vendor' => 'sanitize_string',
				'Door_ETA' => 'sanitize_string',
				'Other_ETA' => 'sanitize_string',
				'Standard_Lead_Time' => 'sanitize_string',
				'Date_Shipped' => 'sanitize_string',
				'Back_Orders' => 'sanitize_string',
				'Back_Orders_Shipped' => 'sanitize_string',
				'Proposed_Shipping_Date' => 'sanitize_string',
				'Shipping_Comments' => 'sanitize_string',
				'Shipping_Details' => 'sanitize_string',
				'Dealer_Route' => 'sanitize_string',
				'Sales_Rep' => 'sanitize_string',
				'Creator' => 'sanitize_string',
				'Updated_By' => 'sanitize_string',
				'Status' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
		# Statement to execute after adding record
		$Name = get_active_user('displayname');
		# End of before update statement
				$db->where("job.Job_Number", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					$this->write_to_log("edit", "true");
					$this->set_flash_msg("Record updated successfully", "success");
					return $this->redirect("job");
				}
				else{
					if($db->getLastError()){
						$this->set_page_error();
						$this->write_to_log("edit", "false");
					}
					elseif(!$numRows){
						//not an error, but no record was updated
						$page_error = "No record updated";
						$this->set_page_error($page_error);
						$this->set_flash_msg($page_error, "warning");
						$this->write_to_log("edit", "false");
						return	$this->redirect("job");
					}
				}
			}
		}
		$db->where("job.Job_Number", $rec_id);;
		$data = $db->getOne($tablename, $fields);
		$page_title = $this->view->page_title = "Edit  Job";
		if(!$data){
			$this->set_page_error();
		}
		return $this->render_view("job/production_edit.php", $data);
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function quick_add_2($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("Job_Type","Job_Number_Prefix","Production_Received","Dealer","Customer_PO","Tag_Name","Order_Entry","Received_Order","Requested_Date","Sent_To_OE","Sent_For_Confirmation","Confirmed","Sent_To_Plant","Invoiced","Value","Uppers","Talls","Bases","Vanities","Accessories","Door_Style","Wood","Colour","Comments","Original_Job_Number","Door_Vendor","Door_ETA","Other_ETA","Standard_Lead_Time","Date_Shipped","Back_Orders","Back_Orders_Shipped","Proposed_Shipping_Date","Shipping_Comments","Shipping_Details","Dealer_Route","Sales_Rep","Creator","Updated_By","Status");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'Job_Type' => 'required',
				'Job_Number_Prefix' => 'required',
				'Production_Received' => 'required',
				'Dealer' => 'required',
				'Customer_PO' => 'required',
				'Tag_Name' => 'required',
				'Order_Entry' => 'required',
				'Received_Order' => 'required',
				'Requested_Date' => 'required',
				'Sent_To_OE' => 'required',
				'Sent_For_Confirmation' => 'required',
				'Confirmed' => 'required',
				'Sent_To_Plant' => 'required',
				'Invoiced' => 'required',
				'Value' => 'required|numeric',
				'Uppers' => 'required|numeric',
				'Talls' => 'required|numeric',
				'Bases' => 'required|numeric',
				'Vanities' => 'required|numeric',
				'Accessories' => 'required|numeric',
				'Door_Style' => 'required',
				'Wood' => 'required',
				'Colour' => 'required',
				'Comments' => 'required',
				'Original_Job_Number' => 'required',
				'Door_Vendor' => 'required',
				'Door_ETA' => 'required',
				'Other_ETA' => 'required',
				'Standard_Lead_Time' => 'required',
				'Date_Shipped' => 'required',
				'Back_Orders' => 'required',
				'Back_Orders_Shipped' => 'required',
				'Proposed_Shipping_Date' => 'required',
				'Shipping_Comments' => 'required',
				'Shipping_Details' => 'required',
				'Dealer_Route' => 'required',
				'Sales_Rep' => 'required',
				'Creator' => 'required',
				'Updated_By' => 'required',
				'Status' => 'required',
			);
			$this->sanitize_array = array(
				'Job_Type' => 'sanitize_string',
				'Job_Number_Prefix' => 'sanitize_string',
				'Production_Received' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'Customer_PO' => 'sanitize_string',
				'Tag_Name' => 'sanitize_string',
				'Order_Entry' => 'sanitize_string',
				'Received_Order' => 'sanitize_string',
				'Requested_Date' => 'sanitize_string',
				'Sent_To_OE' => 'sanitize_string',
				'Sent_For_Confirmation' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'Sent_To_Plant' => 'sanitize_string',
				'Invoiced' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'Uppers' => 'sanitize_string',
				'Talls' => 'sanitize_string',
				'Bases' => 'sanitize_string',
				'Vanities' => 'sanitize_string',
				'Accessories' => 'sanitize_string',
				'Door_Style' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'Original_Job_Number' => 'sanitize_string',
				'Door_Vendor' => 'sanitize_string',
				'Door_ETA' => 'sanitize_string',
				'Other_ETA' => 'sanitize_string',
				'Standard_Lead_Time' => 'sanitize_string',
				'Date_Shipped' => 'sanitize_string',
				'Back_Orders' => 'sanitize_string',
				'Back_Orders_Shipped' => 'sanitize_string',
				'Proposed_Shipping_Date' => 'sanitize_string',
				'Shipping_Comments' => 'sanitize_string',
				'Shipping_Details' => 'sanitize_string',
				'Dealer_Route' => 'sanitize_string',
				'Sales_Rep' => 'sanitize_string',
				'Creator' => 'sanitize_string',
				'Updated_By' => 'sanitize_string',
				'Status' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->write_to_log("add", "true");
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("job");
				}
				else{
					$this->set_page_error();
					$this->write_to_log("add", "false");
				}
			}
		}
		$page_title = $this->view->page_title = "Add New Job";
		$this->render_view("job/quick_add_2.php");
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view_details($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("Status", 
			"Concat(Job_Number_Prefix,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM Job_Number)))) AS Job_No", 
			"Job_Type", 
			"Job_Number_Prefix", 
			"Job_Number", 
			"Production_Received", 
			"Dealer", 
			"Customer_PO", 
			"Tag_Name", 
			"Received_Order", 
			"Requested_Date", 
			"Confirmed", 
			"Comments", 
			"Original_Job_Number", 
			"Door_Vendor", 
			"Door_ETA", 
			"Other_ETA", 
			"Standard_Lead_Time", 
			"Date_Shipped", 
			"Back_Orders", 
			"Back_Orders_Shipped", 
			"Proposed_Shipping_Date", 
			"Shipping_Comments", 
			"Shipping_Details", 
			"Dealer_Route", 
			"Sales_Rep");
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("job.Job_Number", $rec_id);; //select record based on primary key
		}
		$record = $db->getOne($tablename, $fields );
		if($record){
			$this->write_to_log("view", "true");
			$page_title = $this->view->page_title = "View  Job";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
			$this->write_to_log("view", "false");
		}
		return $this->render_view("job/view_details.php", $record);
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view_ish($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("job.Full_Job_Number", 
			"job.Job_Type", 
			"job.Job_Number_Prefix", 
			"job.Job_Number", 
			"jlv2_jl_6_job_conversation.fk_JobNum AS jlv2_jl_6_job_conversation_fk_JobNum", 
			"job.Production_Received", 
			"job.Dealer", 
			"job.Customer_PO", 
			"job.Tag_Name", 
			"job.Order_Entry", 
			"job.Received_Order", 
			"job.Requested_Date", 
			"job.Sent_To_OE", 
			"job.Sent_For_Confirmation", 
			"job.Confirmation_Received", 
			"job.Confirmed", 
			"job.Sent_To_Plant", 
			"job.Invoiced", 
			"job.Value", 
			"job.Uppers", 
			"job.Talls", 
			"job.Bases", 
			"job.Vanities", 
			"job.Accessories", 
			"job.Door_Style", 
			"job.Wood", 
			"job.Colour", 
			"job.Comments", 
			"job.Original_Job_Number", 
			"job.Door_Vendor", 
			"job.Door_ETA", 
			"job.Other_ETA", 
			"job.Standard_Lead_Time", 
			"job.Date_Shipped", 
			"job.Back_Orders", 
			"job.Back_Orders_Shipped", 
			"job.Proposed_Shipping_Date", 
			"job.Shipping_Comments", 
			"job.Shipping_Details", 
			"job.Dealer_Route", 
			"job.Sales_Rep", 
			"job.Creator", 
			"job.Updated_By", 
			"job.Created_TS", 
			"job.Last_Updated_TS", 
			"job.Status");
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("job.Job_Number", $rec_id);; //select record based on primary key
		}
		$db->join("jlv2_jl_6_job_conversation", "job.Job_Number = jlv2_jl_6_job_conversation.fk_JobNum", "INNER");  
		$record = $db->getOne($tablename, $fields );
		if($record){
			$this->write_to_log("view", "true");
			$page_title = $this->view->page_title = "View  Job";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
			$this->write_to_log("view", "false");
		}
		return $this->render_view("job/view_ish.php", $record);
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function joblist($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("Concat(Job_Number_Prefix,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM Job_Number)))) AS DJob_No", 
			"Job_Number", 
			"Production_Received", 
			"Dealer", 
			"Customer_PO", 
			"Tag_Name", 
			"Comments", 
			"Confirmed", 
			"Value", 
			"Uppers", 
			"Talls", 
			"Bases", 
			"Vanities", 
			"Accessories", 
			"Door_Style", 
			"Wood", 
			"Colour");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				job.Full_Job_Number LIKE ? OR 
				job.Job_Type LIKE ? OR 
				job.Job_Number_Prefix LIKE ? OR 
				job.Job_Number LIKE ? OR 
				trim(TRAILING '.' FROM (trim(TRAILING '0' FROM Job_Number))) LIKE ? OR 
				job.Production_Received LIKE ? OR 
				job.Dealer LIKE ? OR 
				job.Customer_PO LIKE ? OR 
				job.Tag_Name LIKE ? OR 
				job.Comments LIKE ? OR 
				job.Order_Entry LIKE ? OR 
				job.Received_Order LIKE ? OR 
				job.Requested_Date LIKE ? OR 
				job.Sent_To_OE LIKE ? OR 
				job.Sent_For_Confirmation LIKE ? OR 
				job.Confirmation_Received LIKE ? OR 
				job.Confirmed LIKE ? OR 
				job.Sent_To_Plant LIKE ? OR 
				job.Invoiced LIKE ? OR 
				job.Value LIKE ? OR 
				job.Uppers LIKE ? OR 
				job.Talls LIKE ? OR 
				job.Bases LIKE ? OR 
				job.Vanities LIKE ? OR 
				job.Accessories LIKE ? OR 
				job.Door_Style LIKE ? OR 
				job.Wood LIKE ? OR 
				job.Colour LIKE ? OR 
				job.Original_Job_Number LIKE ? OR 
				job.Door_Vendor LIKE ? OR 
				job.Door_ETA LIKE ? OR 
				job.Other_ETA LIKE ? OR 
				job.Standard_Lead_Time LIKE ? OR 
				job.Date_Shipped LIKE ? OR 
				job.Back_Orders LIKE ? OR 
				job.Back_Orders_Shipped LIKE ? OR 
				job.Proposed_Shipping_Date LIKE ? OR 
				job.Shipping_Comments LIKE ? OR 
				job.Shipping_Details LIKE ? OR 
				job.Dealer_Route LIKE ? OR 
				job.Sales_Rep LIKE ? OR 
				job.Creator LIKE ? OR 
				job.Updated_By LIKE ? OR 
				job.Created_TS LIKE ? OR 
				job.Last_Updated_TS LIKE ? OR 
				job.Status LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "job/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("job.Job_Number", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		//list of record id for audit trail
		$this->rec_id = array_column($records, "Job_Number");
		$this->write_to_log("list", "true");
		if($db->getLastError()){
			$this->set_page_error();
			$this->write_to_log("list", "false");
		}
		$page_title = $this->view->page_title = "Job";
		$this->render_view("job/joblist.php", $data); //render the full page
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function blist($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("job.Full_Job_Number", 
			"job.Job_Type", 
			"job.Job_Number_Prefix", 
			"job.Job_Number", 
			"jlv2_jl_6_job_conversation.fk_JobNum AS jlv2_jl_6_job_conversation_fk_JobNum", 
			"job.Production_Received", 
			"job.Dealer", 
			"job.Customer_PO", 
			"job.Tag_Name", 
			"job.Order_Entry", 
			"job.Received_Order", 
			"job.Requested_Date", 
			"job.Sent_To_OE", 
			"job.Sent_For_Confirmation", 
			"job.Confirmation_Received", 
			"job.Confirmed", 
			"job.Sent_To_Plant", 
			"job.Invoiced", 
			"job.Value", 
			"job.Uppers", 
			"job.Talls", 
			"job.Bases", 
			"job.Vanities", 
			"job.Accessories", 
			"job.Door_Style", 
			"job.Wood", 
			"job.Colour", 
			"job.Comments", 
			"job.Original_Job_Number", 
			"job.Door_Vendor", 
			"job.Door_ETA", 
			"job.Other_ETA", 
			"job.Standard_Lead_Time", 
			"job.Date_Shipped", 
			"job.Back_Orders", 
			"job.Back_Orders_Shipped", 
			"job.Proposed_Shipping_Date", 
			"job.Shipping_Comments", 
			"job.Shipping_Details", 
			"job.Dealer_Route", 
			"job.Sales_Rep", 
			"job.Creator", 
			"job.Updated_By", 
			"job.Created_TS", 
			"job.Last_Updated_TS", 
			"job.Status");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				job.Full_Job_Number LIKE ? OR 
				job.Job_Type LIKE ? OR 
				job.Job_Number_Prefix LIKE ? OR 
				job.Job_Number LIKE ? OR 
				job.Production_Received LIKE ? OR 
				job.Dealer LIKE ? OR 
				job.Customer_PO LIKE ? OR 
				job.Tag_Name LIKE ? OR 
				job.Order_Entry LIKE ? OR 
				job.Received_Order LIKE ? OR 
				job.Requested_Date LIKE ? OR 
				job.Sent_To_OE LIKE ? OR 
				job.Sent_For_Confirmation LIKE ? OR 
				job.Confirmation_Received LIKE ? OR 
				job.Confirmed LIKE ? OR 
				job.Sent_To_Plant LIKE ? OR 
				job.Invoiced LIKE ? OR 
				job.Value LIKE ? OR 
				job.Uppers LIKE ? OR 
				job.Talls LIKE ? OR 
				job.Bases LIKE ? OR 
				job.Vanities LIKE ? OR 
				job.Accessories LIKE ? OR 
				job.Door_Style LIKE ? OR 
				job.Wood LIKE ? OR 
				job.Colour LIKE ? OR 
				job.Comments LIKE ? OR 
				job.Original_Job_Number LIKE ? OR 
				job.Door_Vendor LIKE ? OR 
				job.Door_ETA LIKE ? OR 
				job.Other_ETA LIKE ? OR 
				job.Standard_Lead_Time LIKE ? OR 
				job.Date_Shipped LIKE ? OR 
				job.Back_Orders LIKE ? OR 
				job.Back_Orders_Shipped LIKE ? OR 
				job.Proposed_Shipping_Date LIKE ? OR 
				job.Shipping_Comments LIKE ? OR 
				job.Shipping_Details LIKE ? OR 
				job.Dealer_Route LIKE ? OR 
				job.Sales_Rep LIKE ? OR 
				job.Creator LIKE ? OR 
				job.Updated_By LIKE ? OR 
				job.Created_TS LIKE ? OR 
				job.Last_Updated_TS LIKE ? OR 
				job.Status LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "job/search.php";
		}
		$db->join("jlv2_jl_6_job_conversation", "job.Job_Number = jlv2_jl_6_job_conversation.fk_JobNum", "INNER");
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("job.Job_Number", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		//list of record id for audit trail
		$this->rec_id = array_column($records, "Job_Number");
		$this->write_to_log("list", "true");
		if($db->getLastError()){
			$this->set_page_error();
			$this->write_to_log("list", "false");
		}
		$page_title = $this->view->page_title = "Job";
		$view_name = (is_ajax() ? "job/ajax-blist.php" : "job/blist.php");
		$this->render_view($view_name, $data);
	}
}
