<?php 
/**
 * Xx_job_list_prototype_xx Page Controller
 * @category  Controller
 */
class Xx_job_list_prototype_xxController extends SecureController{
	function __construct(){
		parent::__construct();
		$this->tablename = "xx_job_list_prototype_xx";
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("Full_Job_Number","Job_Type","Job_Number_Prefix","Job_Number","Production_Received","Dealer","Customer_PO","Tag_Name","Order_Entry","Received_Order","Requested_Date","Sent_To_OE","Sent_For_Confirmation","Confirmation_Received","Confirmed","Sent_To_Plant","Invoiced","Value","Uppers","Talls","Bases","Vanities","Accessories","Door_Style","Wood","Colour","Comments","Original_Job_Number","Door_Vendor","Door_ETA","Other_ETA","Standard_Lead_Time","Date_Shipped","Back_Orders","Back_Orders_Shipped","Proposed_Shipping_Date","Shipping_Comments","Shipping_Details","Dealer_Route","Sales_Rep","Creator","Updated_By","Last_Updated_TS","Status");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'Full_Job_Number' => 'required',
				'Job_Type' => 'required',
				'Job_Number_Prefix' => 'required',
				'Production_Received' => 'required',
				'Dealer' => 'required',
				'Customer_PO' => 'required',
				'Tag_Name' => 'required',
				'Order_Entry' => 'required',
				'Received_Order' => 'required',
				'Requested_Date' => 'required',
				'Sent_To_OE' => 'required',
				'Sent_For_Confirmation' => 'required',
				'Confirmation_Received' => 'required',
				'Confirmed' => 'required',
				'Sent_To_Plant' => 'required',
				'Invoiced' => 'required',
				'Value' => 'required|numeric',
				'Uppers' => 'required|numeric',
				'Talls' => 'required|numeric',
				'Bases' => 'required|numeric',
				'Vanities' => 'required|numeric',
				'Accessories' => 'required|numeric',
				'Door_Style' => 'required',
				'Wood' => 'required',
				'Colour' => 'required',
				'Comments' => 'required',
				'Original_Job_Number' => 'required',
				'Door_Vendor' => 'required',
				'Door_ETA' => 'required',
				'Other_ETA' => 'required',
				'Standard_Lead_Time' => 'required',
				'Date_Shipped' => 'required',
				'Back_Orders' => 'required',
				'Back_Orders_Shipped' => 'required',
				'Proposed_Shipping_Date' => 'required',
				'Shipping_Comments' => 'required',
				'Shipping_Details' => 'required',
				'Dealer_Route' => 'required',
				'Sales_Rep' => 'required',
				'Creator' => 'required',
				'Updated_By' => 'required',
				'Last_Updated_TS' => 'required',
				'Status' => 'required',
			);
			$this->sanitize_array = array(
				'Full_Job_Number' => 'sanitize_string',
				'Job_Type' => 'sanitize_string',
				'Job_Number_Prefix' => 'sanitize_string',
				'Production_Received' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'Customer_PO' => 'sanitize_string',
				'Tag_Name' => 'sanitize_string',
				'Order_Entry' => 'sanitize_string',
				'Received_Order' => 'sanitize_string',
				'Requested_Date' => 'sanitize_string',
				'Sent_To_OE' => 'sanitize_string',
				'Sent_For_Confirmation' => 'sanitize_string',
				'Confirmation_Received' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'Sent_To_Plant' => 'sanitize_string',
				'Invoiced' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'Uppers' => 'sanitize_string',
				'Talls' => 'sanitize_string',
				'Bases' => 'sanitize_string',
				'Vanities' => 'sanitize_string',
				'Accessories' => 'sanitize_string',
				'Door_Style' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'Original_Job_Number' => 'sanitize_string',
				'Door_Vendor' => 'sanitize_string',
				'Door_ETA' => 'sanitize_string',
				'Other_ETA' => 'sanitize_string',
				'Standard_Lead_Time' => 'sanitize_string',
				'Date_Shipped' => 'sanitize_string',
				'Back_Orders' => 'sanitize_string',
				'Back_Orders_Shipped' => 'sanitize_string',
				'Proposed_Shipping_Date' => 'sanitize_string',
				'Shipping_Comments' => 'sanitize_string',
				'Shipping_Details' => 'sanitize_string',
				'Dealer_Route' => 'sanitize_string',
				'Sales_Rep' => 'sanitize_string',
				'Creator' => 'sanitize_string',
				'Updated_By' => 'sanitize_string',
				'Last_Updated_TS' => 'sanitize_string',
				'Status' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("xx_job_list_prototype_xx.Job_Number", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					$this->write_to_log("edit", "true");
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					$this->write_to_log("edit", "false");
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
}
