<?php 
//check if current user role is allowed access to the pages
$can_add = ACL::is_allowed("jlv2_aa_0_oc_users/add");
$can_edit = ACL::is_allowed("jlv2_aa_0_oc_users/edit");
$can_view = ACL::is_allowed("jlv2_aa_0_oc_users/view");
$can_delete = ACL::is_allowed("jlv2_aa_0_oc_users/delete");
?>
<?php
$comp_model = new SharedController;
$page_element_id = "view-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data Information from Controller
$data = $this->view_data;
//$rec_id = $data['__tableprimarykey'];
$page_id = $this->route->page_id; //Page id from url
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_edit_btn = $this->show_edit_btn;
$show_delete_btn = $this->show_delete_btn;
$show_export_btn = $this->show_export_btn;
?>
<section class="page" id="<?php echo $page_element_id; ?>" data-page-type="view"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">My Account</h4>
                </div>
            </div>
        </div>
    </div>
    <?php
    }
    ?>
    <div  class="">
        <div class="container">
            <div class="row ">
                <div class="col-md-12 comp-grid">
                    <?php $this :: display_page_errors(); ?>
                    <div  class="card animated fadeIn page-content">
                        <?php
                        $counter = 0;
                        if(!empty($data)){
                        $rec_id = (!empty($data['uid']) ? urlencode($data['uid']) : null);
                        $counter++;
                        ?>
                        <div class="bg-primary m-2 mb-4">
                            <div class="profile">
                                <div class="avatar">
                                    <?php 
                                    if(!empty(USER_PHOTO)){
                                    Html::page_img(USER_PHOTO, 100, 100); 
                                    }
                                    ?>
                                </div>
                                <h1 class="title mt-4"><?php echo $data['uid_lower']; ?></h1>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="mx-3 mb-3">
                                    <ul class="nav nav-pills flex-column text-left">
                                        <li class="nav-item">
                                            <a data-toggle="tab" href="#AccountPageView" class="nav-link active">
                                                <i class="icon dripicons-user"></i> Account Detail
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab" href="#AccountPageEdit" class="nav-link">
                                                <i class="icon dripicons-document-edit"></i> Edit Account
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab" href="#AccountPageChangeEmail" class="nav-link">
                                                <i class="icon dripicons-mail"></i> Change Email
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-sm-9">
                                <div class="mb-3">
                                    <div class="tab-content">
                                        <div class="tab-pane show active fade" id="AccountPageView" role="tabpanel">
                                            <table class="table table-hover table-borderless table-striped">
                                                <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                                    <tr  class="td-uid">
                                                        <th class="title"> Uid: </th>
                                                        <td class="value">
                                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['uid']; ?>" 
                                                                data-pk="<?php echo $data['uid'] ?>" 
                                                                data-url="<?php print_link("jlv2_aa_0_oc_users/editfield/" . urlencode($data['uid'])); ?>" 
                                                                data-name="uid" 
                                                                data-title="Enter Uid" 
                                                                data-placement="left" 
                                                                data-toggle="click" 
                                                                data-type="text" 
                                                                data-mode="popover" 
                                                                data-showbuttons="left" 
                                                                class="is-editable" <?php } ?>>
                                                                <?php echo $data['uid']; ?> 
                                                            </span>
                                                        </td>
                                                    </tr>
                                                    <tr  class="td-displayname">
                                                        <th class="title"> Displayname: </th>
                                                        <td class="value">
                                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['displayname']; ?>" 
                                                                data-pk="<?php echo $data['uid'] ?>" 
                                                                data-url="<?php print_link("jlv2_aa_0_oc_users/editfield/" . urlencode($data['uid'])); ?>" 
                                                                data-name="displayname" 
                                                                data-title="Enter Displayname" 
                                                                data-placement="left" 
                                                                data-toggle="click" 
                                                                data-type="text" 
                                                                data-mode="popover" 
                                                                data-showbuttons="left" 
                                                                class="is-editable" <?php } ?>>
                                                                <?php echo $data['displayname']; ?> 
                                                            </span>
                                                        </td>
                                                    </tr>
                                                    <tr  class="td-uid_lower">
                                                        <th class="title"> Uid Lower: </th>
                                                        <td class="value">
                                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['uid_lower']; ?>" 
                                                                data-pk="<?php echo $data['uid'] ?>" 
                                                                data-url="<?php print_link("jlv2_aa_0_oc_users/editfield/" . urlencode($data['uid'])); ?>" 
                                                                data-name="uid_lower" 
                                                                data-title="Enter Uid Lower" 
                                                                data-placement="left" 
                                                                data-toggle="click" 
                                                                data-type="text" 
                                                                data-mode="popover" 
                                                                data-showbuttons="left" 
                                                                class="is-editable" <?php } ?>>
                                                                <?php echo $data['uid_lower']; ?> 
                                                            </span>
                                                        </td>
                                                    </tr>
                                                    <tr  class="td-email">
                                                        <th class="title"> Email: </th>
                                                        <td class="value"> <?php echo $data['email']; ?></td>
                                                    </tr>
                                                    <tr  class="td-type">
                                                        <th class="title"> Type: </th>
                                                        <td class="value">
                                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['type']; ?>" 
                                                                data-pk="<?php echo $data['uid'] ?>" 
                                                                data-url="<?php print_link("jlv2_aa_0_oc_users/editfield/" . urlencode($data['uid'])); ?>" 
                                                                data-name="type" 
                                                                data-title="Enter Type" 
                                                                data-placement="left" 
                                                                data-toggle="click" 
                                                                data-type="text" 
                                                                data-mode="popover" 
                                                                data-showbuttons="left" 
                                                                class="is-editable" <?php } ?>>
                                                                <?php echo $data['type']; ?> 
                                                            </span>
                                                        </td>
                                                    </tr>
                                                    <tr  class="td-jl_type">
                                                        <th class="title"> Jl Type: </th>
                                                        <td class="value">
                                                            <span <?php if($can_edit){ ?> data-source='<?php echo json_encode_quote(Menu :: $jl_type); ?>' 
                                                                data-value="<?php echo $data['jl_type']; ?>" 
                                                                data-pk="<?php echo $data['uid'] ?>" 
                                                                data-url="<?php print_link("jlv2_aa_0_oc_users/editfield/" . urlencode($data['uid'])); ?>" 
                                                                data-name="jl_type" 
                                                                data-title="Select a value ..." 
                                                                data-placement="left" 
                                                                data-toggle="click" 
                                                                data-type="select" 
                                                                data-mode="popover" 
                                                                data-showbuttons="left" 
                                                                class="is-editable" <?php } ?>>
                                                                <?php echo $data['jl_type']; ?> 
                                                            </span>
                                                        </td>
                                                    </tr>
                                                    <tr  class="td-ql_type">
                                                        <th class="title"> Ql Type: </th>
                                                        <td class="value">
                                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['ql_type']; ?>" 
                                                                data-pk="<?php echo $data['uid'] ?>" 
                                                                data-url="<?php print_link("jlv2_aa_0_oc_users/editfield/" . urlencode($data['uid'])); ?>" 
                                                                data-name="ql_type" 
                                                                data-title="Enter Ql Type" 
                                                                data-placement="left" 
                                                                data-toggle="click" 
                                                                data-type="text" 
                                                                data-mode="popover" 
                                                                data-showbuttons="left" 
                                                                class="is-editable" <?php } ?>>
                                                                <?php echo $data['ql_type']; ?> 
                                                            </span>
                                                        </td>
                                                    </tr>
                                                    <tr  class="td-sl_type">
                                                        <th class="title"> Sl Type: </th>
                                                        <td class="value">
                                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['sl_type']; ?>" 
                                                                data-pk="<?php echo $data['uid'] ?>" 
                                                                data-url="<?php print_link("jlv2_aa_0_oc_users/editfield/" . urlencode($data['uid'])); ?>" 
                                                                data-name="sl_type" 
                                                                data-title="Enter Sl Type" 
                                                                data-placement="left" 
                                                                data-toggle="click" 
                                                                data-type="text" 
                                                                data-mode="popover" 
                                                                data-showbuttons="left" 
                                                                class="is-editable" <?php } ?>>
                                                                <?php echo $data['sl_type']; ?> 
                                                            </span>
                                                        </td>
                                                    </tr>
                                                    <tr  class="td-rl_type">
                                                        <th class="title"> Rl Type: </th>
                                                        <td class="value">
                                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['rl_type']; ?>" 
                                                                data-pk="<?php echo $data['uid'] ?>" 
                                                                data-url="<?php print_link("jlv2_aa_0_oc_users/editfield/" . urlencode($data['uid'])); ?>" 
                                                                data-name="rl_type" 
                                                                data-title="Enter Rl Type" 
                                                                data-placement="left" 
                                                                data-toggle="click" 
                                                                data-type="text" 
                                                                data-mode="popover" 
                                                                data-showbuttons="left" 
                                                                class="is-editable" <?php } ?>>
                                                                <?php echo $data['rl_type']; ?> 
                                                            </span>
                                                        </td>
                                                    </tr>
                                                    <tr  class="td-initials">
                                                        <th class="title"> Initials: </th>
                                                        <td class="value">
                                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['initials']; ?>" 
                                                                data-pk="<?php echo $data['uid'] ?>" 
                                                                data-url="<?php print_link("jlv2_aa_0_oc_users/editfield/" . urlencode($data['uid'])); ?>" 
                                                                data-name="initials" 
                                                                data-title="Enter Initials" 
                                                                data-placement="left" 
                                                                data-toggle="click" 
                                                                data-type="text" 
                                                                data-mode="popover" 
                                                                data-showbuttons="left" 
                                                                class="is-editable" <?php } ?>>
                                                                <?php echo $data['initials']; ?> 
                                                            </span>
                                                        </td>
                                                    </tr>
                                                    <tr  class="td-account_status">
                                                        <th class="title"> Account Status: </th>
                                                        <td class="value">
                                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['account_status']; ?>" 
                                                                data-pk="<?php echo $data['uid'] ?>" 
                                                                data-url="<?php print_link("jlv2_aa_0_oc_users/editfield/" . urlencode($data['uid'])); ?>" 
                                                                data-name="account_status" 
                                                                data-title="Enter Account Status" 
                                                                data-placement="left" 
                                                                data-toggle="click" 
                                                                data-type="text" 
                                                                data-mode="popover" 
                                                                data-showbuttons="left" 
                                                                class="is-editable" <?php } ?>>
                                                                <?php echo $data['account_status']; ?> 
                                                            </span>
                                                        </td>
                                                    </tr>
                                                </tbody>    
                                            </table>
                                        </div>
                                        <div class="tab-pane fade" id="AccountPageEdit" role="tabpanel">
                                            <div class=" reset-grids">
                                                <?php  $this->render_page("account/edit"); ?>
                                            </div>
                                        </div>
                                        <div class="tab-pane  fade" id="AccountPageChangeEmail" role="tabpanel">
                                            <div class=" reset-grids">
                                                <?php  $this->render_page("account/change_email"); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php
                        }
                        else{
                        ?>
                        <!-- Empty Record Message -->
                        <div class="text-muted p-3">
                            <i class="icon dripicons-wrong"></i> No Record Found
                        </div>
                        <?php
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
