<?php 
//check if current user role is allowed access to the pages
$can_add = ACL::is_allowed("jlv2_jl_7_production_status/add");
$can_edit = ACL::is_allowed("jlv2_jl_7_production_status/edit");
$can_view = ACL::is_allowed("jlv2_jl_7_production_status/view");
$can_delete = ACL::is_allowed("jlv2_jl_7_production_status/delete");
?>
<?php
$comp_model = new SharedController;
$page_element_id = "list-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data From Controller
$view_data = $this->view_data;
$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = $this->route->field_name;
$field_value = $this->route->field_value;
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;
?>
<section class="page" id="<?php echo $page_element_id; ?>" data-page-type="list"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">Production Status</h4>
                </div>
                <div class="col-md-12 comp-grid">
                    <div class="">
                        <!-- Page bread crumbs components-->
                        <?php
                        if(!empty($field_name) || !empty($_GET['search'])){
                        ?>
                        <hr class="sm d-block d-sm-none" />
                        <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                            <ul class="breadcrumb m-0 p-1">
                                <?php
                                if(!empty($field_name)){
                                ?>
                                <li class="breadcrumb-item">
                                    <a class="text-decoration-none" href="<?php print_link('jlv2_jl_7_production_status'); ?>">
                                        <i class="icon dripicons-arrow-thin-left"></i>
                                    </a>
                                </li>
                                <li class="breadcrumb-item">
                                    <?php echo (get_value("tag") ? get_value("tag")  :  make_readable($field_name)); ?>
                                </li>
                                <li  class="breadcrumb-item active text-capitalize font-weight-bold">
                                    <?php echo (get_value("label") ? get_value("label")  :  make_readable(urldecode($field_value))); ?>
                                </li>
                                <?php 
                                }   
                                ?>
                                <?php
                                if(get_value("search")){
                                ?>
                                <li class="breadcrumb-item">
                                    <a class="text-decoration-none" href="<?php print_link('jlv2_jl_7_production_status'); ?>">
                                        <i class="icon dripicons-arrow-thin-left"></i>
                                    </a>
                                </li>
                                <li class="breadcrumb-item text-capitalize">
                                    Search
                                </li>
                                <li  class="breadcrumb-item active text-capitalize font-weight-bold"><?php echo get_value("search"); ?></li>
                                <?php
                                }
                                ?>
                            </ul>
                        </nav>
                        <!--End of Page bread crumbs components-->
                        <?php
                        }
                        ?>
                    </div>
                </div>
                <div class="col-md-4 comp-grid">
                </div>
            </div>
        </div>
    </div>
    <?php
    }
    ?>
    <div  class="">
        <div class="container-fluid">
            <div class="row ">
                <div class="col-md-12 comp-grid">
                    <?php $this :: display_page_errors(); ?>
                    <div  class=" animated fadeIn page-content">
                        <div id="jlv2_jl_7_production_status-production_station_list-records">
                            <div id="page-report-body" class="table-responsive">
                                <table class="table  table-striped table-sm text-left">
                                    <thead class="table-header bg-light">
                                        <tr>
                                            <th class="td-btn"></th>
                                            <th  class="td-JobNum"> Jobnum</th>
                                            <th  class="td-Ordered"> Ordered</th>
                                            <th  class="td-Nested"> Nested</th>
                                            <th  class="td-Finished_Parts"> Finished Parts</th>
                                            <th  class="td-Wrapped"> Wrapped</th>
                                            <th  class="td-Finishing"> Finishing</th>
                                            <th  class="td-Unfinished_Parts"> Unfinished Parts</th>
                                            <th  class="td-Assembled"> Assembled</th>
                                            <th  class="td-tOrdered"> Tordered</th>
                                            <th  class="td-tNested"> Tnested</th>
                                            <th  class="td-tFinished_Parts"> Tfinished Parts</th>
                                            <th  class="td-tWrapped"> Twrapped</th>
                                            <th  class="td-tFinishing"> Tfinishing</th>
                                            <th  class="td-tUnfinished_Parts"> Tunfinished Parts</th>
                                            <th  class="td-tAssembled"> Tassembled</th>
                                            <th  class="td-sOrdered"> Sordered</th>
                                            <th  class="td-sNested"> Snested</th>
                                            <th  class="td-sFinished_Parts"> Sfinished Parts</th>
                                            <th  class="td-sWrapped"> Swrapped</th>
                                            <th  class="td-sFinishing"> Sfinishing</th>
                                            <th  class="td-sUnfinished_Parts"> Sunfinished Parts</th>
                                            <th  class="td-sAssembled"> Sassembled</th>
                                            <th  class="td-Job_Number_Prefix"> Job Number Prefix</th>
                                            <th  class="td-SQ_FT_Parts"> Sq Ft Parts</th>
                                            <th  class="td-SQ_FT_Doors"> Sq Ft Doors</th>
                                            <th  class="td-CNC_MDF"> Cnc Mdf</th>
                                            <th  class="td-CNC_FIN"> Cnc Fin</th>
                                            <th  class="td-CNC_UNFIN"> Cnc Unfin</th>
                                        </tr>
                                    </thead>
                                    <?php
                                    if(!empty($records)){
                                    ?>
                                    <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                        <!--record-->
                                        <?php
                                        $counter = 0;
                                        foreach($records as $data){
                                        $rec_id = (!empty($data['JobNum']) ? urlencode($data['JobNum']) : null);
                                        $counter++;
                                        ?>
                                        <tr>
                                            <td class="td-JobNum"><a href="<?php print_link("jlv2_jl_7_production_status/view/$data[JobNum]") ?>"><?php echo $data['JobNum']; ?></a></td>
                                            <td class="td-Ordered">
                                                <span <?php if($can_edit){ ?> data-flatpickr="{ minDate: '', maxDate: ''}" 
                                                    data-value="<?php echo $data['Ordered']; ?>" 
                                                    data-pk="<?php echo $data['JobNum'] ?>" 
                                                    data-url="<?php print_link("jlv2_jl_7_production_status/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                    data-name="Ordered" 
                                                    data-title="Enter Ordered" 
                                                    data-placement="left" 
                                                    data-toggle="click" 
                                                    data-type="flatdatetimepicker" 
                                                    data-mode="popover" 
                                                    data-showbuttons="left" 
                                                    class="is-editable" <?php } ?>>
                                                    <?php echo $data['Ordered']; ?> 
                                                </span>
                                            </td>
                                            <td class="td-Nested">
                                                <span <?php if($can_edit){ ?> data-flatpickr="{ minDate: '', maxDate: ''}" 
                                                    data-value="<?php echo $data['Nested']; ?>" 
                                                    data-pk="<?php echo $data['JobNum'] ?>" 
                                                    data-url="<?php print_link("jlv2_jl_7_production_status/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                    data-name="Nested" 
                                                    data-title="Enter Nested" 
                                                    data-placement="left" 
                                                    data-toggle="click" 
                                                    data-type="flatdatetimepicker" 
                                                    data-mode="popover" 
                                                    data-showbuttons="left" 
                                                    class="is-editable" <?php } ?>>
                                                    <?php echo $data['Nested']; ?> 
                                                </span>
                                            </td>
                                            <td class="td-Finished_Parts">
                                                <span <?php if($can_edit){ ?> data-flatpickr="{ minDate: '', maxDate: ''}" 
                                                    data-value="<?php echo $data['Finished_Parts']; ?>" 
                                                    data-pk="<?php echo $data['JobNum'] ?>" 
                                                    data-url="<?php print_link("jlv2_jl_7_production_status/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                    data-name="Finished_Parts" 
                                                    data-title="Enter Finished Parts" 
                                                    data-placement="left" 
                                                    data-toggle="click" 
                                                    data-type="flatdatetimepicker" 
                                                    data-mode="popover" 
                                                    data-showbuttons="left" 
                                                    class="is-editable" <?php } ?>>
                                                    <?php echo $data['Finished_Parts']; ?> 
                                                </span>
                                            </td>
                                            <td class="td-Wrapped">
                                                <span <?php if($can_edit){ ?> data-flatpickr="{ minDate: '', maxDate: ''}" 
                                                    data-value="<?php echo $data['Wrapped']; ?>" 
                                                    data-pk="<?php echo $data['JobNum'] ?>" 
                                                    data-url="<?php print_link("jlv2_jl_7_production_status/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                    data-name="Wrapped" 
                                                    data-title="Enter Wrapped" 
                                                    data-placement="left" 
                                                    data-toggle="click" 
                                                    data-type="flatdatetimepicker" 
                                                    data-mode="popover" 
                                                    data-showbuttons="left" 
                                                    class="is-editable" <?php } ?>>
                                                    <?php echo $data['Wrapped']; ?> 
                                                </span>
                                            </td>
                                            <td class="td-Finishing">
                                                <span <?php if($can_edit){ ?> data-flatpickr="{ minDate: '', maxDate: ''}" 
                                                    data-value="<?php echo $data['Finishing']; ?>" 
                                                    data-pk="<?php echo $data['JobNum'] ?>" 
                                                    data-url="<?php print_link("jlv2_jl_7_production_status/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                    data-name="Finishing" 
                                                    data-title="Enter Finishing" 
                                                    data-placement="left" 
                                                    data-toggle="click" 
                                                    data-type="flatdatetimepicker" 
                                                    data-mode="popover" 
                                                    data-showbuttons="left" 
                                                    class="is-editable" <?php } ?>>
                                                    <?php echo $data['Finishing']; ?> 
                                                </span>
                                            </td>
                                            <td class="td-Unfinished_Parts">
                                                <span <?php if($can_edit){ ?> data-flatpickr="{ minDate: '', maxDate: ''}" 
                                                    data-value="<?php echo $data['Unfinished_Parts']; ?>" 
                                                    data-pk="<?php echo $data['JobNum'] ?>" 
                                                    data-url="<?php print_link("jlv2_jl_7_production_status/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                    data-name="Unfinished_Parts" 
                                                    data-title="Enter Unfinished Parts" 
                                                    data-placement="left" 
                                                    data-toggle="click" 
                                                    data-type="flatdatetimepicker" 
                                                    data-mode="popover" 
                                                    data-showbuttons="left" 
                                                    class="is-editable" <?php } ?>>
                                                    <?php echo $data['Unfinished_Parts']; ?> 
                                                </span>
                                            </td>
                                            <td class="td-Assembled">
                                                <span <?php if($can_edit){ ?> data-flatpickr="{ minDate: '', maxDate: ''}" 
                                                    data-value="<?php echo $data['Assembled']; ?>" 
                                                    data-pk="<?php echo $data['JobNum'] ?>" 
                                                    data-url="<?php print_link("jlv2_jl_7_production_status/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                    data-name="Assembled" 
                                                    data-title="Enter Assembled" 
                                                    data-placement="left" 
                                                    data-toggle="click" 
                                                    data-type="flatdatetimepicker" 
                                                    data-mode="popover" 
                                                    data-showbuttons="left" 
                                                    class="is-editable" <?php } ?>>
                                                    <?php echo $data['Assembled']; ?> 
                                                </span>
                                            </td>
                                            <td class="td-tOrdered">
                                                <span <?php if($can_edit){ ?> data-value="<?php echo $data['tOrdered']; ?>" 
                                                    data-pk="<?php echo $data['JobNum'] ?>" 
                                                    data-url="<?php print_link("jlv2_jl_7_production_status/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                    data-name="tOrdered" 
                                                    data-title="Enter Tordered" 
                                                    data-placement="left" 
                                                    data-toggle="click" 
                                                    data-type="number" 
                                                    data-mode="popover" 
                                                    data-showbuttons="left" 
                                                    class="is-editable" <?php } ?>>
                                                    <?php echo $data['tOrdered']; ?> 
                                                </span>
                                            </td>
                                            <td class="td-tNested">
                                                <span <?php if($can_edit){ ?> data-value="<?php echo $data['tNested']; ?>" 
                                                    data-pk="<?php echo $data['JobNum'] ?>" 
                                                    data-url="<?php print_link("jlv2_jl_7_production_status/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                    data-name="tNested" 
                                                    data-title="Enter Tnested" 
                                                    data-placement="left" 
                                                    data-toggle="click" 
                                                    data-type="number" 
                                                    data-mode="popover" 
                                                    data-showbuttons="left" 
                                                    class="is-editable" <?php } ?>>
                                                    <?php echo $data['tNested']; ?> 
                                                </span>
                                            </td>
                                            <td class="td-tFinished_Parts">
                                                <span <?php if($can_edit){ ?> data-value="<?php echo $data['tFinished_Parts']; ?>" 
                                                    data-pk="<?php echo $data['JobNum'] ?>" 
                                                    data-url="<?php print_link("jlv2_jl_7_production_status/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                    data-name="tFinished_Parts" 
                                                    data-title="Enter Tfinished Parts" 
                                                    data-placement="left" 
                                                    data-toggle="click" 
                                                    data-type="number" 
                                                    data-mode="popover" 
                                                    data-showbuttons="left" 
                                                    class="is-editable" <?php } ?>>
                                                    <?php echo $data['tFinished_Parts']; ?> 
                                                </span>
                                            </td>
                                            <td class="td-tWrapped">
                                                <span <?php if($can_edit){ ?> data-value="<?php echo $data['tWrapped']; ?>" 
                                                    data-pk="<?php echo $data['JobNum'] ?>" 
                                                    data-url="<?php print_link("jlv2_jl_7_production_status/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                    data-name="tWrapped" 
                                                    data-title="Enter Twrapped" 
                                                    data-placement="left" 
                                                    data-toggle="click" 
                                                    data-type="number" 
                                                    data-mode="popover" 
                                                    data-showbuttons="left" 
                                                    class="is-editable" <?php } ?>>
                                                    <?php echo $data['tWrapped']; ?> 
                                                </span>
                                            </td>
                                            <td class="td-tFinishing">
                                                <span <?php if($can_edit){ ?> data-value="<?php echo $data['tFinishing']; ?>" 
                                                    data-pk="<?php echo $data['JobNum'] ?>" 
                                                    data-url="<?php print_link("jlv2_jl_7_production_status/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                    data-name="tFinishing" 
                                                    data-title="Enter Tfinishing" 
                                                    data-placement="left" 
                                                    data-toggle="click" 
                                                    data-type="number" 
                                                    data-mode="popover" 
                                                    data-showbuttons="left" 
                                                    class="is-editable" <?php } ?>>
                                                    <?php echo $data['tFinishing']; ?> 
                                                </span>
                                            </td>
                                            <td class="td-tUnfinished_Parts">
                                                <span <?php if($can_edit){ ?> data-value="<?php echo $data['tUnfinished_Parts']; ?>" 
                                                    data-pk="<?php echo $data['JobNum'] ?>" 
                                                    data-url="<?php print_link("jlv2_jl_7_production_status/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                    data-name="tUnfinished_Parts" 
                                                    data-title="Enter Tunfinished Parts" 
                                                    data-placement="left" 
                                                    data-toggle="click" 
                                                    data-type="number" 
                                                    data-mode="popover" 
                                                    data-showbuttons="left" 
                                                    class="is-editable" <?php } ?>>
                                                    <?php echo $data['tUnfinished_Parts']; ?> 
                                                </span>
                                            </td>
                                            <td class="td-tAssembled">
                                                <span <?php if($can_edit){ ?> data-value="<?php echo $data['tAssembled']; ?>" 
                                                    data-pk="<?php echo $data['JobNum'] ?>" 
                                                    data-url="<?php print_link("jlv2_jl_7_production_status/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                    data-name="tAssembled" 
                                                    data-title="Enter Tassembled" 
                                                    data-placement="left" 
                                                    data-toggle="click" 
                                                    data-type="number" 
                                                    data-mode="popover" 
                                                    data-showbuttons="left" 
                                                    class="is-editable" <?php } ?>>
                                                    <?php echo $data['tAssembled']; ?> 
                                                </span>
                                            </td>
                                            <td class="td-sOrdered"> <?php echo $data['sOrdered']; ?></td>
                                            <td class="td-sNested"> <?php echo $data['sNested']; ?></td>
                                            <td class="td-sFinished_Parts"> <?php echo $data['sFinished_Parts']; ?></td>
                                            <td class="td-sWrapped"> <?php echo $data['sWrapped']; ?></td>
                                            <td class="td-sFinishing"> <?php echo $data['sFinishing']; ?></td>
                                            <td class="td-sUnfinished_Parts"> <?php echo $data['sUnfinished_Parts']; ?></td>
                                            <td class="td-sAssembled"> <?php echo $data['sAssembled']; ?></td>
                                            <td class="td-Job_Number_Prefix"> <?php echo $data['Job_Number_Prefix']; ?></td>
                                            <td class="td-SQ_FT_Parts"> <?php echo $data['SQ_FT_Parts']; ?></td>
                                            <td class="td-SQ_FT_Doors"> <?php echo $data['SQ_FT_Doors']; ?></td>
                                            <td class="td-CNC_MDF"> <?php echo $data['CNC_MDF']; ?></td>
                                            <td class="td-CNC_FIN"> <?php echo $data['CNC_FIN']; ?></td>
                                            <td class="td-CNC_UNFIN"> <?php echo $data['CNC_UNFIN']; ?></td>
                                        </tr>
                                        <?php 
                                        }
                                        ?>
                                        <!--endrecord-->
                                    </tbody>
                                    <tbody class="search-data" id="search-data-<?php echo $page_element_id; ?>"></tbody>
                                    <?php
                                    }
                                    ?>
                                </table>
                                <?php 
                                if(empty($records)){
                                ?>
                                <h4 class="bg-light text-center border-top text-muted animated bounce  p-3">
                                    <i class="icon dripicons-wrong"></i> No record found
                                </h4>
                                <?php
                                }
                                ?>
                            </div>
                            <?php
                            if( $show_footer && !empty($records)){
                            ?>
                            <div class=" border-top mt-2">
                                <div class="row justify-content-center">    
                                    <div class="col-md-auto justify-content-center">    
                                        <div class="p-3 d-flex justify-content-between">    
                                        </div>
                                    </div>
                                    <div class="col">   
                                        <?php
                                        if($show_pagination == true){
                                        $pager = new Pagination($total_records, $record_count);
                                        $pager->route = $this->route;
                                        $pager->show_page_count = true;
                                        $pager->show_record_count = true;
                                        $pager->show_page_limit =true;
                                        $pager->limit_count = $this->limit_count;
                                        $pager->show_page_number_list = true;
                                        $pager->pager_link_range=5;
                                        $pager->render();
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div  class="">
        <div class="container">
            <div class="row ">
                <div class="col-md-12 comp-grid">
                </div>
            </div>
        </div>
    </div>
</section>
