<?php 
//check if current user role is allowed access to the pages
$can_add = ACL::is_allowed("job/add");
$can_edit = ACL::is_allowed("job/edit");
$can_view = ACL::is_allowed("job/view");
$can_delete = ACL::is_allowed("job/delete");
?>
<?php
$comp_model = new SharedController;
$page_element_id = "list-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data From Controller
$view_data = $this->view_data;
$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = $this->route->field_name;
$field_value = $this->route->field_value;
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;
?>
<section class="page ajax-page" id="<?php echo $page_element_id; ?>" data-page-type="list"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">Job</h4>
                </div>
                <div class="col-sm-3 ">
                    <?php if($can_add){ ?>
                    <a  class="btn btn btn-primary my-1" href="<?php print_link("job/add") ?>">
                        <i class="icon dripicons-plus"></i>                             
                        Add New Job 
                    </a>
                    <?php } ?>
                </div>
                <div class="col-sm-4 ">
                    <form  class="search" action="<?php print_link('job/'); ?>" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="icon dripicons-search"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <!-- Page bread crumbs components-->
                            <?php
                            if(!empty($field_name) || !empty($_GET['search'])){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('job'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <?php echo (get_value("tag") ? get_value("tag")  :  make_readable($field_name)); ?>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold">
                                        <?php echo (get_value("label") ? get_value("label")  :  make_readable(urldecode($field_value))); ?>
                                    </li>
                                    <?php 
                                    }   
                                    ?>
                                    <?php
                                    if(get_value("search")){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('job'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item text-capitalize">
                                        Search
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold"><?php echo get_value("search"); ?></li>
                                    <?php
                                    }
                                    ?>
                                </ul>
                            </nav>
                            <!--End of Page bread crumbs components-->
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        }
        ?>
        <div  class="">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-md-12 comp-grid">
                        <?php $this :: display_page_errors(); ?>
                        <div  class=" animated fadeIn page-content">
                            <div id="job-blist-records">
                                <div id="page-report-body" class="table-responsive">
                                    <?php Html::ajaxpage_spinner(); ?>
                                    <table class="table  table-striped table-sm text-left">
                                        <thead class="table-header bg-light">
                                            <tr>
                                                <th class="td-btn"></th>
                                                <th  class="td-Full_Job_Number"> Full Job Number</th>
                                                <th  class="td-Job_Type"> Job Type</th>
                                                <th  class="td-Job_Number_Prefix"> Job Number Prefix</th>
                                                <th  class="td-Job_Number"> Job Number</th>
                                                <th  class="td-Production_Received"> Production Received</th>
                                                <th  class="td-Dealer"> Dealer</th>
                                                <th  class="td-Customer_PO"> Customer Po</th>
                                                <th  class="td-Tag_Name"> Tag Name</th>
                                                <th  class="td-Order_Entry"> Order Entry</th>
                                                <th  class="td-Received_Order"> Received Order</th>
                                                <th  class="td-Requested_Date"> Requested Date</th>
                                                <th  class="td-Sent_To_OE"> Sent To Oe</th>
                                                <th  class="td-Sent_For_Confirmation"> Sent For Confirmation</th>
                                                <th  class="td-Confirmation_Received"> Confirmation Received</th>
                                                <th  class="td-Confirmed"> Confirmed</th>
                                                <th  class="td-Sent_To_Plant"> Sent To Plant</th>
                                                <th  class="td-Invoiced"> Invoiced</th>
                                                <th  class="td-Value"> Value</th>
                                                <th  class="td-Uppers"> Uppers</th>
                                                <th  class="td-Talls"> Talls</th>
                                                <th  class="td-Bases"> Bases</th>
                                                <th  class="td-Vanities"> Vanities</th>
                                                <th  class="td-Accessories"> Accessories</th>
                                                <th  class="td-Door_Style"> Door Style</th>
                                                <th  class="td-Wood"> Wood</th>
                                                <th  class="td-Colour"> Colour</th>
                                                <th  class="td-Comments"> Comments</th>
                                                <th  class="td-Original_Job_Number"> Original Job Number</th>
                                                <th  class="td-Door_Vendor"> Door Vendor</th>
                                                <th  class="td-Door_ETA"> Door Eta</th>
                                                <th  class="td-Other_ETA"> Other Eta</th>
                                                <th  class="td-Standard_Lead_Time"> Standard Lead Time</th>
                                                <th  class="td-Date_Shipped"> Date Shipped</th>
                                                <th  class="td-Back_Orders"> Back Orders</th>
                                                <th  class="td-Back_Orders_Shipped"> Back Orders Shipped</th>
                                                <th  class="td-Proposed_Shipping_Date"> Proposed Shipping Date</th>
                                                <th  class="td-Shipping_Comments"> Shipping Comments</th>
                                                <th  class="td-Shipping_Details"> Shipping Details</th>
                                                <th  class="td-Dealer_Route"> Dealer Route</th>
                                                <th  class="td-Sales_Rep"> Sales Rep</th>
                                                <th  class="td-Creator"> Creator</th>
                                                <th  class="td-Updated_By"> Updated By</th>
                                                <th  class="td-Created_TS"> Created Ts</th>
                                                <th  class="td-Last_Updated_TS"> Last Updated Ts</th>
                                                <th  class="td-Status"> Status</th>
                                            </tr>
                                        </thead>
                                        <?php
                                        if(!empty($records)){
                                        ?>
                                        <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                            <!--record-->
                                            <?php
                                            $counter = 0;
                                            foreach($records as $data){
                                            $rec_id = (!empty($data['Job_Number']) ? urlencode($data['Job_Number']) : null);
                                            $counter++;
                                            ?>
                                            <tr>
                                                <th class="td-btn">
                                                    <?php if($can_view){ ?>
                                                    <a class="btn btn-sm btn-success has-tooltip" title="View Record" href="<?php print_link("job/view/$rec_id"); ?>">
                                                        <i class="icon dripicons-preview"></i> View
                                                    </a>
                                                    <?php } ?>
                                                    <?php if($can_edit){ ?>
                                                    <a class="btn btn-sm btn-info has-tooltip" title="Edit This Record" href="<?php print_link("job/edit/$rec_id"); ?>">
                                                        <i class="icon dripicons-document-edit"></i> Edit
                                                    </a>
                                                    <?php } ?>
                                                </th>
                                                <td class="td-Full_Job_Number"> <?php echo $data['Full_Job_Number']; ?></td>
                                                <td class="td-Job_Type"> <?php echo $data['Job_Type']; ?></td>
                                                <td class="td-Job_Number_Prefix"> <?php echo $data['Job_Number_Prefix']; ?></td>
                                                <td class="td-Job_Number">
                                                    <?php
                                                    $page_fields = array('fk_JobNum' => $data['Job_Number']);
                                                    $page_link = "masterdetail/index/job/jlv2_jl_6_job_conversation/fk_JobNum/" . urlencode($data['Job_Number']);
                                                    $md_pagelink = set_page_link($page_link, $page_fields); 
                                                    ?>
                                                    <a size="sm" class="btn btn-sm btn-primary page-modal" href="<?php print_link($md_pagelink) ?>">
                                                        <i class="icon dripicons-preview"></i> <?php echo $data['jlv2_jl_6_job_conversation_fk_JobNum'] ?>
                                                    </a>
                                                </td>
                                                <td class="td-Production_Received"> <?php echo $data['Production_Received']; ?></td>
                                                <td class="td-Dealer"> <?php echo $data['Dealer']; ?></td>
                                                <td class="td-Customer_PO"> <?php echo $data['Customer_PO']; ?></td>
                                                <td class="td-Tag_Name"> <?php echo $data['Tag_Name']; ?></td>
                                                <td class="td-Order_Entry"> <?php echo $data['Order_Entry']; ?></td>
                                                <td class="td-Received_Order"> <?php echo $data['Received_Order']; ?></td>
                                                <td class="td-Requested_Date"> <?php echo $data['Requested_Date']; ?></td>
                                                <td class="td-Sent_To_OE"> <?php echo $data['Sent_To_OE']; ?></td>
                                                <td class="td-Sent_For_Confirmation"> <?php echo $data['Sent_For_Confirmation']; ?></td>
                                                <td class="td-Confirmation_Received"> <?php echo $data['Confirmation_Received']; ?></td>
                                                <td class="td-Confirmed"> <?php echo $data['Confirmed']; ?></td>
                                                <td class="td-Sent_To_Plant"> <?php echo $data['Sent_To_Plant']; ?></td>
                                                <td class="td-Invoiced"> <?php echo $data['Invoiced']; ?></td>
                                                <td class="td-Value"> <?php echo $data['Value']; ?></td>
                                                <td class="td-Uppers"> <?php echo $data['Uppers']; ?></td>
                                                <td class="td-Talls"> <?php echo $data['Talls']; ?></td>
                                                <td class="td-Bases"> <?php echo $data['Bases']; ?></td>
                                                <td class="td-Vanities"> <?php echo $data['Vanities']; ?></td>
                                                <td class="td-Accessories"> <?php echo $data['Accessories']; ?></td>
                                                <td class="td-Door_Style"> <?php echo $data['Door_Style']; ?></td>
                                                <td class="td-Wood"> <?php echo $data['Wood']; ?></td>
                                                <td class="td-Colour"> <?php echo $data['Colour']; ?></td>
                                                <td class="td-Comments"> <?php echo $data['Comments']; ?></td>
                                                <td class="td-Original_Job_Number"> <?php echo $data['Original_Job_Number']; ?></td>
                                                <td class="td-Door_Vendor"> <?php echo $data['Door_Vendor']; ?></td>
                                                <td class="td-Door_ETA"> <?php echo $data['Door_ETA']; ?></td>
                                                <td class="td-Other_ETA"> <?php echo $data['Other_ETA']; ?></td>
                                                <td class="td-Standard_Lead_Time"> <?php echo $data['Standard_Lead_Time']; ?></td>
                                                <td class="td-Date_Shipped"> <?php echo $data['Date_Shipped']; ?></td>
                                                <td class="td-Back_Orders"> <?php echo $data['Back_Orders']; ?></td>
                                                <td class="td-Back_Orders_Shipped"> <?php echo $data['Back_Orders_Shipped']; ?></td>
                                                <td class="td-Proposed_Shipping_Date"> <?php echo $data['Proposed_Shipping_Date']; ?></td>
                                                <td class="td-Shipping_Comments"> <?php echo $data['Shipping_Comments']; ?></td>
                                                <td class="td-Shipping_Details"> <?php echo $data['Shipping_Details']; ?></td>
                                                <td class="td-Dealer_Route"> <?php echo $data['Dealer_Route']; ?></td>
                                                <td class="td-Sales_Rep"> <?php echo $data['Sales_Rep']; ?></td>
                                                <td class="td-Creator"> <?php echo $data['Creator']; ?></td>
                                                <td class="td-Updated_By"> <?php echo $data['Updated_By']; ?></td>
                                                <td class="td-Created_TS"> <?php echo $data['Created_TS']; ?></td>
                                                <td class="td-Last_Updated_TS"> <?php echo $data['Last_Updated_TS']; ?></td>
                                                <td class="td-Status"> <?php echo $data['Status']; ?></td>
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            <!--endrecord-->
                                        </tbody>
                                        <tbody class="search-data" id="search-data-<?php echo $page_element_id; ?>"></tbody>
                                        <?php
                                        }
                                        ?>
                                    </table>
                                    <?php 
                                    if(empty($records)){
                                    ?>
                                    <h4 class="bg-light text-center border-top text-muted animated bounce  p-3">
                                        <i class="icon dripicons-wrong"></i> No record found
                                    </h4>
                                    <?php
                                    }
                                    ?>
                                </div>
                                <?php
                                if( $show_footer && !empty($records)){
                                ?>
                                <div class=" border-top mt-2">
                                    <div class="row justify-content-center">    
                                        <div class="col-md-auto justify-content-center">    
                                            <div class="p-3 d-flex justify-content-between">    
                                            </div>
                                        </div>
                                        <div class="col">   
                                            <?php
                                            if($show_pagination == true){
                                            $pager = new Pagination($total_records, $record_count);
                                            $pager->route = $this->route;
                                            $pager->show_page_count = true;
                                            $pager->show_record_count = true;
                                            $pager->show_page_limit =true;
                                            $pager->limit_count = $this->limit_count;
                                            $pager->show_page_number_list = true;
                                            $pager->pager_link_range=5;
                                            $pager->ajax_page = true;
                                            $pager->render();
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
