<?php
/**
 * Page Access Control
 * @category  RBAC Helper
 */
defined('ROOT') or exit('No direct script access allowed');
class ACL
{
	

	/**
	 * Array of user roles and page access 
	 * Use "*" to grant all access right to particular user role
	 * @var array
	 */
	public static $role_pages = array(
			'administrator' =>
						array(
							'backorder' => array('list','view','add','edit', 'editfield','delete','import_data','add_from','add_1','l_follow_up'),
							'jlv2_aa_0_oc_user_roles' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_aa_0_oc_users' => array('list','view','add','edit', 'editfield','delete','import_data','accountedit','accountview'),
							'jlv2_jl_1_dd_colour' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_dealer' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_door_style' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_door_vendor' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_glaze_custom' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_job_number_prefix' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_job_type' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_order_entry' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_paint_stain' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_production_status' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_sales_rep' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_wood' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_5_joblist' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_5_joblist_pre2020' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_6_job_conversation' => array('list','view','add','edit', 'editfield','delete','import_data','list_perjob'),
							'jlv2_jl_6_job_history' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_6_joblist_historyold' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_7_production_status' => array('list','view','add','edit', 'editfield','delete','import_data','production_station_list'),
							'jlv2_pl_1_dd_conv_status' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'job' => array('list','view','add','edit', 'editfield','delete','import_data','view_details','quick_add_job','production_edit','quick_add_2','view_details_1_1','view_ish','joblist','blist'),
							'xx_jlv2_jl_6_job_history_template' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'xx_job_list_prototype_xx' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'defaults' => array('list','view','add','edit', 'editfield','delete'),
							'maintenance_checklist' => array('list','view','add','edit', 'editfield','delete'),
							'maintenance_checklist_items' => array('list','view','add','edit', 'editfield','delete'),
							'oc_filecache' => array('list','view','add','edit', 'editfield','delete','nclist','nclistbkp'),
							'oc_deck_assigned_labels' => array('list','view','add','edit', 'editfield','delete'),
							'oc_deck_assigned_users' => array('list','view','add','edit', 'editfield','delete'),
							'oc_deck_cards' => array('list','view','add','edit', 'editfield','delete')
						),
		
			'user' =>
						array(
							'backorder' => array('list','view','add','edit', 'editfield','add_from','add_1','l_follow_up'),
							'jlv2_aa_0_oc_users' => array('accountedit','accountview'),
							'jlv2_jl_5_joblist_pre2020' => array('list','view'),
							'jlv2_jl_6_job_conversation' => array('list','view','add','list_perjob'),
							'jlv2_jl_7_production_status' => array('production_station_list'),
							'job' => array('list','view','add','view_details','quick_add_job','production_edit','quick_add_2','view_details_1_1','view_ish','joblist','blist'),
							'oc_filecache' => array('nclist','nclistbkp')
						),
		
			'production' =>
						array(
							'backorder' => array('add_1','l_follow_up'),
							'jlv2_jl_7_production_status' => array('production_station_list'),
							'job' => array('view_details_1_1','view_ish','joblist','blist'),
							'oc_filecache' => array('nclist','nclistbkp')
						),
		
			'production_manager' =>
						array(
							'backorder' => array('list','view','add','edit', 'editfield','delete','add_from','add_1','import_data','l_follow_up'),
							'jlv2_aa_0_oc_user_roles' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_aa_0_oc_users' => array('list','view','accountedit','accountview','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_colour' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_dealer' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_door_style' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_door_vendor' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_glaze_custom' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_job_number_prefix' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_job_type' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_order_entry' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_paint_stain' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_production_status' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_sales_rep' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_wood' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_5_joblist' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_5_joblist_pre2020' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_6_job_conversation' => array('list','view','add','edit', 'editfield','delete','list_perjob','import_data'),
							'jlv2_jl_6_job_history' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_6_joblist_historyold' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_7_production_status' => array('list','view','add','edit', 'editfield','delete','production_station_list','import_data'),
							'jlv2_pl_1_dd_conv_status' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'job' => array('list','view','add','edit', 'editfield','delete','quick_add_job','production_edit','quick_add_2','view_details','view_details_1_1','view_ish','import_data','joblist','blist'),
							'xx_jlv2_jl_6_job_history_template' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'xx_job_list_prototype_xx' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'defaults' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'maintenance_checklist' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'maintenance_checklist_items' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'oc_filecache' => array('list','view','add','edit', 'editfield','delete','nclist','import_data','nclistbkp')
						),
		
			'sales' =>
						array(
							'job' => array('joblist','blist')
						),
		
			'sales_manager' =>
						array(
							'backorder' => array('list','view','add','edit', 'editfield','delete','add_from','add_1','l_follow_up','import_data'),
							'jlv2_aa_0_oc_user_roles' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_aa_0_oc_users' => array('list','view','accountedit','accountview','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_colour' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_dealer' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_door_style' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_door_vendor' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_glaze_custom' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_job_number_prefix' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_job_type' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_order_entry' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_paint_stain' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_production_status' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_sales_rep' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_1_dd_wood' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_5_joblist' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_5_joblist_pre2020' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_6_job_conversation' => array('list','view','add','edit', 'editfield','delete','list_perjob','import_data'),
							'jlv2_jl_6_job_history' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_6_joblist_historyold' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'jlv2_jl_7_production_status' => array('list','view','add','edit', 'editfield','delete','production_station_list','import_data'),
							'jlv2_pl_1_dd_conv_status' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'job' => array('list','view','add','edit', 'editfield','delete','quick_add_job','production_edit','quick_add_2','view_details','view_details_1_1','view_ish','import_data','joblist','blist'),
							'xx_jlv2_jl_6_job_history_template' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'xx_job_list_prototype_xx' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'defaults' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'maintenance_checklist' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'maintenance_checklist_items' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'oc_filecache' => array('list','view','add','edit', 'editfield','delete','nclist','nclistbkp','import_data'),
							'oc_deck_assigned_labels' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'oc_deck_assigned_users' => array('list','view','add','edit', 'editfield','delete','import_data'),
							'oc_deck_cards' => array('list','view','add','edit', 'editfield','delete','import_data')
						)
		);

	/**
	 * Current user role name
	 * @var string
	 */
	public static $user_role = null;

	/**
	 * pages to Exclude From Access Validation Check
	 * @var array
	 */
	public static $exclude_page_check = array("", "index", "home", "account", "info", "masterdetail");

	/**
	 * Init page properties
	 */
	public function __construct()
	{	
		if(!empty(USER_ROLE)){
			self::$user_role = USER_ROLE;
		}
	}

	/**
	 * Check page path against user role permissions
	 * if user has access return AUTHORIZED
	 * if user has NO access return UNAUTHORIZED
	 * if user has NO role return NO_ROLE
	 * @return string
	 */
	public static function GetPageAccess($path)
	{
		$rp = self::$role_pages;
		if ($rp == "*") {
			return AUTHORIZED; // Grant access to any user
		} else {
			$path = strtolower(trim($path, '/'));

			$arr_path = explode("/", $path);
			$page = strtolower($arr_path[0]);

			//If user is accessing excluded access contrl pages
			if (in_array($page, self::$exclude_page_check)) {
				return AUTHORIZED;
			}

			$user_role = strtolower(USER_ROLE); // Get user defined role from session value
			if (array_key_exists($user_role, $rp)) {
				$action = (!empty($arr_path[1]) ? $arr_path[1] : "list");
				if ($action == "index") {
					$action = "list";
				}
				//Check if user have access to all pages or user have access to all page actions
				if ($rp[$user_role] == "*" || (!empty($rp[$user_role][$page]) && $rp[$user_role][$page] == "*")) {
					return AUTHORIZED;
				} else {
					if (!empty($rp[$user_role][$page]) && in_array($action, $rp[$user_role][$page])) {
						return AUTHORIZED;
					}
				}
				return FORBIDDEN;
			} else {
				//User does not have any role.
				return NOROLE;
			}
		}
	}

	/**
	 * Check if user role has access to a page
	 * @return Bool
	 */
	public static function is_allowed($path)
	{
		return (self::GetPageAccess($path) == AUTHORIZED);
	}

}
