<?php 
/**
 * Jl_0_Oc_User_Roles Page Controller
 * @category  Controller
 */
class Jl_0_Oc_User_RolesController extends SecureController{
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function index($fieldname = null , $fieldvalue = null){
		$db = $this->GetModel();
		$fields = array('pk_role_id', 	'list', 	'changed_by', 	'updated');
		$limit = $this->get_page_limit(50); // return pagination from BaseModel Class e.g array(5,20)
		if(!empty($this->search)){
			$text = $this->search;
			$db->orWhere('pk_role_id',"%$text%",'LIKE');
			$db->orWhere('list',"%$text%",'LIKE');
			$db->orWhere('changed_by',"%$text%",'LIKE');
			$db->orWhere('updated',"%$text%",'LIKE');
		}
		if(!empty($this->orderby)){ // when order by request fields (from $_GET param)
			$db->orderBy($this->orderby,$this->ordertype);
		}
		else{
			$db->orderBy('pk_role_id', ORDER_TYPE);
		}
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get('jl_0_oc_user_roles', $limit, $fields);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		if($db->getLastError()){
			$this->view->page_error = $db->getLastError();
		}
		$this->view->page_title ="Jl 0 Oc User Roles";
		$this->view->render('jl_0_oc_user_roles/list.php' , $data ,'main_layout.php');
	}
	/**
     * View Record Action 
     * @return View
     */
	function view( $rec_id = null , $value = null){
		$db = $this->GetModel();
		$fields = array( 'pk_role_id', 	'list', 	'changed_by', 	'updated' );
		if( !empty($value) ){
			$db->where($rec_id, urldecode($value));
		}
		else{
			$db->where('pk_role_id' , $rec_id);
		}
		$record = $db->getOne( 'jl_0_oc_user_roles', $fields );
		if(!empty($record)){
			$this->view->page_title ="View  Jl 0 Oc User Roles";
			$this->view->render('jl_0_oc_user_roles/view.php' , $record ,'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error = $db->getLastError();
			}
			else{
				$this->view->page_error = "Record not found";
			}
			$this->view->render('jl_0_oc_user_roles/view.php' , $record , 'main_layout.php');
		}
	}
	/**
     * Add New Record Action 
     * If Not $_POST Request, Display Add Record Form View
     * @return View
     */
	function add(){
		if(is_post_request()){
			$modeldata = transform_request_data($_POST);
			$rules_array = array(
				'list' => 'required',
				'changed_by' => 'required',
			);
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}
			if( empty($this->view->page_error) ){
				$db = $this->GetModel();
				$rec_id = $db->insert( 'jl_0_oc_user_roles' , $modeldata );
				if(!empty($rec_id)){
					set_flash_msg('','');
					redirect_to_page("jl_0_oc_user_roles");
					return;
				}
				else{
					if($db->getLastError()){
						$this->view->page_error[] = $db->getLastError();
					}
					else{
						$this->view->page_error[] = "Error inserting record";
					}
				}
			}
		}
		$this->view->page_title ="Add New Jl 0 Oc User Roles";
		$this->view->render('jl_0_oc_user_roles/add.php' ,null,'main_layout.php');
	}
	/**
     * Edit Record Action 
     * If Not $_POST Request, Display Edit Record Form View
     * @return View
     */
	function edit($rec_id=null){
		$db = $this->GetModel();
		if(is_post_request()){
			$modeldata = transform_request_data($_POST);
			$rules_array = array(
				'list' => 'required',
				'changed_by' => 'required',
			);
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}
			if(empty($this->view->page_error)){
				$db->where('pk_role_id' , $rec_id);
				$bool = $db->update('jl_0_oc_user_roles',$modeldata);
				if($bool){
					set_flash_msg('','');
					redirect_to_page("jl_0_oc_user_roles");
					return;
				}
				else{
					$this->view->page_error[] = $db->getLastError();
				}
			}
		}
		$fields = array('pk_role_id','list','changed_by');
		$db->where('pk_role_id' , $rec_id);
		$data = $db->getOne('jl_0_oc_user_roles',$fields);
		$this->view->page_title ="Edit  Jl 0 Oc User Roles";
		if(!empty($data)){
			$this->view->render('jl_0_oc_user_roles/edit.php' , $data, 'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error[] = $db->getLastError();
			}
			else{
				$this->view->page_error[] = "Record not found";
			}
			$this->view->render('jl_0_oc_user_roles/edit.php' , $data , 'main_layout.php');
		}
	}
	/**
     * Delete Record Action 
     * @return View
     */
	function delete( $rec_ids = null ){
		$db = $this->GetModel();
		$arr_id = explode( ',', $rec_ids );
		foreach( $arr_id as $rec_id ){
			$db->where('pk_role_id' , $rec_id,"=",'OR');
		}
		$bool = $db->delete( 'jl_0_oc_user_roles' );
		if($bool){
			set_flash_msg("Data Deleted",'success');
		}
		else{
			if($db->getLastError()){
				set_flash_msg($db->getLastError(),'danger');
			}
			else{
				set_flash_msg("Error deleting the record. please make sure that the record exit",'danger');
			}
		}
		redirect_to_page("jl_0_oc_user_roles");
	}
}
