
<?php 
$can_add = PageAccessManager::is_allowed('ql_5_quotelist/add');
$can_edit = PageAccessManager::is_allowed('ql_5_quotelist/edit');
$can_view = PageAccessManager::is_allowed('ql_5_quotelist/view');
$can_delete = PageAccessManager::is_allowed('ql_5_quotelist/delete');
?>

<?php
$comp_model = new SharedController;

//Page Data From Controller
$view_data = $this->view_data;

$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = Router :: $field_name;
$field_value = Router :: $field_value;

$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;

?>

<section class="page">
    
    <?php
    if( $show_header == true ){
    ?>
    
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            
            <div class="row ">
                
                <div class="col-sm-4 comp-grid">
                    <h3 class="record-title">Quote List</h3>
                    
                </div>
                
                <div class="col-sm-3 comp-grid">
                    
                    <?php 
                    if($can_add){
                    ?>
                    
                    <a  class="btn btn btn-primary btn-block" href="<?php print_link("ql_5_quotelist/add") ?>">
                        <i class="material-icons">add</i>                               
                        Add New Quote 
                    </a>
                    
                    <?php 
                    }
                    ?>
                    
                </div>
                
                <div class="col-sm-5 comp-grid">
                    
                    <form  class="search" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_query_str_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="material-icons">search</i></button>
                                </div>
                            </div>
                        </form>
                        
                    </div>
                    
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <?php
                            if(!empty($field_name) || !empty($field_name)){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item"><a class="text-capitalize" href="<?php print_link('ql_5_quotelist') ?>"><?php echo $field_name ?></a></li>
                                    <li  class="breadcrumb-item active text-capitalize"><?php echo urldecode($field_value) ?></li>
                                    <?php 
                                    }   
                                    ?>
                                    <?php
                                    if(!empty($_GET['search'])){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-capitalize" href="<?php print_link('ql_5_quotelist') ?>">Search</a>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize"> <strong><?php echo get_value('search'); ?></strong></li>
                                    <?php
                                    }
                                    ?>
                                    
                                </ul>
                            </nav>  
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
        
        <?php
        }
        ?>
        
        <div  class="">
            <div class="container-fluid">
                
                <div class="row ">
                    
                    <div class="col-md-12 comp-grid">
                        
                        <?php $this :: display_page_errors(); ?>
                        
                        <div  class="card animated fadeIn">
                            <div id="ql_5_quotelist-list-records">
                                
                                <?php
                                if(!empty($records)){
                                ?>
                                <div class="page-records table-responsive">
                                    <table class="table table-hover table-striped table-sm">
                                        <thead class="table-header bg-light">
                                            <tr>
                                                
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='Status' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('Status', "Status"); ?>
                                                </th>
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='Comments' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('Comments', "Comments"); ?>
                                                </th>
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='followupdate' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('followupdate', "Followupdate"); ?>
                                                </th>
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='QuoteNum' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('QuoteNum', "Quote #"); ?>
                                                </th>
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='Dealer' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('Dealer', "Dealer"); ?>
                                                </th>
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='TagName' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('TagName', "Tagname"); ?>
                                                </th>
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='SalesRep' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('SalesRep', "Rep"); ?>
                                                </th>
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='RecdRFQ' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('RecdRFQ', "Rec'd"); ?>
                                                </th>
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='Value' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('Value', "Value"); ?>
                                                </th>
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='jobnumber' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('jobnumber', "JobNum"); ?>
                                                </th>
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='changed_by' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('changed_by', "Changed By"); ?>
                                                </th>
                                                
                                                
                                                <th class="td-btn"></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            
                                            <?php
                                            
                                            foreach($records as $data){
                                            
                                            ?>
                                            <tr>
                                                
                                                
                                                <td> <?php echo $data['Status']; ?> </td>
                                                <td><span title="<?php echo htmlentities($data['Comments']); ?>"><?php echo htmlentities(mb_strimwidth($data['Comments'], 0, 17, "...")); ?></span></td>
                                                <td> <?php echo $data['followupdate']; ?> </td>
                                                <td><a href="<?php print_link("ql_5_quotelist/view/$data[QuoteNum]") ?>"><?php echo $data['QuoteNum']; ?></a></td>
                                                <td> <?php echo $data['Dealer']; ?> </td>
                                                <td> <?php echo $data['TagName']; ?> </td>
                                                <td> <?php echo $data['SalesRep']; ?> </td>
                                                <td> <?php echo $data['RecdRFQ']; ?> </td>
                                                <td> <?php echo $data['Value']; ?> </td>
                                                <td> <?php echo $data['jobnumber']; ?> </td>
                                                <td> <?php echo $data['changed_by']; ?> </td>
                                                
                                                
                                                <th class="td-btn">
                                                    
                                                    
                                                    <?php 
                                                    if($can_view){
                                                    ?>
                                                    
                                                    <a class="btn btn-sm btn-success has-tooltip page-modal" title="View Record" href="<?php print_link("ql_5_quotelist/view/$data[QuoteNum]"); ?>">
                                                        <i class="material-icons">visibility</i> 
                                                    </a>
                                                    
                                                    <?php 
                                                    }
                                                    ?>
                                                    
                                                    
                                                    <?php 
                                                    if($can_edit){
                                                    ?>
                                                    
                                                    <a class="btn btn-sm btn-info has-tooltip" title="Edit This Record" href="<?php print_link('ql_5_quotelist/edit/'.$data['QuoteNum']); ?>">
                                                        <i class="material-icons">edit</i> 
                                                    </a>
                                                    
                                                    <?php 
                                                    }
                                                    ?>
                                                    
                                                    
                                                    
                                                </th>
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            
                                        </tbody>
                                    </table>
                                </div>
                                <?php
                                if( $show_footer == true ){
                                ?>
                                <div class="card-footer">
                                    <div class="row">   
                                        <div class="col-sm-3">  
                                            
                                            <button data-prompt-msg="Are you sure you want to delete these records" data-url="<?php print_link("ql_5_quotelist/delete/{sel_ids}"); ?>" class="btn btn-sm btn-danger btn-delete-selected d-none">
                                                <i class="material-icons">clear</i> Delete Selected
                                            </button>
                                            
                                            
                                            <button class="btn btn-sm btn-primary export-btn"><i class="material-icons">save</i> </button>
                                            
                                            
                                        </div>
                                        <div class="col">   
                                            
                                            <?php
                                            if( $show_pagination == true ){
                                            $pager = new Pagination($total_records,$record_count);
                                            $pager->page_name='ql_5_quotelist';
                                            $pager->show_page_count=true;
                                            $pager->show_record_count=true;
                                            $pager->show_page_limit=true;
                                            $pager->show_page_number_list=true;
                                            $pager->pager_link_range=5;
                                            
                                            $pager->render();
                                            }
                                            ?>
                                            
                                        </div>
                                    </div>
                                </div>
                                <?php
                                }
                                }
                                else{
                                ?>
                                <div class="text-muted animated bounce">
                                    <h4><i class="material-icons">block</i> No Records Found</h4>
                                </div>
                                <?php
                                }
                                ?>
                                
                            </div>
                        </div>
                        
                    </div>
                    
                </div>
            </div>
        </div>
        
    </section>
    