<?php
	/**
	 * Role Based Access Control
	 * @category  RBAC Helper
	 */
	defined('ROOT') OR exit('No direct script access allowed');
	class PageAccessManager{
		/**
	     * Array Of User Roles And Page Access 
	     * Use "*" to Grant All Access Right to Particular User Role
	     * @return Html View
	     */
		public static $usersRolePermissions=array(
			'administrator' =>
						array(
							'jl_0_oc_users' => array('list','view','add','edit','delete','import_data'),
							'jl_1_dd_colours' => array('list','view','add','edit','delete','import_data'),
							'jl_1_dd_dealers' => array('list','view','add','edit','delete','import_data'),
							'jl_1_dd_doorstyles' => array('list','view','add','edit','delete','import_data'),
							'jl_1_dd_doorvendor' => array('list','view','add','edit','delete','import_data'),
							'jl_1_dd_jobnumprefix' => array('list','view','add','edit','delete','import_data'),
							'jl_1_dd_orderentry' => array('list','view','add','edit','delete','import_data'),
							'jl_1_dd_rso' => array('list','view','add','edit','delete','import_data'),
							'jl_1_dd_salesrep' => array('list','view','add','edit','delete','import_data'),
							'jl_1_dd_woods' => array('list','view','add','edit','delete','import_data'),
							'ql_1_dd_status' => array('list','view','add','edit','delete','import_data'),
							'ql_5_quotelist' => array('list','view','add','edit','delete','import_data','open quotrd','open quotes for followup','open_quotes_for_followup_future')
						),
		
			'manager' =>
						array(
							'jl_0_oc_users' => array('list','view'),
							'ql_5_quotelist' => array('list','view','add','edit','delete','open_quotrd','open_quotes_for_followup','open_quotes_for_followup_future','import_data')
						),
		
			'user' =>
						array(
							'ql_5_quotelist' => array('list','view','add','edit','delete','open_quotrd','open_quotes_for_followup','open_quotes_for_followup_future','import_data')
						),
		
			'dataentry' =>
						array(
							'ql_5_quotelist' => array('view','add','edit','delete','open_quotrd','open_quotes_for_followup','open_quotes_for_followup_future')
						),
		
			'viewonly' =>
						array(
							'jl_1_dd_colours' => array('view'),
							'jl_1_dd_dealers' => array('view'),
							'ql_5_quotelist' => array('open_quotrd','open_quotes_for_followup','open_quotes_for_followup_future')
						)
		);
		
		/**
	     * pages to Exclude From Access Validation Check
	     * @var $excludePageCheck array()
	     */
		public static $excludePageCheck=array("","index","home","account","info","report");
		
		/**
	     * Display About us page
	     * @return string
	     */
		public static function GetPageAccess($path){
			$rp=self::$usersRolePermissions;
			if($rp=="*"){
				return "AUTHORIZED"; // Grant Access To Any User
			}
			else{
				$path = strtolower(trim($path,'/')); 

				$arrPath=explode("/", $path);
				$page=strtolower($arrPath[0]);
				
				//If User Is Accessing Exclude Access Check Page
				if(in_array($page , self:: $excludePageCheck)){
					return "AUTHORIZED";
				}
					
				$userRole=strtolower(USER_ROLE); // Get User Defined Role From Session Value
				if(array_key_exists($userRole,$rp)){
					$action=(!empty($arrPath[1]) ? $arrPath[1] : null);
					if($action=="index" || $action==""){
						$action="list";
					}

					//Check If User Have Access To All Pages Or User Have Access to All Page Actions
					if($rp[$userRole]=="*" || (!empty($rp[$userRole][$page]) && $rp[$userRole][$page]=="*")){
						return "AUTHORIZED";
					}
					else{
						if(!empty($rp[$userRole][$page]) && in_array($action,$rp[$userRole][$page])){
							return "AUTHORIZED";
						}
					}
					return "NOT_AUTHORIZED";
				}
				else{
					//User Does Not Have Any Role.
					return "NO_ROLE_PERMISSION";
				}
			}
		}
		
		public static function is_allowed($path){
			$access = self::GetPageAccess($path);
			return ($access == 'AUTHORIZED');
		}
	}
?>