<?php

//////////////////////////////////////////////////////////////////////////////80
// Macro Class
//////////////////////////////////////////////////////////////////////////////80
// Copyright (c) Atheos & Liam Siira (Atheos.io), distributed as-is and without
// warranty under the MIT License. See [root]/docs/LICENSE.md for more.
// This information must remain intact.
//////////////////////////////////////////////////////////////////////////////80
// Authors: Codiad Team, @daeks, Atheos Team, @hlsiira
//////////////////////////////////////////////////////////////////////////////80

class Macro {

	//////////////////////////////////////////////////////////////////////////80
	// PROPERTIES
	//////////////////////////////////////////////////////////////////////////80
	private $activeUser = null;
	private $db = null;

	//////////////////////////////////////////////////////////////////////////80
	// METHODS
	//////////////////////////////////////////////////////////////////////////80

	// ----------------------------------||---------------------------------- //

	//////////////////////////////////////////////////////////////////////////80
	// Construct
	//////////////////////////////////////////////////////////////////////////80
	public function __construct($activeUser) {
		$this->activeUser = $activeUser;
		$this->db = Common::getObjStore("macros");
	}

	//////////////////////////////////////////////////////////////////
	// Load Contextmenu Macros
	//////////////////////////////////////////////////////////////////
	public function load() {
		$macros = $this->db->select("*");
		if (!empty($macros)) {
			Common::send("success", $macros);
		} else {
			Common::send("error", "No macros found.");
		}
	}

	//////////////////////////////////////////////////////////////////
	// Save Contextmenu Macros
	//////////////////////////////////////////////////////////////////
	public function create($macro) {
		if ($this->db->insert($macro)) {
			Common::send("success");
		} else {
			Common::send("error", "Could not save.");
		}
	}

	//////////////////////////////////////////////////////////////////
	// Execute Macro
	//////////////////////////////////////////////////////////////////

	// public function Execute() {
	// 	$macrolist = $this->Load();
	// 	$command = $macrolist[$this->id]['c'];

	// 	if (!$this->isAbsPath($this->path)) {
	// 		$this->path = WORKSPACE.'/'.$this->path;
	// 	}
	// 	if (is_file($this->path)) {
	// 		$command = str_replace('%FILE%', $this->path, $command);
	// 		$command = str_replace('%FOLDER%', dirname($this->path), $command);
	// 		$command = str_replace('%NAME%', basename($this->path), $command);
	// 	} else {
	// 		$command = str_replace('%FOLDER%', $this->path, $command);
	// 		$command = str_replace('%NAME%', basename($this->path), $command);
	// 	}

	// 	Common::execute($command);
	// 	echo formatJSEND("success", null);
	// }

}