<?php 
/**
 * Jlv2_aa_0_oc_users Page Controller
 * @category  Controller
 */
class Jlv2_aa_0_oc_usersController extends BaseController{
	/**
     * Edit single field Action 
     * Return record id
     * @return View
     */
	function editfield($rec_id = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename = 'jlv2_aa_0_oc_users';
		$fields = $this->fields = array('uid','displayname','password','uid_lower','email','type','jl_type','ql_type','sl_type','rl_type','initials'); //editable fields
		if(is_post_request()){
			Csrf :: cross_check();
			$postdata = array();
			if(isset($_POST['name']) && isset($_POST['value'])){
				$fieldname = $_POST['name'];
				$fieldvalue = $_POST['value'];
				$postdata[$fieldname] = $fieldvalue;
				$postdata = $this->transform_request_data($postdata);
			}
			else{
				$this->view->page_error = "invalid post data";
			}
			$this->rules_array = array(
				'email' => 'valid_email',
			);
			$this->sanitize_array = array(
				'uid' => 'sanitize_string',
				'displayname' => 'sanitize_string',
				'uid_lower' => 'sanitize_string',
				'email' => 'sanitize_string',
				'type' => 'sanitize_string',
				'jl_type' => 'sanitize_string',
				'ql_type' => 'sanitize_string',
				'sl_type' => 'sanitize_string',
				'rl_type' => 'sanitize_string',
				'initials' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the POST Data
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if(empty($this->view->page_error)){
				$db->where('jlv2_aa_0_oc_users.uid' , $rec_id);
				try{
					$bool = $db->update($tablename, $modeldata);
					$numRows = $db->getRowCount();
					if($bool && $numRows){
						render_json(
							array(
								'num_rows' =>$numRows,
								'rec_id' =>$rec_id,
							)
						);
					}
					else{
						$page_error = null;
						if($db->getLastError()){
							$page_error = $db->getLastError();
						}
						elseif(!$numRows){
							$page_error = "No record updated";
						}
						else{
							$page_error = "No record found";
						}
						render_error($page_error);
					}
				}
				catch(Exception $e){
					render_error($e->getMessage());
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		else{
			render_error("Request type not accepted");
		}
	}
}
