<?php 
/**
 * Jlv2_jl_5_joblist Page Controller
 * @category  Controller
 */
class Jlv2_jl_5_joblistController extends BaseController{
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function index($fieldname = null , $fieldvalue = null){
		$db = $this->GetModel();
		$tablename = $this->tablename = 'jlv2_jl_5_joblist';
		$fields = array('Comments', 
			'CONCAT(NJobNum,JobNum) AS cJobNum', 
			'Dealer', 
			'TagName', 
			'Customer_Number', 
			'Door_Style', 
			'Wood', 
			'Colour', 
			'JobNum', 
			'Uppers', 
			'Talls', 
			'Bases', 
			'Vanities', 
			'Accessories', 
			'Value', 
			'Status', 
			'LastUpdated');
		$limit = $this->get_page_limit(MAX_RECORD_COUNT); // return pagination from BaseModel Class e.g array(5,20)
		$getdata = $this->getdata; //array of sanitized values passed via $_GET;
		if(!empty($this->search)){
			$text = trim($this->search);
			$db->where("(Comments LIKE ? OR Dealer LIKE ? OR TagName LIKE ? OR Customer_Number LIKE ? OR RSO LIKE ? OR Door_Style LIKE ? OR Wood LIKE ? OR Colour LIKE ? OR Requested_Date LIKE ? OR Received_Order LIKE ? OR Sent_To_OE LIKE ? OR Sent_For_Confirmation LIKE ? OR Confirmation_Received LIKE ? OR Confirmed LIKE ? OR Sent_To_Plant LIKE ? OR Plant LIKE ? OR Inv LIKE ? OR OE LIKE ? OR JobNum LIKE ? OR Uppers LIKE ? OR Talls LIKE ? OR Bases LIKE ? OR Vanities LIKE ? OR Accessories LIKE ? OR Value LIKE ? OR Status LIKE ? OR Door_Vendor LIKE ? OR Standard_Lead_Time LIKE ? OR Date_Shipped LIKE ? OR Other_ETA LIKE ? OR Door_ETA LIKE ? OR Back_Orders LIKE ? OR Back_Orders_Shipped LIKE ? OR Proposed_Shipping_Date LIKE ? OR Shipping_Comments LIKE ? OR Shipping_Details LIKE ? OR DealerRoute LIKE ? OR OrgJobNum LIKE ? OR Creator LIKE ? OR UpdatedBy LIKE ? OR SalesRep LIKE ? OR TimeStamp LIKE ? OR LastUpdated LIKE ?)", array("%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"));
		}
		if(!empty($this->orderby)){ // when order by request fields (from $_GET param)
			$db->orderBy($this->orderby,$this->ordertype);
		}
		else{
			$db->orderBy('jlv2_jl_5_joblist.JobNum', ORDER_TYPE);
		}
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $limit, $fields);
		if(	!empty($records)){
			foreach($records as &$record){
				$record['Comments'] = str_truncate($record['Comments'],30,'...');
$record['Dealer'] = str_truncate($record['Dealer'],4,'...');
$record['Door_Style'] = str_truncate($record['Door_Style'],5,'...');
			}
		}
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		if($db->getLastError()){
			$page_error = $db->getLastError();
			$this->view->page_error = $page_error;
		}
		$this->view->page_title ="Joblist";
		$this->view->render('jlv2_jl_5_joblist/list.php' , $data ,'main_layout.php');
	}
	/**
     * View Record Action 
     * @return View
     */
	function view( $rec_id = null , $value = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename = 'jlv2_jl_5_joblist';
		$fields = array('jlv2_jl_5_joblist.JobNum', 
			'jlv2_jl_5_joblist.Dealer', 
			'jlv2_jl_5_joblist.TagName', 
			'jlv2_jl_5_joblist.Customer_Number', 
			'jlv2_jl_5_joblist.RSO', 
			'jlv2_jl_5_joblist.Door_Style', 
			'jlv2_jl_5_joblist.Wood', 
			'jlv2_jl_5_joblist.Colour', 
			'jlv2_jl_5_joblist.Comments', 
			'jlv2_jl_5_joblist.Requested_Date', 
			'jlv2_jl_5_joblist.Received_Order', 
			'jlv2_jl_5_joblist.Sent_To_OE', 
			'jlv2_jl_5_joblist.Sent_For_Confirmation', 
			'jlv2_jl_5_joblist.Confirmation_Received', 
			'jlv2_jl_5_joblist.Confirmed', 
			'jlv2_jl_5_joblist.Sent_To_Plant', 
			'jlv2_jl_5_joblist.Plant', 
			'jlv2_jl_5_joblist.Inv', 
			'jlv2_jl_5_joblist.OE', 
			'jlv2_jl_5_joblist.Uppers', 
			'jlv2_jl_5_joblist.Talls', 
			'jlv2_jl_5_joblist.Bases', 
			'jlv2_jl_5_joblist.Vanities', 
			'jlv2_jl_5_joblist.Accessories', 
			'jlv2_jl_5_joblist.Value', 
			'jlv2_jl_5_joblist.Door_Vendor', 
			'jlv2_jl_5_joblist.Standard_Lead_Time', 
			'jlv2_jl_5_joblist.Date_Shipped', 
			'jlv2_jl_5_joblist.Other_ETA', 
			'jlv2_jl_5_joblist.Door_ETA', 
			'jlv2_jl_5_joblist.Back_Orders', 
			'jlv2_jl_5_joblist.Back_Orders_Shipped', 
			'jlv2_jl_5_joblist.Proposed_Shipping_Date', 
			'jlv2_jl_5_joblist.Shipping_Comments', 
			'jlv2_jl_5_joblist.Shipping_Details', 
			'jlv2_jl_5_joblist.DealerRoute', 
			'jlv2_jl_5_joblist.NJobNum', 
			'jlv2_jl_5_joblist.OrgJobNum', 
			'jlv2_jl_5_joblist.Creator', 
			'jlv2_jl_5_joblist.UpdatedBy', 
			'jlv2_jl_5_joblist.SalesRep', 
			'jlv2_jl_5_joblist.TimeStamp', 
			'jlv2_jl_5_joblist.LastUpdated', 
			'jlv2_jl_5_joblist.Status', 
			'jlv2_jl_7_production_status.JobNum AS jlv2_jl_7_production_status_JobNum', 
			'jlv2_jl_7_production_status.Ordered AS jlv2_jl_7_production_status_Ordered', 
			'jlv2_jl_7_production_status.Nested AS jlv2_jl_7_production_status_Nested', 
			'jlv2_jl_7_production_status.Finished_Parts AS jlv2_jl_7_production_status_Finished_Parts', 
			'jlv2_jl_7_production_status.Wrapped AS jlv2_jl_7_production_status_Wrapped', 
			'jlv2_jl_7_production_status.Finishing AS jlv2_jl_7_production_status_Finishing', 
			'jlv2_jl_7_production_status.Unfinished_Parts AS jlv2_jl_7_production_status_Unfinished_Parts', 
			'jlv2_jl_7_production_status.Assembled AS jlv2_jl_7_production_status_Assembled');
		$getdata = $this->getdata; //array of sanitized values passed via $_GET;
		if( !empty($value) ){
			$db->where($rec_id, urldecode($value));
		}
		else{
			$db->where('jlv2_jl_5_joblist.JobNum' , $rec_id);
		}
		$db->join("jlv2_jl_7_production_status","jlv2_jl_5_joblist.JobNum = jlv2_jl_7_production_status.JobNum","LEFT ");  
		$record = $db->getOne($tablename, $fields );
		if(!empty($record)){
			$record['Dealer'] = str_truncate($record['Dealer'],4,'...');
$record['TagName'] = str_truncate($record['TagName'],12,'...');
$record['Door_Vendor'] = str_truncate($record['Door_Vendor'],5,'...');
			$this->view->page_title ="View  Jobs";
			$this->view->render('jlv2_jl_5_joblist/view.php' , $record ,'main_layout.php');
		}
		else{
			$page_error = null;
			if($db->getLastError()){
				$page_error = $db->getLastError();
			}
			else{
				$page_error = "No record found";
			}
			$this->view->page_error = $page_error;
			$this->view->render('jlv2_jl_5_joblist/view.php' , $record , 'main_layout.php');
		}
	}
	/**
     * Add New Record Action 
     * If Not $_POST Request, Display Add Record Form View
     * @return View
     */
	function add(){
		if(is_post_request()){
			Csrf :: cross_check();
			$db = $this->GetModel();
			$tablename = $this->tablename = 'jlv2_jl_5_joblist';
			$fields = $this->fields = array('NJobNum','JobNum','Dealer','TagName','Customer_Number','RSO','Comments','Received_Order','Creator'); //insert fields
			$postdata = $this->transform_request_data($_POST);
			$this->rules_array = array(
				'TagName' => 'max_len,25',
			);
			$this->sanitize_array = array(
				'NJobNum' => 'sanitize_string',
				'JobNum' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'TagName' => 'sanitize_string',
				'Customer_Number' => 'sanitize_string',
				'RSO' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'Received_Order' => 'sanitize_string',
				'Creator' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this -> modeldata = $this->validate_form($postdata);
			if(empty($this->view->page_error)){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if(!empty($rec_id)){
					if(is_ajax()){
						render_json("Record added successfully");
					}
					else{
						set_flash_msg("Data Added",'success');
						if(!empty($this->redirect)){ 
							redirect_to_page($this->redirect); //if redirect url is passed via $_GET
						}
						else{
							redirect_to_page("jlv2_jl_5_joblist/view/$rec_id");
						}
					}
					return;
				}
				else{
					$page_error = null;
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					else{
						$page_error = "Error inserting record";
					}
					if(is_ajax()){
						render_error($page_error); 
						return;
					}
					else{
						$this->view->page_error[] = $page_error;
					}
				}
			}
		}
		$this->view->page_title ="Add Job";
		$this->view->render('jlv2_jl_5_joblist/add.php' ,null,'main_layout.php');
	}
	/**
     * Edit Record Action 
     * If Not $_POST Request, Display Edit Record Form View
     * @return View
     */
	function edit($rec_id = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename = 'jlv2_jl_5_joblist';
		$fields = $this->fields = array('NJobNum','JobNum','Status','Dealer','TagName','Customer_Number','RSO','Door_Style','Wood','Colour','Comments','Requested_Date','Received_Order','Sent_To_OE','Sent_For_Confirmation','Confirmation_Received','Confirmed','Sent_To_Plant','Plant','Inv','OE','Uppers','Talls','Bases','Vanities','Accessories','Value','Door_Vendor','Standard_Lead_Time','Date_Shipped','Other_ETA','Door_ETA','Back_Orders','Back_Orders_Shipped','Proposed_Shipping_Date','Shipping_Comments','Shipping_Details','DealerRoute','OrgJobNum','Creator'); //editable fields
		if(is_post_request()){
			Csrf :: cross_check();
			$postdata = $this->transform_request_data($_POST);
			$this->rules_array = array(
				'TagName' => 'max_len,25',
				'Uppers' => 'numeric',
				'Talls' => 'numeric',
				'Bases' => 'numeric',
				'Vanities' => 'numeric',
				'Accessories' => 'numeric',
				'Value' => 'numeric',
			);
			$this->sanitize_array = array(
				'NJobNum' => 'sanitize_string',
				'JobNum' => 'sanitize_string',
				'Status' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'TagName' => 'sanitize_string',
				'Customer_Number' => 'sanitize_string',
				'RSO' => 'sanitize_string',
				'Door_Style' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'Requested_Date' => 'sanitize_string',
				'Received_Order' => 'sanitize_string',
				'Sent_To_OE' => 'sanitize_string',
				'Sent_For_Confirmation' => 'sanitize_string',
				'Confirmation_Received' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'Sent_To_Plant' => 'sanitize_string',
				'Plant' => 'sanitize_string',
				'Inv' => 'sanitize_string',
				'OE' => 'sanitize_string',
				'Uppers' => 'sanitize_string',
				'Talls' => 'sanitize_string',
				'Bases' => 'sanitize_string',
				'Vanities' => 'sanitize_string',
				'Accessories' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'Door_Vendor' => 'sanitize_string',
				'Standard_Lead_Time' => 'sanitize_string',
				'Date_Shipped' => 'sanitize_string',
				'Other_ETA' => 'sanitize_string',
				'Door_ETA' => 'sanitize_string',
				'Back_Orders' => 'sanitize_string',
				'Back_Orders_Shipped' => 'sanitize_string',
				'Proposed_Shipping_Date' => 'sanitize_string',
				'Shipping_Comments' => 'sanitize_string',
				'Shipping_Details' => 'sanitize_string',
				'DealerRoute' => 'sanitize_string',
				'OrgJobNum' => 'sanitize_string',
				'Creator' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if(empty($this->view->page_error)){
				$db->where('jlv2_jl_5_joblist.JobNum' , $rec_id);
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					if(is_ajax()){
						render_json("Record updated successfully");
					}
					else{
						set_flash_msg('','');
						if(!empty($this->redirect)){ 
							redirect_to_page($this->redirect); //if redirect url is passed via $_GET
						}
						else{
							redirect_to_page("jlv2_jl_5_joblist/view/$rec_id");
						}
					}
					return;
				}
				else{
					$page_error = null;
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
						if(is_ajax()){
							render_error($page_error); //return http status error
						}
						else{
							//no changes made to the table record
							set_flash_msg($page_error, 'warning');
							if(!empty($this->redirect)){ 
								redirect_to_page($this->redirect); //if redirect url is passed via $_GET
							}
							else{
								redirect_to_page("jlv2_jl_5_joblist/view/$rec_id");
							}
						}
						return;
					}
					else{
						$page_error = "No record found";
					}
					if(is_ajax()){
						render_error($page_error); //return http status error
						return;
					}
					//continue to display edit page with errors
					$this->view->page_error[] = $page_error;
				}
			}
		}
		$db->where('jlv2_jl_5_joblist.JobNum' , $rec_id);
		$data = $db->getOne($tablename, $fields);
		$this->view->page_title ="Edit  A Job";
		if(!empty($data)){
			$this->view->render('jlv2_jl_5_joblist/edit.php' , $data, 'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error[] = $db->getLastError();
			}
			else{
				$this->view->page_error[] = "No record found";
			}
			$this->view->render('jlv2_jl_5_joblist/edit.php' , $data , 'main_layout.php');
		}
	}
	/**
     * Edit single field Action 
     * Return record id
     * @return View
     */
	function editfield($rec_id = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename = 'jlv2_jl_5_joblist';
		$fields = $this->fields = array('NJobNum','JobNum','Status','Dealer','TagName','Customer_Number','RSO','Door_Style','Wood','Colour','Comments','Requested_Date','Received_Order','Sent_To_OE','Sent_For_Confirmation','Confirmation_Received','Confirmed','Sent_To_Plant','Plant','Inv','OE','Uppers','Talls','Bases','Vanities','Accessories','Value','Door_Vendor','Standard_Lead_Time','Date_Shipped','Other_ETA','Door_ETA','Back_Orders','Back_Orders_Shipped','Proposed_Shipping_Date','Shipping_Comments','Shipping_Details','DealerRoute','OrgJobNum','Creator'); //editable fields
		if(is_post_request()){
			Csrf :: cross_check();
			$postdata = array();
			if(isset($_POST['name']) && isset($_POST['value'])){
				$fieldname = $_POST['name'];
				$fieldvalue = $_POST['value'];
				$postdata[$fieldname] = $fieldvalue;
				$postdata = $this->transform_request_data($postdata);
			}
			else{
				$this->view->page_error = "invalid post data";
			}
			$this->rules_array = array(
				'TagName' => 'max_len,25',
				'Uppers' => 'numeric',
				'Talls' => 'numeric',
				'Bases' => 'numeric',
				'Vanities' => 'numeric',
				'Accessories' => 'numeric',
				'Value' => 'numeric',
			);
			$this->sanitize_array = array(
				'NJobNum' => 'sanitize_string',
				'JobNum' => 'sanitize_string',
				'Status' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'TagName' => 'sanitize_string',
				'Customer_Number' => 'sanitize_string',
				'RSO' => 'sanitize_string',
				'Door_Style' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'Requested_Date' => 'sanitize_string',
				'Received_Order' => 'sanitize_string',
				'Sent_To_OE' => 'sanitize_string',
				'Sent_For_Confirmation' => 'sanitize_string',
				'Confirmation_Received' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'Sent_To_Plant' => 'sanitize_string',
				'Plant' => 'sanitize_string',
				'Inv' => 'sanitize_string',
				'OE' => 'sanitize_string',
				'Uppers' => 'sanitize_string',
				'Talls' => 'sanitize_string',
				'Bases' => 'sanitize_string',
				'Vanities' => 'sanitize_string',
				'Accessories' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'Door_Vendor' => 'sanitize_string',
				'Standard_Lead_Time' => 'sanitize_string',
				'Date_Shipped' => 'sanitize_string',
				'Other_ETA' => 'sanitize_string',
				'Door_ETA' => 'sanitize_string',
				'Back_Orders' => 'sanitize_string',
				'Back_Orders_Shipped' => 'sanitize_string',
				'Proposed_Shipping_Date' => 'sanitize_string',
				'Shipping_Comments' => 'sanitize_string',
				'Shipping_Details' => 'sanitize_string',
				'DealerRoute' => 'sanitize_string',
				'OrgJobNum' => 'sanitize_string',
				'Creator' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the POST Data
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if(empty($this->view->page_error)){
				$db->where('jlv2_jl_5_joblist.JobNum' , $rec_id);
				try{
					$bool = $db->update($tablename, $modeldata);
					$numRows = $db->getRowCount();
					if($bool && $numRows){
						render_json(
							array(
								'num_rows' =>$numRows,
								'rec_id' =>$rec_id,
							)
						);
					}
					else{
						$page_error = null;
						if($db->getLastError()){
							$page_error = $db->getLastError();
						}
						elseif(!$numRows){
							$page_error = "No record updated";
						}
						else{
							$page_error = "No record found";
						}
						render_error($page_error);
					}
				}
				catch(Exception $e){
					render_error($e->getMessage());
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		else{
			render_error("Request type not accepted");
		}
	}
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function l2($fieldname = null , $fieldvalue = null){
		$db = $this->GetModel();
		$tablename = $this->tablename = 'jlv2_jl_5_joblist';
		$fields = array('Comments', 
			'Status', 
			'CONCAT (NJobNum,JobNum) AS Job_Number', 
			'JobNum', 
			'Dealer', 
			'TagName', 
			'Customer_Number', 
			'RSO', 
			'Door_Style', 
			'Wood', 
			'Colour', 
			'Requested_Date', 
			'Inv', 
			'Uppers', 
			'Talls', 
			'Bases', 
			'Vanities', 
			'Accessories', 
			'Value', 
			'Door_Vendor', 
			'Standard_Lead_Time', 
			'Other_ETA', 
			'Door_ETA', 
			'Proposed_Shipping_Date', 
			'Shipping_Comments');
		$limit = $this->get_page_limit(MAX_RECORD_COUNT); // return pagination from BaseModel Class e.g array(5,20)
		$getdata = $this->getdata; //array of sanitized values passed via $_GET;
		if(!empty($this->search)){
			$text = trim($this->search);
			$db->where("(Comments LIKE ? OR Status LIKE ? OR NJobNum LIKE ? OR JobNum LIKE ? OR Dealer LIKE ? OR TagName LIKE ? OR Customer_Number LIKE ? OR RSO LIKE ? OR Door_Style LIKE ? OR Wood LIKE ? OR Colour LIKE ? OR Requested_Date LIKE ? OR Received_Order LIKE ? OR Sent_To_OE LIKE ? OR Sent_For_Confirmation LIKE ? OR Confirmation_Received LIKE ? OR Confirmed LIKE ? OR Sent_To_Plant LIKE ? OR Plant LIKE ? OR Inv LIKE ? OR OE LIKE ? OR Uppers LIKE ? OR Talls LIKE ? OR Bases LIKE ? OR Vanities LIKE ? OR Accessories LIKE ? OR Value LIKE ? OR Door_Vendor LIKE ? OR Standard_Lead_Time LIKE ? OR Date_Shipped LIKE ? OR Other_ETA LIKE ? OR Door_ETA LIKE ? OR Back_Orders LIKE ? OR Back_Orders_Shipped LIKE ? OR Proposed_Shipping_Date LIKE ? OR Shipping_Comments LIKE ? OR Shipping_Details LIKE ? OR DealerRoute LIKE ? OR OrgJobNum LIKE ? OR Creator LIKE ? OR UpdatedBy LIKE ? OR SalesRep LIKE ? OR TimeStamp LIKE ? OR LastUpdated LIKE ?)", array("%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"));
		}
		if(!empty($this->orderby)){ // when order by request fields (from $_GET param)
			$db->orderBy($this->orderby,$this->ordertype);
		}
		else{
			$db->orderBy('jlv2_jl_5_joblist.JobNum', ORDER_TYPE);
		}
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $limit, $fields);
		if(	!empty($records)){
			foreach($records as &$record){
				$record['Dealer'] = str_truncate($record['Dealer'],4,'...');
$record['TagName'] = str_truncate($record['TagName'],12,'...');
$record['Door_Vendor'] = str_truncate($record['Door_Vendor'],5,'...');
			}
		}
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		if($db->getLastError()){
			$page_error = $db->getLastError();
			$this->view->page_error = $page_error;
		}
		$this->view->page_title ="Joblist";
		$this->view->render('jlv2_jl_5_joblist/l2.php' , $data ,'main_layout.php');
	}
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function list_with_no_production_details($fieldname = null , $fieldvalue = null){
		$db = $this->GetModel();
		$tablename = $this->tablename = 'jlv2_jl_5_joblist';
		$fields = array('Comments', 
			'CONCAT(NJobNum,JobNum) AS cJobNum', 
			'JobNum', 
			'Dealer', 
			'TagName', 
			'Customer_Number', 
			'Door_Style', 
			'Wood', 
			'Colour', 
			'Uppers', 
			'Talls', 
			'Bases', 
			'Vanities', 
			'Accessories', 
			'Value', 
			'Status');
		$limit = $this->get_page_limit(MAX_RECORD_COUNT); // return pagination from BaseModel Class e.g array(5,20)
		$getdata = $this->getdata; //array of sanitized values passed via $_GET;
		if(!empty($this->search)){
			$text = trim($this->search);
			$db->where("(Comments LIKE ? OR JobNum LIKE ? OR Dealer LIKE ? OR TagName LIKE ? OR Customer_Number LIKE ? OR RSO LIKE ? OR Door_Style LIKE ? OR Wood LIKE ? OR Colour LIKE ? OR Requested_Date LIKE ? OR Received_Order LIKE ? OR Sent_To_OE LIKE ? OR Sent_For_Confirmation LIKE ? OR Confirmation_Received LIKE ? OR Confirmed LIKE ? OR Sent_To_Plant LIKE ? OR Plant LIKE ? OR Inv LIKE ? OR OE LIKE ? OR Uppers LIKE ? OR Talls LIKE ? OR Bases LIKE ? OR Vanities LIKE ? OR Accessories LIKE ? OR Value LIKE ? OR Door_Vendor LIKE ? OR Standard_Lead_Time LIKE ? OR Date_Shipped LIKE ? OR Other_ETA LIKE ? OR Door_ETA LIKE ? OR Back_Orders LIKE ? OR Back_Orders_Shipped LIKE ? OR Proposed_Shipping_Date LIKE ? OR Shipping_Comments LIKE ? OR Shipping_Details LIKE ? OR DealerRoute LIKE ? OR OrgJobNum LIKE ? OR Creator LIKE ? OR UpdatedBy LIKE ? OR SalesRep LIKE ? OR TimeStamp LIKE ? OR LastUpdated LIKE ? OR Status LIKE ?)", array("%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"));
		}
		if(!empty($this->orderby)){ // when order by request fields (from $_GET param)
			$db->orderBy($this->orderby,$this->ordertype);
		}
		else{
			$db->orderBy('jlv2_jl_5_joblist.JobNum', ORDER_TYPE);
		}
		$db->where("JobNum NOT IN ( select jobnum from jlv2_jl_7_production_status)");
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $limit, $fields);
		if(	!empty($records)){
			foreach($records as &$record){
				$record['Comments'] = str_truncate($record['Comments'],30,'...');
$record['Dealer'] = str_truncate($record['Dealer'],4,'...');
$record['Door_Style'] = str_truncate($record['Door_Style'],5,'...');
			}
		}
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		if($db->getLastError()){
			$page_error = $db->getLastError();
			$this->view->page_error = $page_error;
		}
		$this->view->page_title ="Joblist";
		$this->view->render('jlv2_jl_5_joblist/list_with_no_production_details.php' , $data ,'main_layout.php');
	}
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function jl_not_invoiced($fieldname = null , $fieldvalue = null){
		$db = $this->GetModel();
		$tablename = $this->tablename = 'jlv2_jl_5_joblist';
		$fields = array('Comments', 
			'CONCAT(NJobNum,JobNum) AS cJobNum', 
			'JobNum', 
			'Dealer', 
			'TagName', 
			'Customer_Number', 
			'Door_Style', 
			'Wood', 
			'Colour', 
			'Uppers', 
			'Talls', 
			'Bases', 
			'Vanities', 
			'Accessories', 
			'Value', 
			'Status');
		$limit = $this->get_page_limit(MAX_RECORD_COUNT); // return pagination from BaseModel Class e.g array(5,20)
		$getdata = $this->getdata; //array of sanitized values passed via $_GET;
		if(!empty($this->search)){
			$text = trim($this->search);
			$db->where("(Comments LIKE ? OR JobNum LIKE ? OR Dealer LIKE ? OR TagName LIKE ? OR Customer_Number LIKE ? OR RSO LIKE ? OR Door_Style LIKE ? OR Wood LIKE ? OR Colour LIKE ? OR Requested_Date LIKE ? OR Received_Order LIKE ? OR Sent_To_OE LIKE ? OR Sent_For_Confirmation LIKE ? OR Confirmation_Received LIKE ? OR Confirmed LIKE ? OR Sent_To_Plant LIKE ? OR Plant LIKE ? OR Inv LIKE ? OR OE LIKE ? OR Uppers LIKE ? OR Talls LIKE ? OR Bases LIKE ? OR Vanities LIKE ? OR Accessories LIKE ? OR Value LIKE ? OR Door_Vendor LIKE ? OR Standard_Lead_Time LIKE ? OR Date_Shipped LIKE ? OR Other_ETA LIKE ? OR Door_ETA LIKE ? OR Back_Orders LIKE ? OR Back_Orders_Shipped LIKE ? OR Proposed_Shipping_Date LIKE ? OR Shipping_Comments LIKE ? OR Shipping_Details LIKE ? OR DealerRoute LIKE ? OR OrgJobNum LIKE ? OR Creator LIKE ? OR UpdatedBy LIKE ? OR SalesRep LIKE ? OR TimeStamp LIKE ? OR LastUpdated LIKE ? OR Status LIKE ?)", array("%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"));
		}
		if(!empty($this->orderby)){ // when order by request fields (from $_GET param)
			$db->orderBy($this->orderby,$this->ordertype);
		}
		else{
			$db->orderBy('jlv2_jl_5_joblist.JobNum', ORDER_TYPE);
		}
		$db->where("JobNum NOT IN ( select jobnum from jlv2_jl_7_production_status)");
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $limit, $fields);
		if(	!empty($records)){
			foreach($records as &$record){
				$record['Comments'] = str_truncate($record['Comments'],30,'...');
$record['Dealer'] = str_truncate($record['Dealer'],4,'...');
$record['Door_Style'] = str_truncate($record['Door_Style'],5,'...');
			}
		}
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		if($db->getLastError()){
			$page_error = $db->getLastError();
			$this->view->page_error = $page_error;
		}
		$this->view->page_title ="Joblist";
		$this->view->render('jlv2_jl_5_joblist/jl_not_invoiced.php' , $data ,'main_layout.php');
	}
}
