<?php 
/**
 * Jlv2_jl_5_joblistorg Page Controller
 * @category  Controller
 */
class Jlv2_jl_5_joblistorgController extends BaseController{
	/**
     * Edit single field Action 
     * Return record id
     * @return View
     */
	function editfield($rec_id = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename = 'jlv2_jl_5_joblistorg';
		$fields = $this->fields = array('JobNum','Dealer','TagName','Customer_Number','RSO','Door_Style','Wood','Colour','Comments','Requested_Date','Received_Order','Sent_To_OE','Sent_For_Confirmation','Confirmation_Received','Confirmed','Sent_To_Plant','Plant','Inv','OE','Uppers','Talls','Bases','Vanities','Accessories','Value','Door_Vendor','Standard_Lead_Time','Date_Shipped','Other_ETA','Door_ETA','Back_Orders','Back_Orders_Shipped','Proposed_Shipping_Date','Shipping_Comments','Shipping_Details','DealerRoute','NJobNum','OrgJobNum','Creator','UpdatedBy','SalesRep','LastUpdated','Status'); //editable fields
		if(is_post_request()){
			Csrf :: cross_check();
			$postdata = array();
			if(isset($_POST['name']) && isset($_POST['value'])){
				$fieldname = $_POST['name'];
				$fieldvalue = $_POST['value'];
				$postdata[$fieldname] = $fieldvalue;
				$postdata = $this->transform_request_data($postdata);
			}
			else{
				$this->view->page_error = "invalid post data";
			}
			$this->rules_array = array(
				'Uppers' => 'numeric',
				'Talls' => 'numeric',
				'Bases' => 'numeric',
				'Vanities' => 'numeric',
				'Accessories' => 'numeric',
				'Value' => 'numeric',
			);
			$this->sanitize_array = array(
				'Dealer' => 'sanitize_string',
				'TagName' => 'sanitize_string',
				'Customer_Number' => 'sanitize_string',
				'RSO' => 'sanitize_string',
				'Door_Style' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'Requested_Date' => 'sanitize_string',
				'Received_Order' => 'sanitize_string',
				'Sent_To_OE' => 'sanitize_string',
				'Sent_For_Confirmation' => 'sanitize_string',
				'Confirmation_Received' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'Sent_To_Plant' => 'sanitize_string',
				'Plant' => 'sanitize_string',
				'Inv' => 'sanitize_string',
				'OE' => 'sanitize_string',
				'Uppers' => 'sanitize_string',
				'Talls' => 'sanitize_string',
				'Bases' => 'sanitize_string',
				'Vanities' => 'sanitize_string',
				'Accessories' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'Door_Vendor' => 'sanitize_string',
				'Standard_Lead_Time' => 'sanitize_string',
				'Date_Shipped' => 'sanitize_string',
				'Other_ETA' => 'sanitize_string',
				'Door_ETA' => 'sanitize_string',
				'Back_Orders' => 'sanitize_string',
				'Back_Orders_Shipped' => 'sanitize_string',
				'Proposed_Shipping_Date' => 'sanitize_string',
				'Shipping_Comments' => 'sanitize_string',
				'Shipping_Details' => 'sanitize_string',
				'DealerRoute' => 'sanitize_string',
				'NJobNum' => 'sanitize_string',
				'OrgJobNum' => 'sanitize_string',
				'Creator' => 'sanitize_string',
				'UpdatedBy' => 'sanitize_string',
				'SalesRep' => 'sanitize_string',
				'LastUpdated' => 'sanitize_string',
				'Status' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the POST Data
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if(empty($this->view->page_error)){
				$db->where('jlv2_jl_5_joblistorg.JobNum' , $rec_id);
				try{
					$bool = $db->update($tablename, $modeldata);
					$numRows = $db->getRowCount();
					if($bool && $numRows){
						render_json(
							array(
								'num_rows' =>$numRows,
								'rec_id' =>$rec_id,
							)
						);
					}
					else{
						$page_error = null;
						if($db->getLastError()){
							$page_error = $db->getLastError();
						}
						elseif(!$numRows){
							$page_error = "No record updated";
						}
						else{
							$page_error = "No record found";
						}
						render_error($page_error);
					}
				}
				catch(Exception $e){
					render_error($e->getMessage());
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		else{
			render_error("Request type not accepted");
		}
	}
}
