<?php 
/**
 * Jlv2_jl_7_production_status Page Controller
 * @category  Controller
 */
class Jlv2_jl_7_production_statusController extends BaseController{
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function index($fieldname = null , $fieldvalue = null){
		$db = $this->GetModel();
		$tablename = $this->tablename = 'jlv2_jl_7_production_status';
		$fields = array('jlv2_jl_7_production_status.JobNum', 
			'jlv2_jl_7_production_status.tOrdered', 
			'jlv2_jl_7_production_status.tNested', 
			'jlv2_jl_7_production_status.tFinished_Parts', 
			'jlv2_jl_7_production_status.tWrapped', 
			'jlv2_jl_7_production_status.tFinishing', 
			'jlv2_jl_7_production_status.tUnfinished_Parts', 
			'jlv2_jl_7_production_status.tAssembled');
		$limit = $this->get_page_limit(MAX_RECORD_COUNT); // return pagination from BaseModel Class e.g array(5,20)
		$getdata = $this->getdata; //array of sanitized values passed via $_GET;
		if(!empty($this->search)){
			$text = trim($this->search);
			$db->where("(jlv2_jl_7_production_status.JobNum LIKE ? OR jlv2_jl_7_production_status.Ordered LIKE ? OR jlv2_jl_7_production_status.Nested LIKE ? OR jlv2_jl_7_production_status.Finished_Parts LIKE ? OR jlv2_jl_7_production_status.Wrapped LIKE ? OR jlv2_jl_7_production_status.Finishing LIKE ? OR jlv2_jl_7_production_status.Unfinished_Parts LIKE ? OR jlv2_jl_7_production_status.Assembled LIKE ? OR jlv2_jl_7_production_status.tOrdered LIKE ? OR jlv2_jl_7_production_status.tNested LIKE ? OR jlv2_jl_7_production_status.tFinished_Parts LIKE ? OR jlv2_jl_7_production_status.tWrapped LIKE ? OR jlv2_jl_7_production_status.tFinishing LIKE ? OR jlv2_jl_7_production_status.tUnfinished_Parts LIKE ? OR jlv2_jl_7_production_status.tAssembled LIKE ?)", array("%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"));
		}
		if(!empty($this->orderby)){ // when order by request fields (from $_GET param)
			$db->orderBy($this->orderby,$this->ordertype);
		}
		else{
			$db->orderBy('jlv2_jl_7_production_status.JobNum', ORDER_TYPE);
		}
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $limit, $fields);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		if($db->getLastError()){
			$page_error = $db->getLastError();
			$this->view->page_error = $page_error;
		}
		$this->view->page_title ="Production Status";
		$this->view->render('jlv2_jl_7_production_status/list.php' , $data ,'main_layout.php');
	}
	/**
     * View Record Action 
     * @return View
     */
	function view( $rec_id = null , $value = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename = 'jlv2_jl_7_production_status';
		$fields = array('jlv2_jl_5_joblist.Status AS jlv2_jl_5_joblist_Status', 
			'jlv2_jl_7_production_status.JobNum', 
			'jlv2_jl_7_production_status.tOrdered', 
			'jlv2_jl_7_production_status.tNested', 
			'jlv2_jl_7_production_status.tFinished_Parts', 
			'jlv2_jl_7_production_status.tWrapped', 
			'jlv2_jl_7_production_status.tFinishing', 
			'jlv2_jl_7_production_status.tUnfinished_Parts', 
			'jlv2_jl_7_production_status.tAssembled', 
			'jlv2_jl_5_joblist.JobNum AS jlv2_jl_5_joblist_JobNum', 
			'jlv2_jl_5_joblist.Dealer AS jlv2_jl_5_joblist_Dealer', 
			'jlv2_jl_5_joblist.TagName AS jlv2_jl_5_joblist_TagName', 
			'jlv2_jl_5_joblist.Customer_Number AS jlv2_jl_5_joblist_Customer_Number', 
			'jlv2_jl_5_joblist.Door_Style AS jlv2_jl_5_joblist_Door_Style', 
			'jlv2_jl_5_joblist.Wood AS jlv2_jl_5_joblist_Wood', 
			'jlv2_jl_5_joblist.Colour AS jlv2_jl_5_joblist_Colour', 
			'jlv2_jl_5_joblist.Comments AS jlv2_jl_5_joblist_Comments', 
			'jlv2_jl_5_joblist.Inv AS jlv2_jl_5_joblist_Inv', 
			'jlv2_jl_5_joblist.Uppers AS jlv2_jl_5_joblist_Uppers', 
			'jlv2_jl_5_joblist.Talls AS jlv2_jl_5_joblist_Talls', 
			'jlv2_jl_5_joblist.Bases AS jlv2_jl_5_joblist_Bases', 
			'jlv2_jl_5_joblist.Vanities AS jlv2_jl_5_joblist_Vanities', 
			'jlv2_jl_5_joblist.Accessories AS jlv2_jl_5_joblist_Accessories', 
			'jlv2_jl_5_joblist.Value AS jlv2_jl_5_joblist_Value', 
			'jlv2_jl_5_joblist.Shipping_Comments AS jlv2_jl_5_joblist_Shipping_Comments', 
			'jlv2_jl_5_joblist.OrgJobNum AS jlv2_jl_5_joblist_OrgJobNum');
		$getdata = $this->getdata; //array of sanitized values passed via $_GET;
		if( !empty($value) ){
			$db->where($rec_id, urldecode($value));
		}
		else{
			$db->where('jlv2_jl_7_production_status.JobNum' , $rec_id);
		}
		$db->join("jlv2_jl_5_joblist","jlv2_jl_7_production_status.JobNum = jlv2_jl_5_joblist.JobNum","RIGHT ");  
		$record = $db->getOne($tablename, $fields );
		if(!empty($record)){
			$this->view->page_title ="View Production Status";
			$this->view->render('jlv2_jl_7_production_status/view.php' , $record ,'main_layout.php');
		}
		else{
			$page_error = null;
			if($db->getLastError()){
				$page_error = $db->getLastError();
			}
			else{
				$page_error = "No record found";
			}
			$this->view->page_error = $page_error;
			$this->view->render('jlv2_jl_7_production_status/view.php' , $record , 'main_layout.php');
		}
	}
	/**
     * Add New Record Action 
     * If Not $_POST Request, Display Add Record Form View
     * @return View
     */
	function add(){
		if(is_post_request()){
			Csrf :: cross_check();
			$db = $this->GetModel();
			$tablename = $this->tablename = 'jlv2_jl_7_production_status';
			$fields = $this->fields = array('JobNum','tOrdered','tNested','tFinished_Parts','tWrapped','tFinishing','tUnfinished_Parts','tAssembled'); //insert fields
			$postdata = $this->transform_request_data($_POST);
			$this->rules_array = array(
			);
			$this->sanitize_array = array(
				'JobNum' => 'sanitize_string',
				'tOrdered' => 'sanitize_string',
				'tNested' => 'sanitize_string',
				'tFinished_Parts' => 'sanitize_string',
				'tWrapped' => 'sanitize_string',
				'tFinishing' => 'sanitize_string',
				'tUnfinished_Parts' => 'sanitize_string',
				'tAssembled' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this -> modeldata = $this->validate_form($postdata);
			if(empty($this->view->page_error)){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if(!empty($rec_id)){
					if(is_ajax()){
						render_json("Record added successfully");
					}
					else{
						set_flash_msg("Data Added",'success');
						if(!empty($this->redirect)){ 
							redirect_to_page($this->redirect); //if redirect url is passed via $_GET
						}
						else{
							redirect_to_page("jlv2_jl_7_production_status");
						}
					}
					return;
				}
				else{
					$page_error = null;
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					else{
						$page_error = "Error inserting record";
					}
					if(is_ajax()){
						render_error($page_error); 
						return;
					}
					else{
						$this->view->page_error[] = $page_error;
					}
				}
			}
		}
		$this->view->page_title ="Add New Production Status";
		$this->view->render('jlv2_jl_7_production_status/add.php' ,null,'main_layout.php');
	}
	/**
     * Edit Record Action 
     * If Not $_POST Request, Display Edit Record Form View
     * @return View
     */
	function edit($rec_id = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename = 'jlv2_jl_7_production_status';
		$fields = $this->fields = array('JobNum','tOrdered','tNested','tFinished_Parts','tWrapped','tFinishing','tUnfinished_Parts','tAssembled'); //editable fields
		if(is_post_request()){
			Csrf :: cross_check();
			$postdata = $this->transform_request_data($_POST);
			$this->rules_array = array(
			);
			$this->sanitize_array = array(
				'JobNum' => 'sanitize_string',
				'tOrdered' => 'sanitize_string',
				'tNested' => 'sanitize_string',
				'tFinished_Parts' => 'sanitize_string',
				'tWrapped' => 'sanitize_string',
				'tFinishing' => 'sanitize_string',
				'tUnfinished_Parts' => 'sanitize_string',
				'tAssembled' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if(empty($this->view->page_error)){
				$db->where('jlv2_jl_7_production_status.JobNum' , $rec_id);
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					if(is_ajax()){
						render_json("Record updated successfully");
					}
					else{
						set_flash_msg('','');
						if(!empty($this->redirect)){ 
							redirect_to_page($this->redirect); //if redirect url is passed via $_GET
						}
						else{
							redirect_to_page("jlv2_jl_7_production_status");
						}
					}
					return;
				}
				else{
					$page_error = null;
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
						if(is_ajax()){
							render_error($page_error); //return http status error
						}
						else{
							//no changes made to the table record
							set_flash_msg($page_error, 'warning');
							if(!empty($this->redirect)){ 
								redirect_to_page($this->redirect); //if redirect url is passed via $_GET
							}
							else{
								redirect_to_page("jlv2_jl_7_production_status");
							}
						}
						return;
					}
					else{
						$page_error = "No record found";
					}
					if(is_ajax()){
						render_error($page_error); //return http status error
						return;
					}
					//continue to display edit page with errors
					$this->view->page_error[] = $page_error;
				}
			}
		}
		$db->where('jlv2_jl_7_production_status.JobNum' , $rec_id);
		$data = $db->getOne($tablename, $fields);
		$this->view->page_title ="Edit Production Status";
		if(!empty($data)){
			$this->view->render('jlv2_jl_7_production_status/edit.php' , $data, 'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error[] = $db->getLastError();
			}
			else{
				$this->view->page_error[] = "No record found";
			}
			$this->view->render('jlv2_jl_7_production_status/edit.php' , $data , 'main_layout.php');
		}
	}
	/**
     * Edit single field Action 
     * Return record id
     * @return View
     */
	function editfield($rec_id = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename = 'jlv2_jl_7_production_status';
		$fields = $this->fields = array('JobNum','tOrdered','tNested','tFinished_Parts','tWrapped','tFinishing','tUnfinished_Parts','tAssembled'); //editable fields
		if(is_post_request()){
			Csrf :: cross_check();
			$postdata = array();
			if(isset($_POST['name']) && isset($_POST['value'])){
				$fieldname = $_POST['name'];
				$fieldvalue = $_POST['value'];
				$postdata[$fieldname] = $fieldvalue;
				$postdata = $this->transform_request_data($postdata);
			}
			else{
				$this->view->page_error = "invalid post data";
			}
			$this->rules_array = array(
			);
			$this->sanitize_array = array(
				'JobNum' => 'sanitize_string',
				'tOrdered' => 'sanitize_string',
				'tNested' => 'sanitize_string',
				'tFinished_Parts' => 'sanitize_string',
				'tWrapped' => 'sanitize_string',
				'tFinishing' => 'sanitize_string',
				'tUnfinished_Parts' => 'sanitize_string',
				'tAssembled' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the POST Data
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if(empty($this->view->page_error)){
				$db->where('jlv2_jl_7_production_status.JobNum' , $rec_id);
				try{
					$bool = $db->update($tablename, $modeldata);
					$numRows = $db->getRowCount();
					if($bool && $numRows){
						render_json(
							array(
								'num_rows' =>$numRows,
								'rec_id' =>$rec_id,
							)
						);
					}
					else{
						$page_error = null;
						if($db->getLastError()){
							$page_error = $db->getLastError();
						}
						elseif(!$numRows){
							$page_error = "No record updated";
						}
						else{
							$page_error = "No record found";
						}
						render_error($page_error);
					}
				}
				catch(Exception $e){
					render_error($e->getMessage());
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		else{
			render_error("Request type not accepted");
		}
	}
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function not_wrapped($fieldname = null , $fieldvalue = null){
		$db = $this->GetModel();
		$tablename = $this->tablename = 'jlv2_jl_7_production_status';
		$fields = array('jlv2_jl_7_production_status.JobNum', 
			'jlv2_jl_7_production_status.tOrdered', 
			'jlv2_jl_7_production_status.tNested', 
			'jlv2_jl_7_production_status.tFinished_Parts', 
			'jlv2_jl_7_production_status.tWrapped', 
			'jlv2_jl_7_production_status.tFinishing', 
			'jlv2_jl_7_production_status.tUnfinished_Parts', 
			'jlv2_jl_7_production_status.tAssembled');
		$limit = $this->get_page_limit(MAX_RECORD_COUNT); // return pagination from BaseModel Class e.g array(5,20)
		$getdata = $this->getdata; //array of sanitized values passed via $_GET;
		if(!empty($this->search)){
			$text = trim($this->search);
			$db->where("(jlv2_jl_7_production_status.JobNum LIKE ? OR jlv2_jl_7_production_status.Ordered LIKE ? OR jlv2_jl_7_production_status.Nested LIKE ? OR jlv2_jl_7_production_status.Finished_Parts LIKE ? OR jlv2_jl_7_production_status.Wrapped LIKE ? OR jlv2_jl_7_production_status.Finishing LIKE ? OR jlv2_jl_7_production_status.Unfinished_Parts LIKE ? OR jlv2_jl_7_production_status.Assembled LIKE ? OR jlv2_jl_7_production_status.tOrdered LIKE ? OR jlv2_jl_7_production_status.tNested LIKE ? OR jlv2_jl_7_production_status.tFinished_Parts LIKE ? OR jlv2_jl_7_production_status.tWrapped LIKE ? OR jlv2_jl_7_production_status.tFinishing LIKE ? OR jlv2_jl_7_production_status.tUnfinished_Parts LIKE ? OR jlv2_jl_7_production_status.tAssembled LIKE ?)", array("%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"));
		}
		if(!empty($this->orderby)){ // when order by request fields (from $_GET param)
			$db->orderBy($this->orderby,$this->ordertype);
		}
		else{
			$db->orderBy('jlv2_jl_7_production_status.JobNum', ORDER_TYPE);
		}
		$db->where("tFinished_Parts=1 and tWrapped <>1 AND JobNum > 3100");
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $limit, $fields);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		if($db->getLastError()){
			$page_error = $db->getLastError();
			$this->view->page_error = $page_error;
		}
		$this->view->page_title ="Production Status";
		$this->view->render('jlv2_jl_7_production_status/not_wrapped.php' , $data ,'main_layout.php');
	}
}
