<?php 
/**
 * Joblist2015 Page Controller
 * @category  Controller
 */
class Joblist2015Controller extends BaseController{
	/**
     * Edit single field Action 
     * Return record id
     * @return View
     */
	function editfield($rec_id = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename = 'joblist2015';
		$fields = $this->fields = array('JobNum','Artisan','Dealer','CustomerNum','TagName','OrderEntry','SalesRep','RecdOrder','StdLeadTime','ReqDate','Value','SentToOE','SentToDealer','Confirmed','SentToPlant','Inv','Comments','RSO','Uppers','Talls','Bases','Vanities','Accessories','Wood','Colour','DoorVendor','DoorETA','OtherETA','Priority','Creator','DoorStyle','Conf_Rec','NJobNum','DateShipped','BackOrders','BackOrdersShipped','propshipdate','shipcomments','shipdetails','DealerRoute','OrgJobNum','UpdatedBy','LastUpdated'); //editable fields
		if(is_post_request()){
			Csrf :: cross_check();
			$postdata = array();
			if(isset($_POST['name']) && isset($_POST['value'])){
				$fieldname = $_POST['name'];
				$fieldvalue = $_POST['value'];
				$postdata[$fieldname] = $fieldvalue;
				$postdata = $this->transform_request_data($postdata);
			}
			else{
				$this->view->page_error = "invalid post data";
			}
			$this->rules_array = array(
				'Value' => 'numeric',
				'Uppers' => 'numeric',
				'Talls' => 'numeric',
				'Bases' => 'numeric',
				'Vanities' => 'numeric',
				'Accessories' => 'numeric',
			);
			$this->sanitize_array = array(
				'Artisan' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'CustomerNum' => 'sanitize_string',
				'TagName' => 'sanitize_string',
				'OrderEntry' => 'sanitize_string',
				'SalesRep' => 'sanitize_string',
				'RecdOrder' => 'sanitize_string',
				'StdLeadTime' => 'sanitize_string',
				'ReqDate' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'SentToOE' => 'sanitize_string',
				'SentToDealer' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'SentToPlant' => 'sanitize_string',
				'Inv' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'RSO' => 'sanitize_string',
				'Uppers' => 'sanitize_string',
				'Talls' => 'sanitize_string',
				'Bases' => 'sanitize_string',
				'Vanities' => 'sanitize_string',
				'Accessories' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'DoorVendor' => 'sanitize_string',
				'DoorETA' => 'sanitize_string',
				'OtherETA' => 'sanitize_string',
				'Priority' => 'sanitize_string',
				'Creator' => 'sanitize_string',
				'DoorStyle' => 'sanitize_string',
				'Conf_Rec' => 'sanitize_string',
				'NJobNum' => 'sanitize_string',
				'DateShipped' => 'sanitize_string',
				'BackOrders' => 'sanitize_string',
				'BackOrdersShipped' => 'sanitize_string',
				'propshipdate' => 'sanitize_string',
				'shipcomments' => 'sanitize_string',
				'shipdetails' => 'sanitize_string',
				'DealerRoute' => 'sanitize_string',
				'OrgJobNum' => 'sanitize_string',
				'UpdatedBy' => 'sanitize_string',
				'LastUpdated' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the POST Data
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if(empty($this->view->page_error)){
				$db->where('joblist2015.JobNum' , $rec_id);
				try{
					$bool = $db->update($tablename, $modeldata);
					$numRows = $db->getRowCount();
					if($bool && $numRows){
						render_json(
							array(
								'num_rows' =>$numRows,
								'rec_id' =>$rec_id,
							)
						);
					}
					else{
						$page_error = null;
						if($db->getLastError()){
							$page_error = $db->getLastError();
						}
						elseif(!$numRows){
							$page_error = "No record updated";
						}
						else{
							$page_error = "No record found";
						}
						render_error($page_error);
					}
				}
				catch(Exception $e){
					render_error($e->getMessage());
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		else{
			render_error("Request type not accepted");
		}
	}
}
