
<?php

$comp_model = new SharedController;
$current_page = get_current_url();
$csrf_token = Csrf :: $token;

//Page Data From Controller
$view_data = $this->view_data;

$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;

$field_name = Router :: $field_name;
$field_value = Router :: $field_value;

$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;


?>

<section class="page">
    
    <?php
    if( $show_header == true ){
    ?>
    
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            
            <div class="row ">
                
                <div class="col-sm-4 ">
                    <h3 class="record-title">Job List L2</h3>
                    
                </div>
                
                <div class="col-sm-3 ">
                    
                    <a href="<?php print_link("jlv2_jl_5_joblist/add") ?>"  class="btn btn btn-primary my-1 open-page-modal">
                        <i class="material-icons">add</i>                                   
                        Add New Job 
                    </a>
                    <div data-backdrop="true" id="Btn-Modal-1" class="modal fade"  role="dialog" aria-labelledby="Btn-Modal-1" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-body p-0">
                                    
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>
                
                <div class="col-sm-5 ">
                    
                    <form  class="search" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_query_str_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="material-icons">search</i></button>
                                </div>
                            </div>
                        </form>
                        
                    </div>
                    
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <?php
                            if(!empty($field_name) || !empty($_GET['search'])){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-capitalize" href="<?php print_link('jlv2_jl_5_joblist'); ?>">
                                            <i class="material-icons">arrow_back</i> <?php echo make_readable($field_name); ?>
                                        </a>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize"><?php echo make_readable(urldecode($field_value)); ?></li>
                                    <?php 
                                    }   
                                    ?>
                                    
                                    <?php
                                    if(!empty($_GET['search'])){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-capitalize" href="<?php print_link('jlv2_jl_5_joblist') ?>">Search</a>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize"> <strong><?php echo get_value('search'); ?></strong></li>
                                    <?php
                                    }
                                    ?>
                                    
                                </ul>
                            </nav>  
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
        
        <?php
        }
        ?>
        
        <div  class="">
            <div class="container-fluid">
                
                <div class="row ">
                    
                    <div class="col-md-12 comp-grid">
                        
                        <?php $this :: display_page_errors(); ?>
                        
                        <div  class=" animated fadeIn">
                            <div id="jlv2_jl_5_joblist-l2-records">
                                
                                <?php
                                if(!empty($records)){
                                ?>
                                <div class="page-records table-responsive">
                                    <table class="table table-hover table-striped table-sm">
                                        <thead class="table-header bg-light text-dark">
                                            <tr>
                                                
                                                
                                                <th class="col-sm-5"> Comments</th>
                                                <th > Status</th>
                                                <th > Job</th>
                                                <th > Dealer</th>
                                                <th > Tagname</th>
                                                <th > Customer Number</th>
                                                <th > Rso</th>
                                                <th > Door Style</th>
                                                <th > Wood</th>
                                                <th > Colour</th>
                                                <th > Requested Date</th>
                                                <th > Inv</th>
                                                <th > U</th>
                                                <th > T</th>
                                                <th > B</th>
                                                <th > <b>V</b></th>
                                                <th > Acc</th>
                                                <th > Value</th>
                                                <th > Door Vendor</th>
                                                <th > Standard Lead Time</th>
                                                <th > Other Eta</th>
                                                <th > Door Eta</th>
                                                <th > Proposed Shipping Date</th>
                                                <th > Shipping Comments</th>
                                                
                                                <th class="td-btn"></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            
                                            <?php
                                            $counter = 0;
                                            
                                            foreach($records as $data){
                                            $rec_id = (!empty($data['JobNum']) ? urlencode($data['JobNum']) : null);
                                            $counter++;
                                            
                                            
                                            ?>
                                            <tr>
                                                
                                                
                                                
                                                
                                                <td><a href="<?php print_link("mailto:$data[Comments]") ?>"><?php echo $data['Comments']; ?></a></td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Status" 
                                                        data-title="Enter Status" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Status']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['Job_Number']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Dealer" 
                                                        data-title="Enter Dealer" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Dealer']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="TagName" 
                                                        data-title="Enter Tagname" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['TagName']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Customer_Number" 
                                                        data-title="Enter Customer Number" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Customer_Number']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-value="<?php echo $data['RSO']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="RSO" 
                                                        data-title="Enter Rso" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['RSO']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-value="<?php echo $data['Door_Style']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Door_Style" 
                                                        data-title="Enter Door Style" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Door_Style']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Wood" 
                                                        data-title="Enter Wood" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Wood']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Colour" 
                                                        data-title="Enter Colour" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Colour']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-value="<?php echo $data['Requested_Date']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Requested_Date" 
                                                        data-title="Enter Requested Date" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Requested_Date']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-value="<?php echo $data['Inv']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Inv" 
                                                        data-title="Enter Inv" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Inv']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-step="1" 
                                                        data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-value="<?php echo $data['Uppers']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Uppers" 
                                                        data-title="Enter Uppers" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Uppers']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-step="1" 
                                                        data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-value="<?php echo $data['Talls']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Talls" 
                                                        data-title="Enter Talls" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Talls']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-step="1" 
                                                        data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-value="<?php echo $data['Bases']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Bases" 
                                                        data-title="Enter Bases" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Bases']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-step="1" 
                                                        data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-value="<?php echo $data['Vanities']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Vanities" 
                                                        data-title="Enter Vanities" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Vanities']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-step="1" 
                                                        data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-value="<?php echo $data['Accessories']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Accessories" 
                                                        data-title="Enter Accessories" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Accessories']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-step="1" 
                                                        data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-value="<?php echo $data['Value']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Value" 
                                                        data-title="Enter Value" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Value']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Door_Vendor" 
                                                        data-title="Enter Door Vendor" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Door_Vendor']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-value="<?php echo $data['Standard_Lead_Time']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Standard_Lead_Time" 
                                                        data-title="Enter Standard Lead Time" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Standard_Lead_Time']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-value="<?php echo $data['Other_ETA']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Other_ETA" 
                                                        data-title="Enter Other Eta" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Other_ETA']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-value="<?php echo $data['Door_ETA']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Door_ETA" 
                                                        data-title="Enter Door Eta" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Door_ETA']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-value="<?php echo $data['Proposed_Shipping_Date']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Proposed_Shipping_Date" 
                                                        data-title="Enter Proposed Shipping Date" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Proposed_Shipping_Date']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Shipping_Comments" 
                                                        data-title="Enter Shipping Comments" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Shipping_Comments']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <th class="td-btn">
                                                    
                                                    
                                                    
                                                    
                                                    
                                                </th>
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            
                                            
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                                <?php
                                if( $show_footer == true ){
                                ?>
                                <div class="">
                                    <div class="row">   
                                        <div class="col-sm-4">  
                                            <div class="py-2">  
                                                
                                                
                                                
                                            </div>
                                        </div>
                                        <div class="col">   
                                            
                                            <?php
                                            if( $show_pagination == true ){
                                            $pager = new Pagination($total_records,$record_count);
                                            $pager->page_name='jlv2_jl_5_joblist';
                                            $pager->show_page_count=true;
                                            $pager->show_record_count=true;
                                            $pager->show_page_limit=true;
                                            $pager->show_page_number_list=true;
                                            $pager->pager_link_range=5;
                                            
                                            $pager->render();
                                            }
                                            ?>
                                            
                                        </div>
                                    </div>
                                </div>
                                <?php
                                }
                                }
                                else{
                                ?>
                                <div class="text-muted animated bounce  p-3">
                                    <h4><i class="material-icons">block</i> </h4>
                                </div>
                                <?php
                                }
                                ?>
                                
                            </div>
                        </div>
                        
                    </div>
                    
                </div>
            </div>
        </div>
        
    </section>
    