
<?php

$comp_model = new SharedController;
$current_page = get_current_url();
$csrf_token = Csrf :: $token;

//Page Data From Controller
$view_data = $this->view_data;

$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;

$field_name = Router :: $field_name;
$field_value = Router :: $field_value;

$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;


?>

<section class="page">
    
    <?php
    if( $show_header == true ){
    ?>
    
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            
            <div class="row ">
                
                <div class="col-sm-4 ">
                    <h3 class="record-title">Job List</h3>
                    
                </div>
                
                <div class="col-sm-3 ">
                    
                    <a href="<?php print_link("jlv2_jl_5_joblist/add") ?>"  class="btn btn btn-primary my-1 open-page-modal">
                        <i class="material-icons">add</i>                                   
                        Add New Job 
                    </a>
                    <div data-backdrop="true" id="Btn-Modal-1" class="modal fade"  role="dialog" aria-labelledby="Btn-Modal-1" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-body p-0">
                                    
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>
                
                <div class="col-sm-5 ">
                    
                    <form  class="search" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_query_str_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="material-icons">search</i></button>
                                </div>
                            </div>
                        </form>
                        
                    </div>
                    
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <?php
                            if(!empty($field_name) || !empty($_GET['search'])){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-capitalize" href="<?php print_link('jlv2_jl_5_joblist'); ?>">
                                            <i class="material-icons">arrow_back</i> <?php echo make_readable($field_name); ?>
                                        </a>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize"><?php echo make_readable(urldecode($field_value)); ?></li>
                                    <?php 
                                    }   
                                    ?>
                                    
                                    <?php
                                    if(!empty($_GET['search'])){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-capitalize" href="<?php print_link('jlv2_jl_5_joblist') ?>">Search</a>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize"> <strong><?php echo get_value('search'); ?></strong></li>
                                    <?php
                                    }
                                    ?>
                                    
                                </ul>
                            </nav>  
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
        
        <?php
        }
        ?>
        
        <div  class="">
            <div class="container-fluid">
                
                <div class="row ">
                    
                    <div class="col-md-12 comp-grid">
                        
                        <?php $this :: display_page_errors(); ?>
                        
                        <div  class=" animated fadeIn">
                            <div id="jlv2_jl_5_joblist-list-records">
                                
                                <?php
                                if(!empty($records)){
                                ?>
                                <div class="page-records table-responsive">
                                    <table class="table table-hover table-striped table-sm">
                                        <thead class="table-header bg-dark text-light">
                                            <tr>
                                                
                                                
                                                <th > Comments</th>
                                                <th > Job Num</th>
                                                <th > Dealer</th>
                                                <th > Tagname</th>
                                                <th > Customer Number</th>
                                                <th > Door Style</th>
                                                <th > Wood</th>
                                                <th > Colour</th>
                                                <th > Uppers</th>
                                                <th > Talls</th>
                                                <th > Bases</th>
                                                <th > Vanities</th>
                                                <th > Accessories</th>
                                                <th > Value</th>
                                                <th > Status</th>
                                                <th > Lastupdated</th>
                                                
                                                <th class="td-btn"></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            
                                            <?php
                                            $counter = 0;
                                            
                                            foreach($records as $data){
                                            $rec_id = (!empty($data['JobNum']) ? urlencode($data['JobNum']) : null);
                                            $counter++;
                                            
                                            
                                            ?>
                                            <tr>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['Comments']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['cJobNum']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['Dealer']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-value="<?php echo $data['TagName']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="TagName" 
                                                        data-title="Enter Tagname (25)" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['TagName']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Customer_Number" 
                                                        data-title="Enter Customer PO Number" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Customer_Number']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-source='<?php print_link('api/json/jlv2_jl_5_joblist_Door_Style_option_list'); ?>' 
                                                        data-value="<?php echo $data['Door_Style']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Door_Style" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Door_Style']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['Wood']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-source='<?php print_link('api/json/jlv2_jl_5_joblist_Colour_option_list'); ?>' 
                                                        data-value="<?php echo $data['Colour']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Colour" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Colour']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-step="1" 
                                                        data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-value="<?php echo $data['Uppers']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Uppers" 
                                                        data-title="Enter Uppers" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Uppers']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-step="1" 
                                                        data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-value="<?php echo $data['Talls']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Talls" 
                                                        data-title="Enter Talls" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Talls']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-step="1" 
                                                        data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-value="<?php echo $data['Bases']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Bases" 
                                                        data-title="Enter Bases" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Bases']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-step="1" 
                                                        data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-value="<?php echo $data['Vanities']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Vanities" 
                                                        data-title="Enter Vanities" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Vanities']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-step="1" 
                                                        data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-value="<?php echo $data['Accessories']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Accessories" 
                                                        data-title="Enter Accessories" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Accessories']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-step="1" 
                                                        data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-value="<?php echo $data['Value']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Value" 
                                                        data-title="Enter Value" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Value']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-source='<?php print_link('api/json/jlv2_jl_5_joblist_Status_option_list'); ?>' 
                                                        data-value="<?php echo $data['Status']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Status" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Status']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-flatpickr="{ minDate: '', maxDate: ''}" 
                                                        data-source='<?php echo json_encode_quote(Menu :: $TagName); ?>' 
                                                        data-value="<?php echo $data['LastUpdated']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_5_joblist/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="LastUpdated" 
                                                        data-title="Enter Lastupdated" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['LastUpdated']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <th class="td-btn">
                                                    
                                                    
                                                    <a class="btn btn-sm btn-success has-tooltip page-modal" title="View Record" href="<?php print_link("jlv2_jl_5_joblist/view/$rec_id"); ?>">
                                                        <i class="material-icons">visibility</i> 
                                                    </a>
                                                    
                                                    
                                                    <a class="btn btn-sm btn-info has-tooltip page-modal" title="Edit This Record" href="<?php print_link("jlv2_jl_5_joblist/edit/$rec_id"); ?>">
                                                        <i class="material-icons">edit</i> 
                                                    </a>
                                                    
                                                    
                                                    
                                                </th>
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            
                                            
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                                <?php
                                if( $show_footer == true ){
                                ?>
                                <div class="">
                                    <div class="row">   
                                        <div class="col-sm-4">  
                                            <div class="py-2">  
                                                
                                                
                                                
                                            </div>
                                        </div>
                                        <div class="col">   
                                            
                                            <?php
                                            if( $show_pagination == true ){
                                            $pager = new Pagination($total_records,$record_count);
                                            $pager->page_name='jlv2_jl_5_joblist';
                                            $pager->show_page_count=true;
                                            $pager->show_record_count=true;
                                            $pager->show_page_limit=true;
                                            $pager->show_page_number_list=true;
                                            $pager->pager_link_range=5;
                                            
                                            $pager->render();
                                            }
                                            ?>
                                            
                                        </div>
                                    </div>
                                </div>
                                <?php
                                }
                                }
                                else{
                                ?>
                                <div class="text-muted animated bounce  p-3">
                                    <h4><i class="material-icons">block</i> </h4>
                                </div>
                                <?php
                                }
                                ?>
                                
                            </div>
                        </div>
                        
                    </div>
                    
                </div>
            </div>
        </div>
        
    </section>
    