
<?php

$comp_model = new SharedController;
$current_page = get_current_url();
$csrf_token = Csrf :: $token;

//Page Data From Controller
$view_data = $this->view_data;

$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;

$field_name = Router :: $field_name;
$field_value = Router :: $field_value;

$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;


?>

<section class="page">
    
    <?php
    if( $show_header == true ){
    ?>
    
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            
            <div class="row ">
                
                <div class="col-sm-4 ">
                    <h3 class="record-title">Production Status - Not Wrapped</h3>
                    
                </div>
                
                <div class="col-sm-3 ">
                    
                </div>
                
                <div class="col-sm-5 ">
                    
                    <form  class="search" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_query_str_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="material-icons">search</i></button>
                                </div>
                            </div>
                        </form>
                        
                    </div>
                    
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <?php
                            if(!empty($field_name) || !empty($_GET['search'])){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-capitalize" href="<?php print_link('jlv2_jl_7_production_status'); ?>">
                                            <i class="material-icons">arrow_back</i> <?php echo make_readable($field_name); ?>
                                        </a>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize"><?php echo make_readable(urldecode($field_value)); ?></li>
                                    <?php 
                                    }   
                                    ?>
                                    
                                    <?php
                                    if(!empty($_GET['search'])){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-capitalize" href="<?php print_link('jlv2_jl_7_production_status') ?>">Search</a>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize"> <strong><?php echo get_value('search'); ?></strong></li>
                                    <?php
                                    }
                                    ?>
                                    
                                </ul>
                            </nav>  
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                    
                    <div class="col-md-4 comp-grid">
                        
                    </div>
                    
                </div>
            </div>
        </div>
        
        <?php
        }
        ?>
        
        <div  class="">
            <div class="container-fluid">
                
                <div class="row ">
                    
                    <div class="col-md-12 comp-grid">
                        
                        <?php $this :: display_page_errors(); ?>
                        
                        <div  class=" animated fadeIn">
                            <div id="jlv2_jl_7_production_status-not_wrapped-records">
                                
                                <?php
                                if(!empty($records)){
                                ?>
                                <div class="page-records table-responsive">
                                    <table class="table table-hover table-striped table-sm">
                                        <thead class="table-header bg-dark text-light">
                                            <tr>
                                                
                                                
                                                <th > Jobnum</th>
                                                <th > Ordered</th>
                                                <th > Nested</th>
                                                <th > Finished Parts</th>
                                                <th > Wrapped</th>
                                                <th > Finishing</th>
                                                <th > Unfinished Parts</th>
                                                <th > Assembled</th>
                                                
                                                <th class="td-btn"></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            
                                            <?php
                                            $counter = 0;
                                            
                                            foreach($records as $data){
                                            $rec_id = (!empty($data['JobNum']) ? urlencode($data['JobNum']) : null);
                                            $counter++;
                                            
                                            
                                            ?>
                                            <tr>
                                                
                                                
                                                
                                                
                                                <td><a href="<?php print_link("jlv2_jl_7_production_status/$data[JobNum]") ?>"><?php echo $data['JobNum']; ?></a></td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-source='[{value: "1", label: "True"},{value: "False", label: "False"}]' 
                                                        data-value="<?php echo $data['tOrdered']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_7_production_status/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="tOrdered" 
                                                        data-title="Enter Ordered" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="bottom" 
                                                        class="is-editable" >
                                                        <?php echo $data['tOrdered']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-source='[{value: "1", label: "True"},{value: "False", label: "False"}]' 
                                                        data-value="<?php echo $data['tNested']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_7_production_status/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="tNested" 
                                                        data-title="Enter Nested" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="bottom" 
                                                        class="is-editable" >
                                                        <?php echo $data['tNested']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-source='[{value: "1", label: "True"},{value: "False", label: "False"}]' 
                                                        data-value="<?php echo $data['tFinished_Parts']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_7_production_status/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="tFinished_Parts" 
                                                        data-title="Enter Finished Parts" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="bottom" 
                                                        class="is-editable" >
                                                        <?php echo $data['tFinished_Parts']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-source='[{value: "1", label: "True"},{value: "False", label: "False"}]' 
                                                        data-value="<?php echo $data['tWrapped']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_7_production_status/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="tWrapped" 
                                                        data-title="Enter Wrapped" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="bottom" 
                                                        class="is-editable" >
                                                        <?php echo $data['tWrapped']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-source='[{value: "1", label: "True"},{value: "False", label: "False"}]' 
                                                        data-value="<?php echo $data['tFinishing']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_7_production_status/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="tFinishing" 
                                                        data-title="Enter Finishing" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="bottom" 
                                                        class="is-editable" >
                                                        <?php echo $data['tFinishing']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-source='[{value: "1", label: "True"},{value: "False", label: "False"}]' 
                                                        data-value="<?php echo $data['tUnfinished_Parts']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_7_production_status/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="tUnfinished_Parts" 
                                                        data-title="Enter Unfinished Parts" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="bottom" 
                                                        class="is-editable" >
                                                        <?php echo $data['tUnfinished_Parts']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <td>
                                                    <a  data-source='[{value: "1", label: "True"},{value: "False", label: "False"}]' 
                                                        data-value="<?php echo $data['tAssembled']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("jlv2_jl_7_production_status/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="tAssembled" 
                                                        data-title="Enter Assembled" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="bottom" 
                                                        class="is-editable" >
                                                        <?php echo $data['tAssembled']; ?>  
                                                    </a>
                                                </td>
                                                
                                                
                                                
                                                
                                                <th class="td-btn">
                                                    
                                                    
                                                    <a class="btn btn-sm btn-success has-tooltip" title="View Record" href="<?php print_link("jlv2_jl_7_production_status/view/$rec_id"); ?>">
                                                        <i class="material-icons">visibility</i> 
                                                    </a>
                                                    
                                                    
                                                    <a class="btn btn-sm btn-info has-tooltip" title="Edit This Record" href="<?php print_link("jlv2_jl_7_production_status/edit/$rec_id"); ?>">
                                                        <i class="material-icons">edit</i> 
                                                    </a>
                                                    
                                                    
                                                    
                                                </th>
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            
                                            
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                                <?php
                                if( $show_footer == true ){
                                ?>
                                <div class="">
                                    <div class="row">   
                                        <div class="col-sm-4">  
                                            <div class="py-2">  
                                                
                                                
                                                
                                            </div>
                                        </div>
                                        <div class="col">   
                                            
                                            <?php
                                            if( $show_pagination == true ){
                                            $pager = new Pagination($total_records,$record_count);
                                            $pager->page_name='jlv2_jl_7_production_status';
                                            $pager->show_page_count=true;
                                            $pager->show_record_count=true;
                                            $pager->show_page_limit=true;
                                            $pager->show_page_number_list=true;
                                            $pager->pager_link_range=5;
                                            
                                            $pager->render();
                                            }
                                            ?>
                                            
                                        </div>
                                    </div>
                                </div>
                                <?php
                                }
                                }
                                else{
                                ?>
                                <div class="text-muted animated bounce  p-3">
                                    <h4><i class="material-icons">block</i> </h4>
                                </div>
                                <?php
                                }
                                ?>
                                
                            </div>
                        </div>
                        
                    </div>
                    
                </div>
            </div>
        </div>
        
        <div  class="">
            <div class="container">
                
                <div class="row ">
                    
                    <div class="col-md-12 comp-grid">
                        
                    </div>
                    
                </div>
            </div>
        </div>
        
        <div  class="">
            <div class="container">
                
                <div class="row ">
                    
                    <div class="col-md-12 comp-grid">
                        
                    </div>
                    
                </div>
            </div>
        </div>
        
    </section>
    