
<?php

$comp_model = new SharedController;
$current_page = get_current_url();
$csrf_token = Csrf :: $token;

//Page Data From Controller
$view_data = $this->view_data;

$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;

$field_name = Router :: $field_name;
$field_value = Router :: $field_value;

$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;


?>

<section class="page">
    
    <?php
    if( $show_header == true ){
    ?>
    
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            
            <div class="row ">
                
                <div class="col-sm-4 ">
                    <h3 class="record-title">Jlv2 Joblist Production</h3>
                    
                </div>
                
                <div class="col-sm-5 ">
                    
                    <form  class="search" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_query_str_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="material-icons">search</i></button>
                                </div>
                            </div>
                        </form>
                        
                    </div>
                    
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <?php
                            if(!empty($field_name) || !empty($_GET['search'])){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-capitalize" href="<?php print_link('jlv2_joblist_production'); ?>">
                                            <i class="material-icons">arrow_back</i> <?php echo make_readable($field_name); ?>
                                        </a>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize"><?php echo make_readable(urldecode($field_value)); ?></li>
                                    <?php 
                                    }   
                                    ?>
                                    
                                    <?php
                                    if(!empty($_GET['search'])){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-capitalize" href="<?php print_link('jlv2_joblist_production') ?>">Search</a>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize"> <strong><?php echo get_value('search'); ?></strong></li>
                                    <?php
                                    }
                                    ?>
                                    
                                </ul>
                            </nav>  
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
        
        <?php
        }
        ?>
        
        <div  class="">
            <div class="container-fluid">
                
                <div class="row ">
                    
                    <div class="col-md-12 comp-grid">
                        
                        <?php $this :: display_page_errors(); ?>
                        
                        <div  class=" animated fadeIn">
                            <div id="jlv2_joblist_production-list-records">
                                
                                <?php
                                if(!empty($records)){
                                ?>
                                <div class="page-records table-responsive">
                                    <table class="table table-hover table-striped table-sm">
                                        <thead class="table-header bg-primary text-light">
                                            <tr>
                                                
                                                
                                                <th > Comments</th>
                                                <th > Jobnum</th>
                                                <th > Dealer</th>
                                                <th > Tagname</th>
                                                <th > Customer Number</th>
                                                <th > Colour</th>
                                                <th > Uppers</th>
                                                <th > Talls</th>
                                                <th > Bases</th>
                                                <th > Vanities</th>
                                                <th > Accessories</th>
                                                <th > Value</th>
                                                <th > Ordered</th>
                                                <th > Nested</th>
                                                <th > Finished Parts</th>
                                                <th > Wrapped</th>
                                                <th > Finishing</th>
                                                <th > Unfinished Parts</th>
                                                <th > Assembled</th>
                                                <th > Inv</th>
                                                <th > Proposed Shipping Date</th>
                                                <th > Shipping Comments</th>
                                                
                                                
                                            </tr>
                                        </thead>
                                        <tbody>
                                            
                                            <?php
                                            $counter = 0;
                                            
                                            foreach($records as $data){
                                            $rec_id = (!empty($data['']) ? urlencode($data['']) : null);
                                            $counter++;
                                            
                                            
                                            ?>
                                            <tr>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['Comments']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['JobNum']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['Dealer']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['TagName']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['Customer_Number']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['Colour']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['Uppers']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['Talls']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['Bases']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['Vanities']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['Accessories']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['Value']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['tOrdered']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['tNested']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['tFinished_Parts']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['tWrapped']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['tFinishing']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['tUnfinished_Parts']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['tAssembled']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['Inv']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['Proposed_Shipping_Date']; ?> </td>
                                                
                                                
                                                
                                                
                                                <td> <?php echo $data['Shipping_Comments']; ?> </td>
                                                
                                                
                                                
                                                
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            
                                            
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                                <?php
                                if( $show_footer == true ){
                                ?>
                                <div class="">
                                    <div class="row">   
                                        <div class="col-sm-4">  
                                            <div class="py-2">  
                                                
                                                
                                                
                                            </div>
                                        </div>
                                        <div class="col">   
                                            
                                            <?php
                                            if( $show_pagination == true ){
                                            $pager = new Pagination($total_records,$record_count);
                                            $pager->page_name='jlv2_joblist_production';
                                            $pager->show_page_count=true;
                                            $pager->show_record_count=true;
                                            $pager->show_page_limit=true;
                                            $pager->show_page_number_list=true;
                                            $pager->pager_link_range=5;
                                            
                                            $pager->render();
                                            }
                                            ?>
                                            
                                        </div>
                                    </div>
                                </div>
                                <?php
                                }
                                }
                                else{
                                ?>
                                <div class="text-muted animated bounce  p-3">
                                    <h4><i class="material-icons">block</i> </h4>
                                </div>
                                <?php
                                }
                                ?>
                                
                            </div>
                        </div>
                        
                    </div>
                    
                </div>
            </div>
        </div>
        
    </section>
    