<?php 
/**
 * Bg_1_dd_bg4_product_sub_group Page Controller
 * @category  Controller
 */
class Bg_1_dd_bg4_product_sub_groupController extends SecureController{
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function index($fieldname = null , $fieldvalue = null){
		$db = $this->GetModel();
		$fields = array('pk_bg4_product_sub_group_id', 	'List', 	'Full', 	'Updated_By', 	'TimeStamp');
		$limit = $this->get_page_limit(MAX_RECORD_COUNT); // return pagination from BaseModel Class e.g array(5,20)
		if(!empty($this->search)){
			$text = $this->search;
			$db->orWhere('pk_bg4_product_sub_group_id',"%$text%",'LIKE');
			$db->orWhere('List',"%$text%",'LIKE');
			$db->orWhere('Full',"%$text%",'LIKE');
			$db->orWhere('Updated_By',"%$text%",'LIKE');
			$db->orWhere('TimeStamp',"%$text%",'LIKE');
		}
		if(!empty($this->orderby)){ // when order by request fields (from $_GET param)
			$db->orderBy($this->orderby,$this->ordertype);
		}
		else{
			$db->orderBy('pk_bg4_product_sub_group_id', ORDER_TYPE);
		}
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get('bg_1_dd_bg4_product_sub_group', $limit, $fields);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		if($db->getLastError()){
			$this->view->page_error = $db->getLastError();
		}
		$this->view->page_title ="DD Product Sub Group";
		$this->view->render('bg_1_dd_bg4_product_sub_group/list.php' , $data ,'main_layout.php');
	}
	/**
     * View Record Action 
     * @return View
     */
	function view( $rec_id = null , $value = null){
		$db = $this->GetModel();
		$fields = array( 'pk_bg4_product_sub_group_id', 	'List', 	'Full', 	'Updated_By', 	'TimeStamp' );
		if( !empty($value) ){
			$db->where($rec_id, urldecode($value));
		}
		else{
			$db->where('pk_bg4_product_sub_group_id' , $rec_id);
		}
		$record = $db->getOne( 'bg_1_dd_bg4_product_sub_group', $fields );
		if(!empty($record)){
			$this->view->page_title ="DD Product Sub Group";
			$this->view->render('bg_1_dd_bg4_product_sub_group/view.php' , $record ,'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error = $db->getLastError();
			}
			else{
				$this->view->page_error = "Record not found";
			}
			$this->view->render('bg_1_dd_bg4_product_sub_group/view.php' , $record , 'main_layout.php');
		}
	}
	/**
     * Add New Record Action 
     * If Not $_POST Request, Display Add Record Form View
     * @return View
     */
	function add(){
		if(is_post_request()){
			$db = $this->GetModel();
			$modeldata = transform_request_data($_POST);
			Csrf :: cross_check();
			$rules_array = array(
				'List' => 'required',
				'Full' => 'required',
				'Updated_By' => 'required',
			);
			$filter_array = array(
				'List' => 'sanitize_string',
				'Full' => 'sanitize_string',
				'Updated_By' => 'sanitize_string',
			);
			$modeldata = GUMP::filter_input($modeldata, $filter_array); //remove unwanted html characters to prevent xss attack
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}
			if( empty($this->view->page_error) ){
				$rec_id = $db->insert( 'bg_1_dd_bg4_product_sub_group' , $modeldata );
				if(!empty($rec_id)){
					set_flash_msg('','');
					redirect_to_page("bg_1_dd_bg4_product_sub_group");
					return;
				}
				else{
					if($db->getLastError()){
						$this->view->page_error[] = $db->getLastError();
					}
					else{
						$this->view->page_error[] = "Error inserting record";
					}
				}
			}
		}
		$this->view->page_title ="Product Sub Group";
		$this->view->render('bg_1_dd_bg4_product_sub_group/add.php' ,null,'main_layout.php');
	}
	/**
     * Edit Record Action 
     * If Not $_POST Request, Display Edit Record Form View
     * @return View
     */
	function edit($rec_id=null){
		$db = $this->GetModel();
		if(is_post_request()){
			$modeldata = transform_request_data($_POST);
			Csrf :: cross_check();
			$rules_array = array(
				'List' => 'required',
				'Full' => 'required',
				'Updated_By' => 'required',
			);
			$filter_array = array(
				'List' => 'sanitize_string',
				'Full' => 'sanitize_string',
				'Updated_By' => 'sanitize_string',
			);
			$modeldata = GUMP::filter_input($modeldata, $filter_array); //remove unwanted html characters to prevent xss attack
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}
			if(empty($this->view->page_error)){
				$db->where('pk_bg4_product_sub_group_id' , $rec_id);
				$bool = $db->update('bg_1_dd_bg4_product_sub_group',$modeldata);
				if($bool){
					set_flash_msg('','');
					redirect_to_page("bg_1_dd_bg4_product_sub_group");
					return;
				}
				else{
					$this->view->page_error[] = $db->getLastError();
				}
			}
		}
		$fields = array('pk_bg4_product_sub_group_id','List','Full','Updated_By');
		$db->where('pk_bg4_product_sub_group_id' , $rec_id);
		$data = $db->getOne('bg_1_dd_bg4_product_sub_group',$fields);
		$this->view->page_title ="Edit  Product Sub Group";
		if(!empty($data)){
			$this->view->render('bg_1_dd_bg4_product_sub_group/edit.php' , $data, 'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error[] = $db->getLastError();
			}
			else{
				$this->view->page_error[] = "Record not found";
			}
			$this->view->render('bg_1_dd_bg4_product_sub_group/edit.php' , $data , 'main_layout.php');
		}
	}
	/**
     * Delete Record Action 
     * @return View
     */
	function delete( $rec_ids = null ){
		Csrf :: cross_check();
		$db = $this->GetModel();
		$arr_id = explode( ',', $rec_ids );
		foreach( $arr_id as $rec_id ){
			$db->where('pk_bg4_product_sub_group_id' , $rec_id,"=",'OR');
		}
		$bool = $db->delete( 'bg_1_dd_bg4_product_sub_group' );
		if($bool){
			set_flash_msg("Data Deleted",'success');
		}
		else{
			if($db->getLastError()){
				set_flash_msg($db->getLastError(),'danger');
			}
			else{
				set_flash_msg("Error deleting the record. please make sure that the record exit",'danger');
			}
		}
		redirect_to_page("bg_1_dd_bg4_product_sub_group");
	}
}
