<?php 
/**
 * Bg_5_products_latest Page Controller
 * @category  Controller
 */
class Bg_5_products_latestController extends SecureController{
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function index($fieldname = null , $fieldvalue = null){
		$db = $this->GetModel();
		$fields = array('products_id', 	'PRODUCT_CODE', 	'DESCRIPTION', 	'Price', 	'Price_Date', 	'STATUS', 	'Product_Type', 	'Product_Sub_Group', 	'Supplier_List_Price', 	'Retail_List_Price', 	'Supplier_ID', 	'Supplier_Code', 	'Finished_End', 	'Drawer_Size', 	'TSK', 	'New_Product_Type', 	'New_Product_Sub_Group', 	'Update_By', 	'timestamp');
		$limit = $this->get_page_limit(MAX_RECORD_COUNT); // return pagination from BaseModel Class e.g array(5,20)
		if(!empty($this->search)){
			$text = $this->search;
			$db->orWhere('products_id',"%$text%",'LIKE');
			$db->orWhere('PRODUCT_CODE',"%$text%",'LIKE');
			$db->orWhere('DESCRIPTION',"%$text%",'LIKE');
			$db->orWhere('Price',"%$text%",'LIKE');
			$db->orWhere('Price_Date',"%$text%",'LIKE');
			$db->orWhere('STATUS',"%$text%",'LIKE');
			$db->orWhere('Product_Type',"%$text%",'LIKE');
			$db->orWhere('Product_Sub_Group',"%$text%",'LIKE');
			$db->orWhere('Supplier_List_Price',"%$text%",'LIKE');
			$db->orWhere('Retail_List_Price',"%$text%",'LIKE');
			$db->orWhere('Supplier_ID',"%$text%",'LIKE');
			$db->orWhere('Supplier_Code',"%$text%",'LIKE');
			$db->orWhere('Finished_End',"%$text%",'LIKE');
			$db->orWhere('Drawer_Size',"%$text%",'LIKE');
			$db->orWhere('TSK',"%$text%",'LIKE');
			$db->orWhere('New_Product_Type',"%$text%",'LIKE');
			$db->orWhere('New_Product_Sub_Group',"%$text%",'LIKE');
			$db->orWhere('Update_By',"%$text%",'LIKE');
			$db->orWhere('timestamp',"%$text%",'LIKE');
		}
		if(!empty($this->orderby)){ // when order by request fields (from $_GET param)
			$db->orderBy($this->orderby,$this->ordertype);
		}
		else{
			$db->orderBy('products_id', ORDER_TYPE);
		}
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get('bg_5_products_latest', $limit, $fields);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		if($db->getLastError()){
			$this->view->page_error = $db->getLastError();
		}
		$this->view->page_title ="Latest Products";
		$this->view->render('bg_5_products_latest/list.php' , $data ,'main_layout.php');
	}
	/**
     * View Record Action 
     * @return View
     */
	function view( $rec_id = null , $value = null){
		$db = $this->GetModel();
		$fields = array( 'products_id', 	'PRODUCT_CODE', 	'DESCRIPTION', 	'Price', 	'Price_Date', 	'STATUS', 	'Product_Type', 	'Product_Sub_Group', 	'Supplier_List_Price', 	'Retail_List_Price', 	'Supplier_ID', 	'Supplier_Code', 	'Finished_End', 	'Drawer_Size', 	'TSK', 	'New_Product_Type', 	'New_Product_Sub_Group', 	'Update_By', 	'timestamp' );
		if( !empty($value) ){
			$db->where($rec_id, urldecode($value));
		}
		else{
			$db->where('products_id' , $rec_id);
		}
		$record = $db->getOne( 'bg_5_products_latest', $fields );
		if(!empty($record)){
			$this->view->page_title ="View  Products";
			$this->view->render('bg_5_products_latest/view.php' , $record ,'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error = $db->getLastError();
			}
			else{
				$this->view->page_error = "Record not found";
			}
			$this->view->render('bg_5_products_latest/view.php' , $record , 'main_layout.php');
		}
	}
	/**
     * Add New Record Action 
     * If Not $_POST Request, Display Add Record Form View
     * @return View
     */
	function add(){
		if(is_post_request()){
			$db = $this->GetModel();
			$modeldata = transform_request_data($_POST);
			Csrf :: cross_check();
			$rules_array = array(
				'PRODUCT_CODE' => 'required',
				'DESCRIPTION' => 'required',
				'Price' => 'required|numeric',
				'Price_Date' => 'required',
				'STATUS' => 'required',
				'Product_Type' => 'required',
				'Product_Sub_Group' => 'required',
				'Supplier_List_Price' => 'required|numeric',
				'Retail_List_Price' => 'required|numeric',
				'Supplier_ID' => 'required',
				'Supplier_Code' => 'required',
				'Finished_End' => 'required',
				'Drawer_Size' => 'required',
				'TSK' => 'required',
				'New_Product_Type' => 'required',
				'New_Product_Sub_Group' => 'required',
				'Update_By' => 'required',
			);
			$filter_array = array(
				'PRODUCT_CODE' => 'sanitize_string',
				'DESCRIPTION' => 'sanitize_string',
				'Price' => 'sanitize_string',
				'Price_Date' => 'sanitize_string',
				'STATUS' => 'sanitize_string',
				'Product_Type' => 'sanitize_string',
				'Product_Sub_Group' => 'sanitize_string',
				'Supplier_List_Price' => 'sanitize_string',
				'Retail_List_Price' => 'sanitize_string',
				'Supplier_ID' => 'sanitize_string',
				'Supplier_Code' => 'sanitize_string',
				'Finished_End' => 'sanitize_string',
				'Drawer_Size' => 'sanitize_string',
				'TSK' => 'sanitize_string',
				'New_Product_Type' => 'sanitize_string',
				'New_Product_Sub_Group' => 'sanitize_string',
				'Update_By' => 'sanitize_string',
			);
			$modeldata = GUMP::filter_input($modeldata, $filter_array); //remove unwanted html characters to prevent xss attack
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}
			if( empty($this->view->page_error) ){
				$rec_id = $db->insert( 'bg_5_products_latest' , $modeldata );
				if(!empty($rec_id)){
					set_flash_msg('','');
					redirect_to_page("bg_5_products_latest");
					return;
				}
				else{
					if($db->getLastError()){
						$this->view->page_error[] = $db->getLastError();
					}
					else{
						$this->view->page_error[] = "Error inserting record";
					}
				}
			}
		}
		$this->view->page_title ="Add New Product";
		$this->view->render('bg_5_products_latest/add.php' ,null,'main_layout.php');
	}
	/**
     * Edit Record Action 
     * If Not $_POST Request, Display Edit Record Form View
     * @return View
     */
	function edit($rec_id=null){
		$db = $this->GetModel();
		if(is_post_request()){
			$modeldata = transform_request_data($_POST);
			Csrf :: cross_check();
			$rules_array = array(
				'PRODUCT_CODE' => 'required',
				'DESCRIPTION' => 'required',
				'Price' => 'required|numeric',
				'Price_Date' => 'required',
				'STATUS' => 'required',
				'Product_Type' => 'required',
				'Product_Sub_Group' => 'required',
				'Supplier_List_Price' => 'required|numeric',
				'Retail_List_Price' => 'required|numeric',
				'Supplier_ID' => 'required',
				'Supplier_Code' => 'required',
				'Finished_End' => 'required',
				'Drawer_Size' => 'required',
				'TSK' => 'required',
				'New_Product_Type' => 'required',
				'New_Product_Sub_Group' => 'required',
				'Update_By' => 'required',
			);
			$filter_array = array(
				'PRODUCT_CODE' => 'sanitize_string',
				'DESCRIPTION' => 'sanitize_string',
				'Price' => 'sanitize_string',
				'Price_Date' => 'sanitize_string',
				'STATUS' => 'sanitize_string',
				'Product_Type' => 'sanitize_string',
				'Product_Sub_Group' => 'sanitize_string',
				'Supplier_List_Price' => 'sanitize_string',
				'Retail_List_Price' => 'sanitize_string',
				'Supplier_ID' => 'sanitize_string',
				'Supplier_Code' => 'sanitize_string',
				'Finished_End' => 'sanitize_string',
				'Drawer_Size' => 'sanitize_string',
				'TSK' => 'sanitize_string',
				'New_Product_Type' => 'sanitize_string',
				'New_Product_Sub_Group' => 'sanitize_string',
				'Update_By' => 'sanitize_string',
			);
			$modeldata = GUMP::filter_input($modeldata, $filter_array); //remove unwanted html characters to prevent xss attack
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}
			if(empty($this->view->page_error)){
				$db->where('products_id' , $rec_id);
				$bool = $db->update('bg_5_products_latest',$modeldata);
				if($bool){
					set_flash_msg('','');
					redirect_to_page("bg_5_products_latest");
					return;
				}
				else{
					$this->view->page_error[] = $db->getLastError();
				}
			}
		}
		$fields = array('products_id','PRODUCT_CODE','DESCRIPTION','Price','Price_Date','STATUS','Product_Type','Product_Sub_Group','Supplier_List_Price','Retail_List_Price','Supplier_ID','Supplier_Code','Finished_End','Drawer_Size','TSK','New_Product_Type','New_Product_Sub_Group','Update_By');
		$db->where('products_id' , $rec_id);
		$data = $db->getOne('bg_5_products_latest',$fields);
		$this->view->page_title ="Edit Product";
		if(!empty($data)){
			$this->view->render('bg_5_products_latest/edit.php' , $data, 'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error[] = $db->getLastError();
			}
			else{
				$this->view->page_error[] = "Record not found";
			}
			$this->view->render('bg_5_products_latest/edit.php' , $data , 'main_layout.php');
		}
	}
	/**
     * Delete Record Action 
     * @return View
     */
	function delete( $rec_ids = null ){
		Csrf :: cross_check();
		$db = $this->GetModel();
		$arr_id = explode( ',', $rec_ids );
		foreach( $arr_id as $rec_id ){
			$db->where('products_id' , $rec_id,"=",'OR');
		}
		$bool = $db->delete( 'bg_5_products_latest' );
		if($bool){
			set_flash_msg("Data Deleted",'success');
		}
		else{
			if($db->getLastError()){
				set_flash_msg($db->getLastError(),'danger');
			}
			else{
				set_flash_msg("Error deleting the record. please make sure that the record exit",'danger');
			}
		}
		redirect_to_page("bg_5_products_latest");
	}
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function list_for_dealers($fieldname = null , $fieldvalue = null){
		$db = $this->GetModel();
		$fields = array('products_id', 	'PRODUCT_CODE', 	'DESCRIPTION', 	'Price', 	'Price_Date', 	'STATUS', 	'Supplier_List_Price', 	'Retail_List_Price', 	'Supplier_ID', 	'Supplier_Code', 	'Finished_End', 	'Drawer_Size', 	'TSK', 	'New_Product_Type', 	'New_Product_Sub_Group');
		$limit = $this->get_page_limit(MAX_RECORD_COUNT); // return pagination from BaseModel Class e.g array(5,20)
		if(!empty($this->search)){
			$text = $this->search;
			$db->orWhere('products_id',"%$text%",'LIKE');
			$db->orWhere('PRODUCT_CODE',"%$text%",'LIKE');
			$db->orWhere('DESCRIPTION',"%$text%",'LIKE');
			$db->orWhere('Price',"%$text%",'LIKE');
			$db->orWhere('Price_Date',"%$text%",'LIKE');
			$db->orWhere('STATUS',"%$text%",'LIKE');
			$db->orWhere('Product_Type',"%$text%",'LIKE');
			$db->orWhere('Product_Sub_Group',"%$text%",'LIKE');
			$db->orWhere('Supplier_List_Price',"%$text%",'LIKE');
			$db->orWhere('Retail_List_Price',"%$text%",'LIKE');
			$db->orWhere('Supplier_ID',"%$text%",'LIKE');
			$db->orWhere('Supplier_Code',"%$text%",'LIKE');
			$db->orWhere('Finished_End',"%$text%",'LIKE');
			$db->orWhere('Drawer_Size',"%$text%",'LIKE');
			$db->orWhere('TSK',"%$text%",'LIKE');
			$db->orWhere('New_Product_Type',"%$text%",'LIKE');
			$db->orWhere('New_Product_Sub_Group',"%$text%",'LIKE');
			$db->orWhere('Update_By',"%$text%",'LIKE');
			$db->orWhere('timestamp',"%$text%",'LIKE');
		}
		if(!empty($this->orderby)){ // when order by request fields (from $_GET param)
			$db->orderBy($this->orderby,$this->ordertype);
		}
		else{
			$db->orderBy('products_id', ORDER_TYPE);
		}
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get('bg_5_products_latest', $limit, $fields);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		if($db->getLastError()){
			$this->view->page_error = $db->getLastError();
		}
		$this->view->page_title ="Latest Products";
		$this->view->render('bg_5_products_latest/list_for_dealers.php' , $data ,'main_layout.php');
	}
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function list_for_access($fieldname = null , $fieldvalue = null){
		$db = $this->GetModel();
		$fields = array('products_id', 	'PRODUCT_CODE', 	'DESCRIPTION', 	'Price', 	'Price_Date', 	'STATUS', 	'Product_Type', 	'Product_Sub_Group', 	'Supplier_List_Price', 	'Retail_List_Price', 	'Supplier_ID', 	'Supplier_Code', 	'Finished_End', 	'Drawer_Size', 	'TSK');
		$limit = $this->get_page_limit(MAX_RECORD_COUNT); // return pagination from BaseModel Class e.g array(5,20)
		if(!empty($this->search)){
			$text = $this->search;
			$db->orWhere('products_id',"%$text%",'LIKE');
			$db->orWhere('PRODUCT_CODE',"%$text%",'LIKE');
			$db->orWhere('DESCRIPTION',"%$text%",'LIKE');
			$db->orWhere('Price',"%$text%",'LIKE');
			$db->orWhere('Price_Date',"%$text%",'LIKE');
			$db->orWhere('STATUS',"%$text%",'LIKE');
			$db->orWhere('Product_Type',"%$text%",'LIKE');
			$db->orWhere('Product_Sub_Group',"%$text%",'LIKE');
			$db->orWhere('Supplier_List_Price',"%$text%",'LIKE');
			$db->orWhere('Retail_List_Price',"%$text%",'LIKE');
			$db->orWhere('Supplier_ID',"%$text%",'LIKE');
			$db->orWhere('Supplier_Code',"%$text%",'LIKE');
			$db->orWhere('Finished_End',"%$text%",'LIKE');
			$db->orWhere('Drawer_Size',"%$text%",'LIKE');
			$db->orWhere('TSK',"%$text%",'LIKE');
			$db->orWhere('New_Product_Type',"%$text%",'LIKE');
			$db->orWhere('New_Product_Sub_Group',"%$text%",'LIKE');
			$db->orWhere('Update_By',"%$text%",'LIKE');
			$db->orWhere('timestamp',"%$text%",'LIKE');
		}
		if(!empty($this->orderby)){ // when order by request fields (from $_GET param)
			$db->orderBy($this->orderby,$this->ordertype);
		}
		else{
			$db->orderBy('products_id', ORDER_TYPE);
		}
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get('bg_5_products_latest', $limit, $fields);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		if($db->getLastError()){
			$this->view->page_error = $db->getLastError();
		}
		$this->view->page_title ="Latest Products";
		$this->view->render('bg_5_products_latest/list_for_access.php' , $data ,'main_layout.php');
	}
}
