
<?php

$comp_model = new SharedController;

$csrf_token = Csrf :: $token;

//Page Data From Controller
$view_data = $this->view_data;

$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = Router :: $field_name;
$field_value = Router :: $field_value;

$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;

?>

<section class="page">
    
    <?php
    if( $show_header == true ){
    ?>
    
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            
            <div class="row ">
                
                <div class="col-sm-4 comp-grid">
                    <h3 class="record-title">Bg 5 Products Latest</h3>
                    
                </div>
                
                <div class="col-sm-3 comp-grid">
                    
                    <a  class="btn btn btn-primary btn-block" href="<?php print_link("bg_5_products_latest/add") ?>">
                        <i class="material-icons">add</i>                               
                        Add New Bg 5 Products Latest 
                    </a>
                    
                </div>
                
                <div class="col-sm-5 comp-grid">
                    
                    <form  class="search" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_query_str_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="material-icons">search</i></button>
                                </div>
                            </div>
                        </form>
                        
                    </div>
                    
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <?php
                            if(!empty($field_name) || !empty($field_name)){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item"><a class="text-capitalize" href="<?php print_link('bg_5_products_latest') ?>"><?php echo $field_name ?></a></li>
                                    <li  class="breadcrumb-item active text-capitalize"><?php echo urldecode($field_value) ?></li>
                                    <?php 
                                    }   
                                    ?>
                                    <?php
                                    if(!empty($_GET['search'])){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-capitalize" href="<?php print_link('bg_5_products_latest') ?>">Search</a>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize"> <strong><?php echo get_value('search'); ?></strong></li>
                                    <?php
                                    }
                                    ?>
                                    
                                </ul>
                            </nav>  
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
        
        <?php
        }
        ?>
        
        <div  class="">
            <div class="container-fluid">
                
                <div class="row ">
                    
                    <div class="col-md-12 comp-grid">
                        
                        <?php $this :: display_page_errors(); ?>
                        
                        <div  class="card animated fadeIn">
                            <div id="bg_5_products_latest-list_for_dealers-records">
                                
                                <?php
                                if(!empty($records)){
                                ?>
                                <div class="page-records table-responsive">
                                    <table class="table table-hover table-striped table-sm">
                                        <thead class="table-header bg-light">
                                            <tr>
                                                
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='PRODUCT_CODE' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('PRODUCT_CODE', "Product Code"); ?>
                                                </th>
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='DESCRIPTION' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('DESCRIPTION', "Description"); ?>
                                                </th>
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='Price' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('Price', "Price"); ?>
                                                </th>
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='Price_Date' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('Price_Date', "Price Date"); ?>
                                                </th>
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='STATUS' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('STATUS', "Status"); ?>
                                                </th>
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='Supplier_List_Price' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('Supplier_List_Price', "Supplier List Price"); ?>
                                                </th>
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='Retail_List_Price' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('Retail_List_Price', "Retail List Price"); ?>
                                                </th>
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='Supplier_ID' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('Supplier_ID', "Supplier Id"); ?>
                                                </th>
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='Supplier_Code' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('Supplier_Code', "Supplier Code"); ?>
                                                </th>
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='Finished_End' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('Finished_End', "Finished End"); ?>
                                                </th>
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='Drawer_Size' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('Drawer_Size', "Drawer Size"); ?>
                                                </th>
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='TSK' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('TSK', "Tsk"); ?>
                                                </th>
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='New_Product_Type' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('New_Product_Type', "New Product Type"); ?>
                                                </th>
                                                
                                                
                                                <th  <?php echo (get_query_str_value('orderby')=='New_Product_Sub_Group' ? 'class="sortedby"' : null); ?>>
                                                    
                                                    <?php Html :: get_field_order_link('New_Product_Sub_Group', "New Product Sub Group"); ?>
                                                </th>
                                                
                                                
                                                <th class="td-btn"></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            
                                            <?php
                                            $counter = 0;
                                            
                                            foreach($records as $data){
                                            $counter++;
                                            
                                            ?>
                                            <tr>
                                                
                                                
                                                <td> <?php echo $data['PRODUCT_CODE']; ?> </td>
                                                <td> <?php echo $data['DESCRIPTION']; ?> </td>
                                                <td> <?php echo $data['Price']; ?> </td>
                                                <td> <?php echo $data['Price_Date']; ?> </td>
                                                <td> <?php echo $data['STATUS']; ?> </td>
                                                <td> <?php echo $data['Supplier_List_Price']; ?> </td>
                                                <td> <?php echo $data['Retail_List_Price']; ?> </td>
                                                <td> <?php echo $data['Supplier_ID']; ?> </td>
                                                <td> <?php echo $data['Supplier_Code']; ?> </td>
                                                <td> <?php echo $data['Finished_End']; ?> </td>
                                                <td> <?php echo $data['Drawer_Size']; ?> </td>
                                                <td> <?php echo $data['TSK']; ?> </td>
                                                <td> <?php echo $data['New_Product_Type']; ?> </td>
                                                <td> <?php echo $data['New_Product_Sub_Group']; ?> </td>
                                                
                                                
                                                <th class="td-btn">
                                                    
                                                    
                                                    <a class="btn btn-sm btn-success has-tooltip" title="View Record" href="<?php print_link('bg_5_products_latest/view/'.$data['products_id']); ?>">
                                                        <i class="material-icons">visibility</i> 
                                                    </a>
                                                    
                                                    
                                                    <a class="btn btn-sm btn-info has-tooltip" title="Edit This Record" href="<?php print_link('bg_5_products_latest/edit/'.$data['products_id']); ?>">
                                                        <i class="material-icons">edit</i> 
                                                    </a>
                                                    
                                                    
                                                    <a class="btn btn-sm btn-danger recordDeletePromptAction has-tooltip" title="Delete this record" href="<?php print_link("bg_5_products_latest/delete/$data[products_id]/?csrf_token=$csrf_token"); ?>" data-prompt-msg="">
                                                        <i class="material-icons">clear</i>
                                                        
                                                    </a>
                                                    
                                                    
                                                </th>
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            
                                            
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                                <?php
                                if( $show_footer == true ){
                                ?>
                                <div class="card-footer">
                                    <div class="row">   
                                        <div class="col-sm-3">  
                                            
                                            <button data-prompt-msg="Are you sure you want to delete these records" data-url="<?php print_link("bg_5_products_latest/delete/{sel_ids}/?csrf_token=$csrf_token"); ?>" class="btn btn-sm btn-danger btn-delete-selected d-none">
                                                <i class="material-icons">clear</i> Delete Selected
                                            </button>
                                            
                                            
                                            <button class="btn btn-sm btn-primary export-btn"><i class="material-icons">save</i> </button>
                                            
                                            
                                        </div>
                                        <div class="col">   
                                            
                                            <?php
                                            if( $show_pagination == true ){
                                            $pager = new Pagination($total_records,$record_count);
                                            $pager->page_name='bg_5_products_latest';
                                            $pager->show_page_count=true;
                                            $pager->show_record_count=true;
                                            $pager->show_page_limit=true;
                                            $pager->show_page_number_list=true;
                                            $pager->pager_link_range=5;
                                            
                                            $pager->render();
                                            }
                                            ?>
                                            
                                        </div>
                                    </div>
                                </div>
                                <?php
                                }
                                }
                                else{
                                ?>
                                <div class="text-muted animated bounce  p-3">
                                    <h4><i class="material-icons">block</i> No Records Found</h4>
                                </div>
                                <?php
                                }
                                ?>
                                
                            </div>
                        </div>
                        
                    </div>
                    
                </div>
            </div>
        </div>
        
    </section>
    