<?php 
/**
 * Bg_7_products_comment_history Page Controller
 * @category  Controller
 */
class Bg_7_products_comment_historyController extends SecureController{
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function index($fieldname = null , $fieldvalue = null){
		$db = $this->GetModel();
		$fields = array('pk_Product_Comment_History_ID', 	'fk_Product_id', 	'User_ID', 	'TimeStamp', 	'Comment', 	'Field', 	'Reason', 	'Assigned', 	'Acked');
		$limit = $this->get_page_limit(MAX_RECORD_COUNT); // return pagination from BaseModel Class e.g array(5,20)
		if(!empty($this->search)){
			$text = $this->search;
			$db->orWhere('pk_Product_Comment_History_ID',"%$text%",'LIKE');
			$db->orWhere('fk_Product_id',"%$text%",'LIKE');
			$db->orWhere('User_ID',"%$text%",'LIKE');
			$db->orWhere('TimeStamp',"%$text%",'LIKE');
			$db->orWhere('Comment',"%$text%",'LIKE');
			$db->orWhere('Field',"%$text%",'LIKE');
			$db->orWhere('Reason',"%$text%",'LIKE');
			$db->orWhere('Assigned',"%$text%",'LIKE');
			$db->orWhere('Acked',"%$text%",'LIKE');
		}
		if(!empty($this->orderby)){ // when order by request fields (from $_GET param)
			$db->orderBy($this->orderby,$this->ordertype);
		}
		else{
			$db->orderBy('pk_Product_Comment_History_ID', ORDER_TYPE);
		}
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get('bg_7_products_comment_history', $limit, $fields);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		if($db->getLastError()){
			$this->view->page_error = $db->getLastError();
		}
		$this->view->page_title =" Products Comment History";
		$this->view->render('bg_7_products_comment_history/list.php' , $data ,'main_layout.php');
	}
	/**
     * View Record Action 
     * @return View
     */
	function view( $rec_id = null , $value = null){
		$db = $this->GetModel();
		$fields = array( 'pk_Product_Comment_History_ID', 	'fk_Product_id', 	'User_ID', 	'TimeStamp', 	'Comment', 	'Field', 	'Reason', 	'Assigned', 	'Acked' );
		if( !empty($value) ){
			$db->where($rec_id, urldecode($value));
		}
		else{
			$db->where('pk_Product_Comment_History_ID' , $rec_id);
		}
		$record = $db->getOne( 'bg_7_products_comment_history', $fields );
		if(!empty($record)){
			$this->view->page_title ="View Comment History";
			$this->view->render('bg_7_products_comment_history/view.php' , $record ,'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error = $db->getLastError();
			}
			else{
				$this->view->page_error = "Record not found";
			}
			$this->view->render('bg_7_products_comment_history/view.php' , $record , 'main_layout.php');
		}
	}
	/**
     * Add New Record Action 
     * If Not $_POST Request, Display Add Record Form View
     * @return View
     */
	function add(){
		if(is_post_request()){
			$db = $this->GetModel();
			$modeldata = transform_request_data($_POST);
			Csrf :: cross_check();
			$rules_array = array(
				'pk_Product_Comment_History_ID' => 'required|numeric',
				'fk_Product_id' => 'required|numeric',
				'User_ID' => 'required',
				'Comment' => 'required',
				'Reason' => 'required',
			);
			$filter_array = array(
				'pk_Product_Comment_History_ID' => 'sanitize_string',
				'fk_Product_id' => 'sanitize_string',
				'User_ID' => 'sanitize_string',
				'Comment' => 'sanitize_string',
				'Field' => 'sanitize_string',
				'Reason' => 'sanitize_string',
				'Assigned' => 'sanitize_string',
				'Acked' => 'sanitize_string',
			);
			$modeldata = GUMP::filter_input($modeldata, $filter_array); //remove unwanted html characters to prevent xss attack
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}
			if( empty($this->view->page_error) ){
				$rec_id = $db->insert( 'bg_7_products_comment_history' , $modeldata );
				if(!empty($rec_id)){
					set_flash_msg('','');
					redirect_to_page("bg_7_products_comment_history");
					return;
				}
				else{
					if($db->getLastError()){
						$this->view->page_error[] = $db->getLastError();
					}
					else{
						$this->view->page_error[] = "Error inserting record";
					}
				}
			}
		}
		$this->view->page_title ="Add Comment History";
		$this->view->render('bg_7_products_comment_history/add.php' ,null,'main_layout.php');
	}
	/**
     * Edit Record Action 
     * If Not $_POST Request, Display Edit Record Form View
     * @return View
     */
	function edit($rec_id=null){
		$db = $this->GetModel();
		if(is_post_request()){
			$modeldata = transform_request_data($_POST);
			Csrf :: cross_check();
			$rules_array = array(
				'pk_Product_Comment_History_ID' => 'required|numeric',
				'fk_Product_id' => 'required|numeric',
				'User_ID' => 'required',
				'Comment' => 'required',
				'Reason' => 'required',
			);
			$filter_array = array(
				'pk_Product_Comment_History_ID' => 'sanitize_string',
				'fk_Product_id' => 'sanitize_string',
				'User_ID' => 'sanitize_string',
				'Comment' => 'sanitize_string',
				'Field' => 'sanitize_string',
				'Reason' => 'sanitize_string',
				'Assigned' => 'sanitize_string',
				'Acked' => 'sanitize_string',
			);
			$modeldata = GUMP::filter_input($modeldata, $filter_array); //remove unwanted html characters to prevent xss attack
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}
			if(empty($this->view->page_error)){
				$db->where('pk_Product_Comment_History_ID' , $rec_id);
				$bool = $db->update('bg_7_products_comment_history',$modeldata);
				if($bool){
					set_flash_msg('','');
					redirect_to_page("bg_7_products_comment_history");
					return;
				}
				else{
					$this->view->page_error[] = $db->getLastError();
				}
			}
		}
		$fields = array('pk_Product_Comment_History_ID','fk_Product_id','User_ID','Comment','Field','Reason','Assigned','Acked');
		$db->where('pk_Product_Comment_History_ID' , $rec_id);
		$data = $db->getOne('bg_7_products_comment_history',$fields);
		$this->view->page_title ="Edit Comment History";
		if(!empty($data)){
			$this->view->render('bg_7_products_comment_history/edit.php' , $data, 'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error[] = $db->getLastError();
			}
			else{
				$this->view->page_error[] = "Record not found";
			}
			$this->view->render('bg_7_products_comment_history/edit.php' , $data , 'main_layout.php');
		}
	}
}
