<?php 
/**
 * Accounting_notes Page Controller
 * @category  Controller
 */
class Accounting_notesController extends BaseController{
	function __construct(){
		parent::__construct();
		$this->tablename = "accounting_notes";
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("Job_Number","Created_By","Note","Follow_Up_Required","Follow_Up_Date","Follow_Up_Complete");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'Job_Number' => 'numeric',
				'Created_By' => 'required',
			);
			$this->sanitize_array = array(
				'Job_Number' => 'sanitize_string',
				'Created_By' => 'sanitize_string',
				'Note' => 'sanitize_string',
				'Follow_Up_Required' => 'sanitize_string',
				'Follow_Up_Date' => 'sanitize_string',
				'Follow_Up_Complete' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("accounting_notes");
				}
				else{
					$this->set_page_error();
				}
			}
		}
		$page_title = $this->view->page_title = "Add New Accounting Notes";
		$this->render_view("accounting_notes/add.php");
	}
	/**
     * Update table record with formdata
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function edit($rec_id = null, $formdata = null){
		$request = $this->request;
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		 //editable fields
		$fields = $this->fields = array("Job_Number","Created_By","Note","Follow_Up_Required","Follow_Up_Date","Follow_Up_Complete");
		if($formdata){
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'Job_Number' => 'numeric',
				'Created_By' => 'required',
			);
			$this->sanitize_array = array(
				'Job_Number' => 'sanitize_string',
				'Created_By' => 'sanitize_string',
				'Note' => 'sanitize_string',
				'Follow_Up_Required' => 'sanitize_string',
				'Follow_Up_Date' => 'sanitize_string',
				'Follow_Up_Complete' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("accounting_notes.Job_Number", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					$this->set_flash_msg("Record updated successfully", "success");
					return $this->redirect("accounting_notes");
				}
				else{
					if($db->getLastError()){
						$this->set_page_error();
					}
					elseif(!$numRows){
						//not an error, but no record was updated
						$page_error = "No record updated";
						$this->set_page_error($page_error);
						$this->set_flash_msg($page_error, "warning");
						return	$this->redirect("accounting_notes");
					}
				}
			}
		}
		$db->where("accounting_notes.Job_Number", $rec_id);;
		$data = $db->getOne($tablename, $fields);
		$page_title = $this->view->page_title = "Edit  Accounting Notes";
		if(!$data){
			$this->set_page_error();
		}
		return $this->render_view("accounting_notes/edit.php", $data);
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("Job_Number","Created_By","Note","Follow_Up_Required","Follow_Up_Date","Follow_Up_Complete");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'Job_Number' => 'numeric',
				'Created_By' => 'required',
			);
			$this->sanitize_array = array(
				'Job_Number' => 'sanitize_string',
				'Created_By' => 'sanitize_string',
				'Note' => 'sanitize_string',
				'Follow_Up_Required' => 'sanitize_string',
				'Follow_Up_Date' => 'sanitize_string',
				'Follow_Up_Complete' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("accounting_notes.Job_Number", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
	/**
     * Delete record from the database
	 * Support multi delete by separating record id by comma.
     * @return BaseView
     */
	function delete($rec_id = null){
		Csrf::cross_check();
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$this->rec_id = $rec_id;
		//form multiple delete, split record id separated by comma into array
		$arr_rec_id = array_map('trim', explode(",", $rec_id));
		$db->where("accounting_notes.Job_Number", $arr_rec_id, "in");
		$bool = $db->delete($tablename);
		if($bool){
			$this->set_flash_msg("Record deleted successfully", "success");
		}
		elseif($db->getLastError()){
			$page_error = $db->getLastError();
			$this->set_flash_msg($page_error, "danger");
		}
		return	$this->redirect("accounting_notes");
	}
}
