<?php 
/**
 * Job Page Controller
 * @category  Controller
 */
class JobController extends BaseController{
	function __construct(){
		parent::__construct();
		$this->tablename = "job";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("Job_Number_Prefix", 
			"Job_Number", 
			"Status", 
			"Dealer", 
			"Customer_PO", 
			"Tag_Name", 
			"Received_Order", 
			"Original_Job_Number", 
			"Description", 
			"OE", 
			"Sales_Rep", 
			"Requested_Date", 
			"Value", 
			"Sent_To_OE", 
			"Sent_For_Confirmation", 
			"Confirmation_Received", 
			"Confirmed", 
			"Sent_To_Plant", 
			"Received_At_Plant", 
			"Confirmed_Ship_Date", 
			"Invoiced", 
			"TimeStamp", 
			"Job_Type", 
			"Uppers", 
			"Talls", 
			"Bases", 
			"Vanities", 
			"Accessories", 
			"Door_Style", 
			"Wood", 
			"Colour", 
			"Material", 
			"Custom_Cabinets", 
			"Door_Vendor", 
			"Door_ETA", 
			"Date_Shipped", 
			"Back_Orders", 
			"Back_Orders_Shipped", 
			"Proposed_Shipping_Date", 
			"Lead_Time", 
			"Creator", 
			"Dealer_Route", 
			"Updated_By", 
			"Last_Updated");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				job.Job_Number_Prefix LIKE ? OR 
				job.Job_Number LIKE ? OR 
				job.Status LIKE ? OR 
				job.Dealer LIKE ? OR 
				job.Customer_PO LIKE ? OR 
				job.Tag_Name LIKE ? OR 
				job.Received_Order LIKE ? OR 
				job.Original_Job_Number LIKE ? OR 
				job.Description LIKE ? OR 
				job.OE LIKE ? OR 
				job.Sales_Rep LIKE ? OR 
				job.Requested_Date LIKE ? OR 
				job.Value LIKE ? OR 
				job.Sent_To_OE LIKE ? OR 
				job.Sent_For_Confirmation LIKE ? OR 
				job.Confirmation_Received LIKE ? OR 
				job.Confirmed LIKE ? OR 
				job.Sent_To_Plant LIKE ? OR 
				job.Received_At_Plant LIKE ? OR 
				job.Confirmed_Ship_Date LIKE ? OR 
				job.Invoiced LIKE ? OR 
				job.TimeStamp LIKE ? OR 
				job.Job_Type LIKE ? OR 
				job.Uppers LIKE ? OR 
				job.Talls LIKE ? OR 
				job.Bases LIKE ? OR 
				job.Vanities LIKE ? OR 
				job.Accessories LIKE ? OR 
				job.Door_Style LIKE ? OR 
				job.Wood LIKE ? OR 
				job.Colour LIKE ? OR 
				job.Material LIKE ? OR 
				job.Custom_Cabinets LIKE ? OR 
				job.Door_Vendor LIKE ? OR 
				job.Door_ETA LIKE ? OR 
				job.Date_Shipped LIKE ? OR 
				job.Back_Orders LIKE ? OR 
				job.Back_Orders_Shipped LIKE ? OR 
				job.Proposed_Shipping_Date LIKE ? OR 
				job.Lead_Time LIKE ? OR 
				job.Creator LIKE ? OR 
				job.Dealer_Route LIKE ? OR 
				job.Updated_By LIKE ? OR 
				job.Last_Updated LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "job/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("job.Job_Number", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Job";
		$view_name = (is_ajax() ? "job/ajax-list.php" : "job/list.php");
		$this->render_view($view_name, $data);
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("job.Job_Number_Prefix", 
			"job.Job_Number", 
			"job.Status", 
			"job.Dealer", 
			"job.Customer_PO", 
			"job.Tag_Name", 
			"job.Received_Order", 
			"job.Original_Job_Number", 
			"job.Description", 
			"job.OE", 
			"job.Sales_Rep", 
			"job.Requested_Date", 
			"job.Value", 
			"job.Sent_To_OE", 
			"job.Sent_For_Confirmation", 
			"job.Confirmation_Received", 
			"job.Confirmed", 
			"job.Sent_To_Plant", 
			"job.Received_At_Plant", 
			"job.Confirmed_Ship_Date", 
			"job.Invoiced", 
			"job.TimeStamp", 
			"job.Job_Type", 
			"job.Uppers", 
			"job.Talls", 
			"job.Bases", 
			"job.Vanities", 
			"job.Accessories", 
			"job.Door_Style", 
			"job.Wood", 
			"job.Colour", 
			"job.Material", 
			"job.Custom_Cabinets", 
			"job.Door_Vendor", 
			"job.Door_ETA", 
			"job.Date_Shipped", 
			"job.Back_Orders", 
			"job.Back_Orders_Shipped", 
			"job.Proposed_Shipping_Date", 
			"job.Lead_Time", 
			"job.Creator", 
			"job.Dealer_Route", 
			"job.Updated_By", 
			"job.Last_Updated", 
			"accounting.Created_By AS accounting_Created_By", 
			"accounting.Paid AS accounting_Paid", 
			"accounting.Invoiced AS accounting_Invoiced", 
			"accounting.Note AS accounting_Note", 
			"accounting.Updated_By AS accounting_Updated_By", 
			"accounting.Accounting_Received AS accounting_Accounting_Received", 
			"accounting.Job_Number AS accounting_Job_Number", 
			"accounting.Created_TS AS accounting_Created_TS", 
			"accounting.Paid_TS AS accounting_Paid_TS", 
			"accounting.Updated_TS AS accounting_Updated_TS", 
			"accounting.Accounting_Received_TS AS accounting_Accounting_Received_TS", 
			"accounting.Invoiced_TS AS accounting_Invoiced_TS", 
			"accounting.Deposit_Required AS accounting_Deposit_Required", 
			"accounting.Deposit_Paid_TS AS accounting_Deposit_Paid_TS", 
			"accounting.Deposit_Paid AS accounting_Deposit_Paid");
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("job.Job_Number", $rec_id);; //select record based on primary key
		}
		$db->join("accounting", "job.Job_Number = accounting.Job_Number", "LEFT ");  
		$record = $db->getOne($tablename, $fields );
		if($record){
			$page_title = $this->view->page_title = "View  Job";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
		}
		return $this->render_view("job/view.php", $record);
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("Job_Number_Prefix","Job_Type","Job_Number","Status","Dealer","Customer_PO","Tag_Name","Received_Order","Original_Job_Number","Description","OE","Requested_Date","Value","Sent_To_OE","Vanities","Door_Style","Wood","Colour","Door_Vendor","Door_ETA");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'Job_Number' => 'numeric',
				'Value' => 'numeric',
				'Vanities' => 'numeric',
			);
			$this->sanitize_array = array(
				'Job_Number_Prefix' => 'sanitize_string',
				'Job_Type' => 'sanitize_string',
				'Job_Number' => 'sanitize_string',
				'Status' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'Customer_PO' => 'sanitize_string',
				'Tag_Name' => 'sanitize_string',
				'Received_Order' => 'sanitize_string',
				'Original_Job_Number' => 'sanitize_string',
				'Description' => 'sanitize_string',
				'OE' => 'sanitize_string',
				'Requested_Date' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'Sent_To_OE' => 'sanitize_string',
				'Vanities' => 'sanitize_string',
				'Door_Style' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'Door_Vendor' => 'sanitize_string',
				'Door_ETA' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("job");
				}
				else{
					$this->set_page_error();
				}
			}
		}
		$page_title = $this->view->page_title = "Add New Job";
		$this->render_view("job/add.php");
	}
	/**
     * Update table record with formdata
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function edit($rec_id = null, $formdata = null){
		$request = $this->request;
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		 //editable fields
		$fields = $this->fields = array("Job_Number_Prefix","Job_Type","Job_Number","Status","Dealer","Customer_PO","Tag_Name","Received_Order","Original_Job_Number","Description","OE","Requested_Date","Value","Sent_To_OE","Sent_For_Confirmation","Confirmation_Received","Confirmed","Sent_To_Plant","Received_At_Plant","Invoiced","Uppers","Talls","Bases","Vanities","Accessories","Custom_Cabinets","Door_Style","Wood","Colour","Door_Vendor","Door_ETA");
		if($formdata){
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'Job_Number' => 'numeric',
				'Value' => 'numeric',
				'Uppers' => 'numeric',
				'Talls' => 'numeric',
				'Bases' => 'numeric',
				'Vanities' => 'numeric',
				'Accessories' => 'numeric',
			);
			$this->sanitize_array = array(
				'Job_Number_Prefix' => 'sanitize_string',
				'Job_Type' => 'sanitize_string',
				'Job_Number' => 'sanitize_string',
				'Status' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'Customer_PO' => 'sanitize_string',
				'Tag_Name' => 'sanitize_string',
				'Received_Order' => 'sanitize_string',
				'Original_Job_Number' => 'sanitize_string',
				'Description' => 'sanitize_string',
				'OE' => 'sanitize_string',
				'Requested_Date' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'Sent_To_OE' => 'sanitize_string',
				'Sent_For_Confirmation' => 'sanitize_string',
				'Confirmation_Received' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'Sent_To_Plant' => 'sanitize_string',
				'Received_At_Plant' => 'sanitize_string',
				'Invoiced' => 'sanitize_string',
				'Uppers' => 'sanitize_string',
				'Talls' => 'sanitize_string',
				'Bases' => 'sanitize_string',
				'Vanities' => 'sanitize_string',
				'Accessories' => 'sanitize_string',
				'Custom_Cabinets' => 'sanitize_string',
				'Door_Style' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'Door_Vendor' => 'sanitize_string',
				'Door_ETA' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("job.Job_Number", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					$this->set_flash_msg("Record updated successfully", "success");
					return $this->redirect("job");
				}
				else{
					if($db->getLastError()){
						$this->set_page_error();
					}
					elseif(!$numRows){
						//not an error, but no record was updated
						$page_error = "No record updated";
						$this->set_page_error($page_error);
						$this->set_flash_msg($page_error, "warning");
						return	$this->redirect("job");
					}
				}
			}
		}
		$db->where("job.Job_Number", $rec_id);;
		$data = $db->getOne($tablename, $fields);
		$page_title = $this->view->page_title = "Edit  Job";
		if(!$data){
			$this->set_page_error();
		}
		return $this->render_view("job/edit.php", $data);
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("Job_Number_Prefix","Job_Type","Job_Number","Status","Dealer","Customer_PO","Tag_Name","Received_Order","Original_Job_Number","Description","OE","Requested_Date","Value","Sent_To_OE","Sent_For_Confirmation","Confirmation_Received","Confirmed","Sent_To_Plant","Received_At_Plant","Invoiced","Uppers","Talls","Bases","Vanities","Accessories","Custom_Cabinets","Door_Style","Wood","Colour","Door_Vendor","Door_ETA");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'Job_Number' => 'numeric',
				'Value' => 'numeric',
				'Uppers' => 'numeric',
				'Talls' => 'numeric',
				'Bases' => 'numeric',
				'Vanities' => 'numeric',
				'Accessories' => 'numeric',
			);
			$this->sanitize_array = array(
				'Job_Number_Prefix' => 'sanitize_string',
				'Job_Type' => 'sanitize_string',
				'Job_Number' => 'sanitize_string',
				'Status' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'Customer_PO' => 'sanitize_string',
				'Tag_Name' => 'sanitize_string',
				'Received_Order' => 'sanitize_string',
				'Original_Job_Number' => 'sanitize_string',
				'Description' => 'sanitize_string',
				'OE' => 'sanitize_string',
				'Requested_Date' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'Sent_To_OE' => 'sanitize_string',
				'Sent_For_Confirmation' => 'sanitize_string',
				'Confirmation_Received' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'Sent_To_Plant' => 'sanitize_string',
				'Received_At_Plant' => 'sanitize_string',
				'Invoiced' => 'sanitize_string',
				'Uppers' => 'sanitize_string',
				'Talls' => 'sanitize_string',
				'Bases' => 'sanitize_string',
				'Vanities' => 'sanitize_string',
				'Accessories' => 'sanitize_string',
				'Custom_Cabinets' => 'sanitize_string',
				'Door_Style' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'Door_Vendor' => 'sanitize_string',
				'Door_ETA' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("job.Job_Number", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
	/**
     * Delete record from the database
	 * Support multi delete by separating record id by comma.
     * @return BaseView
     */
	function delete($rec_id = null){
		Csrf::cross_check();
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$this->rec_id = $rec_id;
		//form multiple delete, split record id separated by comma into array
		$arr_rec_id = array_map('trim', explode(",", $rec_id));
		$db->where("job.Job_Number", $arr_rec_id, "in");
		$bool = $db->delete($tablename);
		if($bool){
			$this->set_flash_msg("Record deleted successfully", "success");
		}
		elseif($db->getLastError()){
			$page_error = $db->getLastError();
			$this->set_flash_msg($page_error, "danger");
		}
		return	$this->redirect("job");
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function job_accounting_list($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("Concat(`job`.`Job_Number_Prefix`,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM job.`Job_Number`)))) AS DJobNum", 
			"job.Job_Number", 
			"job.Status", 
			"job.Dealer", 
			"job.Tag_Name", 
			"job.Confirmation_Received", 
			"job.Sent_To_Plant", 
			"job.Received_At_Plant", 
			"job.Confirmed_Ship_Date", 
			"accounting.Paid AS accounting_Paid", 
			"accounting.Invoiced AS accounting_Invoiced", 
			"accounting.Note AS accounting_Note", 
			"accounting.Accounting_Received AS accounting_Accounting_Received", 
			"accounting.Job_Number AS accounting_Job_Number", 
			"accounting.Deposit_Required AS accounting_Deposit_Required", 
			"accounting.Deposit_Paid AS accounting_Deposit_Paid");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				job.DJobNum LIKE ? OR 
				job.Job_Number_Prefix LIKE ? OR 
				job.Job_Number LIKE ? OR 
				job.Status LIKE ? OR 
				job.Dealer LIKE ? OR 
				job.Customer_PO LIKE ? OR 
				job.Tag_Name LIKE ? OR 
				job.Received_Order LIKE ? OR 
				job.Original_Job_Number LIKE ? OR 
				job.Description LIKE ? OR 
				job.OE LIKE ? OR 
				job.Sales_Rep LIKE ? OR 
				job.Requested_Date LIKE ? OR 
				job.Value LIKE ? OR 
				job.Sent_To_OE LIKE ? OR 
				job.Sent_For_Confirmation LIKE ? OR 
				job.Confirmation_Received LIKE ? OR 
				job.Confirmed LIKE ? OR 
				job.Sent_To_Plant LIKE ? OR 
				job.Received_At_Plant LIKE ? OR 
				job.Confirmed_Ship_Date LIKE ? OR 
				job.Invoiced LIKE ? OR 
				job.TimeStamp LIKE ? OR 
				job.Job_Type LIKE ? OR 
				job.Uppers LIKE ? OR 
				job.Talls LIKE ? OR 
				job.Bases LIKE ? OR 
				job.Vanities LIKE ? OR 
				job.Accessories LIKE ? OR 
				job.Door_Style LIKE ? OR 
				job.Wood LIKE ? OR 
				job.Colour LIKE ? OR 
				job.Material LIKE ? OR 
				job.Custom_Cabinets LIKE ? OR 
				job.Door_Vendor LIKE ? OR 
				job.Door_ETA LIKE ? OR 
				job.Date_Shipped LIKE ? OR 
				job.Back_Orders LIKE ? OR 
				job.Back_Orders_Shipped LIKE ? OR 
				job.Proposed_Shipping_Date LIKE ? OR 
				job.Lead_Time LIKE ? OR 
				job.Creator LIKE ? OR 
				job.Dealer_Route LIKE ? OR 
				job.Updated_By LIKE ? OR 
				job.Last_Updated LIKE ? OR 
				accounting.Created_By LIKE ? OR 
				accounting.Paid LIKE ? OR 
				accounting.Invoiced LIKE ? OR 
				accounting.Note LIKE ? OR 
				accounting.Updated_By LIKE ? OR 
				accounting.Accounting_Received LIKE ? OR 
				accounting.Job_Number LIKE ? OR 
				accounting.Created_TS LIKE ? OR 
				accounting.Paid_TS LIKE ? OR 
				accounting.Updated_TS LIKE ? OR 
				accounting.Accounting_Received_TS LIKE ? OR 
				accounting.Invoiced_TS LIKE ? OR 
				accounting.Deposit_Required LIKE ? OR 
				accounting.Deposit_Paid_TS LIKE ? OR 
				accounting.Deposit_Paid LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "job/search.php";
		}
		$db->join("accounting", "job.Job_Number = accounting.Job_Number", "LEFT");
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("job.Job_Number", ORDER_TYPE);
		}
		$db->where("`job`.`Received_At_Plant` = 'Y' AND accounting.Job_Number = NULL AND `job`.`Invoiced` !='Y'Concat(job.job_number_prefix,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM job.job_number))))");
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Job";
		$view_name = (is_ajax() ? "job/ajax-job_accounting_list.php" : "job/job_accounting_list.php");
		$this->render_view($view_name, $data);
	}
}
