<?php 
/**
 * Joblist Page Controller
 * @category  Controller
 */
class JoblistController extends BaseController{
	function __construct(){
		parent::__construct();
		$this->tablename = "joblist";
	}
// No View Function Generated Because No Field is Defined as the Primary Key on the Database Table
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("JobNum","Artisan","Dealer","CustomerNum","TagName","OrderEntry","SalesRep","RecdOrder","StdLeadTime","ReqDate","Value","SentToOE","SentToDealer","Confirmed","SentToPlant","Inv","Comments","RSO","Uppers","Talls","Bases","Vanities","Accessories","Wood","Colour","DoorVendor","DoorETA","OtherETA","Priority","Creator","DoorStyle","Conf_Rec","NJobNum","DateShipped","BackOrders","BackOrdersShipped","propshipdate","shipcomments","shipdetails","DealerRoute","OrgJobNum","UpdatedBy","LastUpdated");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'JobNum' => 'numeric',
				'Value' => 'numeric',
				'Uppers' => 'numeric',
				'Talls' => 'numeric',
				'Bases' => 'numeric',
				'Vanities' => 'numeric',
				'Accessories' => 'numeric',
			);
			$this->sanitize_array = array(
				'JobNum' => 'sanitize_string',
				'Artisan' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'CustomerNum' => 'sanitize_string',
				'TagName' => 'sanitize_string',
				'OrderEntry' => 'sanitize_string',
				'SalesRep' => 'sanitize_string',
				'RecdOrder' => 'sanitize_string',
				'StdLeadTime' => 'sanitize_string',
				'ReqDate' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'SentToOE' => 'sanitize_string',
				'SentToDealer' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'SentToPlant' => 'sanitize_string',
				'Inv' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'RSO' => 'sanitize_string',
				'Uppers' => 'sanitize_string',
				'Talls' => 'sanitize_string',
				'Bases' => 'sanitize_string',
				'Vanities' => 'sanitize_string',
				'Accessories' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'DoorVendor' => 'sanitize_string',
				'DoorETA' => 'sanitize_string',
				'OtherETA' => 'sanitize_string',
				'Priority' => 'sanitize_string',
				'Creator' => 'sanitize_string',
				'DoorStyle' => 'sanitize_string',
				'Conf_Rec' => 'sanitize_string',
				'NJobNum' => 'sanitize_string',
				'DateShipped' => 'sanitize_string',
				'BackOrders' => 'sanitize_string',
				'BackOrdersShipped' => 'sanitize_string',
				'propshipdate' => 'sanitize_string',
				'shipcomments' => 'sanitize_string',
				'shipdetails' => 'sanitize_string',
				'DealerRoute' => 'sanitize_string',
				'OrgJobNum' => 'sanitize_string',
				'UpdatedBy' => 'sanitize_string',
				'LastUpdated' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("joblist");
				}
				else{
					$this->set_page_error();
				}
			}
		}
		$page_title = $this->view->page_title = "Add New Joblist";
		$this->render_view("joblist/add.php");
	}
// No Edit Function Generated Because No Field is Defined as the Primary Key
}
