<?php 
/**
 * Zz_accounting Page Controller
 * @category  Controller
 */
class Zz_accountingController extends BaseController{
	function __construct(){
		parent::__construct();
		$this->tablename = "zz_accounting";
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("Job_Number","Created_By","Paid","Paid_TS","Invoiced","Note","Updated_By","Updated_TS","Accounting_Received","Accounting_Received_TS","Invoiced_TS","Deposit_Required","Deposit_Paid_TS","Deposit_Paid");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'Job_Number' => 'numeric',
			);
			$this->sanitize_array = array(
				'Job_Number' => 'sanitize_string',
				'Created_By' => 'sanitize_string',
				'Paid' => 'sanitize_string',
				'Paid_TS' => 'sanitize_string',
				'Invoiced' => 'sanitize_string',
				'Note' => 'sanitize_string',
				'Updated_By' => 'sanitize_string',
				'Updated_TS' => 'sanitize_string',
				'Accounting_Received' => 'sanitize_string',
				'Accounting_Received_TS' => 'sanitize_string',
				'Invoiced_TS' => 'sanitize_string',
				'Deposit_Required' => 'sanitize_string',
				'Deposit_Paid_TS' => 'sanitize_string',
				'Deposit_Paid' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("zz_accounting.Job_Number", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
}
