<?php
$comp_model = new SharedController;
$page_element_id = "list-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data From Controller
$view_data = $this->view_data;
$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = $this->route->field_name;
$field_value = $this->route->field_value;
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;
?>
<section class="page ajax-page" id="<?php echo $page_element_id; ?>" data-page-type="list"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">Jobs At Production</h4>
                </div>
                <div class="col-sm-4 ">
                    <form  class="search" action="<?php print_link('job/'); ?>" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="icon dripicons-search"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <!-- Page bread crumbs components-->
                            <?php
                            if(!empty($field_name) || !empty($_GET['search'])){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('job'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <?php echo (get_value("tag") ? get_value("tag")  :  make_readable($field_name)); ?>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold">
                                        <?php echo (get_value("label") ? get_value("label")  :  make_readable(urldecode($field_value))); ?>
                                    </li>
                                    <?php 
                                    }   
                                    ?>
                                    <?php
                                    if(get_value("search")){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('job'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item text-capitalize">
                                        Search
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold"><?php echo get_value("search"); ?></li>
                                    <?php
                                    }
                                    ?>
                                </ul>
                            </nav>
                            <!--End of Page bread crumbs components-->
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        }
        ?>
        <div  class="">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-md-12 comp-grid">
                        <?php $this :: display_page_errors(); ?>
                        <div  class=" animated fadeIn page-content">
                            <div id="job-job_accounting_list-records">
                                <div id="page-report-body" class="table-responsive">
                                    <?php Html::ajaxpage_spinner(); ?>
                                    <table class="table  table-striped table-sm text-left">
                                        <thead class="table-header bg-light">
                                            <tr>
                                                <th class="td-btn"></th>
                                                <th  class="td-DJobNum"> Job #</th>
                                                <th  class="td-Status"> Status</th>
                                                <th  class="td-Dealer"> Dealer</th>
                                                <th  class="td-Tag_Name"> Tag Name</th>
                                                <th  class="td-Confirmation_Received"> Confirmation Received</th>
                                                <th  class="td-Sent_To_Plant"> Sent To Plant</th>
                                                <th  class="td-Received_At_Plant"> Received At Plant</th>
                                                <th  class="td-Confirmed_Ship_Date"> Confirmed Ship Date</th>
                                                <th  class="td-accounting_Paid"> Accounting Paid</th>
                                                <th  class="td-accounting_Invoiced"> Accounting Invoiced</th>
                                                <th  class="td-accounting_Note"> Accounting Note</th>
                                                <th  class="td-accounting_Accounting_Received"> Accounting Accounting Received</th>
                                                <th  class="td-accounting_Deposit_Required"> Accounting Deposit Required</th>
                                                <th  class="td-accounting_Deposit_Paid"> Accounting Deposit Paid</th>
                                            </tr>
                                        </thead>
                                        <?php
                                        if(!empty($records)){
                                        ?>
                                        <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                            <!--record-->
                                            <?php
                                            $counter = 0;
                                            foreach($records as $data){
                                            $rec_id = (!empty($data['Job_Number']) ? urlencode($data['Job_Number']) : null);
                                            $counter++;
                                            ?>
                                            <tr>
                                                <th class="td-btn">
                                                    <a class="btn btn-sm btn-success has-tooltip page-modal" title="View Record" href="<?php print_link("job/view/$rec_id"); ?>">
                                                        <i class="icon dripicons-preview"></i> View
                                                    </a>
                                                    <a class="btn btn-sm btn-info has-tooltip page-modal" title="Edit This Record" href="<?php print_link("job/edit/$rec_id"); ?>">
                                                        <i class="icon dripicons-document-edit"></i> Edit
                                                    </a>
                                                </th>
                                                <td class="td-DJobNum"> <?php echo $data['DJobNum']; ?></td>
                                                <td class="td-Status">
                                                    <span  data-source='<?php print_link('api/json/job_Status_option_list'); ?>' 
                                                        data-value="<?php echo $data['Status']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Status" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Status']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Dealer">
                                                    <span  data-source='<?php print_link('api/json/job_Dealer_option_list'); ?>' 
                                                        data-value="<?php echo $data['Dealer']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Dealer" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Dealer']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Tag_Name">
                                                    <span  data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Tag_Name" 
                                                        data-title="Enter Tag Name" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Tag_Name']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Confirmation_Received">
                                                    <span  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Confirmation_Received']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Confirmation_Received" 
                                                        data-title="Enter Confirmation Received" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Confirmation_Received']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Sent_To_Plant">
                                                    <span  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Sent_To_Plant']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Sent_To_Plant" 
                                                        data-title="Enter Sent To Plant" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Sent_To_Plant']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Received_At_Plant">
                                                    <span  data-source='[{value: "Y", label: "Y"},{value: "Y", label: "Y"}]' 
                                                        data-value="<?php echo $data['Received_At_Plant']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Received_At_Plant" 
                                                        data-title="Enter Received At Plant" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Received_At_Plant']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Confirmed_Ship_Date"> <?php echo $data['Confirmed_Ship_Date']; ?></td>
                                                <td class="td-accounting_Paid">
                                                    <span  data-source='[{value: "Y", label: "Y"},{value: "N", label: "N"}]' 
                                                        data-value="<?php echo $data['accounting_Paid']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("accounting/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Paid" 
                                                        data-title="Enter Paid" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['accounting_Paid']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-accounting_Invoiced">
                                                    <span  data-source='[{value: "Y", label: "Y"},{value: "N", label: "N"}]' 
                                                        data-value="<?php echo $data['accounting_Invoiced']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("accounting/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Invoiced" 
                                                        data-title="Enter Invoiced" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['accounting_Invoiced']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-accounting_Note">
                                                    <span  data-source='<?php print_link('api/json/job_accounting_Note_option_list'); ?>' 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("accounting/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Note" 
                                                        data-title="Enter Note" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['accounting_Note']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-accounting_Accounting_Received">
                                                    <span  data-source='[{value: "Y", label: "Y"},{value: "N", label: "N"}]' 
                                                        data-value="<?php echo $data['accounting_Accounting_Received']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("accounting/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Accounting_Received" 
                                                        data-title="Enter Accounting Received" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['accounting_Accounting_Received']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-accounting_Deposit_Required">
                                                    <span  data-source='[{value: "Y", label: "Y"},{value: "N", label: "N"}]' 
                                                        data-value="<?php echo $data['accounting_Deposit_Required']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("accounting/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Deposit_Required" 
                                                        data-title="Enter Deposit Required" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['accounting_Deposit_Required']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-accounting_Deposit_Paid">
                                                    <span  data-source='[{value: "Y", label: "Y"},{value: "N", label: "N"}]' 
                                                        data-value="<?php echo $data['accounting_Deposit_Paid']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("accounting/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Deposit_Paid" 
                                                        data-title="Enter Deposit Paid" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['accounting_Deposit_Paid']; ?> 
                                                    </span>
                                                </td>
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            <!--endrecord-->
                                        </tbody>
                                        <tbody class="search-data" id="search-data-<?php echo $page_element_id; ?>"></tbody>
                                        <?php
                                        }
                                        ?>
                                    </table>
                                    <?php 
                                    if(empty($records)){
                                    ?>
                                    <h4 class="bg-light text-center border-top text-muted animated bounce  p-3">
                                        <i class="icon dripicons-wrong"></i> No record found
                                    </h4>
                                    <?php
                                    }
                                    ?>
                                </div>
                                <?php
                                if( $show_footer && !empty($records)){
                                ?>
                                <div class=" border-top mt-2">
                                    <div class="row justify-content-center">    
                                        <div class="col-md-auto justify-content-center">    
                                            <div class="p-3 d-flex justify-content-between">    
                                            </div>
                                        </div>
                                        <div class="col">   
                                            <?php
                                            if($show_pagination == true){
                                            $pager = new Pagination($total_records, $record_count);
                                            $pager->route = $this->route;
                                            $pager->show_page_count = true;
                                            $pager->show_record_count = true;
                                            $pager->show_page_limit =true;
                                            $pager->limit_count = $this->limit_count;
                                            $pager->show_page_number_list = true;
                                            $pager->pager_link_range=5;
                                            $pager->ajax_page = true;
                                            $pager->render();
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
