<?php
$comp_model = new SharedController;
$page_element_id = "list-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data From Controller
$view_data = $this->view_data;
$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = $this->route->field_name;
$field_value = $this->route->field_value;
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;
?>
<section class="page ajax-page" id="<?php echo $page_element_id; ?>" data-page-type="list"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">Production</h4>
                </div>
                <div class="col-sm-4 ">
                    <form  class="search" action="<?php print_link('production/'); ?>" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="icon dripicons-search"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <!-- Page bread crumbs components-->
                            <?php
                            if(!empty($field_name) || !empty($_GET['search'])){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('production'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <?php echo (get_value("tag") ? get_value("tag")  :  make_readable($field_name)); ?>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold">
                                        <?php echo (get_value("label") ? get_value("label")  :  make_readable(urldecode($field_value))); ?>
                                    </li>
                                    <?php 
                                    }   
                                    ?>
                                    <?php
                                    if(get_value("search")){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('production'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item text-capitalize">
                                        Search
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold"><?php echo get_value("search"); ?></li>
                                    <?php
                                    }
                                    ?>
                                </ul>
                            </nav>
                            <!--End of Page bread crumbs components-->
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        }
        ?>
        <div  class="">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-md-12 comp-grid">
                        <?php $this :: display_page_errors(); ?>
                        <div  class=" animated fadeIn page-content">
                            <div id="production-production_main_list-records">
                                <div id="page-report-body" class="table-responsive">
                                    <?php Html::ajaxpage_spinner(); ?>
                                    <table class="table  table-striped table-sm text-left">
                                        <thead class="table-header bg-light">
                                            <tr>
                                                <th class="td-btn"></th>
                                                <th  class="td-DJobNum"> Job #</th>
                                                <th  class="td-Job_Reviewed"> Job Reviewed</th>
                                                <th  class="td-RGA_Approval_Received"> Rga Approval Received</th>
                                                <th  class="td-Material_Ordered"> Material Ordered</th>
                                                <th  class="td-Material_ETA"> Material Eta</th>
                                                <th  class="td-Material_Received"> Material Received</th>
                                                <th  class="td-Doors_Ordered"> Doors Ordered</th>
                                                <th  class="td-Door_ETA"> Door Eta</th>
                                                <th  class="td-Accessories_Ordered"> Accessories Ordered</th>
                                                <th  class="td-Paint_Ordered"> Paint Ordered</th>
                                                <th  class="td-Finishing_Required"> Finishing Required</th>
                                                <th  class="td-CUSTOM_FINISHED_PARTS"> Custom Finished Parts</th>
                                                <th  class="td-CUSTOM_UNFINISHED_PARTS"> Custom Unfinished Parts</th>
                                                <th  class="td-Job_Programmed"> Job Programmed</th>
                                                <th  class="td-Doors_Received"> Doors Received</th>
                                                <th  class="td-Doors_Drilled"> Doors Drilled</th>
                                                <th  class="td-Accessories_Received"> Accessories Received</th>
                                                <th  class="td-Finished_Parts_CNC"> Finished Parts Cnc</th>
                                                <th  class="td-Finished_Parts_Banded_Doweled"> Finished Parts Banded Doweled</th>
                                                <th  class="td-Custom_Parts_Completed"> Custom Parts Completed</th>
                                                <th  class="td-Parts_ready_for_Finishing"> Parts Ready For Finishing</th>
                                                <th  class="td-Finished_Parts_Complete"> Finished Parts Complete</th>
                                                <th  class="td-Unfinished_Parts_CNC"> Unfinished Parts Cnc</th>
                                                <th  class="td-Unfinished_Parts_Complete"> Unfinished Parts Complete</th>
                                                <th  class="td-Cabinets_Assembled"> Cabinets Assembled</th>
                                                <th  class="td-Cabinets_Wrapped"> Cabinets Wrapped</th>
                                                <th  class="td-Packages_Wrapped"> Packages Wrapped</th>
                                                <th  class="td-Job_Ready_to_Ship"> Job Ready To Ship</th>
                                                <th  class="td-Drawer_Type"> Drawer Type</th>
                                                <th  class="td-Finished_End_Sq_Ft"> Finished End Sq Ft</th>
                                                <th  class="td-Door_Sq_Ft"> Door Sq Ft</th>
                                                <th  class="td-MDF_SHEET_QUANTITY"> Mdf Sheet Quantity</th>
                                                <th  class="td-MEL_SHEET_QUANTITY"> Mel Sheet Quantity</th>
                                                <th  class="td-FIN_SHEET_QUANTITY"> Fin Sheet Quantity</th>
                                                <th  class="td-job_Status"> Job Status</th>
                                                <th  class="td-job_Dealer"> Job Dealer</th>
                                                <th  class="td-job_Tag_Name"> Job Tag Name</th>
                                                <th  class="td-job_Sent_To_Plant"> Job Sent To Plant</th>
                                                <th  class="td-job_Received_At_Plant"> Job Received At Plant</th>
                                                <th  class="td-job_Confirmed_Ship_Date"> Job Confirmed Ship Date</th>
                                                <th  class="td-job_Uppers"> Job Uppers</th>
                                                <th  class="td-job_Talls"> Job Talls</th>
                                                <th  class="td-job_Bases"> Job Bases</th>
                                                <th  class="td-job_Vanities"> Job Vanities</th>
                                                <th  class="td-job_Custom_Cabinets"> Job Custom Cabinets</th>
                                                <th  class="td-job_Accessories"> Job Accessories</th>
                                                <th  class="td-job_Door_Style"> Job Door Style</th>
                                                <th  class="td-job_Wood"> Job Wood</th>
                                                <th  class="td-job_Colour"> Job Colour</th>
                                                <th  class="td-job_Material"> Job Material</th>
                                                <th  class="td-Pickup_or_Delivery"> Pickup Or Delivery</th>
                                                <th  class="td-Delivery_Address"> Delivery Address</th>
                                            </tr>
                                        </thead>
                                        <?php
                                        if(!empty($records)){
                                        ?>
                                        <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                            <!--record-->
                                            <?php
                                            $counter = 0;
                                            foreach($records as $data){
                                            $rec_id = (!empty($data['pk_Production']) ? urlencode($data['pk_Production']) : null);
                                            $counter++;
                                            ?>
                                            <tr>
                                                <th class="td-btn">
                                                    <a class="btn btn-sm btn-success has-tooltip page-modal" title="View Record" href="<?php print_link("production/view/$rec_id"); ?>">
                                                        <i class="icon dripicons-preview"></i> View
                                                    </a>
                                                    <a class="btn btn-sm btn-info has-tooltip page-modal" title="Edit This Record" href="<?php print_link("production/edit/$rec_id"); ?>">
                                                        <i class="icon dripicons-document-edit"></i> Edit
                                                    </a>
                                                </th>
                                                <td class="td-DJobNum"> <?php echo $data['DJobNum']; ?></td>
                                                <td class="td-Job_Reviewed">
                                                    <span  data-source='[{value: "Y", label: "Y"},{value: "N", label: "N"}]' 
                                                        data-value="<?php echo $data['Job_Reviewed']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Job_Reviewed" 
                                                        data-title="Enter Job Reviewed" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Job_Reviewed']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-RGA_Approval_Received">
                                                    <span  data-source='[{value: "Y", label: "Y"},{value: "N", label: "N"}]' 
                                                        data-value="<?php echo $data['RGA_Approval_Received']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="RGA_Approval_Received" 
                                                        data-title="Enter Rga Approval Received" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['RGA_Approval_Received']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Material_Ordered">
                                                    <span  data-source='[{value: "Y", label: "Y"},{value: "N", label: "N"}]' 
                                                        data-value="<?php echo $data['Material_Ordered']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Material_Ordered" 
                                                        data-title="Enter Material Ordered" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Material_Ordered']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Material_ETA">
                                                    <span  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Material_ETA']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Material_ETA" 
                                                        data-title="Enter Material Eta" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Material_ETA']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Material_Received">
                                                    <span  data-source='[{value: "Y", label: "Y"},{value: "N", label: "N"}]' 
                                                        data-value="<?php echo $data['Material_Received']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Material_Received" 
                                                        data-title="Enter Material Received" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Material_Received']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Doors_Ordered">
                                                    <span  data-source='[{value: "Y", label: "Y"},{value: "N", label: "N"}]' 
                                                        data-value="<?php echo $data['Doors_Ordered']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Doors_Ordered" 
                                                        data-title="Enter Doors Ordered" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Doors_Ordered']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Door_ETA">
                                                    <span  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Door_ETA']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Door_ETA" 
                                                        data-title="Enter Door Eta" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Door_ETA']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Accessories_Ordered">
                                                    <span  data-source='[{value: "Y", label: "Y"},{value: "N", label: "N"}]' 
                                                        data-value="<?php echo $data['Accessories_Ordered']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Accessories_Ordered" 
                                                        data-title="Enter Accessories Ordered" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Accessories_Ordered']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Paint_Ordered">
                                                    <span  data-source='[{value: "Y", label: "Y"},{value: "N", label: "N"}]' 
                                                        data-value="<?php echo $data['Paint_Ordered']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Paint_Ordered" 
                                                        data-title="Enter Paint Ordered" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Paint_Ordered']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Finishing_Required">
                                                    <span  data-source='[{value: "Y", label: "Y"},{value: "N", label: "N"}]' 
                                                        data-value="<?php echo $data['Finishing_Required']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Finishing_Required" 
                                                        data-title="Enter Finishing Required" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Finishing_Required']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-CUSTOM_FINISHED_PARTS">
                                                    <span  data-value="<?php echo $data['CUSTOM_FINISHED_PARTS']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="CUSTOM_FINISHED_PARTS" 
                                                        data-title="Enter Custom Finished Parts" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['CUSTOM_FINISHED_PARTS']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-CUSTOM_UNFINISHED_PARTS">
                                                    <span  data-value="<?php echo $data['CUSTOM_UNFINISHED_PARTS']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="CUSTOM_UNFINISHED_PARTS" 
                                                        data-title="Enter Custom Unfinished Parts" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['CUSTOM_UNFINISHED_PARTS']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Job_Programmed">
                                                    <span  data-value="<?php echo $data['Job_Programmed']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Job_Programmed" 
                                                        data-title="Enter Job Programmed" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Job_Programmed']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Doors_Received">
                                                    <span  data-value="<?php echo $data['Doors_Received']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Doors_Received" 
                                                        data-title="Enter Doors Received" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Doors_Received']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Doors_Drilled">
                                                    <span  data-value="<?php echo $data['Doors_Drilled']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Doors_Drilled" 
                                                        data-title="Enter Doors Drilled" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Doors_Drilled']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Accessories_Received">
                                                    <span  data-value="<?php echo $data['Accessories_Received']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Accessories_Received" 
                                                        data-title="Enter Accessories Received" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Accessories_Received']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Finished_Parts_CNC">
                                                    <span  data-value="<?php echo $data['Finished_Parts_CNC']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Finished_Parts_CNC" 
                                                        data-title="Enter Finished Parts Cnc" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Finished_Parts_CNC']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Finished_Parts_Banded_Doweled">
                                                    <span  data-value="<?php echo $data['Finished_Parts_Banded_Doweled']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Finished_Parts_Banded_Doweled" 
                                                        data-title="Enter Finished Parts Banded Doweled" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Finished_Parts_Banded_Doweled']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Custom_Parts_Completed">
                                                    <span  data-value="<?php echo $data['Custom_Parts_Completed']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Custom_Parts_Completed" 
                                                        data-title="Enter Custom Parts Completed" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Custom_Parts_Completed']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Parts_ready_for_Finishing">
                                                    <span  data-value="<?php echo $data['Parts_ready_for_Finishing']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Parts_ready_for_Finishing" 
                                                        data-title="Enter Parts Ready For Finishing" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Parts_ready_for_Finishing']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Finished_Parts_Complete">
                                                    <span  data-value="<?php echo $data['Finished_Parts_Complete']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Finished_Parts_Complete" 
                                                        data-title="Enter Finished Parts Complete" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Finished_Parts_Complete']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Unfinished_Parts_CNC">
                                                    <span  data-value="<?php echo $data['Unfinished_Parts_CNC']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Unfinished_Parts_CNC" 
                                                        data-title="Enter Unfinished Parts Cnc" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Unfinished_Parts_CNC']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Unfinished_Parts_Complete">
                                                    <span  data-value="<?php echo $data['Unfinished_Parts_Complete']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Unfinished_Parts_Complete" 
                                                        data-title="Enter Unfinished Parts Complete" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Unfinished_Parts_Complete']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Cabinets_Assembled">
                                                    <span  data-value="<?php echo $data['Cabinets_Assembled']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Cabinets_Assembled" 
                                                        data-title="Enter Cabinets Assembled" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Cabinets_Assembled']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Cabinets_Wrapped">
                                                    <span  data-value="<?php echo $data['Cabinets_Wrapped']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Cabinets_Wrapped" 
                                                        data-title="Enter Cabinets Wrapped" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Cabinets_Wrapped']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Packages_Wrapped">
                                                    <span  data-value="<?php echo $data['Packages_Wrapped']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Packages_Wrapped" 
                                                        data-title="Enter Packages Wrapped" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Packages_Wrapped']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Job_Ready_to_Ship">
                                                    <span  data-value="<?php echo $data['Job_Ready_to_Ship']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Job_Ready_to_Ship" 
                                                        data-title="Enter Job Ready To Ship" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Job_Ready_to_Ship']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Drawer_Type">
                                                    <span  data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Drawer_Type" 
                                                        data-title="Enter Drawer Type" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Drawer_Type']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Finished_End_Sq_Ft">
                                                    <span  data-step="0.1" 
                                                        data-value="<?php echo $data['Finished_End_Sq_Ft']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Finished_End_Sq_Ft" 
                                                        data-title="Enter Finished End Sq Ft" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Finished_End_Sq_Ft']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Door_Sq_Ft">
                                                    <span  data-step="0.1" 
                                                        data-value="<?php echo $data['Door_Sq_Ft']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Door_Sq_Ft" 
                                                        data-title="Enter Door Sq Ft" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Door_Sq_Ft']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-MDF_SHEET_QUANTITY">
                                                    <span  data-step="0.1" 
                                                        data-value="<?php echo $data['MDF_SHEET_QUANTITY']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="MDF_SHEET_QUANTITY" 
                                                        data-title="Enter Mdf Sheet Quantity" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['MDF_SHEET_QUANTITY']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-MEL_SHEET_QUANTITY">
                                                    <span  data-step="0.1" 
                                                        data-value="<?php echo $data['MEL_SHEET_QUANTITY']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="MEL_SHEET_QUANTITY" 
                                                        data-title="Enter Mel Sheet Quantity" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['MEL_SHEET_QUANTITY']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-FIN_SHEET_QUANTITY">
                                                    <span  data-step="0.1" 
                                                        data-value="<?php echo $data['FIN_SHEET_QUANTITY']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="FIN_SHEET_QUANTITY" 
                                                        data-title="Enter Fin Sheet Quantity" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['FIN_SHEET_QUANTITY']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Status">
                                                    <span  data-source='<?php print_link('api/json/production_job_Status_option_list'); ?>' 
                                                        data-value="<?php echo $data['job_Status']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Status" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Status']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Dealer">
                                                    <span  data-source='<?php print_link('api/json/production_job_Dealer_option_list'); ?>' 
                                                        data-value="<?php echo $data['job_Dealer']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Dealer" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Dealer']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Tag_Name">
                                                    <span  data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Tag_Name" 
                                                        data-title="Enter Tag Name" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Tag_Name']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Sent_To_Plant">
                                                    <span  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['job_Sent_To_Plant']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Sent_To_Plant" 
                                                        data-title="Enter Sent To Plant" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Sent_To_Plant']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Received_At_Plant">
                                                    <span  data-source='[{value: "Y", label: "Y"},{value: "Y", label: "Y"}]' 
                                                        data-value="<?php echo $data['job_Received_At_Plant']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Received_At_Plant" 
                                                        data-title="Enter Received At Plant" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Received_At_Plant']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Confirmed_Ship_Date"> <?php echo $data['job_Confirmed_Ship_Date']; ?></td>
                                                <td class="td-job_Uppers">
                                                    <span  data-value="<?php echo $data['job_Uppers']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Uppers" 
                                                        data-title="Enter Uppers" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Uppers']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Talls">
                                                    <span  data-value="<?php echo $data['job_Talls']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Talls" 
                                                        data-title="Enter Talls" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Talls']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Bases">
                                                    <span  data-value="<?php echo $data['job_Bases']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Bases" 
                                                        data-title="Enter Bases" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Bases']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Vanities">
                                                    <span  data-value="<?php echo $data['job_Vanities']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Vanities" 
                                                        data-title="Enter Vanities" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Vanities']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Custom_Cabinets">
                                                    <span  data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Custom_Cabinets" 
                                                        data-title="Enter Custom Cabinets" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Custom_Cabinets']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Accessories">
                                                    <span  data-value="<?php echo $data['job_Accessories']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Accessories" 
                                                        data-title="Enter Accessories" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Accessories']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Door_Style">
                                                    <span  data-value="<?php echo $data['job_Door_Style']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Door_Style" 
                                                        data-title="Enter Door Style" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Door_Style']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Wood">
                                                    <span  data-source='<?php print_link('api/json/production_job_Wood_option_list'); ?>' 
                                                        data-value="<?php echo $data['job_Wood']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Wood" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Wood']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Colour">
                                                    <span  data-source='<?php print_link('api/json/production_job_Colour_option_list'); ?>' 
                                                        data-value="<?php echo $data['job_Colour']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Colour" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Colour']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Material"> <?php echo $data['job_Material']; ?></td>
                                                <td class="td-Pickup_or_Delivery">
                                                    <span  data-source='[{value: "P", label: "P"},{value: "D", label: "D"}]' 
                                                        data-value="<?php echo $data['Pickup_or_Delivery']; ?>" 
                                                        data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Pickup_or_Delivery" 
                                                        data-title="Enter Pickup Or Delivery" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Pickup_or_Delivery']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Delivery_Address">
                                                    <span  data-pk="<?php echo $data['pk_Production'] ?>" 
                                                        data-url="<?php print_link("production/editfield/" . urlencode($data['pk_Production'])); ?>" 
                                                        data-name="Delivery_Address" 
                                                        data-title="Enter Delivery Address" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Delivery_Address']; ?> 
                                                    </span>
                                                </td>
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            <!--endrecord-->
                                        </tbody>
                                        <tbody class="search-data" id="search-data-<?php echo $page_element_id; ?>"></tbody>
                                        <?php
                                        }
                                        ?>
                                    </table>
                                    <?php 
                                    if(empty($records)){
                                    ?>
                                    <h4 class="bg-light text-center border-top text-muted animated bounce  p-3">
                                        <i class="icon dripicons-wrong"></i> No record found
                                    </h4>
                                    <?php
                                    }
                                    ?>
                                </div>
                                <?php
                                if( $show_footer && !empty($records)){
                                ?>
                                <div class=" border-top mt-2">
                                    <div class="row justify-content-center">    
                                        <div class="col-md-auto justify-content-center">    
                                            <div class="p-3 d-flex justify-content-between">    
                                            </div>
                                        </div>
                                        <div class="col">   
                                            <?php
                                            if($show_pagination == true){
                                            $pager = new Pagination($total_records, $record_count);
                                            $pager->route = $this->route;
                                            $pager->show_page_count = true;
                                            $pager->show_record_count = true;
                                            $pager->show_page_limit =true;
                                            $pager->limit_count = $this->limit_count;
                                            $pager->show_page_number_list = true;
                                            $pager->pager_link_range=5;
                                            $pager->ajax_page = true;
                                            $pager->render();
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
