<?php 
/**
 * Accounting Page Controller
 * @category  Controller
 */
class AccountingController extends BaseController{
	function __construct(){
		parent::__construct();
		$this->tablename = "accounting";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("Created_By", 
			"Paid", 
			"Invoiced", 
			"Note", 
			"Updated_By", 
			"Accounting_Received", 
			"Job_Number", 
			"Deposit_Required", 
			"Deposit_Paid", 
			"deposit_requested");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				accounting.Created_By LIKE ? OR 
				accounting.Paid LIKE ? OR 
				accounting.Invoiced LIKE ? OR 
				accounting.Note LIKE ? OR 
				accounting.Updated_By LIKE ? OR 
				accounting.Accounting_Received LIKE ? OR 
				accounting.Job_Number LIKE ? OR 
				accounting.Created_TS LIKE ? OR 
				accounting.Paid_TS LIKE ? OR 
				accounting.Updated_TS LIKE ? OR 
				accounting.Accounting_Received_TS LIKE ? OR 
				accounting.Invoiced_TS LIKE ? OR 
				accounting.Deposit_Required LIKE ? OR 
				accounting.Deposit_Paid_TS LIKE ? OR 
				accounting.Deposit_Paid LIKE ? OR 
				accounting.deposit_requested LIKE ? OR 
				accounting.deposit_requested_ts LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "accounting/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("accounting.Job_Number", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Accounting";
		$view_name = (is_ajax() ? "accounting/ajax-list.php" : "accounting/list.php");
		$this->render_view($view_name, $data);
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("accounting.Created_By", 
			"accounting.Paid", 
			"accounting.Invoiced", 
			"accounting.Note", 
			"accounting.Updated_By", 
			"accounting.Accounting_Received", 
			"accounting.Job_Number", 
			"accounting.Deposit_Required", 
			"accounting.Deposit_Paid", 
			"job.Job_Number_Prefix AS job_Job_Number_Prefix", 
			"job.Job_Number AS job_Job_Number", 
			"job.Status AS job_Status", 
			"job.Dealer AS job_Dealer", 
			"job.Customer_PO AS job_Customer_PO", 
			"job.Tag_Name AS job_Tag_Name", 
			"job.Received_Order AS job_Received_Order", 
			"job.Original_Job_Number AS job_Original_Job_Number", 
			"job.Description AS job_Description", 
			"job.OE AS job_OE", 
			"job.Sales_Rep AS job_Sales_Rep", 
			"job.Requested_Date AS job_Requested_Date", 
			"job.Value AS job_Value", 
			"job.Sent_To_OE AS job_Sent_To_OE", 
			"job.Sent_For_Confirmation AS job_Sent_For_Confirmation", 
			"job.Confirmation_Received AS job_Confirmation_Received", 
			"job.Confirmed AS job_Confirmed", 
			"job.Sent_To_Plant AS job_Sent_To_Plant", 
			"job.Received_At_Plant AS job_Received_At_Plant", 
			"job.Confirmed_Ship_Date AS job_Confirmed_Ship_Date", 
			"job.Invoiced AS job_Invoiced", 
			"job.TimeStamp AS job_TimeStamp", 
			"job.Job_Type AS job_Job_Type", 
			"job.Uppers AS job_Uppers", 
			"job.Talls AS job_Talls", 
			"job.Bases AS job_Bases", 
			"job.Vanities AS job_Vanities", 
			"job.Accessories AS job_Accessories", 
			"job.Door_Style AS job_Door_Style", 
			"job.Wood AS job_Wood", 
			"job.Colour AS job_Colour", 
			"job.Material AS job_Material", 
			"job.Custom_Cabinets AS job_Custom_Cabinets", 
			"job.Door_Vendor AS job_Door_Vendor", 
			"job.Door_ETA AS job_Door_ETA", 
			"job.Date_Shipped AS job_Date_Shipped", 
			"job.Back_Orders AS job_Back_Orders", 
			"job.Back_Orders_Shipped AS job_Back_Orders_Shipped", 
			"job.Proposed_Shipping_Date AS job_Proposed_Shipping_Date", 
			"job.Lead_Time AS job_Lead_Time", 
			"job.Creator AS job_Creator", 
			"job.Dealer_Route AS job_Dealer_Route", 
			"job.Updated_By AS job_Updated_By", 
			"job.Last_Updated AS job_Last_Updated", 
			"job.Job_Number_Prefix AS job_Job_Number_Prefix", 
			"job.Job_Number AS job_Job_Number", 
			"job.Status AS job_Status", 
			"job.Dealer AS job_Dealer", 
			"job.Customer_PO AS job_Customer_PO", 
			"job.Tag_Name AS job_Tag_Name", 
			"job.Received_Order AS job_Received_Order", 
			"job.Original_Job_Number AS job_Original_Job_Number", 
			"job.Description AS job_Description", 
			"job.OE AS job_OE", 
			"job.Sales_Rep AS job_Sales_Rep", 
			"job.Requested_Date AS job_Requested_Date", 
			"job.Value AS job_Value", 
			"job.Sent_To_OE AS job_Sent_To_OE", 
			"job.Sent_For_Confirmation AS job_Sent_For_Confirmation", 
			"job.Confirmation_Received AS job_Confirmation_Received", 
			"job.Confirmed AS job_Confirmed", 
			"job.Sent_To_Plant AS job_Sent_To_Plant", 
			"job.Received_At_Plant AS job_Received_At_Plant", 
			"job.Confirmed_Ship_Date AS job_Confirmed_Ship_Date", 
			"job.Invoiced AS job_Invoiced", 
			"job.TimeStamp AS job_TimeStamp", 
			"job.Job_Type AS job_Job_Type", 
			"job.Uppers AS job_Uppers", 
			"job.Talls AS job_Talls", 
			"job.Bases AS job_Bases", 
			"job.Vanities AS job_Vanities", 
			"job.Accessories AS job_Accessories", 
			"job.Door_Style AS job_Door_Style", 
			"job.Wood AS job_Wood", 
			"job.Colour AS job_Colour", 
			"job.Material AS job_Material", 
			"job.Custom_Cabinets AS job_Custom_Cabinets", 
			"job.Door_Vendor AS job_Door_Vendor", 
			"job.Door_ETA AS job_Door_ETA", 
			"job.Date_Shipped AS job_Date_Shipped", 
			"job.Back_Orders AS job_Back_Orders", 
			"job.Back_Orders_Shipped AS job_Back_Orders_Shipped", 
			"job.Proposed_Shipping_Date AS job_Proposed_Shipping_Date", 
			"job.Lead_Time AS job_Lead_Time", 
			"job.Creator AS job_Creator", 
			"job.Dealer_Route AS job_Dealer_Route", 
			"job.Updated_By AS job_Updated_By", 
			"job.Last_Updated AS job_Last_Updated", 
			"accounting.deposit_requested", 
			"accounting.deposit_requested_ts");
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("accounting.Job_Number", $rec_id);; //select record based on primary key
		}
		$db->join("job", "accounting.Job_Number = job.Job_Number", "INNER ");  
		$record = $db->getOne($tablename, $fields );
		if($record){
			$page_title = $this->view->page_title = "View  Accounting";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
		}
		return $this->render_view("accounting/view.php", $record);
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("Created_By","Paid","Invoiced","Note","Accounting_Received","Job_Number","Created_TS","Deposit_Required","Deposit_Paid","deposit_requested","deposit_requested_ts");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'Job_Number' => 'required',
			);
			$this->sanitize_array = array(
				'Created_By' => 'sanitize_string',
				'Paid' => 'sanitize_string',
				'Invoiced' => 'sanitize_string',
				'Note' => 'sanitize_string',
				'Accounting_Received' => 'sanitize_string',
				'Job_Number' => 'sanitize_string',
				'Created_TS' => 'sanitize_string',
				'Deposit_Required' => 'sanitize_string',
				'Deposit_Paid' => 'sanitize_string',
				'deposit_requested' => 'sanitize_string',
				'deposit_requested_ts' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			//Check if Duplicate Record Already Exit In The Database
			$db->where("Job_Number", $modeldata['Job_Number']);
			if($db->has($tablename)){
				$this->view->page_error[] = $modeldata['Job_Number']." Already exist!";
			} 
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("accounting/edit/$rec_id");
				}
				else{
					$this->set_page_error();
				}
			}
		}
		$page_title = $this->view->page_title = "Add to Accounting";
		$this->render_view("accounting/add.php");
	}
	/**
     * Update table record with formdata
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function edit($rec_id = null, $formdata = null){
		$request = $this->request;
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		 //editable fields
		$fields = $this->fields = array("Paid","Invoiced","Note","Accounting_Received","Updated_TS","Deposit_Required","Deposit_Paid","deposit_requested","deposit_requested_ts");
		if($formdata){
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
			);
			$this->sanitize_array = array(
				'Paid' => 'sanitize_string',
				'Invoiced' => 'sanitize_string',
				'Note' => 'sanitize_string',
				'Accounting_Received' => 'sanitize_string',
				'Updated_TS' => 'sanitize_string',
				'Deposit_Required' => 'sanitize_string',
				'Deposit_Paid' => 'sanitize_string',
				'deposit_requested' => 'sanitize_string',
				'deposit_requested_ts' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("accounting.Job_Number", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					$this->set_flash_msg("Record updated successfully", "success");
					return $this->redirect("accounting");
				}
				else{
					if($db->getLastError()){
						$this->set_page_error();
					}
					elseif(!$numRows){
						//not an error, but no record was updated
						$page_error = "No record updated";
						$this->set_page_error($page_error);
						$this->set_flash_msg($page_error, "warning");
						return	$this->redirect("accounting");
					}
				}
			}
		}
		$db->where("accounting.Job_Number", $rec_id);;
		$data = $db->getOne($tablename, $fields);
		$page_title = $this->view->page_title = "Edit  Accounting Info";
		if(!$data){
			$this->set_page_error();
		}
		return $this->render_view("accounting/edit.php", $data);
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$db->rawQuery("insert ignore into `accounting` SET `Job_Number`='$rec_id', `Created_By`='ef';");
		
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("Paid","Invoiced","Note","Accounting_Received","Updated_TS","Deposit_Required","Deposit_Paid","deposit_requested","deposit_requested_ts");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			if($fieldname=='Invoiced'){
			  if($fieldvalue=='Y' || $fieldvalue=='/'){
			   	$db->rawQuery("Update `joblist2015` SET `Inv`=CURRENT_TIMESTAMP where `JobNum`='$rec_id';");
			   	$db->rawQuery("UPDATE `accounting_ts` set `Invoiced_TS`=CURRENT_TIMESTAMP, `Updated_TS`=CURRENT_TIMESTAMP Where `Job_Number`= '$rec_id';");
			  } else {
			  $db->rawQuery("Update `joblist2015` SET `Inv`=NULL where `JobNum`='$rec_id';");	
			  } 	
			}
			$db->rawQuery("insert ignore into `accounting_editfield_history` SET `Job_Number`='$rec_id', `Description`='$fieldname = $fieldvalue';");	
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
			);
			$this->sanitize_array = array(
				'Paid' => 'sanitize_string',
				'Invoiced' => 'sanitize_string',
				'Note' => 'sanitize_string',
				'Accounting_Received' => 'sanitize_string',
				'Updated_TS' => 'sanitize_string',
				'Deposit_Required' => 'sanitize_string',
				'Deposit_Paid' => 'sanitize_string',
				'deposit_requested' => 'sanitize_string',
				'deposit_requested_ts' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("accounting.Job_Number", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
	/**
     * Delete record from the database
	 * Support multi delete by separating record id by comma.
     * @return BaseView
     */
	function delete($rec_id = null){
		Csrf::cross_check();
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$this->rec_id = $rec_id;
		//form multiple delete, split record id separated by comma into array
		$arr_rec_id = array_map('trim', explode(",", $rec_id));
		$db->where("accounting.Job_Number", $arr_rec_id, "in");
		$bool = $db->delete($tablename);
		if($bool){
			$this->set_flash_msg("Record deleted successfully", "success");
		}
		elseif($db->getLastError()){
			$page_error = $db->getLastError();
			$this->set_flash_msg($page_error, "danger");
		}
		return	$this->redirect("accounting");
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function deposit_outstanding_list($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("accounting.Paid", 
			"accounting.Invoiced", 
			"accounting.Note", 
			"accounting.Updated_By", 
			"accounting.Accounting_Received", 
			"accounting.Deposit_Required", 
			"accounting.Deposit_Paid", 
			"Concat(`job`.Job_Number_Prefix,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM `job`.Job_Number)))) AS DJobNum", 
			"job.Job_Number_Prefix AS job_Job_Number_Prefix", 
			"job.Job_Number AS job_Job_Number", 
			"job.Status AS job_Status", 
			"job.Dealer AS job_Dealer", 
			"job.Customer_PO AS job_Customer_PO", 
			"job.Tag_Name AS job_Tag_Name", 
			"job.Received_Order AS job_Received_Order", 
			"job.Original_Job_Number AS job_Original_Job_Number", 
			"job.Description AS job_Description", 
			"job.Value AS job_Value", 
			"job.Confirmation_Received AS job_Confirmation_Received", 
			"job.Sent_To_Plant AS job_Sent_To_Plant", 
			"job.Received_At_Plant AS job_Received_At_Plant", 
			"job.Confirmed_Ship_Date AS job_Confirmed_Ship_Date", 
			"job.Wood AS job_Wood", 
			"accounting.deposit_requested", 
			"accounting.deposit_requested_ts");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				accounting.Created_By LIKE ? OR 
				accounting.Paid LIKE ? OR 
				accounting.Invoiced LIKE ? OR 
				accounting.Note LIKE ? OR 
				accounting.Updated_By LIKE ? OR 
				accounting.Accounting_Received LIKE ? OR 
				accounting.Job_Number LIKE ? OR 
				accounting.Created_TS LIKE ? OR 
				accounting.Paid_TS LIKE ? OR 
				accounting.Updated_TS LIKE ? OR 
				accounting.Accounting_Received_TS LIKE ? OR 
				accounting.Invoiced_TS LIKE ? OR 
				accounting.Deposit_Required LIKE ? OR 
				accounting.Deposit_Paid_TS LIKE ? OR 
				accounting.Deposit_Paid LIKE ? OR 
				accounting.DJobNum LIKE ? OR 
				job.Job_Number_Prefix LIKE ? OR 
				job.Job_Number LIKE ? OR 
				job.Status LIKE ? OR 
				job.Dealer LIKE ? OR 
				job.Customer_PO LIKE ? OR 
				job.Tag_Name LIKE ? OR 
				job.Received_Order LIKE ? OR 
				job.Original_Job_Number LIKE ? OR 
				job.Description LIKE ? OR 
				job.OE LIKE ? OR 
				job.Sales_Rep LIKE ? OR 
				job.Requested_Date LIKE ? OR 
				job.Value LIKE ? OR 
				job.Sent_To_OE LIKE ? OR 
				job.Sent_For_Confirmation LIKE ? OR 
				job.Confirmation_Received LIKE ? OR 
				job.Confirmed LIKE ? OR 
				job.Sent_To_Plant LIKE ? OR 
				job.Received_At_Plant LIKE ? OR 
				job.Confirmed_Ship_Date LIKE ? OR 
				job.Invoiced LIKE ? OR 
				job.TimeStamp LIKE ? OR 
				job.Job_Type LIKE ? OR 
				job.Uppers LIKE ? OR 
				job.Talls LIKE ? OR 
				job.Bases LIKE ? OR 
				job.Vanities LIKE ? OR 
				job.Accessories LIKE ? OR 
				job.Door_Style LIKE ? OR 
				job.Wood LIKE ? OR 
				job.Colour LIKE ? OR 
				job.Material LIKE ? OR 
				job.Custom_Cabinets LIKE ? OR 
				job.Door_Vendor LIKE ? OR 
				job.Door_ETA LIKE ? OR 
				job.Date_Shipped LIKE ? OR 
				job.Back_Orders LIKE ? OR 
				job.Back_Orders_Shipped LIKE ? OR 
				job.Proposed_Shipping_Date LIKE ? OR 
				job.Lead_Time LIKE ? OR 
				job.Creator LIKE ? OR 
				job.Dealer_Route LIKE ? OR 
				job.Updated_By LIKE ? OR 
				job.Last_Updated LIKE ? OR 
				accounting.deposit_requested LIKE ? OR 
				accounting.deposit_requested_ts LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "accounting/search.php";
		}
		$db->join("job", "accounting.Job_Number = job.Job_Number", "INNER");
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("accounting.Job_Number", ORDER_TYPE);
		}
		$db->where("Deposit_Required = 'Y' AND Deposit_Paid !='Y'");
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Accounting";
		$view_name = (is_ajax() ? "accounting/ajax-deposit_outstanding_list.php" : "accounting/deposit_outstanding_list.php");
		$this->render_view($view_name, $data);
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function not_in_accounting($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("Concat(`job`.Job_Number_Prefix,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM `job`.Job_Number)))) AS DJobNum", 
			"accounting.Paid", 
			"accounting.Invoiced", 
			"accounting.Note", 
			"accounting.Updated_By", 
			"accounting.Accounting_Received", 
			"accounting.Job_Number", 
			"accounting.Deposit_Required", 
			"accounting.Deposit_Paid", 
			"job.Status AS job_Status", 
			"job.Dealer AS job_Dealer", 
			"job.Customer_PO AS job_Customer_PO", 
			"job.Tag_Name AS job_Tag_Name", 
			"job.Confirmation_Received AS job_Confirmation_Received", 
			"job.Confirmed AS job_Confirmed", 
			"job.Sent_To_Plant AS job_Sent_To_Plant", 
			"job.Received_At_Plant AS job_Received_At_Plant", 
			"job.Confirmed_Ship_Date AS job_Confirmed_Ship_Date", 
			"accounting.deposit_requested", 
			"accounting.deposit_requested_ts");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				accounting.DJobNum LIKE ? OR 
				accounting.Created_By LIKE ? OR 
				accounting.Paid LIKE ? OR 
				accounting.Invoiced LIKE ? OR 
				accounting.Note LIKE ? OR 
				accounting.Updated_By LIKE ? OR 
				accounting.Accounting_Received LIKE ? OR 
				accounting.Job_Number LIKE ? OR 
				accounting.Created_TS LIKE ? OR 
				accounting.Paid_TS LIKE ? OR 
				accounting.Updated_TS LIKE ? OR 
				accounting.Accounting_Received_TS LIKE ? OR 
				accounting.Invoiced_TS LIKE ? OR 
				accounting.Deposit_Required LIKE ? OR 
				accounting.Deposit_Paid_TS LIKE ? OR 
				accounting.Deposit_Paid LIKE ? OR 
				job.Job_Number_Prefix LIKE ? OR 
				job.Job_Number LIKE ? OR 
				job.Status LIKE ? OR 
				job.Dealer LIKE ? OR 
				job.Customer_PO LIKE ? OR 
				job.Tag_Name LIKE ? OR 
				job.Received_Order LIKE ? OR 
				job.Original_Job_Number LIKE ? OR 
				job.Description LIKE ? OR 
				job.OE LIKE ? OR 
				job.Sales_Rep LIKE ? OR 
				job.Requested_Date LIKE ? OR 
				job.Value LIKE ? OR 
				job.Sent_To_OE LIKE ? OR 
				job.Sent_For_Confirmation LIKE ? OR 
				job.Confirmation_Received LIKE ? OR 
				job.Confirmed LIKE ? OR 
				job.Sent_To_Plant LIKE ? OR 
				job.Received_At_Plant LIKE ? OR 
				job.Confirmed_Ship_Date LIKE ? OR 
				job.Invoiced LIKE ? OR 
				job.TimeStamp LIKE ? OR 
				job.Job_Type LIKE ? OR 
				job.Uppers LIKE ? OR 
				job.Talls LIKE ? OR 
				job.Bases LIKE ? OR 
				job.Vanities LIKE ? OR 
				job.Accessories LIKE ? OR 
				job.Door_Style LIKE ? OR 
				job.Wood LIKE ? OR 
				job.Colour LIKE ? OR 
				job.Material LIKE ? OR 
				job.Custom_Cabinets LIKE ? OR 
				job.Door_Vendor LIKE ? OR 
				job.Door_ETA LIKE ? OR 
				job.Date_Shipped LIKE ? OR 
				job.Back_Orders LIKE ? OR 
				job.Back_Orders_Shipped LIKE ? OR 
				job.Proposed_Shipping_Date LIKE ? OR 
				job.Lead_Time LIKE ? OR 
				job.Creator LIKE ? OR 
				job.Dealer_Route LIKE ? OR 
				job.Updated_By LIKE ? OR 
				job.Last_Updated LIKE ? OR 
				accounting.deposit_requested LIKE ? OR 
				accounting.deposit_requested_ts LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "accounting/search.php";
		}
		$db->join("job", "accounting.Job_Number = job.Job_Number", "INNER");
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("accounting.Job_Number", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Accounting";
		$view_name = (is_ajax() ? "accounting/ajax-not_in_accounting.php" : "accounting/not_in_accounting.php");
		$this->render_view($view_name, $data);
	}
}
