<?php 
/**
 * Joblist2015 Page Controller
 * @category  Controller
 */
class Joblist2015Controller extends BaseController{
	function __construct(){
		parent::__construct();
		$this->tablename = "joblist2015";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("JobNum", 
			"Artisan", 
			"Dealer", 
			"CustomerNum", 
			"TagName", 
			"OrderEntry", 
			"SalesRep", 
			"RecdOrder", 
			"StdLeadTime", 
			"ReqDate", 
			"Value", 
			"SentToOE", 
			"SentToDealer", 
			"Confirmed", 
			"SentToPlant", 
			"Inv", 
			"Comments", 
			"TimeStamp", 
			"RSO", 
			"Uppers", 
			"Talls", 
			"Bases", 
			"Vanities", 
			"Accessories", 
			"Wood", 
			"Colour", 
			"DoorVendor", 
			"DoorETA", 
			"OtherETA", 
			"Priority", 
			"Creator", 
			"DoorStyle", 
			"Conf_Rec", 
			"NJobNum", 
			"DateShipped", 
			"BackOrders", 
			"BackOrdersShipped", 
			"propshipdate", 
			"shipcomments", 
			"shipdetails", 
			"DealerRoute", 
			"OrgJobNum", 
			"UpdatedBy", 
			"LastUpdated");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				joblist2015.JobNum LIKE ? OR 
				joblist2015.Artisan LIKE ? OR 
				joblist2015.Dealer LIKE ? OR 
				joblist2015.CustomerNum LIKE ? OR 
				joblist2015.TagName LIKE ? OR 
				joblist2015.OrderEntry LIKE ? OR 
				joblist2015.SalesRep LIKE ? OR 
				joblist2015.RecdOrder LIKE ? OR 
				joblist2015.StdLeadTime LIKE ? OR 
				joblist2015.ReqDate LIKE ? OR 
				joblist2015.Value LIKE ? OR 
				joblist2015.SentToOE LIKE ? OR 
				joblist2015.SentToDealer LIKE ? OR 
				joblist2015.Confirmed LIKE ? OR 
				joblist2015.SentToPlant LIKE ? OR 
				joblist2015.Inv LIKE ? OR 
				joblist2015.Comments LIKE ? OR 
				joblist2015.TimeStamp LIKE ? OR 
				joblist2015.RSO LIKE ? OR 
				joblist2015.Uppers LIKE ? OR 
				joblist2015.Talls LIKE ? OR 
				joblist2015.Bases LIKE ? OR 
				joblist2015.Vanities LIKE ? OR 
				joblist2015.Accessories LIKE ? OR 
				joblist2015.Wood LIKE ? OR 
				joblist2015.Colour LIKE ? OR 
				joblist2015.DoorVendor LIKE ? OR 
				joblist2015.DoorETA LIKE ? OR 
				joblist2015.OtherETA LIKE ? OR 
				joblist2015.Priority LIKE ? OR 
				joblist2015.Creator LIKE ? OR 
				joblist2015.DoorStyle LIKE ? OR 
				joblist2015.Conf_Rec LIKE ? OR 
				joblist2015.NJobNum LIKE ? OR 
				joblist2015.DateShipped LIKE ? OR 
				joblist2015.BackOrders LIKE ? OR 
				joblist2015.BackOrdersShipped LIKE ? OR 
				joblist2015.propshipdate LIKE ? OR 
				joblist2015.shipcomments LIKE ? OR 
				joblist2015.shipdetails LIKE ? OR 
				joblist2015.DealerRoute LIKE ? OR 
				joblist2015.OrgJobNum LIKE ? OR 
				joblist2015.UpdatedBy LIKE ? OR 
				joblist2015.LastUpdated LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "joblist2015/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("joblist2015.JobNum", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Jobs For Accounting";
		$view_name = (is_ajax() ? "joblist2015/ajax-list.php" : "joblist2015/list.php");
		$this->render_view($view_name, $data);
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("joblist2015.JobNum", 
			"joblist2015.Artisan", 
			"joblist2015.Dealer", 
			"joblist2015.CustomerNum", 
			"joblist2015.TagName", 
			"joblist2015.OrderEntry", 
			"joblist2015.SalesRep", 
			"joblist2015.RecdOrder", 
			"joblist2015.StdLeadTime", 
			"joblist2015.ReqDate", 
			"joblist2015.Value", 
			"joblist2015.SentToOE", 
			"joblist2015.SentToDealer", 
			"joblist2015.Confirmed", 
			"joblist2015.SentToPlant", 
			"joblist2015.Inv", 
			"joblist2015.Comments", 
			"joblist2015.TimeStamp", 
			"joblist2015.RSO", 
			"joblist2015.Uppers", 
			"joblist2015.Talls", 
			"joblist2015.Bases", 
			"joblist2015.Vanities", 
			"joblist2015.Accessories", 
			"joblist2015.Wood", 
			"joblist2015.Colour", 
			"joblist2015.DoorVendor", 
			"joblist2015.DoorETA", 
			"joblist2015.OtherETA", 
			"joblist2015.Priority", 
			"joblist2015.Creator", 
			"joblist2015.DoorStyle", 
			"joblist2015.Conf_Rec", 
			"joblist2015.NJobNum", 
			"joblist2015.DateShipped", 
			"joblist2015.BackOrders", 
			"joblist2015.BackOrdersShipped", 
			"joblist2015.propshipdate", 
			"joblist2015.shipcomments", 
			"joblist2015.shipdetails", 
			"joblist2015.DealerRoute", 
			"joblist2015.OrgJobNum", 
			"joblist2015.UpdatedBy", 
			"joblist2015.LastUpdated", 
			"Acc.Created_By AS Acc_Created_By", 
			"Acc.Paid AS Acc_Paid", 
			"Acc.Invoiced AS Acc_Invoiced", 
			"Acc.Note AS Acc_Note", 
			"Acc.Updated_By AS Acc_Updated_By", 
			"Acc.Accounting_Received AS Acc_Accounting_Received", 
			"Acc.Job_Number AS Acc_Job_Number", 
			"Acc.Created_TS AS Acc_Created_TS", 
			"Acc.Paid_TS AS Acc_Paid_TS", 
			"Acc.Updated_TS AS Acc_Updated_TS", 
			"Acc.Accounting_Received_TS AS Acc_Accounting_Received_TS", 
			"Acc.Invoiced_TS AS Acc_Invoiced_TS", 
			"Acc.Deposit_Required AS Acc_Deposit_Required", 
			"Acc.Deposit_Paid_TS AS Acc_Deposit_Paid_TS", 
			"Acc.Deposit_Paid AS Acc_Deposit_Paid", 
			"jl_1_dd_dealers.pk_dealer_id AS jl_1_dd_dealers_pk_dealer_id", 
			"jl_1_dd_dealers.list AS jl_1_dd_dealers_list", 
			"jl_1_dd_dealers.salesrep AS jl_1_dd_dealers_salesrep", 
			"jl_1_dd_dealers.City AS jl_1_dd_dealers_City", 
			"jl_1_dd_dealers.address AS jl_1_dd_dealers_address", 
			"jl_1_dd_dealers.fullname AS jl_1_dd_dealers_fullname", 
			"jl_1_dd_dealers.Priority AS jl_1_dd_dealers_Priority", 
			"jl_1_dd_dealers.changed_by AS jl_1_dd_dealers_changed_by", 
			"jl_1_dd_dealers.deposit_required AS jl_1_dd_dealers_deposit_required", 
			"jl_1_dd_dealers.updated_TS AS jl_1_dd_dealers_updated_TS", 
			"accounting.Created_By AS accounting_Created_By", 
			"accounting.Paid AS accounting_Paid", 
			"accounting.Invoiced AS accounting_Invoiced", 
			"accounting.Note AS accounting_Note", 
			"accounting.Updated_By AS accounting_Updated_By", 
			"accounting.Accounting_Received AS accounting_Accounting_Received", 
			"accounting.Job_Number AS accounting_Job_Number", 
			"accounting.Created_TS AS accounting_Created_TS", 
			"accounting.Paid_TS AS accounting_Paid_TS", 
			"accounting.Updated_TS AS accounting_Updated_TS", 
			"accounting.Accounting_Received_TS AS accounting_Accounting_Received_TS", 
			"accounting.Invoiced_TS AS accounting_Invoiced_TS", 
			"accounting.Deposit_Required AS accounting_Deposit_Required", 
			"accounting.Deposit_Paid_TS AS accounting_Deposit_Paid_TS", 
			"accounting.Deposit_Paid AS accounting_Deposit_Paid", 
			"accounting.deposit_requested AS accounting_deposit_requested", 
			"accounting.deposit_requested_ts AS accounting_deposit_requested_ts");
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("joblist2015.JobNum", $rec_id);; //select record based on primary key
		}
		$db->join("jl_1_dd_dealers", "joblist2015.Dealer = jl_1_dd_dealers.list", "LEFT ");
		$db->join("accounting", "joblist2015.JobNum = accounting.Job_Number", "LEFT ");  
		$record = $db->getOne($tablename, $fields );
		if($record){
			$record['Comments'] = str_truncate($record['Comments'],15,'...');
			$page_title = $this->view->page_title = "View  Job List";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
		}
		return $this->render_view("joblist2015/view.php", $record);
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("NJobNum","JobNum","Artisan","Dealer","CustomerNum","TagName","OrderEntry","Comments","Wood","Colour","DoorVendor","DoorStyle","Conf_Rec");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'JobNum' => 'numeric',
			);
			$this->sanitize_array = array(
				'NJobNum' => 'sanitize_string',
				'JobNum' => 'sanitize_string',
				'Artisan' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'CustomerNum' => 'sanitize_string',
				'TagName' => 'sanitize_string',
				'OrderEntry' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'DoorVendor' => 'sanitize_string',
				'DoorStyle' => 'sanitize_string',
				'Conf_Rec' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("joblist2015");
				}
				else{
					$this->set_page_error();
				}
			}
		}
		$page_title = $this->view->page_title = "Add New Joblist2015";
		$this->render_view("joblist2015/add.php");
	}
	/**
     * Update table record with formdata
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function edit($rec_id = null, $formdata = null){
		$request = $this->request;
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		 //editable fields
		$fields = $this->fields = array("NJobNum","JobNum","Artisan","Value","SentToDealer","Confirmed","SentToPlant","Inv","Comments","Wood","Colour","DoorVendor","DoorStyle","Conf_Rec");
		if($formdata){
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'Value' => 'numeric',
			);
			$this->sanitize_array = array(
				'NJobNum' => 'sanitize_string',
				'Artisan' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'SentToDealer' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'SentToPlant' => 'sanitize_string',
				'Inv' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'DoorVendor' => 'sanitize_string',
				'DoorStyle' => 'sanitize_string',
				'Conf_Rec' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("joblist2015.JobNum", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					$this->set_flash_msg("Record updated successfully", "success");
					return $this->redirect("joblist_view/");
				}
				else{
					if($db->getLastError()){
						$this->set_page_error();
					}
					elseif(!$numRows){
						//not an error, but no record was updated
						$page_error = "No record updated";
						$this->set_page_error($page_error);
						$this->set_flash_msg($page_error, "warning");
						return	$this->redirect("joblist_view/");
					}
				}
			}
		}
		$db->where("joblist2015.JobNum", $rec_id);;
		$data = $db->getOne($tablename, $fields);
		$page_title = $this->view->page_title = "Edit  Job";
		if(!$data){
			$this->set_page_error();
		}
		return $this->render_view("joblist2015/edit.php", $data);
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("NJobNum","JobNum","Artisan","Value","SentToDealer","Confirmed","SentToPlant","Inv","Comments","Wood","Colour","DoorVendor","DoorStyle","Conf_Rec");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'Value' => 'numeric',
			);
			$this->sanitize_array = array(
				'NJobNum' => 'sanitize_string',
				'Artisan' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'SentToDealer' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'SentToPlant' => 'sanitize_string',
				'Inv' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'DoorVendor' => 'sanitize_string',
				'DoorStyle' => 'sanitize_string',
				'Conf_Rec' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("joblist2015.JobNum", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function nlist($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("joblist2015.JobNum", 
			"joblist2015.Artisan", 
			"accounting.Accounting_Received AS accounting_Accounting_Received", 
			"joblist2015.Dealer", 
			"Concat(`joblist2015`.NJobNum,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM `joblist2015`.JobNum)))) AS DJobNum", 
			"joblist2015.TagName", 
			"joblist2015.SentToPlant", 
			"joblist2015.OtherETA", 
			"joblist2015.shipdetails", 
			"accounting.Note AS accounting_Note", 
			"accounting.Job_Number AS accounting_Job_Number", 
			"jl_1_dd_dealers.deposit_required AS jl_1_dd_dealers_deposit_required", 
			"accounting.Deposit_Required AS accounting_Deposit_Required", 
			"accounting.deposit_requested AS accounting_deposit_requested", 
			"accounting.deposit_requested_ts AS accounting_deposit_requested_ts", 
			"accounting.Deposit_Paid_TS AS accounting_Deposit_Paid_TS", 
			"accounting.Deposit_Paid AS accounting_Deposit_Paid", 
			"accounting.Invoiced AS accounting_Invoiced", 
			"accounting.Paid AS accounting_Paid");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				joblist2015.JobNum LIKE ? OR 
				accounting.Accounting_Received LIKE ? OR 
				joblist2015.Dealer LIKE ? OR 
				joblist2015.CustomerNum LIKE ? OR 
				joblist2015.TagName LIKE ? OR 
				joblist2015.Value LIKE ? OR 
				joblist2015.Confirmed LIKE ? OR 
				joblist2015.SentToPlant LIKE ? OR 
				joblist2015.Inv LIKE ? OR 
				joblist2015.Comments LIKE ? OR 
				joblist2015.Wood LIKE ? OR 
				joblist2015.Colour LIKE ? OR 
				joblist2015.DoorVendor LIKE ? OR 
				joblist2015.DoorStyle LIKE ? OR 
				joblist2015.propshipdate LIKE ? OR 
				joblist2015.shipdetails LIKE ? OR 
				jl_1_dd_dealers.fullname LIKE ? OR 
				accounting.Note LIKE ? OR 
				accounting.Job_Number LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "joblist2015/search.php";
		}
		$db->join("jl_1_dd_dealers", "joblist2015.Dealer = jl_1_dd_dealers.list", "LEFT");
		$db->join("accounting", "joblist2015.JobNum = accounting.Job_Number", "LEFT");
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("JobNum", "DESC");
		}
		$db->where("joblist2015.Artisan='Y' AND RecdOrder >'2021-01-01'");
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Accounting List";
		$view_name = (is_ajax() ? "joblist2015/ajax-nlist.php" : "joblist2015/nlist.php");
		$this->render_view($view_name, $data);
	}
	
		/**
     * List page records
     * 4 All
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function jobs_all($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("joblist2015.JobNum", 
			"joblist2015.Artisan", 
			"accounting.Accounting_Received AS accounting_Accounting_Received", 
			"joblist2015.Dealer", 
			"Concat(`joblist2015`.NJobNum,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM `joblist2015`.JobNum)))) AS DJobNum", 
			"joblist2015.TagName", 
			"joblist2015.SentToPlant", 
			"joblist2015.OtherETA", 
			"joblist2015.shipdetails", 
			"accounting.Note AS accounting_Note", 
			"accounting.Job_Number AS accounting_Job_Number", 
			"jl_1_dd_dealers.deposit_required AS jl_1_dd_dealers_deposit_required", 
			"accounting.Deposit_Required AS accounting_Deposit_Required", 
			"accounting.deposit_requested AS accounting_deposit_requested", 
			"accounting.deposit_requested_ts AS accounting_deposit_requested_ts", 
			"accounting.Deposit_Paid_TS AS accounting_Deposit_Paid_TS", 
			"accounting.Deposit_Paid AS accounting_Deposit_Paid", 
			"accounting.Invoiced AS accounting_Invoiced", 
			"accounting.Paid AS accounting_Paid");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				joblist2015.JobNum LIKE ? OR 
				accounting.Accounting_Received LIKE ? OR 
				joblist2015.Dealer LIKE ? OR 
				joblist2015.CustomerNum LIKE ? OR 
				joblist2015.TagName LIKE ? OR 
				joblist2015.Value LIKE ? OR 
				joblist2015.Confirmed LIKE ? OR 
				joblist2015.SentToPlant LIKE ? OR 
				joblist2015.Inv LIKE ? OR 
				joblist2015.Comments LIKE ? OR 
				joblist2015.Wood LIKE ? OR 
				joblist2015.Colour LIKE ? OR 
				joblist2015.DoorVendor LIKE ? OR 
				joblist2015.DoorStyle LIKE ? OR 
				joblist2015.propshipdate LIKE ? OR 
				joblist2015.shipdetails LIKE ? OR 
				jl_1_dd_dealers.fullname LIKE ? OR 
				accounting.Note LIKE ? OR 
				accounting.Job_Number LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "joblist2015/search.php";
		}
		$db->join("jl_1_dd_dealers", "joblist2015.Dealer = jl_1_dd_dealers.list", "LEFT");
		$db->join("accounting", "joblist2015.JobNum = accounting.Job_Number", "LEFT");
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("JobNum", "DESC");
		}
		//where clause jobs_all
		$db->where("RecdOrder >'2000-00-00' OR RecdOrder IS NULL");
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Accounting List";
		$view_name = (is_ajax() ? "joblist2015/ajax-jobs_all.php" : "joblist2015/jobs_all.php");
		$this->render_view($view_name, $data);
	}
	/**
     * List page records
     * 3 Confirmed Ship Date
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function jobs_csd($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("joblist2015.JobNum", 
			"joblist2015.Artisan", 
			"accounting.Accounting_Received AS accounting_Accounting_Received", 
			"joblist2015.Dealer", 
			"Concat(`joblist2015`.NJobNum,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM `joblist2015`.JobNum)))) AS DJobNum", 
			"joblist2015.TagName", 
			"joblist2015.SentToPlant", 
			"joblist2015.OtherETA", 
			"joblist2015.shipdetails", 
			"accounting.Note AS accounting_Note", 
			"accounting.Job_Number AS accounting_Job_Number", 
			"jl_1_dd_dealers.deposit_required AS jl_1_dd_dealers_deposit_required", 
			"accounting.Deposit_Required AS accounting_Deposit_Required", 
			"accounting.deposit_requested AS accounting_deposit_requested", 
			"accounting.deposit_requested_ts AS accounting_deposit_requested_ts", 
			"accounting.Deposit_Paid_TS AS accounting_Deposit_Paid_TS", 
			"accounting.Deposit_Paid AS accounting_Deposit_Paid", 
			"accounting.Invoiced AS accounting_Invoiced", 
			"accounting.Paid AS accounting_Paid");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				joblist2015.JobNum LIKE ? OR 
				accounting.Accounting_Received LIKE ? OR 
				joblist2015.Dealer LIKE ? OR 
				joblist2015.CustomerNum LIKE ? OR 
				joblist2015.TagName LIKE ? OR 
				joblist2015.Value LIKE ? OR 
				joblist2015.Confirmed LIKE ? OR 
				joblist2015.SentToPlant LIKE ? OR 
				joblist2015.Inv LIKE ? OR 
				joblist2015.Comments LIKE ? OR 
				joblist2015.Wood LIKE ? OR 
				joblist2015.Colour LIKE ? OR 
				joblist2015.DoorVendor LIKE ? OR 
				joblist2015.DoorStyle LIKE ? OR 
				joblist2015.propshipdate LIKE ? OR 
				joblist2015.shipdetails LIKE ? OR 
				jl_1_dd_dealers.fullname LIKE ? OR 
				accounting.Note LIKE ? OR 
				accounting.Job_Number LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "joblist2015/search.php";
		}
		$db->join("jl_1_dd_dealers", "joblist2015.Dealer = jl_1_dd_dealers.list", "LEFT");
		$db->join("accounting", "joblist2015.JobNum = accounting.Job_Number", "LEFT");
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("JobNum", "DESC");
		}
		// jobs_csd Where Clause
		$db->where("joblist2015.OtherETA IS NOT NULL AND RecdOrder >'2021-01-01'");
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Accounting List";
		$view_name = (is_ajax() ? "joblist2015/ajax-jobs_csd.php" : "joblist2015/jobs_csd.php");
		$this->render_view($view_name, $data);
	}
		/**
		 * Page 2
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function jobs_s2p($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("joblist2015.JobNum", 
			"joblist2015.Artisan", 
			"accounting.Accounting_Received AS accounting_Accounting_Received", 
			"joblist2015.Dealer", 
			"Concat(`joblist2015`.NJobNum,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM `joblist2015`.JobNum)))) AS DJobNum", 
			"joblist2015.TagName", 
			"joblist2015.SentToPlant", 
			"joblist2015.OtherETA", 
			"joblist2015.shipdetails", 
			"accounting.Note AS accounting_Note", 
			"accounting.Job_Number AS accounting_Job_Number", 
			"jl_1_dd_dealers.deposit_required AS jl_1_dd_dealers_deposit_required", 
			"accounting.Deposit_Required AS accounting_Deposit_Required", 
			"accounting.deposit_requested AS accounting_deposit_requested", 
			"accounting.deposit_requested_ts AS accounting_deposit_requested_ts", 
			"accounting.Deposit_Paid_TS AS accounting_Deposit_Paid_TS", 
			"accounting.Deposit_Paid AS accounting_Deposit_Paid", 
			"accounting.Invoiced AS accounting_Invoiced", 
			"accounting.Paid AS accounting_Paid");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				joblist2015.JobNum LIKE ? OR 
				accounting.Accounting_Received LIKE ? OR 
				joblist2015.Dealer LIKE ? OR 
				joblist2015.CustomerNum LIKE ? OR 
				joblist2015.TagName LIKE ? OR 
				joblist2015.Value LIKE ? OR 
				joblist2015.Confirmed LIKE ? OR 
				joblist2015.SentToPlant LIKE ? OR 
				joblist2015.Inv LIKE ? OR 
				joblist2015.Comments LIKE ? OR 
				joblist2015.Wood LIKE ? OR 
				joblist2015.Colour LIKE ? OR 
				joblist2015.DoorVendor LIKE ? OR 
				joblist2015.DoorStyle LIKE ? OR 
				joblist2015.propshipdate LIKE ? OR 
				joblist2015.shipdetails LIKE ? OR 
				jl_1_dd_dealers.fullname LIKE ? OR 
				accounting.Note LIKE ? OR 
				accounting.Job_Number LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "joblist2015/search.php";
		}
		$db->join("jl_1_dd_dealers", "joblist2015.Dealer = jl_1_dd_dealers.list", "LEFT");
		$db->join("accounting", "joblist2015.JobNum = accounting.Job_Number", "LEFT");
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("JobNum", "DESC");
		}
		$db->where("joblist2015.Artisan='Y' AND RecdOrder >'2021-01-01'");
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Accounting List";
		$view_name = (is_ajax() ? "joblist2015/ajax-jobs_s2p.php" : "joblist2015/jobs_s2p.php");
		$this->render_view($view_name, $data);
	}
	/**
		 * Page 2
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function attn_orders($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("joblist2015.JobNum", 
			"joblist2015.Artisan", 
			"accounting.Accounting_Received AS accounting_Accounting_Received", 
			"joblist2015.Dealer", 
			"Concat(`joblist2015`.NJobNum,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM `joblist2015`.JobNum)))) AS DJobNum", 
			"joblist2015.TagName", 
			"joblist2015.SentToPlant", 
			"joblist2015.OtherETA", 
			"joblist2015.shipdetails", 
			"accounting.Note AS accounting_Note", 
			"accounting.Job_Number AS accounting_Job_Number", 
			"jl_1_dd_dealers.deposit_required AS jl_1_dd_dealers_deposit_required", 
			"accounting.Deposit_Required AS accounting_Deposit_Required", 
			"accounting.deposit_requested AS accounting_deposit_requested", 
			"accounting.deposit_requested_ts AS accounting_deposit_requested_ts", 
			"accounting.Deposit_Paid_TS AS accounting_Deposit_Paid_TS", 
			"accounting.Deposit_Paid AS accounting_Deposit_Paid", 
			"accounting.Invoiced AS accounting_Invoiced", 
			"accounting.Paid AS accounting_Paid");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				joblist2015.JobNum LIKE ? OR 
				accounting.Accounting_Received LIKE ? OR 
				joblist2015.Dealer LIKE ? OR 
				joblist2015.CustomerNum LIKE ? OR 
				joblist2015.TagName LIKE ? OR 
				joblist2015.Value LIKE ? OR 
				joblist2015.Confirmed LIKE ? OR 
				joblist2015.SentToPlant LIKE ? OR 
				joblist2015.Inv LIKE ? OR 
				joblist2015.Comments LIKE ? OR 
				joblist2015.Wood LIKE ? OR 
				joblist2015.Colour LIKE ? OR 
				joblist2015.DoorVendor LIKE ? OR 
				joblist2015.DoorStyle LIKE ? OR 
				joblist2015.propshipdate LIKE ? OR 
				joblist2015.shipdetails LIKE ? OR 
				jl_1_dd_dealers.fullname LIKE ? OR 
				accounting.Note LIKE ? OR 
				accounting.Job_Number LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "joblist2015/search.php";
		}
		$db->join("jl_1_dd_dealers", "joblist2015.Dealer = jl_1_dd_dealers.list", "LEFT");
		$db->join("accounting", "joblist2015.JobNum = accounting.Job_Number", "LEFT");
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("shipdetails", "ASC");
		}
		$db->where("`joblist2015`.`Artisan`='Y' AND `joblist2015`.`Inv` !='Y' AND `accounting`.`Accounting_Received`='Y' AND ((`accounting`.`Invoiced` !='Y' AND `accounting`.`Invoiced`!='/') OR `accounting`.`Invoiced` IS NULL)  ");
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Accounting List";
		$view_name = (is_ajax() ? "joblist2015/ajax-attn_orders.php" : "joblist2015/attn_orders.php");
		$this->render_view($view_name, $data);
	}
	/**
	 * 		$db->where("joblist2015.Artisan='Y' AND (accounting.Accounting_Received !='Y' OR accounting.Accounting_Received IS NULL ) AND RecdOrder >'2021-07-01'");
     * List page records
     * Outstanding Deposits
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function new_jobs($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("joblist2015.JobNum", 
			"joblist2015.Artisan", 
			"accounting.Accounting_Received AS accounting_Accounting_Received", 
			"joblist2015.Dealer", 
			"Concat(`joblist2015`.NJobNum,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM `joblist2015`.JobNum)))) AS DJobNum", 
			"joblist2015.TagName", 
			"joblist2015.SentToPlant", 
			"joblist2015.OtherETA", 
			"joblist2015.shipdetails",
			"joblist2015.OrderEntry",
			"accounting.Note AS accounting_Note", 
			"accounting.Job_Number AS accounting_Job_Number", 
			"jl_1_dd_dealers.deposit_required AS jl_1_dd_dealers_deposit_required", 
			"accounting.Deposit_Required AS accounting_Deposit_Required", 
			"accounting.deposit_requested AS accounting_deposit_requested", 
			"accounting.deposit_requested_ts AS accounting_deposit_requested_ts", 
			"accounting.Deposit_Paid_TS AS accounting_Deposit_Paid_TS", 
			"accounting.Deposit_Paid AS accounting_Deposit_Paid", 
			"accounting.Invoiced AS accounting_Invoiced", 
			"accounting.Paid AS accounting_Paid");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				joblist2015.JobNum LIKE ? OR 
				accounting.Accounting_Received LIKE ? OR 
				joblist2015.Dealer LIKE ? OR 
				joblist2015.CustomerNum LIKE ? OR 
				joblist2015.TagName LIKE ? OR 
				joblist2015.Value LIKE ? OR 
				joblist2015.Confirmed LIKE ? OR 
				joblist2015.SentToPlant LIKE ? OR 
				joblist2015.Inv LIKE ? OR 
				joblist2015.Comments LIKE ? OR 
				joblist2015.Wood LIKE ? OR 
				joblist2015.Colour LIKE ? OR 
				joblist2015.DoorVendor LIKE ? OR 
				joblist2015.DoorStyle LIKE ? OR 
				joblist2015.propshipdate LIKE ? OR 
				joblist2015.shipdetails LIKE ? OR 
				jl_1_dd_dealers.fullname LIKE ? OR 
				accounting.Note LIKE ? OR 
				accounting.Job_Number LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "joblist2015/search.php";
		}
		$db->join("jl_1_dd_dealers", "joblist2015.Dealer = jl_1_dd_dealers.list", "LEFT");
		$db->join("accounting", "joblist2015.JobNum = accounting.Job_Number", "LEFT");
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("SentToPlant", "ASC");
		}
		//where clause New Jobs
		//$db->where(" joblist2015.Artisan='Y' AND (accounting.Accounting_Received !='Y' OR accounting.Accounting_Received IS NULL ) AND RecdOrder >'2021-07-01' ");
		$db->where("joblist2015.Artisan='Y' AND (accounting.Accounting_Received != 'Y'  OR (accounting.Accounting_Received IS NULL) ) AND RecdOrder >'2021-01-01'");
		
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Accounting List";
		$view_name = (is_ajax() ? "joblist2015/ajax-new_jobs.php" : "joblist2015/new_jobs.php");
		$this->render_view($view_name, $data);
	}
	/**
     * List page records
     * Outstanding Deposits
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function attn_deposits($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("joblist2015.JobNum", 
			"joblist2015.Artisan", 
			"accounting.Accounting_Received AS accounting_Accounting_Received", 
			"joblist2015.Dealer", 
			"Concat(`joblist2015`.NJobNum,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM `joblist2015`.JobNum)))) AS DJobNum", 
			"joblist2015.TagName", 
			"joblist2015.SentToPlant", 
			"joblist2015.OtherETA", 
			"joblist2015.shipdetails", 
			"accounting.Note AS accounting_Note", 
			"accounting.Job_Number AS accounting_Job_Number", 
			"jl_1_dd_dealers.deposit_required AS jl_1_dd_dealers_deposit_required", 
			"accounting.Deposit_Required AS accounting_Deposit_Required", 
			"accounting.deposit_requested AS accounting_deposit_requested", 
			"accounting.deposit_requested_ts AS accounting_deposit_requested_ts", 
			"accounting.Deposit_Paid_TS AS accounting_Deposit_Paid_TS", 
			"accounting.Deposit_Paid AS accounting_Deposit_Paid", 
			"accounting.Invoiced AS accounting_Invoiced", 
			"accounting.Paid AS accounting_Paid",
			"accounting_ts.Deposit_Requested_TS as acctsDeposit_Requested_TS");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				joblist2015.JobNum LIKE ? OR 
				accounting.Accounting_Received LIKE ? OR 
				joblist2015.Dealer LIKE ? OR 
				joblist2015.CustomerNum LIKE ? OR 
				joblist2015.TagName LIKE ? OR 
				joblist2015.Value LIKE ? OR 
				joblist2015.Confirmed LIKE ? OR 
				joblist2015.SentToPlant LIKE ? OR 
				joblist2015.Inv LIKE ? OR 
				joblist2015.Comments LIKE ? OR 
				joblist2015.Wood LIKE ? OR 
				joblist2015.Colour LIKE ? OR 
				joblist2015.DoorVendor LIKE ? OR 
				joblist2015.DoorStyle LIKE ? OR 
				joblist2015.propshipdate LIKE ? OR 
				joblist2015.shipdetails LIKE ? OR 
				jl_1_dd_dealers.fullname LIKE ? OR 
				accounting.Note LIKE ? OR 
				accounting.Job_Number LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "joblist2015/search.php";
		}
		$db->join("jl_1_dd_dealers", "joblist2015.Dealer = jl_1_dd_dealers.list", "LEFT");
		$db->join("accounting", "joblist2015.JobNum = accounting.Job_Number", "LEFT");
		$db->join("accounting_ts", "joblist2015.JobNum = accounting_ts.Job_Number", "LEFT");

		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("SentToPlant", "ASC");
		}
		//where clause attn_deposits
		$db->where("joblist2015.Artisan='Y' AND (accounting.Deposit_Paid !='Y' OR accounting.Deposit_Paid IS NULL ) AND accounting.deposit_requested ='Y' AND (accounting.Invoiced IS NULL OR accounting.Invoiced !='Y') AND RecdOrder >'2021-01-01'");
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Accounting List";
		$view_name = (is_ajax() ? "joblist2015/ajax-attn_deposits.php" : "joblist2015/attn_deposits.php");
		$this->render_view($view_name, $data);
	}
	/**
     * List page records
     * Outstanding attn_deposits_to_req
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function attn_deposits_to_req($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("joblist2015.JobNum", 
			"joblist2015.Artisan", 
			"accounting.Accounting_Received AS accounting_Accounting_Received", 
			"joblist2015.Dealer", 
			"Concat(`joblist2015`.NJobNum,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM `joblist2015`.JobNum)))) AS DJobNum", 
			"joblist2015.TagName", 
			"joblist2015.SentToPlant", 
			"joblist2015.OtherETA", 
			"joblist2015.shipdetails", 
			"accounting.Note AS accounting_Note", 
			"accounting.Job_Number AS accounting_Job_Number", 
			"jl_1_dd_dealers.deposit_required AS jl_1_dd_dealers_deposit_required", 
			"accounting.Deposit_Required AS accounting_Deposit_Required", 
			"accounting.deposit_requested AS accounting_deposit_requested", 
			"accounting.deposit_requested_ts AS accounting_deposit_requested_ts", 
			"accounting.Deposit_Paid_TS AS accounting_Deposit_Paid_TS", 
			"accounting.Deposit_Paid AS accounting_Deposit_Paid", 
			"accounting.Invoiced AS accounting_Invoiced", 
			"accounting.Paid AS accounting_Paid");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				joblist2015.JobNum LIKE ? OR 
				accounting.Accounting_Received LIKE ? OR 
				joblist2015.Dealer LIKE ? OR 
				joblist2015.CustomerNum LIKE ? OR 
				joblist2015.TagName LIKE ? OR 
				joblist2015.Value LIKE ? OR 
				joblist2015.Confirmed LIKE ? OR 
				joblist2015.SentToPlant LIKE ? OR 
				joblist2015.Inv LIKE ? OR 
				joblist2015.Comments LIKE ? OR 
				joblist2015.Wood LIKE ? OR 
				joblist2015.Colour LIKE ? OR 
				joblist2015.DoorVendor LIKE ? OR 
				joblist2015.DoorStyle LIKE ? OR 
				joblist2015.propshipdate LIKE ? OR 
				joblist2015.shipdetails LIKE ? OR 
				jl_1_dd_dealers.fullname LIKE ? OR 
				accounting.Note LIKE ? OR 
				accounting.Job_Number LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "joblist2015/search.php";
		}
		$db->join("jl_1_dd_dealers", "joblist2015.Dealer = jl_1_dd_dealers.list", "LEFT");
		$db->join("accounting", "joblist2015.JobNum = accounting.Job_Number", "LEFT");
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("SentToPlant", "ASC");
		}
		//where clause attn_deposits_to_req
		$db->where("joblist2015.Artisan='Y' AND (accounting.Deposit_Paid !='Y' OR accounting.Deposit_Paid IS NULL ) AND jl_1_dd_dealers.deposit_required ='YES'  AND (accounting.deposit_requested IS NULL) AND (accounting.Invoiced IS NULL OR accounting.Invoiced !='Y') AND RecdOrder >'2021-01-01'");
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Accounting List";
		$view_name = (is_ajax() ? "joblist2015/ajax-attn_deposits_to_req.php" : "joblist2015/attn_deposits_to_req.php");
		$this->render_view($view_name, $data);
	}
	/**
     * List page records
     * Outstanding Deposits
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function attn_invoices($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("joblist2015.JobNum", 
			"joblist2015.Artisan", 
			"accounting.Accounting_Received AS accounting_Accounting_Received", 
			"joblist2015.Dealer", 
			"Concat(`joblist2015`.NJobNum,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM `joblist2015`.JobNum)))) AS DJobNum", 
			"joblist2015.TagName", 
			"joblist2015.SentToPlant", 
			"joblist2015.OtherETA", 
			"joblist2015.shipdetails", 
			"accounting.Note AS accounting_Note", 
			"accounting.Job_Number AS accounting_Job_Number", 
			"jl_1_dd_dealers.deposit_required AS jl_1_dd_dealers_deposit_required", 
			"accounting.Deposit_Required AS accounting_Deposit_Required", 
			"accounting.deposit_requested AS accounting_deposit_requested", 
			"accounting.deposit_requested_ts AS accounting_deposit_requested_ts", 
			"accounting.Deposit_Paid_TS AS accounting_Deposit_Paid_TS", 
			"accounting.Deposit_Paid AS accounting_Deposit_Paid", 
			"accounting.Invoiced AS accounting_Invoiced", 
			"accounting.Paid AS accounting_Paid");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				joblist2015.JobNum LIKE ? OR 
				accounting.Accounting_Received LIKE ? OR 
				joblist2015.Dealer LIKE ? OR 
				joblist2015.CustomerNum LIKE ? OR 
				joblist2015.TagName LIKE ? OR 
				joblist2015.Value LIKE ? OR 
				joblist2015.Confirmed LIKE ? OR 
				joblist2015.SentToPlant LIKE ? OR 
				joblist2015.Inv LIKE ? OR 
				joblist2015.Comments LIKE ? OR 
				joblist2015.Wood LIKE ? OR 
				joblist2015.Colour LIKE ? OR 
				joblist2015.DoorVendor LIKE ? OR 
				joblist2015.DoorStyle LIKE ? OR 
				joblist2015.propshipdate LIKE ? OR 
				joblist2015.shipdetails LIKE ? OR 
				jl_1_dd_dealers.fullname LIKE ? OR 
				accounting.Note LIKE ? OR 
				accounting.Job_Number LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "joblist2015/search.php";
		}
		$db->join("jl_1_dd_dealers", "joblist2015.Dealer = jl_1_dd_dealers.list", "LEFT");
		$db->join("accounting", "joblist2015.JobNum = accounting.Job_Number", "LEFT");
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("JobNum", "DESC");
		}
		//where clause attn_invoices
		$db->where("joblist2015.Artisan='Y' AND (accounting.Paid !='Y' OR accounting.Paid IS NULL ) AND joblist2015.DateShipped > '2021-10-01' ");
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Accounting List";
		$view_name = (is_ajax() ? "joblist2015/ajax-attn_invoices.php" : "joblist2015/attn_invoices.php");
		$this->render_view($view_name, $data);
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function jobs_with_a_confirmed_ship_date($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("joblist2015.JobNum", 
			"joblist2015.Artisan", 
			"accounting.Accounting_Received AS accounting_Accounting_Received", 
			"joblist2015.Dealer", 
			"Concat(`joblist2015`.NJobNum,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM `joblist2015`.JobNum)))) AS DJobNum", 
			"joblist2015.TagName", 
			"joblist2015.SentToPlant", 
			"joblist2015.OtherETA", 
			"accounting.Note AS accounting_Note", 
			"accounting.Job_Number AS accounting_Job_Number", 
			"jl_1_dd_dealers.deposit_required AS jl_1_dd_dealers_deposit_required", 
			"accounting.Deposit_Required AS accounting_Deposit_Required", 
			"accounting.deposit_requested AS accounting_deposit_requested", 
			"accounting.deposit_requested_ts AS accounting_deposit_requested_ts", 
			"accounting.Deposit_Paid_TS AS accounting_Deposit_Paid_TS", 
			"accounting.Deposit_Paid AS accounting_Deposit_Paid", 
			"accounting.Invoiced AS accounting_Invoiced", 
			"accounting.Paid AS accounting_Paid");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				joblist2015.JobNum LIKE ? OR 
				joblist2015.Artisan LIKE ? OR 
				accounting.Accounting_Received LIKE ? OR 
				joblist2015.Dealer LIKE ? OR 
				joblist2015.CustomerNum LIKE ? OR 
				joblist2015.DJobNum LIKE ? OR 
				joblist2015.TagName LIKE ? OR 
				joblist2015.OrderEntry LIKE ? OR 
				joblist2015.SalesRep LIKE ? OR 
				joblist2015.RecdOrder LIKE ? OR 
				joblist2015.StdLeadTime LIKE ? OR 
				joblist2015.ReqDate LIKE ? OR 
				joblist2015.Value LIKE ? OR 
				joblist2015.SentToOE LIKE ? OR 
				joblist2015.SentToDealer LIKE ? OR 
				joblist2015.Confirmed LIKE ? OR 
				joblist2015.SentToPlant LIKE ? OR 
				joblist2015.Inv LIKE ? OR 
				joblist2015.Comments LIKE ? OR 
				joblist2015.TimeStamp LIKE ? OR 
				joblist2015.RSO LIKE ? OR 
				joblist2015.Uppers LIKE ? OR 
				joblist2015.Talls LIKE ? OR 
				joblist2015.Bases LIKE ? OR 
				joblist2015.Vanities LIKE ? OR 
				joblist2015.Accessories LIKE ? OR 
				joblist2015.Wood LIKE ? OR 
				joblist2015.Colour LIKE ? OR 
				joblist2015.DoorVendor LIKE ? OR 
				joblist2015.DoorETA LIKE ? OR 
				joblist2015.OtherETA LIKE ? OR 
				joblist2015.Priority LIKE ? OR 
				joblist2015.Creator LIKE ? OR 
				joblist2015.DoorStyle LIKE ? OR 
				joblist2015.Conf_Rec LIKE ? OR 
				joblist2015.NJobNum LIKE ? OR 
				joblist2015.DateShipped LIKE ? OR 
				joblist2015.BackOrders LIKE ? OR 
				joblist2015.BackOrdersShipped LIKE ? OR 
				joblist2015.propshipdate LIKE ? OR 
				joblist2015.shipcomments LIKE ? OR 
				joblist2015.shipdetails LIKE ? OR 
				joblist2015.DealerRoute LIKE ? OR 
				joblist2015.OrgJobNum LIKE ? OR 
				joblist2015.UpdatedBy LIKE ? OR 
				joblist2015.LastUpdated LIKE ? OR 
				jl_1_dd_dealers.pk_dealer_id LIKE ? OR 
				jl_1_dd_dealers.list LIKE ? OR 
				jl_1_dd_dealers.salesrep LIKE ? OR 
				jl_1_dd_dealers.City LIKE ? OR 
				jl_1_dd_dealers.address LIKE ? OR 
				jl_1_dd_dealers.fullname LIKE ? OR 
				jl_1_dd_dealers.Priority LIKE ? OR 
				jl_1_dd_dealers.changed_by LIKE ? OR 
				jl_1_dd_dealers.updated_TS LIKE ? OR 
				accounting.Created_By LIKE ? OR 
				accounting.Note LIKE ? OR 
				accounting.Updated_By LIKE ? OR 
				accounting.Job_Number LIKE ? OR 
				accounting.Created_TS LIKE ? OR 
				accounting.Paid_TS LIKE ? OR 
				accounting.Updated_TS LIKE ? OR 
				accounting.Accounting_Received_TS LIKE ? OR 
				accounting.Invoiced_TS LIKE ? OR 
				jl_1_dd_dealers.deposit_required LIKE ? OR 
				accounting.Deposit_Required LIKE ? OR 
				accounting.deposit_requested LIKE ? OR 
				accounting.deposit_requested_ts LIKE ? OR 
				accounting.Deposit_Paid_TS LIKE ? OR 
				accounting.Deposit_Paid LIKE ? OR 
				accounting.Invoiced LIKE ? OR 
				accounting.Paid LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "joblist2015/search.php";
		}
		$db->join("jl_1_dd_dealers", "joblist2015.Dealer = jl_1_dd_dealers.list", "LEFT");
		$db->join("accounting", "joblist2015.JobNum = accounting.Job_Number", "LEFT");
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("JobNum", "DESC");
		}
		$db->where("joblist2015.OtherETA > '2021-11-03'");
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Accounting List";
		$this->render_view("joblist2015/jobs_with_a_confirmed_ship_date.php", $data); //render the full page
	}
	/*
	
	wip is the DEMO page
	*/
	
	function wip($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("joblist2015.JobNum", 
			"joblist2015.Artisan", 
			"accounting.Accounting_Received AS accounting_Accounting_Received", 
			"joblist2015.Dealer", 
			"Concat(`joblist2015`.NJobNum,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM `joblist2015`.JobNum)))) AS DJobNum", 
			"joblist2015.TagName", 
			"joblist2015.SentToPlant", 
			"joblist2015.OtherETA", 
			"joblist2015.shipdetails", 
			"accounting.Note AS accounting_Note", 
			"accounting.Job_Number AS accounting_Job_Number", 
			"jl_1_dd_dealers.deposit_required AS jl_1_dd_dealers_deposit_required", 
			"accounting.Deposit_Required AS accounting_Deposit_Required", 
			"accounting.deposit_requested AS accounting_deposit_requested", 
			"accounting.deposit_requested_ts AS accounting_deposit_requested_ts", 
			"accounting.Deposit_Paid_TS AS accounting_Deposit_Paid_TS", 
			"accounting.Deposit_Paid AS accounting_Deposit_Paid", 
			"accounting.Invoiced AS accounting_Invoiced", 
			"accounting.Paid AS accounting_Paid");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				joblist2015.JobNum LIKE ? OR 
				accounting.Accounting_Received LIKE ? OR 
				joblist2015.Dealer LIKE ? OR 
				joblist2015.CustomerNum LIKE ? OR 
				joblist2015.TagName LIKE ? OR 
				joblist2015.Value LIKE ? OR 
				joblist2015.Confirmed LIKE ? OR 
				joblist2015.SentToPlant LIKE ? OR 
				joblist2015.Inv LIKE ? OR 
				joblist2015.Comments LIKE ? OR 
				joblist2015.Wood LIKE ? OR 
				joblist2015.Colour LIKE ? OR 
				joblist2015.DoorVendor LIKE ? OR 
				joblist2015.DoorStyle LIKE ? OR 
				joblist2015.propshipdate LIKE ? OR 
				joblist2015.shipdetails LIKE ? OR 
				jl_1_dd_dealers.fullname LIKE ? OR 
				accounting.Note LIKE ? OR 
				accounting.Job_Number LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "joblist2015/search.php";
		}
		$db->join("jl_1_dd_dealers", "joblist2015.Dealer = jl_1_dd_dealers.list", "LEFT");
		$db->join("accounting", "joblist2015.JobNum = accounting.Job_Number", "LEFT");
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("JobNum", "DESC");
		}
		//where clause jobs_all
		$db->where("RecdOrder >'2000-00-00' OR RecdOrder IS NULL");
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "demo page";
		$view_name = (is_ajax() ? "joblist2015/ajax-wip.php" : "joblist2015/wip.php");
		$this->render_view($view_name, $data);
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function all_jobs($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("joblist2015.JobNum", 
			"joblist2015.Artisan", 
			"accounting.Accounting_Received AS accounting_Accounting_Received", 
			"joblist2015.Dealer", 
			"Concat(`joblist2015`.NJobNum,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM `joblist2015`.JobNum)))) AS DJobNum", 
			"joblist2015.TagName", 
			"joblist2015.SentToPlant", 
			"joblist2015.OtherETA", 
			"joblist2015.DateShipped", 
			"accounting.Note AS accounting_Note", 
			"accounting.Job_Number AS accounting_Job_Number", 
			"jl_1_dd_dealers.deposit_required AS jl_1_dd_dealers_deposit_required", 
			"accounting.Deposit_Required AS accounting_Deposit_Required", 
			"accounting.deposit_requested AS accounting_deposit_requested", 
			"accounting.deposit_requested_ts AS accounting_deposit_requested_ts", 
			"accounting.Deposit_Paid_TS AS accounting_Deposit_Paid_TS", 
			"accounting.Deposit_Paid AS accounting_Deposit_Paid", 
			"accounting.Invoiced AS accounting_Invoiced", 
			"accounting.Paid AS accounting_Paid");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				joblist2015.JobNum LIKE ? OR 
				joblist2015.Artisan LIKE ? OR 
				accounting.Accounting_Received LIKE ? OR 
				joblist2015.Dealer LIKE ? OR 
				joblist2015.CustomerNum LIKE ? OR 
				joblist2015.DJobNum LIKE ? OR 
				joblist2015.TagName LIKE ? OR 
				joblist2015.OrderEntry LIKE ? OR 
				joblist2015.SalesRep LIKE ? OR 
				joblist2015.RecdOrder LIKE ? OR 
				joblist2015.StdLeadTime LIKE ? OR 
				joblist2015.ReqDate LIKE ? OR 
				joblist2015.Value LIKE ? OR 
				joblist2015.SentToOE LIKE ? OR 
				joblist2015.SentToDealer LIKE ? OR 
				joblist2015.Confirmed LIKE ? OR 
				joblist2015.SentToPlant LIKE ? OR 
				joblist2015.Inv LIKE ? OR 
				joblist2015.Comments LIKE ? OR 
				joblist2015.TimeStamp LIKE ? OR 
				joblist2015.RSO LIKE ? OR 
				joblist2015.Uppers LIKE ? OR 
				joblist2015.Talls LIKE ? OR 
				joblist2015.Bases LIKE ? OR 
				joblist2015.Vanities LIKE ? OR 
				joblist2015.Accessories LIKE ? OR 
				joblist2015.Wood LIKE ? OR 
				joblist2015.Colour LIKE ? OR 
				joblist2015.DoorVendor LIKE ? OR 
				joblist2015.DoorETA LIKE ? OR 
				joblist2015.OtherETA LIKE ? OR 
				joblist2015.Priority LIKE ? OR 
				joblist2015.Creator LIKE ? OR 
				joblist2015.DoorStyle LIKE ? OR 
				joblist2015.Conf_Rec LIKE ? OR 
				joblist2015.NJobNum LIKE ? OR 
				joblist2015.DateShipped LIKE ? OR 
				joblist2015.BackOrders LIKE ? OR 
				joblist2015.BackOrdersShipped LIKE ? OR 
				joblist2015.propshipdate LIKE ? OR 
				joblist2015.shipcomments LIKE ? OR 
				joblist2015.shipdetails LIKE ? OR 
				joblist2015.DealerRoute LIKE ? OR 
				joblist2015.OrgJobNum LIKE ? OR 
				joblist2015.UpdatedBy LIKE ? OR 
				joblist2015.LastUpdated LIKE ? OR 
				jl_1_dd_dealers.pk_dealer_id LIKE ? OR 
				jl_1_dd_dealers.list LIKE ? OR 
				jl_1_dd_dealers.salesrep LIKE ? OR 
				jl_1_dd_dealers.City LIKE ? OR 
				jl_1_dd_dealers.address LIKE ? OR 
				jl_1_dd_dealers.fullname LIKE ? OR 
				jl_1_dd_dealers.Priority LIKE ? OR 
				jl_1_dd_dealers.changed_by LIKE ? OR 
				jl_1_dd_dealers.updated_TS LIKE ? OR 
				accounting.Created_By LIKE ? OR 
				accounting.Note LIKE ? OR 
				accounting.Updated_By LIKE ? OR 
				accounting.Job_Number LIKE ? OR 
				accounting.Created_TS LIKE ? OR 
				accounting.Paid_TS LIKE ? OR 
				accounting.Updated_TS LIKE ? OR 
				accounting.Accounting_Received_TS LIKE ? OR 
				accounting.Invoiced_TS LIKE ? OR 
				jl_1_dd_dealers.deposit_required LIKE ? OR 
				accounting.Deposit_Required LIKE ? OR 
				accounting.deposit_requested LIKE ? OR 
				accounting.deposit_requested_ts LIKE ? OR 
				accounting.Deposit_Paid_TS LIKE ? OR 
				accounting.Deposit_Paid LIKE ? OR 
				accounting.Invoiced LIKE ? OR 
				accounting.Paid LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "joblist2015/search.php";
		}
		$db->join("jl_1_dd_dealers", "joblist2015.Dealer = jl_1_dd_dealers.list", "LEFT");
		$db->join("accounting", "joblist2015.JobNum = accounting.Job_Number", "LEFT");
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("JobNum", "DESC");
		}
		$db->where("RecdOrder >'2021-07-01'");
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Accounting List";
		$this->render_view("joblist2015/all_jobs.php", $data); //render the full page
	}
}
