<?php
$comp_model = new SharedController;
$page_element_id = "list-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data From Controller
$view_data = $this->view_data;
$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = $this->route->field_name;
$field_value = $this->route->field_value;
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;
?>
<section class="page ajax-page" id="<?php echo $page_element_id; ?>" data-page-type="list"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">Jobconversation</h4>
                </div>
                <div class="col-sm-3 ">
                    <a  class="btn btn btn-primary my-1" href="<?php print_link("jobconversation/add") ?>">
                        <i class="icon dripicons-plus"></i>                             
                        Add New Jobconversation 
                    </a>
                </div>
                <div class="col-sm-4 ">
                    <form  class="search" action="<?php print_link('jobconversation'); ?>" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="icon dripicons-search"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <!-- Page bread crumbs components-->
                            <?php
                            if(!empty($field_name) || !empty($_GET['search'])){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('jobconversation'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <?php echo (get_value("tag") ? get_value("tag")  :  make_readable($field_name)); ?>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold">
                                        <?php echo (get_value("label") ? get_value("label")  :  make_readable(urldecode($field_value))); ?>
                                    </li>
                                    <?php 
                                    }   
                                    ?>
                                    <?php
                                    if(get_value("search")){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('jobconversation'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item text-capitalize">
                                        Search
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold"><?php echo get_value("search"); ?></li>
                                    <?php
                                    }
                                    ?>
                                </ul>
                            </nav>
                            <!--End of Page bread crumbs components-->
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        }
        ?>
        <div  class="">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-md-12 comp-grid">
                        <?php $this :: display_page_errors(); ?>
                        <div  class=" animated fadeIn page-content">
                            <div id="jobconversation-list-records">
                                <div id="page-report-body" class="table-responsive">
                                    <?php Html::ajaxpage_spinner(); ?>
                                    <table class="table  table-striped table-sm text-left">
                                        <thead class="table-header bg-light">
                                            <tr>
                                                <th class="td-btn"></th>
                                                <th  class="td-ConvID"> Convid</th>
                                                <th  class="td-JobNum"> Jobnum</th>
                                                <th  class="td-Comment"> Comment</th>
                                                <th  class="td-Author"> Author</th>
                                                <th  class="td-Date"> Date</th>
                                                <th  class="td-TimeStamp"> Timestamp</th>
                                                <th  class="td-ForWhom"> Forwhom</th>
                                                <th  class="td-Old"> Old</th>
                                                <th  class="td-ReplyTo"> Replyto</th>
                                            </tr>
                                        </thead>
                                        <?php
                                        if(!empty($records)){
                                        ?>
                                        <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                            <!--record-->
                                            <?php
                                            $counter = 0;
                                            foreach($records as $data){
                                            $rec_id = (!empty($data['ConvID']) ? urlencode($data['ConvID']) : null);
                                            $counter++;
                                            ?>
                                            <tr>
                                                <th class="td-btn">
                                                    <a class="btn btn-sm btn-success has-tooltip page-modal" title="View Record" href="<?php print_link("jobconversation/view/$rec_id"); ?>">
                                                        <i class="icon dripicons-preview"></i> View
                                                    </a>
                                                    <a class="btn btn-sm btn-info has-tooltip page-modal" title="Edit This Record" href="<?php print_link("jobconversation/edit/$rec_id"); ?>">
                                                        <i class="icon dripicons-document-edit"></i> Edit
                                                    </a>
                                                </th>
                                                <td class="td-ConvID"><a href="<?php print_link("jobconversation/view/$data[ConvID]") ?>"><?php echo $data['ConvID']; ?></a></td>
                                                <td class="td-JobNum">
                                                    <span  data-step="0.1" 
                                                        data-value="<?php echo $data['JobNum']; ?>" 
                                                        data-pk="<?php echo $data['ConvID'] ?>" 
                                                        data-url="<?php print_link("jobconversation/editfield/" . urlencode($data['ConvID'])); ?>" 
                                                        data-name="JobNum" 
                                                        data-title="Enter Jobnum" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['JobNum']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Comment">
                                                    <span  data-pk="<?php echo $data['ConvID'] ?>" 
                                                        data-url="<?php print_link("jobconversation/editfield/" . urlencode($data['ConvID'])); ?>" 
                                                        data-name="Comment" 
                                                        data-title="Enter Comment" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Comment']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Author">
                                                    <span  data-pk="<?php echo $data['ConvID'] ?>" 
                                                        data-url="<?php print_link("jobconversation/editfield/" . urlencode($data['ConvID'])); ?>" 
                                                        data-name="Author" 
                                                        data-title="Enter Author" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Author']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Date">
                                                    <span  data-pk="<?php echo $data['ConvID'] ?>" 
                                                        data-url="<?php print_link("jobconversation/editfield/" . urlencode($data['ConvID'])); ?>" 
                                                        data-name="Date" 
                                                        data-title="Enter Date" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Date']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-TimeStamp"> <?php echo $data['TimeStamp']; ?></td>
                                                <td class="td-ForWhom">
                                                    <span  data-pk="<?php echo $data['ConvID'] ?>" 
                                                        data-url="<?php print_link("jobconversation/editfield/" . urlencode($data['ConvID'])); ?>" 
                                                        data-name="ForWhom" 
                                                        data-title="Enter Forwhom" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['ForWhom']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Old">
                                                    <span  data-pk="<?php echo $data['ConvID'] ?>" 
                                                        data-url="<?php print_link("jobconversation/editfield/" . urlencode($data['ConvID'])); ?>" 
                                                        data-name="Old" 
                                                        data-title="Enter Old" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Old']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-ReplyTo">
                                                    <span  data-pk="<?php echo $data['ConvID'] ?>" 
                                                        data-url="<?php print_link("jobconversation/editfield/" . urlencode($data['ConvID'])); ?>" 
                                                        data-name="ReplyTo" 
                                                        data-title="Enter Replyto" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['ReplyTo']; ?> 
                                                    </span>
                                                </td>
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            <!--endrecord-->
                                        </tbody>
                                        <tbody class="search-data" id="search-data-<?php echo $page_element_id; ?>"></tbody>
                                        <?php
                                        }
                                        ?>
                                    </table>
                                    <?php 
                                    if(empty($records)){
                                    ?>
                                    <h4 class="bg-light text-center border-top text-muted animated bounce  p-3">
                                        <i class="icon dripicons-wrong"></i> No record found
                                    </h4>
                                    <?php
                                    }
                                    ?>
                                </div>
                                <?php
                                if( $show_footer && !empty($records)){
                                ?>
                                <div class=" border-top mt-2">
                                    <div class="row justify-content-center">    
                                        <div class="col-md-auto justify-content-center">    
                                            <div class="p-3 d-flex justify-content-between">    
                                            </div>
                                        </div>
                                        <div class="col">   
                                            <?php
                                            if($show_pagination == true){
                                            $pager = new Pagination($total_records, $record_count);
                                            $pager->route = $this->route;
                                            $pager->show_page_count = true;
                                            $pager->show_record_count = true;
                                            $pager->show_page_limit =true;
                                            $pager->limit_count = $this->limit_count;
                                            $pager->show_page_number_list = true;
                                            $pager->pager_link_range=5;
                                            $pager->ajax_page = true;
                                            $pager->render();
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
